/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.network.FluidTankSyncPacket;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PurchaseSecondTankPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PurchaseSecondTankPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"purchase_second_tank"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PurchaseSecondTankPacket> STREAM_CODEC = StreamCodec.unit((Object)new PurchaseSecondTankPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PurchaseSecondTankPacket pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractContainerMenu patt1$temp;
            int have;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            ItemStack shellStack = ShellItem.findWornshell((Player)sp);
            if (shellStack.isEmpty()) {
                return;
            }
            if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack)) {
                return;
            }
            boolean already = (Boolean)shellStack.getOrDefault(ModDataComponents.TANK2_UNLOCKED.get(), (Object)false);
            if (already) {
                return;
            }
            boolean isCreative = sp.getAbilities().instabuild;
            if (!isCreative && (have = InventoryUtils.countItemAcrossInventoryAndshell((Player)sp, Items.IRON_INGOT)) < 1) {
                return;
            }
            int remaining = isCreative ? 0 : 1;
            for (int i = 0; i < sp.getInventory().getContainerSize() && remaining > 0; ++i) {
                ItemStack st = sp.getInventory().getItem(i);
                if (st.isEmpty() || !st.is(Items.IRON_INGOT)) continue;
                int c = Math.min(remaining, st.getCount());
                st.shrink(c);
                if (st.isEmpty()) {
                    sp.getInventory().setItem(i, ItemStack.EMPTY);
                }
                remaining -= c;
            }
            if (remaining > 0 && (patt1$temp = sp.containerMenu) instanceof ShellMenu) {
                ShellMenu rm = (ShellMenu)patt1$temp;
                for (int i = 0; i < rm.getshellSlotCount() && remaining > 0; ++i) {
                    ItemStack st = rm.getshellContainer().getItem(i);
                    if (st.isEmpty() || !st.is(Items.IRON_INGOT)) continue;
                    int c = Math.min(remaining, st.getCount());
                    st.shrink(c);
                    if (st.isEmpty()) {
                        rm.getshellContainer().setItem(i, ItemStack.EMPTY);
                    }
                    remaining -= c;
                }
            }
            if (!isCreative && remaining > 0) {
                return;
            }
            shellStack.set(ModDataComponents.TANK2_UNLOCKED.get(), (Object)true);
            WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack);
            int cap = WidgetDataHelper.getDefaultTankCapacity(WidgetUnlockSystem.WidgetType.FLUID_TANK, tier, 2);
            shellStack.set(ModDataComponents.TANK2_CAPACITY.get(), (Object)cap);
            shellStack.set(ModDataComponents.TANK2_FLUID.get(), (Object)FluidStackData.EMPTY);
            FluidTankSyncPacket.sendTo(sp);
        });
    }
}

