/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.UpgradeDefinitions;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.network.TravelersGardenSyncPacket;
import com.etka.nomadsshell.network.WidgetUnlockedPacket;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PurchaseWidgetPacket(WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier targetTier) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PurchaseWidgetPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"purchase_widget"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PurchaseWidgetPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, widgetType) -> buf.writeEnum((Enum)widgetType), buf -> (WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class)), PurchaseWidgetPacket::widgetType, (StreamCodec)StreamCodec.of((buf, tier) -> buf.writeEnum((Enum)tier), buf -> (WidgetUnlockSystem.WidgetTier)buf.readEnum(WidgetUnlockSystem.WidgetTier.class)), PurchaseWidgetPacket::targetTier, PurchaseWidgetPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PurchaseWidgetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                PurchaseWidgetPacket.handlePurchase(packet.widgetType, packet.targetTier, serverPlayer);
            }
        });
    }

    private static void handlePurchase(WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier targetTier, ServerPlayer player) {
        boolean itemsConsumed;
        boolean isCreative;
        List<WidgetUnlockSystem.ItemRequirement> requirements;
        boolean isUpgrade;
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        boolean isInitialUnlock = targetTier == WidgetUnlockSystem.WidgetTier.TIER_I && !WidgetUnlockSystem.isUnlocked(widgetType, shellStack);
        boolean bl = isUpgrade = WidgetUnlockSystem.isUnlocked(widgetType, shellStack) && WidgetUnlockSystem.getWidgetTier(widgetType, shellStack).getLevel() + 1 == targetTier.getLevel();
        if (!isInitialUnlock && !isUpgrade) {
            return;
        }
        if (isUpgrade && !PurchaseWidgetPacket.isUpgradeAllowedByTree(widgetType, targetTier, shellStack)) {
            return;
        }
        if (isInitialUnlock) {
            requirements = widgetType.getRequirements();
        } else {
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shellStack);
            requirements = widgetType.getUpgradeRequirements(currentTier, targetTier);
        }
        boolean hasRequiredItems = isCreative = player.getAbilities().instabuild;
        if (!isCreative) {
            hasRequiredItems = true;
            for (WidgetUnlockSystem.ItemRequirement req : requirements) {
                int playerHas = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                if (playerHas >= req.getCount()) continue;
                hasRequiredItems = false;
                break;
            }
        }
        UpgradeDefinitions.UpgradeNode node = PurchaseWidgetPacket.findNodeForWidget(widgetType, targetTier);
        String tagRequirement = null;
        int tagCount = 0;
        if (!isCreative && node != null && node.tagRequirement != null && node.tagCount > 0) {
            tagRequirement = node.tagRequirement;
            tagCount = node.tagCount;
            int playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)tagRequirement));
            if (playerHas < tagCount) {
                hasRequiredItems = false;
            }
        }
        if (!hasRequiredItems) {
            return;
        }
        boolean bl2 = itemsConsumed = isCreative || PurchaseWidgetPacket.consumeRequiredItems(requirements, player) && PurchaseWidgetPacket.consumeTagRequirement(tagRequirement, tagCount, player);
        if (itemsConsumed) {
            if (isInitialUnlock) {
                WidgetUnlockSystem.unlock(widgetType, shellStack);
                if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                    WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(widgetType, shellStack);
                    int tank1Capacity = WidgetDataHelper.getDefaultTankCapacity(widgetType, tier, 1);
                    shellStack.set(ModDataComponents.TANK1_CAPACITY.get(), (Object)tank1Capacity);
                    shellStack.set(ModDataComponents.TANK1_FLUID.get(), (Object)FluidStackData.EMPTY);
                    int maxTanks = switch (tier) {
                        case WidgetUnlockSystem.WidgetTier.TIER_I -> 1;
                        case WidgetUnlockSystem.WidgetTier.TIER_II, WidgetUnlockSystem.WidgetTier.TIER_III -> 2;
                        case WidgetUnlockSystem.WidgetTier.TIER_IV, WidgetUnlockSystem.WidgetTier.TIER_V -> 3;
                        case WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII -> 4;
                        case WidgetUnlockSystem.WidgetTier.TIER_VIII, WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 5;
                        default -> 1;
                    };
                    for (int i = 2; i <= 5; ++i) {
                        if (i <= maxTanks) {
                            int capacity = WidgetDataHelper.getDefaultTankCapacity(widgetType, tier, i);
                            shellStack.set(PurchaseWidgetPacket.getTankCapacityComponent(i), (Object)capacity);
                        } else {
                            shellStack.set(PurchaseWidgetPacket.getTankCapacityComponent(i), (Object)0);
                        }
                        shellStack.set(PurchaseWidgetPacket.getTankFluidComponent(i), (Object)FluidStackData.EMPTY);
                    }
                }
                if (widgetType == WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM) {
                    shellStack.set(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)1);
                    shellStack.set(ModDataComponents.DRIP_SOURCE_FLUID_0.get(), (Object)FluidStackData.EMPTY);
                    shellStack.set(ModDataComponents.DRIP_SOURCE_FLUID_1.get(), (Object)FluidStackData.EMPTY);
                    shellStack.set(ModDataComponents.DRIP_SOURCE_FLUID_2.get(), (Object)FluidStackData.EMPTY);
                    shellStack.set(ModDataComponents.DRIP_SOURCE_FLUID_3.get(), (Object)FluidStackData.EMPTY);
                    shellStack.set(ModDataComponents.DRIP_SOURCE_FLUID_4.get(), (Object)FluidStackData.EMPTY);
                    shellStack.set(ModDataComponents.DRIP_CAULDRON_MB_0.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_CAULDRON_MB_1.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_CAULDRON_MB_2.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_CAULDRON_MB_3.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_CAULDRON_MB_4.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_PROGRESS_0.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_PROGRESS_1.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_PROGRESS_2.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_PROGRESS_3.get(), (Object)0);
                    shellStack.set(ModDataComponents.DRIP_PROGRESS_4.get(), (Object)0);
                }
                if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                    shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
                    shellStack.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                    shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)0);
                    shellStack.set(ModDataComponents.TG_PLANTS.get(), new ArrayList());
                    shellStack.set(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList());
                    if (player != null) {
                        TravelersGardenSyncPacket.sendTo(player);
                    }
                }
            } else {
                WidgetUnlockSystem.setWidgetTier(widgetType, targetTier, shellStack);
                if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                    switch (targetTier) {
                        case TIER_II: {
                            shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)10);
                            shellStack.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)3);
                            TravelersGardenSyncPacket.sendTo(player);
                            break;
                        }
                        case TIER_III: {
                            shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)25);
                            TravelersGardenSyncPacket.sendTo(player);
                            break;
                        }
                        case TIER_IV: {
                            shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)15);
                            shellStack.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                            TravelersGardenSyncPacket.sendTo(player);
                            break;
                        }
                        case TIER_V: {
                            shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)50);
                            TravelersGardenSyncPacket.sendTo(player);
                            break;
                        }
                        case TIER_VI: {
                            shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)20);
                            shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)60);
                            TravelersGardenSyncPacket.sendTo(player);
                            break;
                        }
                    }
                }
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WidgetUnlockedPacket(widgetType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static boolean consumeRequiredItems(List<WidgetUnlockSystem.ItemRequirement> requirements, ServerPlayer player) {
        Map<Item, Integer> availableItems = InventoryUtils.getAllItemCountsAcrossInventoryAndshell((Player)player);
        for (WidgetUnlockSystem.ItemRequirement requirement : requirements) {
            int available = availableItems.getOrDefault(requirement.getItem(), 0);
            if (available >= requirement.getCount()) continue;
            return false;
        }
        for (WidgetUnlockSystem.ItemRequirement requirement : requirements) {
            int i;
            AbstractContainerMenu stack;
            int remaining = requirement.getCount();
            for (int i2 = 0; i2 < player.getInventory().getContainerSize() && remaining > 0; ++i2) {
                stack = player.getInventory().getItem(i2);
                if (stack.isEmpty() || stack.getItem() != requirement.getItem()) continue;
                int toConsume = Math.min(remaining, stack.getCount());
                stack.shrink(toConsume);
                if (stack.isEmpty()) {
                    player.getInventory().setItem(i2, ItemStack.EMPTY);
                }
                remaining -= toConsume;
            }
            if (remaining <= 0) continue;
            stack = player.containerMenu;
            if (stack instanceof ShellMenu) {
                ShellMenu ShellMenu2 = (ShellMenu)stack;
                for (int i3 = 0; i3 < ShellMenu2.getshellSlotCount() && remaining > 0; ++i3) {
                    ItemStack stack2 = ShellMenu2.getshellContainer().getItem(i3);
                    if (stack2.isEmpty() || stack2.getItem() != requirement.getItem()) continue;
                    int toConsume = Math.min(remaining, stack2.getCount());
                    stack2.shrink(toConsume);
                    if (stack2.isEmpty()) {
                        ShellMenu2.getshellContainer().setItem(i3, ItemStack.EMPTY);
                    }
                    remaining -= toConsume;
                }
                continue;
            }
            ItemStack shell = ShellItem.findWornshell((Player)player);
            if (shell.isEmpty()) continue;
            ItemContainerContents originalshellContents = ShellItem.getshellContents(shell);
            ArrayList<ItemStack> ShellItems = new ArrayList<ItemStack>();
            for (i = 0; i < originalshellContents.getSlots(); ++i) {
                ShellItems.add(originalshellContents.getStackInSlot(i).copy());
            }
            for (i = 0; i < ShellItems.size() && remaining > 0; ++i) {
                ItemStack stack3 = (ItemStack)ShellItems.get(i);
                if (stack3.isEmpty() || stack3.getItem() != requirement.getItem()) continue;
                int toConsume = Math.min(remaining, stack3.getCount());
                stack3.shrink(toConsume);
                if (stack3.isEmpty()) {
                    ShellItems.set(i, ItemStack.EMPTY);
                }
                remaining -= toConsume;
            }
            ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(ShellItems);
            ShellItem.setshellContents(shell, newContents);
        }
        return true;
    }

    private static UpgradeDefinitions.UpgradeNode findNodeForWidget(WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier tier) {
        for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
            if (node.widgetType != widgetType || node.tier != tier) continue;
            return node;
        }
        return null;
    }

    private static boolean consumeTagRequirement(String tagRequirement, int tagCount, ServerPlayer player) {
        if (tagRequirement == null || tagCount <= 0) {
            return true;
        }
        return InventoryUtils.consumeItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)tagRequirement), tagCount);
    }

    private static DataComponentType<Integer> getTankCapacityComponent(int tankIndex) {
        return switch (tankIndex) {
            case 2 -> ModDataComponents.TANK2_CAPACITY.get();
            case 3 -> ModDataComponents.TANK3_CAPACITY.get();
            case 4 -> ModDataComponents.TANK4_CAPACITY.get();
            case 5 -> ModDataComponents.TANK5_CAPACITY.get();
            default -> throw new IllegalArgumentException("Invalid tank index: " + tankIndex);
        };
    }

    private static DataComponentType<FluidStackData> getTankFluidComponent(int tankIndex) {
        return switch (tankIndex) {
            case 2 -> ModDataComponents.TANK2_FLUID.get();
            case 3 -> ModDataComponents.TANK3_FLUID.get();
            case 4 -> ModDataComponents.TANK4_FLUID.get();
            case 5 -> ModDataComponents.TANK5_FLUID.get();
            default -> throw new IllegalArgumentException("Invalid tank index: " + tankIndex);
        };
    }

    private static boolean isUpgradeAllowedByTree(WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier targetTier, ItemStack shellStack) {
        UpgradeDefinitions.UpgradeNode targetNode = PurchaseWidgetPacket.findNodeForWidget(widgetType, targetTier);
        if (targetNode == null) {
            return false;
        }
        for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
            if (!node.connections.contains(targetNode.id) || !PurchaseWidgetPacket.isNodeUnlockedInTree(node, shellStack)) continue;
            return true;
        }
        return targetNode.id.equals("start") || UpgradeDefinitions.getNode((String)"start").connections.contains(targetNode.id);
    }

    private static boolean isNodeUnlockedInTree(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (node.id.equals("start")) {
            return true;
        }
        if (node.widgetType != null) {
            boolean widgetUnlocked = WidgetUnlockSystem.isUnlocked(node.widgetType, shellStack);
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(node.widgetType, shellStack);
            return widgetUnlocked && currentTier.getLevel() >= node.tier.getLevel();
        }
        return PurchaseWidgetPacket.isSubUpgradeUnlockedInTree(node.id, shellStack);
    }

    private static boolean isSubUpgradeUnlockedInTree(String nodeId, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return false;
        }
        if (nodeId.startsWith("furnace_smelt_speed_") || nodeId.startsWith("furnace_fuel_eff_")) {
            int n;
            try {
                n = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            int requiredLevel = nodeId.startsWith("furnace_smelt_speed_") ? Math.max(1, 2 * n - 1) : Math.min(6, 2 * n);
            int perfLevel = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)0);
            return perfLevel >= requiredLevel;
        }
        switch (nodeId) {
            case "furnace_template_1": 
            case "furnace_template_2": 
            case "furnace_template_3": 
            case "furnace_template_4": 
            case "furnace_template_5": {
                int templateSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
                int requiredSlots = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
                return templateSlots >= requiredSlots;
            }
            case "furnace_tag_puller": {
                int tagPullerSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
                return tagPullerSlots >= 5;
            }
            case "auto_crafter_unlock": {
                return (Boolean)shellStack.getOrDefault(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)false);
            }
            case "dripstone_2": 
            case "dripstone_3": 
            case "dripstone_4": 
            case "dripstone_5": {
                int cauldronCount = (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
                int requiredCauldrons = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
                return cauldronCount >= requiredCauldrons;
            }
            case "dripstone_auto_transfer": {
                if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack)) {
                    return false;
                }
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
        }
        return false;
    }
}

