/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record QuickStoreToShellPacket(int slotIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<QuickStoreToShellPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"quick_store_to_shell"));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuickStoreToShellPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, QuickStoreToShellPacket>(){

        public QuickStoreToShellPacket decode(RegistryFriendlyByteBuf buffer) {
            int slotIndex = buffer.readVarInt();
            return new QuickStoreToShellPacket(slotIndex);
        }

        public void encode(RegistryFriendlyByteBuf buffer, QuickStoreToShellPacket packet) {
            buffer.writeVarInt(packet.slotIndex);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(QuickStoreToShellPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                QuickStoreToShellPacket.handleQuickStore(serverPlayer, packet.slotIndex);
            }
        });
    }

    private static void handleQuickStore(ServerPlayer player, int slotIndex) {
        ItemStack itemToAdd;
        ItemStack carriedShell = player.containerMenu.getCarried();
        if (carriedShell.isEmpty() || !(carriedShell.getItem() instanceof ShellItem)) {
            return;
        }
        if (slotIndex < 0 || slotIndex >= player.containerMenu.slots.size()) {
            return;
        }
        Slot slot = (Slot)player.containerMenu.slots.get(slotIndex);
        ItemStack slotItem = slot.getItem();
        if (slotItem.isEmpty() || slotItem.getItem() instanceof ShellItem) {
            return;
        }
        VirtualInventory shellInventory = ShellItem.getVirtualInventory(carriedShell);
        ItemStack remaining = shellInventory.addItem(itemToAdd = slotItem.copy());
        if (remaining.getCount() < slotItem.getCount()) {
            ShellItem.setVirtualInventory(carriedShell, shellInventory);
            player.containerMenu.setCarried(carriedShell);
            slot.set(remaining);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + (player.level().random.nextFloat() - 0.5f) * 0.4f);
            player.containerMenu.broadcastChanges();
        }
    }
}

