/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ThrowItemPacket(int slotIndex, boolean throwAll) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ThrowItemPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"throw_item"));
    public static final StreamCodec<FriendlyByteBuf, ThrowItemPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ThrowItemPacket>(){

        public ThrowItemPacket decode(FriendlyByteBuf buffer) {
            int slotIndex = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            boolean throwAll = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
            return new ThrowItemPacket(slotIndex, throwAll);
        }

        public void encode(FriendlyByteBuf buffer, ThrowItemPacket packet) {
            ByteBufCodecs.INT.encode((Object)buffer, (Object)packet.slotIndex);
            ByteBufCodecs.BOOL.encode((Object)buffer, (Object)packet.throwAll);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ThrowItemPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                if (packet.slotIndex < 0 || packet.slotIndex >= serverPlayer.containerMenu.slots.size()) {
                    return;
                }
                Slot slot = (Slot)serverPlayer.containerMenu.slots.get(packet.slotIndex);
                if (slot == null || !slot.hasItem()) {
                    return;
                }
                ItemStack stackInSlot = slot.getItem();
                if (stackInSlot.isEmpty()) {
                    return;
                }
                if (packet.throwAll) {
                    ItemStack droppedStack = stackInSlot.copy();
                    slot.set(ItemStack.EMPTY);
                    serverPlayer.drop(droppedStack, false);
                } else {
                    ItemStack droppedStack = stackInSlot.split(1);
                    if (stackInSlot.isEmpty()) {
                        slot.set(ItemStack.EMPTY);
                    }
                    serverPlayer.drop(droppedStack, false);
                }
                slot.setChanged();
            }
        });
    }
}

