/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.network.FurnaceSyncPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleFurnaceInputSourcePacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleFurnaceInputSourcePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"toggle_furnace_input_source"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleFurnaceInputSourcePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {}, buf -> new ToggleFurnaceInputSourcePacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ToggleFurnaceInputSourcePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ToggleFurnaceInputSourcePacket.handleToggle(player);
            }
        });
    }

    private static void handleToggle(ServerPlayer player) {
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.FURNACE;
        if (!WidgetUnlockSystem.isUnlocked(widgetType, shellStack)) {
            return;
        }
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shellStack);
        if (currentTier != WidgetUnlockSystem.WidgetTier.TIER_II) {
            return;
        }
        boolean currentSetting = WidgetDataHelper.getFurnaceInputFromBoth((Player)player);
        boolean newSetting = !currentSetting;
        WidgetDataHelper.setFurnaceInputFromBoth((Player)player, newSetting);
        String source = newSetting ? "both backpack and inventory" : "backpack only";
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.UI_BUTTON_CLICK, SoundSource.PLAYERS, 0.5f, 1.0f);
        FurnaceSyncPacket.sendTo(player);
    }
}

