/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TrashItemPacket(boolean hasTrashItem, ItemStack trashItem, int maxMergeCount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TrashItemPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"trash_item"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrashItemPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TrashItemPacket>(){

        public TrashItemPacket decode(RegistryFriendlyByteBuf buffer) {
            boolean hasTrashItem = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
            ItemStack trashItem = hasTrashItem ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            int maxMergeCount = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            return new TrashItemPacket(hasTrashItem, trashItem, maxMergeCount);
        }

        public void encode(RegistryFriendlyByteBuf buffer, TrashItemPacket packet) {
            ByteBufCodecs.BOOL.encode((Object)buffer, (Object)packet.hasTrashItem);
            if (packet.hasTrashItem) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.trashItem);
            }
            ByteBufCodecs.INT.encode((Object)buffer, (Object)packet.maxMergeCount);
        }
    };

    public TrashItemPacket() {
        this(false, ItemStack.EMPTY, -1);
    }

    public TrashItemPacket(ItemStack item, int maxMergeCount) {
        this(!item.isEmpty(), item.isEmpty() ? ItemStack.EMPTY : item, maxMergeCount);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TrashItemPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack carried = serverPlayer.containerMenu.getCarried();
                if (!carried.isEmpty()) {
                    ItemStack currentTrashItem = WidgetDataHelper.getTrashBinItem((Player)serverPlayer);
                    if (!packet.hasTrashItem || packet.maxMergeCount == -1) {
                        WidgetDataHelper.setTrashBinItem((Player)serverPlayer, carried.copy());
                        serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newTrashItem = packet.trashItem;
                        if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)newTrashItem)) {
                            int carriedCount = carried.getCount();
                            int newTrashCount = newTrashItem.getCount();
                            int totalCount = carriedCount + currentTrashItem.getCount();
                            if (totalCount <= packet.maxMergeCount) {
                                WidgetDataHelper.setTrashBinItem((Player)serverPlayer, newTrashItem.copy());
                                serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
                            } else {
                                int currentTrashCount = currentTrashItem.getCount();
                                int amountToDelete = packet.maxMergeCount - currentTrashCount;
                                if (amountToDelete > 0 && amountToDelete < carriedCount) {
                                    carried.shrink(amountToDelete);
                                    ItemStack updatedTrash = newTrashItem.copy();
                                    updatedTrash.setCount(packet.maxMergeCount);
                                    WidgetDataHelper.setTrashBinItem((Player)serverPlayer, updatedTrash);
                                } else if (amountToDelete >= carriedCount) {
                                    WidgetDataHelper.setTrashBinItem((Player)serverPlayer, newTrashItem.copy());
                                    serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
                                }
                            }
                        } else {
                            WidgetDataHelper.setTrashBinItem((Player)serverPlayer, carried.copy());
                            serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
                        }
                    }
                }
            }
        });
    }
}

