/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateAutoFeederSettingsPacket(boolean feedOnDamage, boolean waitForFullHunger, boolean waitForFullDamage) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateAutoFeederSettingsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_auto_feeder_settings"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateAutoFeederSettingsPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBoolean(packet.feedOnDamage);
        buf.writeBoolean(packet.waitForFullHunger);
        buf.writeBoolean(packet.waitForFullDamage);
    }, buf -> {
        boolean feedOnDamage = buf.readBoolean();
        boolean waitForFullHunger = buf.readBoolean();
        boolean waitForFullDamage = buf.readBoolean();
        return new UpdateAutoFeederSettingsPacket(feedOnDamage, waitForFullHunger, waitForFullDamage);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateAutoFeederSettingsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                WidgetDataHelper.setAutoFeederFeedOnDamage((Player)player, packet.feedOnDamage);
                WidgetDataHelper.setAutoFeederWaitForFullHunger((Player)player, packet.waitForFullHunger);
                WidgetDataHelper.setAutoFeederWaitForFullDamage((Player)player, packet.waitForFullDamage);
            }
        });
    }
}

