/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record WidgetUpgradedPacket(WidgetUnlockSystem.WidgetType widgetType, WidgetUnlockSystem.WidgetTier newTier) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WidgetUpgradedPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"widget_upgraded"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WidgetUpgradedPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, wt) -> buf.writeEnum((Enum)wt), buf -> (WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class)), WidgetUpgradedPacket::widgetType, (StreamCodec)StreamCodec.of((buf, tier) -> buf.writeEnum((Enum)tier), buf -> (WidgetUnlockSystem.WidgetTier)buf.readEnum(WidgetUnlockSystem.WidgetTier.class)), WidgetUpgradedPacket::newTier, WidgetUpgradedPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(WidgetUpgradedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            if (!shellStack.isEmpty()) {
                WidgetUnlockSystem.setWidgetTier(packet.widgetType, packet.newTier, shellStack);
            }
        });
    }
}

