/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.upgrade;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.upgrade.UpgradeCommand;
import com.etka.nomadsshell.util.FluidStackData;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class UpgradeFluidTankTierCommand
implements UpgradeCommand {
    private final WidgetUnlockSystem.WidgetTier targetTier;

    public UpgradeFluidTankTierCommand(WidgetUnlockSystem.WidgetTier tier) {
        this.targetTier = tier;
    }

    @Override
    public void execute(ItemStack shellStack, ServerPlayer player) {
        WidgetUnlockSystem.setWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, this.targetTier, shellStack);
        this.updateTankCapacities(shellStack, this.targetTier);
    }

    @Override
    public boolean canExecute(ItemStack shellStack, ServerPlayer player) {
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack)) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack);
        return currentTier.getLevel() < this.targetTier.getLevel();
    }

    @Override
    public String getCommandId() {
        return "upgrade_fluid_tank_" + this.targetTier.name().toLowerCase();
    }

    private void updateTankCapacities(ItemStack shellStack, WidgetUnlockSystem.WidgetTier tier) {
        int maxTanks = UpgradeFluidTankTierCommand.getMaxTanksForTier(tier);
        for (int i = 1; i <= 5; ++i) {
            if (i <= maxTanks) {
                int capacity = UpgradeFluidTankTierCommand.getCorrectTankCapacity(tier, i);
                shellStack.set(UpgradeFluidTankTierCommand.getTankCapacityComponent(i), (Object)capacity);
                if (shellStack.get(UpgradeFluidTankTierCommand.getTankFluidComponent(i)) != null) continue;
                shellStack.set(UpgradeFluidTankTierCommand.getTankFluidComponent(i), (Object)FluidStackData.EMPTY);
                continue;
            }
            shellStack.set(UpgradeFluidTankTierCommand.getTankCapacityComponent(i), (Object)0);
        }
    }

    private static int getCorrectTankCapacity(WidgetUnlockSystem.WidgetTier tier, int tankIndex) {
        return switch (tier) {
            case WidgetUnlockSystem.WidgetTier.TIER_I -> 3000;
            case WidgetUnlockSystem.WidgetTier.TIER_II -> 3000;
            case WidgetUnlockSystem.WidgetTier.TIER_III -> 6000;
            case WidgetUnlockSystem.WidgetTier.TIER_IV -> 6000;
            case WidgetUnlockSystem.WidgetTier.TIER_V -> 12000;
            case WidgetUnlockSystem.WidgetTier.TIER_VI -> 12000;
            case WidgetUnlockSystem.WidgetTier.TIER_VII -> 20000;
            case WidgetUnlockSystem.WidgetTier.TIER_VIII -> 20000;
            case WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 20000;
            default -> 3000;
        };
    }

    private static int getMaxTanksForTier(WidgetUnlockSystem.WidgetTier tier) {
        return switch (tier) {
            case WidgetUnlockSystem.WidgetTier.TIER_I -> 1;
            case WidgetUnlockSystem.WidgetTier.TIER_II, WidgetUnlockSystem.WidgetTier.TIER_III -> 2;
            case WidgetUnlockSystem.WidgetTier.TIER_IV, WidgetUnlockSystem.WidgetTier.TIER_V -> 3;
            case WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII -> 4;
            case WidgetUnlockSystem.WidgetTier.TIER_VIII, WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 5;
            default -> 1;
        };
    }

    private static DataComponentType<Integer> getTankCapacityComponent(int tankIndex) {
        return switch (tankIndex) {
            case 1 -> ModDataComponents.TANK1_CAPACITY.get();
            case 2 -> ModDataComponents.TANK2_CAPACITY.get();
            case 3 -> ModDataComponents.TANK3_CAPACITY.get();
            case 4 -> ModDataComponents.TANK4_CAPACITY.get();
            case 5 -> ModDataComponents.TANK5_CAPACITY.get();
            default -> throw new IllegalArgumentException("Invalid tank index: " + tankIndex);
        };
    }

    private static DataComponentType<FluidStackData> getTankFluidComponent(int tankIndex) {
        return switch (tankIndex) {
            case 1 -> ModDataComponents.TANK1_FLUID.get();
            case 2 -> ModDataComponents.TANK2_FLUID.get();
            case 3 -> ModDataComponents.TANK3_FLUID.get();
            case 4 -> ModDataComponents.TANK4_FLUID.get();
            case 5 -> ModDataComponents.TANK5_FLUID.get();
            default -> throw new IllegalArgumentException("Invalid tank index: " + tankIndex);
        };
    }
}

