/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.upgrade;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.upgrade.UpgradeCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class UpgradeFurnaceTemplateSlotsCommand
implements UpgradeCommand {
    @Override
    public void execute(ItemStack shellStack, ServerPlayer player) {
        int currentSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
        shellStack.set(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)(currentSlots + 1));
    }

    @Override
    public boolean canExecute(ItemStack shellStack, ServerPlayer player) {
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FURNACE, shellStack)) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        if (currentTier.getLevel() < 2) {
            return false;
        }
        int currentSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
        return currentSlots < 5;
    }

    @Override
    public String getCommandId() {
        return "upgrade_furnace_template_slots";
    }
}

