/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.upgrade;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.upgrade.UpgradeCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class UpgradeGuardianTierCommand
implements UpgradeCommand {
    private final WidgetUnlockSystem.WidgetTier targetTier;

    public UpgradeGuardianTierCommand(WidgetUnlockSystem.WidgetTier tier) {
        this.targetTier = tier;
    }

    @Override
    public void execute(ItemStack shellStack, ServerPlayer player) {
        WidgetUnlockSystem.setWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, this.targetTier, shellStack);
    }

    @Override
    public boolean canExecute(ItemStack shellStack, ServerPlayer player) {
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack)) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack);
        return currentTier.getLevel() < this.targetTier.getLevel();
    }

    @Override
    public String getCommandId() {
        return "upgrade_guardian_" + this.targetTier.name().toLowerCase();
    }
}

