/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.etka.nomadsshell.util.ItemStackData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record AutoCraftRecipe(List<ItemStackData> templateGrid, ItemStackData resultItem, ResourceLocation recipeId, String displayName) {
    public static final Codec<AutoCraftRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(ItemStackData.CODEC).fieldOf("template_grid").forGetter(AutoCraftRecipe::templateGrid), (App)ItemStackData.CODEC.fieldOf("result_item").forGetter(AutoCraftRecipe::resultItem), (App)ResourceLocation.CODEC.fieldOf("recipe_id").forGetter(AutoCraftRecipe::recipeId), (App)Codec.STRING.fieldOf("display_name").forGetter(AutoCraftRecipe::displayName)).apply((Applicative)instance, AutoCraftRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutoCraftRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeVarInt(recipe.templateGrid().size());
        for (ItemStackData item : recipe.templateGrid()) {
            ItemStackData.STREAM_CODEC.encode(buf, (Object)item);
        }
        ItemStackData.STREAM_CODEC.encode(buf, (Object)recipe.resultItem());
        ResourceLocation.STREAM_CODEC.encode(buf, (Object)recipe.recipeId());
        buf.writeUtf(recipe.displayName());
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ItemStackData> templateGrid = new ArrayList<ItemStackData>(size);
        for (int i = 0; i < size; ++i) {
            templateGrid.add((ItemStackData)ItemStackData.STREAM_CODEC.decode(buf));
        }
        ItemStackData resultItem = (ItemStackData)ItemStackData.STREAM_CODEC.decode(buf);
        ResourceLocation recipeId = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode(buf);
        String displayName = buf.readUtf();
        return new AutoCraftRecipe(templateGrid, resultItem, recipeId, displayName);
    });

    public boolean isValid() {
        return !this.resultItem.isEmpty() && this.templateGrid.stream().anyMatch(item -> !item.isEmpty()) && !this.recipeId.toString().equals("minecraft:empty");
    }

    public String getDisplayName() {
        if (this.displayName != null && !this.displayName.isEmpty()) {
            return this.displayName;
        }
        if (!this.resultItem.isEmpty()) {
            return this.resultItem.toItemStack().getHoverName().getString();
        }
        return "Unknown Recipe";
    }
}

