/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen;

import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.network.ConfigUpdatePacket;
import com.etka.nomadsshell.network.UpdatePocketSettingsPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class AdminConfigScreen
extends Screen {
    private Tab currentTab = Tab.TIER_DIMENSIONS;
    private static final int TITLE_BAR_HEIGHT = 16;
    private static final int CLOSE_BTN_SIZE = 12;
    private static final int CONTENT_MARGIN = 12;
    private static final int TAB_HEIGHT = 18;
    private static final int BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private static final int FIELD_WIDTH = 60;
    private static final int FIELD_HEIGHT = 18;
    private static final int ROW_HEIGHT = 25;
    private int closeBtnX;
    private int closeBtnY;
    private int tierTabX;
    private int tierTabY;
    private int tierTabW;
    private int tierTabH;
    private int pocketTabX;
    private int pocketTabY;
    private int pocketTabW;
    private int pocketTabH;
    private int creditsTabX;
    private int creditsTabY;
    private int creditsTabW;
    private int creditsTabH;
    private final Map<ShellTier, EditBox> widthFields = new HashMap<ShellTier, EditBox>();
    private final Map<ShellTier, EditBox> heightFields = new HashMap<ShellTier, EditBox>();
    private Button applyTierDimensionsBtn;
    private Button resetToDefaultsBtn;
    private EditBox pocketWidthField;
    private EditBox pocketLengthField;
    private EditBox pocketHeightField;
    private Button pocketBackgroundBtn;
    private Button applyPocketBtn;
    private int pocketWidth = 17;
    private int pocketLength = 17;
    private int pocketHeight = 25;
    private int pocketBackground = 0;

    public AdminConfigScreen() {
        super((Component)Component.translatable((String)"nomadsshell.admin.title"));
        this.pocketWidth = (Integer)ShellConfig.SERVER.teleporterPocketWidth.get();
        this.pocketLength = (Integer)ShellConfig.SERVER.teleporterPocketLength.get();
        this.pocketHeight = (Integer)ShellConfig.SERVER.teleporterPocketHeight.get();
        this.pocketBackground = (Integer)ShellConfig.SERVER.teleporterPocketBackground.get();
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.calculateTabPositions();
        int contentX = 12;
        int contentY = 54;
        if (this.currentTab == Tab.TIER_DIMENSIONS) {
            this.initTierDimensionsTab(contentX, contentY);
        } else if (this.currentTab == Tab.POCKET_DIMENSION) {
            this.initPocketDimensionTab(contentX, contentY);
        } else {
            this.initCreditsTab(contentX, contentY);
        }
        this.closeBtnX = this.width - 12 - 6;
        this.closeBtnY = 2;
    }

    private void calculateTabPositions() {
        int sw = this.width;
        int tabY = 22;
        int tabWidth = Math.max(120, (sw - 24) / 4);
        int tabSpacing = 8;
        this.tierTabX = 12;
        this.tierTabY = tabY;
        this.tierTabW = tabWidth;
        this.tierTabH = 18;
        this.pocketTabX = this.tierTabX + tabWidth + tabSpacing;
        this.pocketTabY = tabY;
        this.pocketTabW = tabWidth;
        this.pocketTabH = 18;
        this.creditsTabX = this.pocketTabX + tabWidth + tabSpacing;
        this.creditsTabY = tabY;
        this.creditsTabW = tabWidth;
        this.creditsTabH = 18;
    }

    private void switchTab(Tab tab) {
        if (this.currentTab != tab) {
            this.currentTab = tab;
            this.init();
        }
    }

    private void initTierDimensionsTab(int contentX, int contentY) {
        int startY = contentY + 30;
        int labelWidth = 100;
        int fieldSpacing = 15;
        ShellTier[] tiers = ShellTier.values();
        for (int i = 0; i < tiers.length; ++i) {
            ShellTier tier = tiers[i];
            int x = contentX + 20;
            int y = startY + i * 25;
            EditBox widthField = new EditBox(this.font, x + labelWidth, y, 60, 18, (Component)Component.literal((String)"Width"));
            widthField.setMaxLength(5);
            widthField.setValue(String.valueOf(ShellConfig.SERVER.getWidth(tier)));
            widthField.setFilter(this::isValidNumber);
            this.addRenderableWidget((GuiEventListener)widthField);
            this.widthFields.put(tier, widthField);
            EditBox heightField = new EditBox(this.font, x + labelWidth + 60 + fieldSpacing, y, 60, 18, (Component)Component.literal((String)"Height"));
            heightField.setMaxLength(5);
            heightField.setValue(String.valueOf(ShellConfig.SERVER.getHeight(tier)));
            heightField.setFilter(this::isValidNumber);
            this.addRenderableWidget((GuiEventListener)heightField);
            this.heightFields.put(tier, heightField);
        }
        int buttonY = startY + tiers.length * 25 + 20;
        this.applyTierDimensionsBtn = Button.builder((Component)Component.translatable((String)"nomadsshell.admin.apply_tier_dimensions"), this::applyTierDimensions).bounds(contentX + 20, buttonY, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.applyTierDimensionsBtn);
        this.resetToDefaultsBtn = Button.builder((Component)Component.translatable((String)"nomadsshell.admin.reset_to_defaults"), this::resetToDefaults).bounds(contentX + 20 + 120 + 10, buttonY, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.resetToDefaultsBtn);
    }

    private void initPocketDimensionTab(int contentX, int contentY) {
        int y = contentY + 30;
        int x = contentX + 20;
        int labelWidth = 120;
        this.pocketWidthField = new EditBox(this.font, x + labelWidth, y, 60, 18, (Component)Component.literal((String)"Width"));
        this.pocketWidthField.setMaxLength(5);
        this.pocketWidthField.setValue(String.valueOf(this.pocketWidth));
        this.pocketWidthField.setFilter(this::isValidNumber);
        this.addRenderableWidget((GuiEventListener)this.pocketWidthField);
        this.pocketLengthField = new EditBox(this.font, x + labelWidth, y += 25, 60, 18, (Component)Component.literal((String)"Length"));
        this.pocketLengthField.setMaxLength(5);
        this.pocketLengthField.setValue(String.valueOf(this.pocketLength));
        this.pocketLengthField.setFilter(this::isValidNumber);
        this.addRenderableWidget((GuiEventListener)this.pocketLengthField);
        this.pocketHeightField = new EditBox(this.font, x + labelWidth, y += 25, 60, 18, (Component)Component.literal((String)"Height"));
        this.pocketHeightField.setMaxLength(5);
        this.pocketHeightField.setValue(String.valueOf(this.pocketHeight));
        this.pocketHeightField.setFilter(this::isValidNumber);
        this.addRenderableWidget((GuiEventListener)this.pocketHeightField);
        this.pocketBackgroundBtn = Button.builder((Component)Component.literal((String)this.pocketBackgroundLabel()), b -> {
            this.pocketBackground = (this.pocketBackground + 1) % 2;
            this.pocketBackgroundBtn.setMessage((Component)Component.literal((String)this.pocketBackgroundLabel()));
        }).bounds(x + labelWidth, y += 25, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.pocketBackgroundBtn);
        this.applyPocketBtn = Button.builder((Component)Component.translatable((String)"nomadsshell.admin.apply_pocket_settings"), this::applyPocketSettings).bounds(x + labelWidth, y += 35, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.applyPocketBtn);
    }

    private void initCreditsTab(int contentX, int contentY) {
    }

    private void applyTierDimensions(Button button) {
        try {
            HashMap<ShellTier, ConfigUpdatePacket.ConfigData> tierConfigs = new HashMap<ShellTier, ConfigUpdatePacket.ConfigData>();
            for (ShellTier tier : ShellTier.values()) {
                String widthText = this.widthFields.get((Object)tier).getValue();
                String heightText = this.heightFields.get((Object)tier).getValue();
                if (widthText.isEmpty() || heightText.isEmpty()) {
                    this.sendErrorMessage("nomadsshell.admin.error.empty_fields");
                    return;
                }
                int width = Integer.parseInt(widthText);
                int height = Integer.parseInt(heightText);
                if (width <= 0 || height <= 0) {
                    this.sendErrorMessage("nomadsshell.admin.error.invalid_values");
                    return;
                }
                tierConfigs.put(tier, new ConfigUpdatePacket.ConfigData(width, height));
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ConfigUpdatePacket(tierConfigs), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.sendSuccessMessage("nomadsshell.admin.success.tier_dimensions");
        }
        catch (NumberFormatException e) {
            this.sendErrorMessage("nomadsshell.admin.error.invalid_numbers");
        }
    }

    private void applyPocketSettings(Button button) {
        try {
            this.pocketWidth = Math.max(1, Integer.parseInt(this.pocketWidthField.getValue()));
            this.pocketLength = Math.max(1, Integer.parseInt(this.pocketLengthField.getValue()));
            this.pocketHeight = Math.max(3, Integer.parseInt(this.pocketHeightField.getValue()));
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdatePocketSettingsPacket(this.pocketWidth, this.pocketLength, this.pocketHeight, this.pocketBackground), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.sendSuccessMessage("nomadsshell.admin.success.pocket_settings");
        }
        catch (NumberFormatException e) {
            this.sendErrorMessage("nomadsshell.admin.error.invalid_pocket_values");
        }
    }

    private void resetToDefaults(Button button) {
        for (ShellTier tier : ShellTier.values()) {
            EditBox widthField = this.widthFields.get((Object)tier);
            EditBox heightField = this.heightFields.get((Object)tier);
            if (widthField == null || heightField == null) continue;
            int defaultWidth = this.getDefaultWidth(tier);
            int defaultHeight = this.getDefaultHeight(tier);
            widthField.setValue(String.valueOf(defaultWidth));
            heightField.setValue(String.valueOf(defaultHeight));
        }
        this.pocketWidth = 17;
        this.pocketLength = 17;
        this.pocketHeight = 25;
        this.pocketBackground = 0;
        if (this.pocketWidthField != null) {
            this.pocketWidthField.setValue(String.valueOf(this.pocketWidth));
        }
        if (this.pocketLengthField != null) {
            this.pocketLengthField.setValue(String.valueOf(this.pocketLength));
        }
        if (this.pocketHeightField != null) {
            this.pocketHeightField.setValue(String.valueOf(this.pocketHeight));
        }
        if (this.pocketBackgroundBtn != null) {
            this.pocketBackgroundBtn.setMessage((Component)Component.literal((String)this.pocketBackgroundLabel()));
        }
        this.sendSuccessMessage("nomadsshell.admin.success.reset_to_defaults");
    }

    private int getDefaultWidth(ShellTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case ShellTier.LEATHER -> 8;
            case ShellTier.COPPER -> 8;
            case ShellTier.IRON -> 10;
            case ShellTier.GOLD -> 10;
            case ShellTier.EMERALD -> 10;
            case ShellTier.DIAMOND -> 10;
            case ShellTier.DIAMOND_BLOCK -> 12;
            case ShellTier.NETHERITE -> 14;
        };
    }

    private int getDefaultHeight(ShellTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case ShellTier.LEATHER -> 4;
            case ShellTier.COPPER -> 6;
            case ShellTier.IRON -> 8;
            case ShellTier.GOLD -> 10;
            case ShellTier.EMERALD -> 11;
            case ShellTier.DIAMOND -> 12;
            case ShellTier.DIAMOND_BLOCK -> 16;
            case ShellTier.NETHERITE -> 20;
        };
    }

    private void sendSuccessMessage(String key) {
        if (this.minecraft == null || this.minecraft.player != null) {
            // empty if block
        }
    }

    private void sendErrorMessage(String key) {
        if (this.minecraft == null || this.minecraft.player != null) {
            // empty if block
        }
    }

    private boolean isValidNumber(String text) {
        if (text.isEmpty()) {
            return true;
        }
        try {
            int value = Integer.parseInt(text);
            return value > 0 && value <= 10000;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String pocketBackgroundLabel() {
        return this.pocketBackground == 1 ? Component.translatable((String)"nomadsshell.admin.pocket_background.overworld").getString() : Component.translatable((String)"nomadsshell.admin.pocket_background.end").getString();
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, Theme.overlayDim());
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(g, mouseX, mouseY, partialTick);
        int sw = this.width;
        int sh = this.height;
        g.fill(0, 0, sw, 16, Theme.titleBarBg());
        g.fill(0, 15, sw, 16, Theme.titleBarBorder());
        g.renderItem(new ItemStack((ItemLike)Items.COMMAND_BLOCK), 6, 2);
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.title").getString(), 26, 4, Theme.titleText());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.close_hint").getString(), sw - 70, 4, Theme.hintText());
        this.renderCloseButton(g);
        int contentTop = 16;
        g.fill(0, contentTop, sw, sh, Theme.contentBg());
        g.fill(0, contentTop, sw, contentTop + 1, Theme.contentTopLine());
        this.renderTabs(g, mouseX, mouseY);
        int titleY = contentTop + 30;
        String title = switch (this.currentTab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"nomadsshell.admin.tier_dimensions").getString();
            case 1 -> Component.translatable((String)"nomadsshell.admin.pocket_dimension").getString();
            case 2 -> Component.translatable((String)"nomadsshell.admin.credits").getString();
        };
        g.drawCenteredString(this.font, title, sw / 2, titleY, Theme.textPrimary());
        int contentX = 12;
        int contentY = contentTop + 28;
        if (this.currentTab == Tab.TIER_DIMENSIONS) {
            this.renderTierDimensionsTab(g, contentX, contentY);
        } else if (this.currentTab == Tab.POCKET_DIMENSION) {
            this.renderPocketDimensionTab(g, contentX, contentY);
        } else {
            this.renderCreditsTab(g, contentX, contentY);
        }
        for (Renderable widget : this.renderables) {
            widget.render(g, mouseX, mouseY, partialTick);
        }
    }

    private void renderCloseButton(GuiGraphics g) {
        int closeX = this.closeBtnX;
        int closeY = this.closeBtnY;
        g.fill(closeX, closeY, closeX + 12, closeY + 12, Theme.panelBg());
        g.fill(closeX - 1, closeY - 1, closeX + 12 + 1, closeY, Theme.titleBarBorder());
        g.fill(closeX - 1, closeY + 12, closeX + 12 + 1, closeY + 12 + 1, Theme.titleBarBorder());
        g.fill(closeX - 1, closeY, closeX, closeY + 12, Theme.titleBarBorder());
        g.fill(closeX + 12, closeY, closeX + 12 + 1, closeY + 12, Theme.titleBarBorder());
        g.fill(closeX + 3, closeY + 3, closeX + 12 - 3, closeY + 4, -1907998);
        g.fill(closeX + 3, closeY + 12 - 4, closeX + 12 - 3, closeY + 12 - 3, -1907998);
        g.fill(closeX + 3, closeY + 3, closeX + 4, closeY + 12 - 3, -1907998);
        g.fill(closeX + 12 - 4, closeY + 3, closeX + 12 - 3, closeY + 12 - 3, -1907998);
    }

    private void renderTabs(GuiGraphics g, int mouseX, int mouseY) {
        int sepY = this.tierTabY + 18 + 2;
        g.fill(this.tierTabX, sepY, this.creditsTabX + this.creditsTabW, sepY + 1, Theme.contentTopLine());
        this.drawTab(g, mouseX, mouseY, this.tierTabX, this.tierTabY, this.tierTabW, this.tierTabH, Component.translatable((String)"nomadsshell.admin.tier_dimensions").getString(), this.currentTab == Tab.TIER_DIMENSIONS);
        this.drawTab(g, mouseX, mouseY, this.pocketTabX, this.pocketTabY, this.pocketTabW, this.pocketTabH, Component.translatable((String)"nomadsshell.admin.pocket_dimension").getString(), this.currentTab == Tab.POCKET_DIMENSION);
        this.drawTab(g, mouseX, mouseY, this.creditsTabX, this.creditsTabY, this.creditsTabW, this.creditsTabH, Component.translatable((String)"nomadsshell.admin.credits").getString(), this.currentTab == Tab.CREDITS);
    }

    private void drawTab(GuiGraphics g, int mouseX, int mouseY, int x, int y, int w, int h, String label, boolean active) {
        boolean hovered;
        boolean bl = hovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (hovered && !active) {
            int hoverOverlay = Theme.isLight() ? 0x14000000 : 0x14FFFFFF;
            g.fill(x, y, x + w, y + h, hoverOverlay);
        }
        int tw = this.font.width(label);
        int tx = x + (w - tw) / 2;
        int ty = y + (h - 8) / 2;
        g.drawString(this.font, label, tx, ty, active ? Theme.textPrimary() : Theme.textSecondary());
        if (active) {
            int ux = x + Math.max(6, (w - tw) / 2 - 6);
            int uw = Math.min(w - 12, tw + 12);
            int uy = y + h + 1;
            g.fill(ux, uy, ux + uw, uy + 2, Theme.titleBarBorder());
        }
    }

    private void renderTierDimensionsTab(GuiGraphics g, int contentX, int contentY) {
        int startY = contentY + 50;
        int x = contentX + 20;
        int labelWidth = 100;
        int fieldSpacing = 15;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.tier").getString(), x, startY - 20, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.width").getString(), x + labelWidth, startY - 20, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.height").getString(), x + labelWidth + 60 + fieldSpacing, startY - 20, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.total_slots").getString(), x + labelWidth + 120 + fieldSpacing * 2 + 10, startY - 20, Theme.textPrimary());
        ShellTier[] tiers = ShellTier.values();
        for (int i = 0; i < tiers.length; ++i) {
            ShellTier tier = tiers[i];
            int y = startY + i * 25;
            Object tierName = tier.getName().replace("_", " ").toLowerCase();
            tierName = ((String)tierName).substring(0, 1).toUpperCase() + ((String)tierName).substring(1);
            g.drawString(this.font, (String)tierName, x, y + 5, Theme.textPrimary());
            EditBox widthField = this.widthFields.get((Object)tier);
            EditBox heightField = this.heightFields.get((Object)tier);
            if (widthField == null || heightField == null) continue;
            String widthText = widthField.getValue();
            String heightText = heightField.getValue();
            if (widthText.isEmpty() || heightText.isEmpty()) continue;
            try {
                int width = Integer.parseInt(widthText);
                int height = Integer.parseInt(heightText);
                int totalSlots = width * height;
                int color = totalSlots <= 256 ? 0x55FF55 : (totalSlots <= 1000 ? 0xFFAA00 : 0xFF5555);
                int slotsX = x + labelWidth + 120 + fieldSpacing * 2 + 10;
                g.drawString(this.font, String.valueOf(totalSlots), slotsX, y + 5, color);
                continue;
            }
            catch (NumberFormatException e) {
                int slotsX = x + labelWidth + 120 + fieldSpacing * 2 + 10;
                g.drawString(this.font, "Invalid", slotsX, y + 5, 0xFF5555);
            }
        }
    }

    private void renderPocketDimensionTab(GuiGraphics g, int contentX, int contentY) {
        int y = contentY + 50;
        int x = contentX + 20;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.pocket_width").getString(), x, y, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.pocket_length").getString(), x, y += 25, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.pocket_height").getString(), x, y += 25, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.admin.pocket_background").getString(), x, y += 25, Theme.textPrimary());
    }

    private void renderCreditsTab(GuiGraphics g, int contentX, int contentY) {
        String[] credits;
        int y = contentY + 50;
        int x = contentX + 20;
        int lineHeight = 12;
        for (String line : credits = new String[]{Component.translatable((String)"nomadsshell.admin.credits.mod_name").getString(), "", Component.translatable((String)"nomadsshell.admin.credits.created_by").getString(), "", Component.translatable((String)"nomadsshell.admin.credits.special_thanks").getString(), Component.translatable((String)"nomadsshell.admin.credits.neoforge_team").getString(), Component.translatable((String)"nomadsshell.admin.credits.minecraft_community").getString(), "", Component.translatable((String)"nomadsshell.admin.credits.translations").getString(), Component.translatable((String)"nomadsshell.admin.credits.translation_english").getString(), Component.translatable((String)"nomadsshell.admin.credits.translation_more").getString()}) {
            if (line.isEmpty()) {
                y += lineHeight / 2;
                continue;
            }
            int color = line.startsWith("\u2022") ? Theme.textSecondary() : Theme.textPrimary();
            g.drawString(this.font, line, x, y, color);
            y += lineHeight;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX >= (double)this.closeBtnX && mouseX <= (double)(this.closeBtnX + 12) && mouseY >= (double)this.closeBtnY && mouseY <= (double)(this.closeBtnY + 12)) {
                this.onClose();
                return true;
            }
            if (mouseX >= (double)this.tierTabX && mouseX <= (double)(this.tierTabX + this.tierTabW) && mouseY >= (double)this.tierTabY && mouseY <= (double)(this.tierTabY + this.tierTabH)) {
                this.switchTab(Tab.TIER_DIMENSIONS);
                return true;
            }
            if (mouseX >= (double)this.pocketTabX && mouseX <= (double)(this.pocketTabX + this.pocketTabW) && mouseY >= (double)this.pocketTabY && mouseY <= (double)(this.pocketTabY + this.pocketTabH)) {
                this.switchTab(Tab.POCKET_DIMENSION);
                return true;
            }
            if (mouseX >= (double)this.creditsTabX && mouseX <= (double)(this.creditsTabX + this.creditsTabW) && mouseY >= (double)this.creditsTabY && mouseY <= (double)(this.creditsTabY + this.creditsTabH)) {
                this.switchTab(Tab.CREDITS);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 297) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static enum Tab {
        TIER_DIMENSIONS,
        POCKET_DIMENSION,
        CREDITS;

    }
}

