/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen;

import com.etka.nomadsshell.client.screen.overlay.OverlayManager;
import com.etka.nomadsshell.client.screen.overlay.TrashBinWidget;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModKeyBindings;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.network.ThrowItemPacket;
import com.etka.nomadsshell.network.UpdateMemorizedSlotPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShellScreen
extends AbstractContainerScreen<ShellMenu> {
    private final ShellTier tier;
    private final int shellRows;
    private final int shellColumns;
    private float guiScale = 1.0f;
    private OverlayManager overlayManager;
    private TrashBinWidget trashBin;
    private double lastMouseX = 0.0;
    private double lastMouseY = 0.0;

    public ShellScreen(ShellMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.tier = menu.getTier();
        this.shellRows = this.tier.getRows();
        this.shellColumns = this.tier.getColumns();
    }

    protected void init() {
        this.calculateResponsiveScale();
        super.init();
        if (((Boolean)OverlayConfig.ENABLE_OVERLAY_FEATURES.get()).booleanValue()) {
            ItemStack shellStack;
            this.overlayManager = new OverlayManager((Screen)this, this.font, (IShellMenu)this.menu);
            if (((Boolean)OverlayConfig.ENABLE_TRASH_BIN.get()).booleanValue()) {
                this.trashBin = this.overlayManager.createTrashBin();
            }
            if (((Boolean)OverlayConfig.ENABLE_FURNACE.get()).booleanValue()) {
                this.overlayManager.createFurnace();
            }
            if (WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.ANVIL, shellStack = ((ShellMenu)this.menu).getshellStack())) {
                this.overlayManager.createAnvil();
            }
            if (WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.COLLECTOR, shellStack)) {
                this.overlayManager.createCollector();
            }
            if (WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.MAGNET, shellStack)) {
                this.overlayManager.createMagnet();
            }
            if (((Boolean)OverlayConfig.ENABLE_SETTINGS.get()).booleanValue()) {
                this.overlayManager.createSettings();
            }
            this.updateOverlayPositions();
        }
    }

    private void calculateResponsiveScale() {
        int baseshellWidth = Math.max(this.shellColumns * 18, 162);
        int baseWidth = baseshellWidth + 16;
        int shellHeight = this.shellRows * 18;
        int playerInventoryHeight = 54;
        int hotbarHeight = 18;
        int gaps = 18;
        int padding = 25;
        int baseHeight = shellHeight + playerInventoryHeight + hotbarHeight + gaps + padding;
        float maxAllowedWidthRatio = 0.8f;
        float maxAllowedHeightRatio = 0.8f;
        if (this.width < 800 || this.height < 600) {
            maxAllowedWidthRatio = 0.95f;
            maxAllowedHeightRatio = 0.9f;
        }
        if (this.width < 640 || this.height < 480) {
            maxAllowedWidthRatio = 0.98f;
            maxAllowedHeightRatio = 0.95f;
        }
        int maxAllowedWidth = (int)((float)this.width * maxAllowedWidthRatio);
        int maxAllowedHeight = (int)((float)this.height * maxAllowedHeightRatio);
        float scaleX = (float)maxAllowedWidth / (float)baseWidth;
        float scaleY = (float)maxAllowedHeight / (float)baseHeight;
        float minScale = 0.3f;
        if (this.width < 640 || this.height < 480) {
            minScale = 0.25f;
        }
        this.guiScale = Math.max(minScale, Math.min(1.0f, Math.min(scaleX, scaleY)));
        this.imageWidth = (int)((float)baseWidth * this.guiScale);
        this.imageHeight = (int)((float)baseHeight * this.guiScale);
        this.inventoryLabelY = (int)((float)(baseHeight - 94) * this.guiScale);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int originalWidth = (int)((float)this.imageWidth / this.guiScale);
        int originalHeight = (int)((float)this.imageHeight / this.guiScale);
        guiGraphics.fill(0, 0, originalWidth, originalHeight, -3750202);
        int slotBorder = Theme.slotBorder();
        for (int row = 0; row < this.shellRows; ++row) {
            for (int col = 0; col < this.shellColumns; ++col) {
                int slotX = 8 + col * 18;
                int slotY = 18 + row * 18;
                guiGraphics.fill(slotX - 1, slotY - 1, slotX + 17, slotY + 17, slotBorder);
                boolean hovered = mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
                int fill = hovered ? Theme.slotHoverFill() : Theme.slotFill();
                guiGraphics.fill(slotX, slotY, slotX + 16, slotY + 16, fill);
            }
        }
        int shellWidth = this.shellColumns * 18;
        int playerInvWidth = 162;
        int playerInvOffset = Math.max(0, (shellWidth - playerInvWidth) / 2);
        int playerInvStartY = 18 + this.shellRows * 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotX = 8 + col * 18 + playerInvOffset;
                int slotY = playerInvStartY + row * 18;
                guiGraphics.fill(slotX - 1, slotY - 1, slotX + 17, slotY + 17, slotBorder);
                boolean hovered = mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
                int fill = hovered ? Theme.slotHoverFill() : Theme.slotFill();
                guiGraphics.fill(slotX, slotY, slotX + 16, slotY + 16, fill);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int slotX = 8 + col * 18 + playerInvOffset;
            int slotY = playerInvStartY + 58;
            guiGraphics.fill(slotX - 1, slotY - 1, slotX + 17, slotY + 17, slotBorder);
            boolean hovered = mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
            int fill = hovered ? Theme.slotHoverFill() : Theme.slotFill();
            guiGraphics.fill(slotX, slotY, slotX + 16, slotY + 16, fill);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.renderDarkBackground(guiGraphics);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        int scaledX = (this.width - this.imageWidth) / 2;
        int scaledY = (this.height - this.imageHeight) / 2;
        poseStack.translate((float)scaledX, (float)scaledY, 0.0f);
        poseStack.scale(this.guiScale, this.guiScale, 1.0f);
        this.renderBg(guiGraphics, partialTick, (int)((float)(mouseX - scaledX) / this.guiScale), (int)((float)(mouseY - scaledY) / this.guiScale));
        this.renderSlotsWithoutCarriedOverlay(guiGraphics, (int)((float)(mouseX - scaledX) / this.guiScale), (int)((float)(mouseY - scaledY) / this.guiScale));
        this.renderLabels(guiGraphics, (int)((float)(mouseX - scaledX) / this.guiScale), (int)((float)(mouseY - scaledY) / this.guiScale));
        poseStack.popPose();
        if (this.overlayManager != null) {
            this.overlayManager.updateHoverStates(mouseX, mouseY);
            this.overlayManager.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderCarriedItemInFront(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((Boolean)OverlayConfig.MEMORIZE_SLOT_SHOW_TOOLTIPS.get()).booleanValue()) {
            ItemStack hoveredItem;
            Slot hoveredSlot;
            int slotIndex = this.findshellSlotIndexUnderMouse(mouseX, mouseY);
            if (slotIndex != -1 && slotIndex < this.shellRows * this.shellColumns && (hoveredSlot = (Slot)((ShellMenu)this.menu).slots.get(slotIndex)) != null && hoveredSlot.hasItem() && !(hoveredItem = hoveredSlot.getItem()).isEmpty()) {
                guiGraphics.renderTooltip(this.font, hoveredItem, mouseX, mouseY);
                return;
            }
            for (Slot slot : ((ShellMenu)this.menu).slots) {
                ItemStack hoveredItem2;
                if (slot == null || !slot.hasItem() || mouseX < this.leftPos + slot.x || mouseX >= this.leftPos + slot.x + 16 || mouseY < this.topPos + slot.y || mouseY >= this.topPos + slot.y + 16 || (hoveredItem2 = slot.getItem()).isEmpty()) continue;
                guiGraphics.renderTooltip(this.font, hoveredItem2, mouseX, mouseY);
                return;
            }
        }
    }

    private void renderDarkBackground(GuiGraphics guiGraphics) {
        guiGraphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderSlotsWithoutCarriedOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < ((ShellMenu)this.menu).slots.size(); ++i) {
            ItemStack tpl;
            Slot slot = (Slot)((ShellMenu)this.menu).slots.get(i);
            this.renderSlot(guiGraphics, slot);
            if (i >= this.shellRows * this.shellColumns || (tpl = WidgetDataHelper.getMemorizedItemAt((Player)this.minecraft.player, i)).isEmpty()) continue;
            int x0 = slot.x;
            int y0 = slot.y;
            int c = -48060;
            guiGraphics.fill(x0 - 1, y0 - 1, x0 + 4, y0, c);
            guiGraphics.fill(x0 - 1, y0 - 1, x0, y0 + 4, c);
            guiGraphics.fill(x0 + 16 - 4, y0 - 1, x0 + 17, y0, c);
            guiGraphics.fill(x0 + 16, y0 - 1, x0 + 17, y0 + 4, c);
            guiGraphics.fill(x0 - 1, y0 + 16, x0 + 4, y0 + 17, c);
            guiGraphics.fill(x0 - 1, y0 + 16 - 4, x0, y0 + 17, c);
            guiGraphics.fill(x0 + 16 - 4, y0 + 16, x0 + 17, y0 + 17, c);
            guiGraphics.fill(x0 + 16, y0 + 16 - 4, x0 + 17, y0 + 17, c);
            if (slot.hasItem()) continue;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            guiGraphics.renderItem(tpl, x0, y0);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().popPose();
        }
    }

    private int findshellSlotIndexUnderMouse(double mouseX, double mouseY) {
        double guiScale = this.minecraft.getWindow().getGuiScale();
        int scaledX = (int)(mouseX / guiScale);
        int scaledY = (int)(mouseY / guiScale);
        for (int i = 0; i < this.shellRows * this.shellColumns; ++i) {
            int row = i / this.shellColumns;
            int col = i % this.shellColumns;
            int slotX = 8 + col * 18;
            int slotY = 18 + row * 18;
            if (scaledX < slotX || scaledX >= slotX + 16 || scaledY < slotY || scaledY >= slotY + 16) continue;
            return i;
        }
        return -1;
    }

    private void renderCarriedItemInFront(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!((ShellMenu)this.menu).getCarried().isEmpty()) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 1000.0f);
            int carriedX = mouseX - 8;
            int carriedY = mouseY - 8;
            int override = this.overlayManager.getCursorCountOverride();
            if (override == 0) {
                poseStack.popPose();
                return;
            }
            guiGraphics.renderItem(((ShellMenu)this.menu).getCarried(), carriedX, carriedY);
            if (override >= 0) {
                this.drawItemCountOverride(guiGraphics, ((ShellMenu)this.menu).getCarried(), carriedX, carriedY, override);
            } else {
                guiGraphics.renderItemDecorations(this.font, ((ShellMenu)this.menu).getCarried(), carriedX, carriedY);
            }
            poseStack.popPose();
        }
    }

    private void drawItemCountOverride(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int count) {
        if (!stack.isEmpty()) {
            String countText = String.valueOf(count);
            int textX = x + 19 - 2 - this.font.width(countText);
            int textY = y + 6 + 3;
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 200.0f);
            guiGraphics.drawString(this.font, countText, textX, textY, 0xFFFFFF, true);
            poseStack.popPose();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, (int)((float)this.inventoryLabelY / this.guiScale), 0x404040, false);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        int scaledX = (this.width - this.imageWidth) / 2;
        int scaledY = (this.height - this.imageHeight) / 2;
        double adjustedMouseX = (mouseX - (double)scaledX) / (double)this.guiScale;
        double adjustedMouseY = (mouseY - (double)scaledY) / (double)this.guiScale;
        return adjustedMouseX >= (double)x && adjustedMouseX < (double)(x + width) && adjustedMouseY >= (double)y && adjustedMouseY < (double)(y + height);
    }

    protected boolean checkHotbarKeyPressed(int keyCode, int scanCode) {
        return super.checkHotbarKeyPressed(keyCode, scanCode);
    }

    private void updateOverlayPositions() {
        if (this.overlayManager != null) {
            int scaledX = (this.width - this.imageWidth) / 2;
            int scaledY = (this.height - this.imageHeight) / 2;
            this.overlayManager.updateMainGuiBounds(scaledX, scaledY, this.imageWidth, this.imageHeight);
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.overlayManager != null) {
            this.overlayManager.tick();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int slotIndex;
        if (this.overlayManager != null && this.overlayManager.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.overlayManager != null && this.overlayManager.isMemorizeModeActive() && (slotIndex = this.findshellSlotIndexUnderMouse(mouseX, mouseY)) != -1 && slotIndex < this.shellRows * this.shellColumns) {
            ItemStack src = ((ShellMenu)this.menu).getCarried();
            if (src.isEmpty()) {
                src = ((Slot)((ShellMenu)this.menu).slots.get(slotIndex)).getItem();
            }
            if (!src.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateMemorizedSlotPacket(slotIndex, false, src.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateMemorizedSlotPacket(slotIndex, true, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.overlayManager != null && this.overlayManager.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.overlayManager != null && this.overlayManager.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.updateOverlayPositions();
    }

    public void onClose() {
        if (this.overlayManager != null) {
            this.overlayManager.resetUnpinnedWidgets();
        }
        super.onClose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Slot hoveredSlot;
        if (this.overlayManager != null && this.overlayManager.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 81 && ((Boolean)OverlayConfig.ENABLE_ITEM_THROWING.get()).booleanValue() && (hoveredSlot = this.getSlotUnderMouse()) != null && hoveredSlot.hasItem()) {
            boolean throwAll = Screen.hasControlDown();
            int slotIndex = ((ShellMenu)this.menu).slots.indexOf((Object)hoveredSlot);
            if (slotIndex != -1) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ThrowItemPacket(slotIndex, throwAll), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        if (keyCode == 66) {
            this.onClose();
            return true;
        }
        if (ModKeyBindings.OPEN_shell.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        if (this.handleDimensionKeys(keyCode, scanCode)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean handleDimensionKeys(int keyCode, int scanCode) {
        if (this.overlayManager != null) {
            if (ModKeyBindings.INCREASE_HEIGHT.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustHeight(1);
            }
            if (ModKeyBindings.DECREASE_HEIGHT.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustHeight(-1);
            }
            if (ModKeyBindings.INCREASE_WIDTH.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustWidth(1);
            }
            if (ModKeyBindings.DECREASE_WIDTH.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustWidth(-1);
            }
        }
        return false;
    }
}

