/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen;

import com.etka.nomadsshell.client.screen.overlay.OverlayManager;
import com.etka.nomadsshell.client.screen.overlay.TrashBinWidget;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModKeyBindings;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.menu.VirtualShellMenu;
import com.etka.nomadsshell.network.ThrowItemPacket;
import com.etka.nomadsshell.network.UpdateMemorizedSlotPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class VirtualShellScreen
extends AbstractContainerScreen<VirtualShellMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"textures/gui/shell_background.png");
    private final int shellWidth;
    private final int shellHeight;
    private final int visibleRows;
    private final boolean needsScrolling;
    private int scrollOffset = 0;
    private boolean isDraggingScrollbar = false;
    private int scrollbarHeight;
    private int scrollbarTop;
    private float guiScale = 1.0f;
    private OverlayManager overlayManager;
    private TrashBinWidget trashBin;
    private int cachedshellLeft;
    private int cachedshellTop;
    private int cachedVisibleRows;
    private int cachedVisibleCols;
    private int cachedStartCol;
    private boolean vrPaintingActive = false;
    private boolean vrLeftSplitMode = false;
    private int vrPaintingButton = -1;
    private int vrFirstSlotIndex = -1;
    private int vrInitialCarriedCount = -1;
    private final LinkedHashSet<Integer> vrVisitedshellSlots = new LinkedHashSet();
    private double lastMouseX = 0.0;
    private double lastMouseY = 0.0;

    public VirtualShellScreen(VirtualShellMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.shellWidth = menu.getshellWidth();
        this.shellHeight = menu.getshellHeight();
        this.visibleRows = menu.getVisibleRows();
        this.needsScrolling = menu.needsScrolling();
    }

    public void refreshDimensions() {
        this.calculateScreenDimensions();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.updateOverlayPositions();
    }

    private int calculateMaxVisibleRows(int shellHeight) {
        int baseMax = Math.min(25, shellHeight);
        if (this.height < 600) {
            int availableHeight = (int)((double)this.height * 0.8);
            int rowHeight = 18;
            int maxRowsByHeight = Math.max(3, availableHeight / rowHeight);
            baseMax = Math.min(baseMax, maxRowsByHeight);
        }
        if (this.height < 480) {
            baseMax = Math.min(baseMax, 8);
        }
        return Math.max(3, baseMax);
    }

    private void calculateScreenDimensions() {
        int[] cachedDims;
        int currentshellWidth = this.shellWidth;
        int currentshellHeight = this.shellHeight;
        int currentVisibleRows = this.visibleRows;
        boolean currentNeedsScrolling = this.needsScrolling;
        if (this.overlayManager != null && (cachedDims = this.overlayManager.getCachedDimensions()) != null) {
            currentshellWidth = cachedDims[0];
            currentshellHeight = cachedDims[1];
            int maxVisibleRows = this.calculateMaxVisibleRows(currentshellHeight);
            currentVisibleRows = Math.min(currentshellHeight, maxVisibleRows);
            currentNeedsScrolling = currentshellHeight > maxVisibleRows;
        }
        int displayMode = OverlayConfig.getDisplayMode();
        int userVisibleHeight = (Integer)OverlayConfig.SETTINGS_VISIBLE_HEIGHT.get();
        int autoVisibleRows = Math.min(25, currentshellHeight);
        if (displayMode == 1 || displayMode == 3) {
            int desired = userVisibleHeight > 0 ? userVisibleHeight : autoVisibleRows;
            currentVisibleRows = Math.max(1, Math.min(desired, currentshellHeight));
            currentNeedsScrolling = currentshellHeight > currentVisibleRows;
        } else {
            currentVisibleRows = Math.min(currentshellHeight, Math.min(25, currentshellHeight));
            currentNeedsScrolling = currentshellHeight > currentVisibleRows;
        }
        int startCol = 0;
        int visibleCols = currentshellWidth;
        if (displayMode == 2 || displayMode == 3) {
            int tabCount = Math.max(1, Math.min((Integer)OverlayConfig.SETTINGS_TAB_COUNT.get(), Math.max(1, currentshellWidth)));
            int currentTab = Math.min(Math.max(0, (Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get()), tabCount - 1);
            int base = currentshellWidth / tabCount;
            int rem = currentshellWidth % tabCount;
            visibleCols = base + (currentTab < rem ? 1 : 0);
            startCol = currentTab * base + Math.min(currentTab, rem);
            visibleCols = Math.max(1, Math.min(visibleCols, currentshellWidth));
        }
        this.cachedVisibleRows = currentVisibleRows;
        this.cachedVisibleCols = visibleCols;
        this.cachedStartCol = startCol;
        int baseshellWidth = Math.max(visibleCols * 18, 162);
        int baseWidth = baseshellWidth + 16;
        if (currentNeedsScrolling) {
            baseWidth += 16;
        }
        int shellPixelHeight = currentVisibleRows * 18;
        int playerInventoryHeight = 54;
        int hotbarHeight = 18;
        int gaps = 18;
        int padding = 25;
        int baseHeight = shellPixelHeight + playerInventoryHeight + hotbarHeight + gaps + padding;
        this.imageWidth = baseWidth;
        this.imageHeight = baseHeight;
        if (currentNeedsScrolling) {
            this.scrollbarHeight = shellPixelHeight - 32;
            this.scrollbarTop = 18;
        }
    }

    protected void init() {
        this.calculateScreenDimensions();
        super.init();
        if (((Boolean)OverlayConfig.ENABLE_OVERLAY_FEATURES.get()).booleanValue()) {
            boolean enableAutoFeeder;
            boolean enableAnvil;
            boolean enableGuardian;
            boolean enableMagnet;
            boolean enableCollector;
            boolean enableDripstone;
            boolean enableFluid;
            this.overlayManager = new OverlayManager((Screen)this, this.font, (IShellMenu)this.menu);
            ItemStack shellStack = ((VirtualShellMenu)this.menu).getshellStack();
            if (((Boolean)OverlayConfig.ENABLE_TRASH_BIN.get()).booleanValue() && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TRASH_BIN, shellStack)) {
                this.trashBin = this.overlayManager.createTrashBin();
            }
            if (((Boolean)OverlayConfig.ENABLE_FURNACE.get()).booleanValue() && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FURNACE, shellStack)) {
                this.overlayManager.createFurnace();
            }
            if (((Boolean)OverlayConfig.ENABLE_CRAFTING_TABLE.get()).booleanValue() && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack)) {
                this.overlayManager.createCraftingTable();
            }
            if ((enableFluid = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack)) {
                this.overlayManager.createFluidTank();
            }
            if ((enableDripstone = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack)) {
                this.overlayManager.createDripstoneFarm();
            }
            try {
                if (ModList.get().isLoaded("travelersgarden") && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, shellStack)) {
                    this.overlayManager.createTravelersGarden();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean enableTeleporter = true;
            if (enableTeleporter && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TELEPORTER, shellStack)) {
                this.overlayManager.createTeleporter();
            }
            if ((enableCollector = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.COLLECTOR, shellStack)) {
                this.overlayManager.createCollector();
            }
            if ((enableMagnet = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.MAGNET, shellStack)) {
                this.overlayManager.createMagnet();
            }
            if ((enableGuardian = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack)) {
                this.overlayManager.createGuardian();
            }
            if ((enableAnvil = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.ANVIL, shellStack)) {
                this.overlayManager.createAnvil();
            }
            if ((enableAutoFeeder = true) && WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.AUTO_FEEDER, shellStack)) {
                this.overlayManager.createAutoFeeder();
            }
            if (((Boolean)OverlayConfig.ENABLE_SETTINGS.get()).booleanValue()) {
                this.overlayManager.createSettings();
            }
            if (((Boolean)OverlayConfig.ENABLE_UPGRADE.get()).booleanValue()) {
                this.overlayManager.createUpgrade();
            }
            this.updateOverlayPositions();
        }
    }

    private void updateOverlayPositions() {
        if (this.overlayManager != null) {
            this.overlayManager.updateMainGuiBounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        }
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        boolean showScrollbar;
        int currentshellWidth = this.overlayManager != null && this.overlayManager.getCachedDimensions() != null ? this.overlayManager.getCachedDimensions()[0] : this.shellWidth;
        int currentVisibleRows = this.cachedVisibleRows;
        int visibleCols = this.cachedVisibleCols;
        int startCol = this.cachedStartCol;
        int bgColor = Theme.contentBg();
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, bgColor);
        int shellBgColor = Theme.contentBg();
        int shellLeft = this.leftPos + 8;
        int shellTop = this.topPos + 18;
        int shellPixelWidth = visibleCols * 18;
        int shellPixelHeight = currentVisibleRows * 18;
        guiGraphics.fill(shellLeft - 1, shellTop - 1, shellLeft + shellPixelWidth + 1, shellTop + shellPixelHeight + 1, Theme.panelBorder());
        guiGraphics.fill(shellLeft, shellTop, shellLeft + shellPixelWidth, shellTop + shellPixelHeight, shellBgColor);
        this.drawSlotGrid(guiGraphics, shellLeft, shellTop, visibleCols, currentVisibleRows);
        this.cachedshellLeft = shellLeft;
        this.cachedshellTop = shellTop;
        int playerInvWidth = 162;
        int playerInvHeight = 76;
        int playerInvOffset = Math.max(0, (shellPixelWidth - playerInvWidth) / 2);
        int playerInvLeft = shellLeft + playerInvOffset;
        int playerInvTop = shellTop + shellPixelHeight + 14;
        guiGraphics.fill(playerInvLeft - 1, playerInvTop - 1, playerInvLeft + playerInvWidth + 1, playerInvTop + playerInvHeight + 1, Theme.panelBorder());
        guiGraphics.fill(playerInvLeft, playerInvTop, playerInvLeft + playerInvWidth, playerInvTop + playerInvHeight, shellBgColor);
        this.drawSlotGrid(guiGraphics, playerInvLeft, playerInvTop, 9, 3);
        this.drawSlotGrid(guiGraphics, playerInvLeft, playerInvTop + 54 + 4, 9, 1);
        int displayMode = OverlayConfig.getDisplayMode();
        boolean bl = showScrollbar = (displayMode == 1 || displayMode == 3) && this.getCurrentshellHeight() > currentVisibleRows;
        if (showScrollbar) {
            this.drawScrollbar(guiGraphics, mouseX, mouseY);
        }
        if (displayMode == 2 || displayMode == 3) {
            this.drawTabs(guiGraphics, shellLeft, shellTop - 14, currentshellWidth);
        }
    }

    private void drawSlotGrid(GuiGraphics guiGraphics, int startX, int startY, int columns, int rows) {
        int slotSize = 18;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int slotX = startX + col * slotSize;
                int slotY = startY + row * slotSize;
                int slotBorder = Theme.slotBorder();
                int slotFill = Theme.slotFill();
                guiGraphics.fill(slotX, slotY, slotX + slotSize - 1, slotY + slotSize - 1, slotBorder);
                guiGraphics.fill(slotX + 1, slotY + 1, slotX + slotSize - 2, slotY + slotSize - 2, slotFill);
            }
        }
    }

    private void drawScrollbar(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int scrollbarX = this.leftPos + this.imageWidth - 16;
        int scrollbarY = this.topPos + this.scrollbarTop;
        int scrollbarWidth = 12;
        int trackColor = Theme.isLight() ? -2039584 : -11119018;
        guiGraphics.fill(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + this.scrollbarHeight, trackColor);
        int maxScrollOffset = ((VirtualShellMenu)this.menu).getMaxScrollOffset();
        if (maxScrollOffset > 0) {
            int currentshellHeight = this.getCurrentshellHeight();
            int currentVisibleRows = this.cachedVisibleRows;
            int thumbHeight = Math.max(12, this.scrollbarHeight * currentVisibleRows / currentshellHeight);
            int thumbY = scrollbarY + (this.scrollbarHeight - thumbHeight) * this.scrollOffset / maxScrollOffset;
            int thumbColor = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight ? (Theme.isLight() ? -5197648 : -5592406) : (Theme.isLight() ? -6381922 : -7829368);
            guiGraphics.fill(scrollbarX + 1, thumbY, scrollbarX + scrollbarWidth - 1, thumbY + thumbHeight, thumbColor);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean currentNeedsScrolling;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.renderVisibleSlots(guiGraphics, mouseX, mouseY);
        if (this.overlayManager != null) {
            this.overlayManager.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        Object titleText = this.title.getString();
        int currentshellHeight = this.getCurrentshellHeight();
        int currentVisibleRows = this.cachedVisibleRows;
        boolean bl = currentNeedsScrolling = (OverlayConfig.getDisplayMode() == 1 || OverlayConfig.getDisplayMode() == 3) && currentshellHeight > currentVisibleRows;
        if (currentNeedsScrolling) {
            titleText = (String)titleText + " (Scrollable: " + (this.scrollOffset + 1) + "-" + (this.scrollOffset + currentVisibleRows) + "/" + currentshellHeight + ")";
        }
        guiGraphics.drawString(this.font, (String)titleText, this.leftPos + 8, this.topPos + 6, Theme.textSecondary(), false);
        this.renderCarriedItemInFront(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((Boolean)OverlayConfig.MEMORIZE_SLOT_SHOW_TOOLTIPS.get()).booleanValue()) {
            ItemStack hoveredItem;
            Slot hoveredSlot;
            int slotIndex = this.findshellSlotIndexUnderMouse(mouseX, mouseY);
            if (slotIndex != -1 && slotIndex < ((VirtualShellMenu)this.menu).slots.size() && (hoveredSlot = (Slot)((VirtualShellMenu)this.menu).slots.get(slotIndex)) != null && hoveredSlot.hasItem() && !(hoveredItem = hoveredSlot.getItem()).isEmpty()) {
                guiGraphics.renderTooltip(this.font, hoveredItem, mouseX, mouseY);
                return;
            }
            for (Slot slot : ((VirtualShellMenu)this.menu).slots) {
                ItemStack hoveredItem2;
                if (slot == null || !slot.hasItem() || mouseX < this.leftPos + slot.x || mouseX >= this.leftPos + slot.x + 16 || mouseY < this.topPos + slot.y || mouseY >= this.topPos + slot.y + 16 || (hoveredItem2 = slot.getItem()).isEmpty()) continue;
                guiGraphics.renderTooltip(this.font, hoveredItem2, mouseX, mouseY);
                return;
            }
        }
    }

    private void renderCarriedItemInFront(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int override;
        if (((VirtualShellMenu)this.menu).getCarried().isEmpty()) {
            return;
        }
        int n = override = this.overlayManager != null ? this.overlayManager.getCursorCountOverride() : -1;
        if (override < 0) {
            override = this.getshellCursorCountOverride();
        }
        if (override == 0) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 1000.0f);
        int carriedX = mouseX - 8;
        int carriedY = mouseY - 8;
        guiGraphics.renderItem(((VirtualShellMenu)this.menu).getCarried(), carriedX, carriedY);
        if (override >= 0) {
            this.drawItemCountOverride(guiGraphics, ((VirtualShellMenu)this.menu).getCarried(), carriedX, carriedY, override);
        } else {
            guiGraphics.renderItemDecorations(this.font, ((VirtualShellMenu)this.menu).getCarried(), carriedX, carriedY);
        }
        poseStack.popPose();
    }

    private void drawItemCountOverride(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int count) {
        if (!stack.isEmpty()) {
            String countText = String.valueOf(count);
            int textX = x + 19 - 2 - this.font.width(countText);
            int textY = y + 6 + 3;
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 200.0f);
            guiGraphics.drawString(this.font, countText, textX, textY, 0xFFFFFF, true);
            poseStack.popPose();
        }
    }

    private int getCurrentshellHeight() {
        if (this.overlayManager != null && this.overlayManager.getCachedDimensions() != null) {
            return this.overlayManager.getCachedDimensions()[1];
        }
        return this.shellHeight;
    }

    private boolean isCarryingItem() {
        return !((VirtualShellMenu)this.menu).getCarried().isEmpty();
    }

    private int findshellSlotIndexUnderMouse(double mouseX, double mouseY) {
        int rLeft = this.cachedshellLeft;
        int rTop = this.cachedshellTop;
        int rRight = rLeft + this.cachedVisibleCols * 18;
        int rBottom = rTop + this.cachedVisibleRows * 18;
        for (int i = 0; i < ((VirtualShellMenu)this.menu).slots.size(); ++i) {
            Slot slot = (Slot)((VirtualShellMenu)this.menu).slots.get(i);
            boolean isshellSlot = slot instanceof VirtualShellMenu.VirtualshellSlot;
            if (!isshellSlot) continue;
            int sxAbs = this.leftPos + slot.x;
            int syAbs = this.topPos + slot.y;
            if (sxAbs < rLeft || sxAbs >= rRight || syAbs < rTop || syAbs >= rBottom || !(mouseX >= (double)sxAbs) || !(mouseX <= (double)(sxAbs + 16)) || !(mouseY >= (double)syAbs) || !(mouseY <= (double)(syAbs + 16))) continue;
            return i;
        }
        return -1;
    }

    private int getshellCursorCountOverride() {
        if (!(this.vrPaintingActive && this.vrLeftSplitMode && this.isCarryingItem())) {
            return -1;
        }
        ItemStack carried = ((VirtualShellMenu)this.menu).getCarried();
        int maxPerStack = carried.getMaxStackSize();
        ArrayList<Integer> eligible = new ArrayList<Integer>();
        Iterator iterator = this.vrVisitedshellSlots.iterator();
        while (iterator.hasNext()) {
            ItemStack inSlot;
            Slot slot;
            int idx = (Integer)iterator.next();
            if (idx < 0 || idx >= ((VirtualShellMenu)this.menu).slots.size() || !((slot = (Slot)((VirtualShellMenu)this.menu).slots.get(idx)) instanceof VirtualShellMenu.VirtualshellSlot) || !(inSlot = slot.getItem()).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)inSlot, (ItemStack)carried) || inSlot.getCount() >= maxPerStack)) continue;
            eligible.add(idx);
        }
        if (eligible.size() < 2) {
            return -1;
        }
        int totalSlots = eligible.size();
        int totalItems = this.vrInitialCarriedCount >= 0 ? this.vrInitialCarriedCount : carried.getCount();
        return totalItems % totalSlots;
    }

    private void renderVisibleSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int rLeft = this.cachedshellLeft;
        int rTop = this.cachedshellTop;
        int rRight = rLeft + this.cachedVisibleCols * 18;
        int rBottom = rTop + this.cachedVisibleRows * 18;
        int startCol = this.cachedStartCol;
        int visibleCols = this.cachedVisibleCols;
        int startRow = ((VirtualShellMenu)this.menu).getScrollOffset();
        int visibleRows = this.cachedVisibleRows;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)this.leftPos, (float)this.topPos, 0.0f);
        for (int i = 0; i < ((VirtualShellMenu)this.menu).slots.size(); ++i) {
            Slot slot = (Slot)((VirtualShellMenu)this.menu).slots.get(i);
            int sxAbs = this.leftPos + slot.x;
            int syAbs = this.topPos + slot.y;
            boolean isshellSlot = slot instanceof VirtualShellMenu.VirtualshellSlot;
            if (isshellSlot) {
                if (sxAbs < rLeft || sxAbs >= rRight || syAbs < rTop || syAbs >= rBottom) continue;
                this.renderSlot(guiGraphics, slot);
                int virtualIdx = ((VirtualShellMenu.VirtualshellSlot)slot).getVirtualSlotIndex();
                Map<String, ItemStack> memMap = WidgetDataHelper.getMemorizedSlots((Player)this.minecraft.player);
                ItemStack tpl = memMap.getOrDefault(String.valueOf(virtualIdx), ItemStack.EMPTY);
                if (tpl.isEmpty()) continue;
                int x0 = slot.x;
                int y0 = slot.y;
                int c = -48060;
                guiGraphics.fill(x0 - 1, y0 - 1, x0 + 4, y0, c);
                guiGraphics.fill(x0 - 1, y0 - 1, x0, y0 + 4, c);
                guiGraphics.fill(x0 + 16 - 4, y0 - 1, x0 + 17, y0, c);
                guiGraphics.fill(x0 + 16, y0 - 1, x0 + 17, y0 + 4, c);
                guiGraphics.fill(x0 - 1, y0 + 16, x0 + 4, y0 + 17, c);
                guiGraphics.fill(x0 - 1, y0 + 16 - 4, x0, y0 + 17, c);
                guiGraphics.fill(x0 + 16 - 4, y0 + 16, x0 + 17, y0 + 17, c);
                guiGraphics.fill(x0 + 16, y0 + 16 - 4, x0 + 17, y0 + 17, c);
                if (slot.hasItem()) continue;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
                guiGraphics.renderItem(tpl, x0, y0);
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                guiGraphics.pose().popPose();
                continue;
            }
            this.renderSlot(guiGraphics, slot);
        }
        pose.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int slotIndex;
        boolean showScrollbar;
        Object object;
        int slotIndex2;
        if (button == 0 && (OverlayConfig.getDisplayMode() == 2 || OverlayConfig.getDisplayMode() == 3) && this.handleTabClick(mouseX, mouseY)) {
            return true;
        }
        if (this.overlayManager != null && this.overlayManager.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.overlayManager != null && this.overlayManager.isMemorizeModeActive() && (slotIndex2 = this.findshellSlotIndexUnderMouse(mouseX, mouseY)) != -1 && (object = ((VirtualShellMenu)this.menu).slots.get(slotIndex2)) instanceof VirtualShellMenu.VirtualshellSlot) {
            VirtualShellMenu.VirtualshellSlot vrs = (VirtualShellMenu.VirtualshellSlot)((Object)object);
            ItemStack src = ((VirtualShellMenu)this.menu).getCarried();
            if (src.isEmpty()) {
                src = ((Slot)((VirtualShellMenu)this.menu).slots.get(slotIndex2)).getItem();
            }
            VirtualShellMenu.VirtualshellSlot s = vrs;
            int vIdx = s.getVirtualSlotIndex();
            if (!src.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateMemorizedSlotPacket(vIdx, false, src.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateMemorizedSlotPacket(vIdx, true, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        boolean bl = showScrollbar = (OverlayConfig.getDisplayMode() == 1 || OverlayConfig.getDisplayMode() == 3) && this.getCurrentshellHeight() > this.cachedVisibleRows;
        if (showScrollbar && button == 0) {
            int scrollbarX = this.leftPos + this.imageWidth - 16;
            int scrollbarY = this.topPos + this.scrollbarTop;
            int scrollbarWidth = 12;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + this.scrollbarHeight)) {
                this.isDraggingScrollbar = true;
                return true;
            }
        }
        if (button == 0 && this.isCarryingItem() && !Screen.hasShiftDown() && (slotIndex = this.findshellSlotIndexUnderMouse(mouseX, mouseY)) != -1) {
            this.vrPaintingActive = true;
            this.vrLeftSplitMode = true;
            this.vrPaintingButton = button;
            this.vrFirstSlotIndex = slotIndex;
            this.vrInitialCarriedCount = ((VirtualShellMenu)this.menu).getCarried().getCount();
            this.vrVisitedshellSlots.clear();
            this.vrVisitedshellSlots.add(slotIndex);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.overlayManager != null && this.overlayManager.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            this.isDraggingScrollbar = false;
            this.vrPaintingActive = false;
            this.vrLeftSplitMode = false;
            this.vrPaintingButton = -1;
            this.vrFirstSlotIndex = -1;
            this.vrInitialCarriedCount = -1;
            this.vrVisitedshellSlots.clear();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean showScrollbar;
        if (this.overlayManager != null && this.overlayManager.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        boolean bl = showScrollbar = (OverlayConfig.getDisplayMode() == 1 || OverlayConfig.getDisplayMode() == 3) && this.getCurrentshellHeight() > this.cachedVisibleRows;
        if (this.isDraggingScrollbar && showScrollbar) {
            int scrollbarY = this.topPos + this.scrollbarTop;
            int relativeY = (int)(mouseY - (double)scrollbarY);
            int maxScrollOffset = ((VirtualShellMenu)this.menu).getMaxScrollOffset();
            if (maxScrollOffset > 0) {
                int newScrollOffset = relativeY * maxScrollOffset / this.scrollbarHeight;
                if ((newScrollOffset = Math.max(0, Math.min(newScrollOffset, maxScrollOffset))) != this.scrollOffset) {
                    int delta = newScrollOffset - this.scrollOffset;
                    this.scrollOffset = newScrollOffset;
                    ((VirtualShellMenu)this.menu).scroll(delta);
                }
            }
            return true;
        }
        if (button == 0 && this.isCarryingItem() && !Screen.hasShiftDown()) {
            if (!this.vrPaintingActive) {
                int startIdx = this.findshellSlotIndexUnderMouse(mouseX, mouseY);
                if (startIdx != -1) {
                    this.vrPaintingActive = true;
                    this.vrLeftSplitMode = true;
                    this.vrPaintingButton = button;
                    this.vrFirstSlotIndex = startIdx;
                    this.vrInitialCarriedCount = ((VirtualShellMenu)this.menu).getCarried().getCount();
                    this.vrVisitedshellSlots.clear();
                    this.vrVisitedshellSlots.add(startIdx);
                }
            } else {
                int slotIndex = this.findshellSlotIndexUnderMouse(mouseX, mouseY);
                if (slotIndex != -1) {
                    this.vrVisitedshellSlots.add(slotIndex);
                }
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean showScrollbar;
        if (this.overlayManager != null && this.overlayManager.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        boolean bl = showScrollbar = (OverlayConfig.getDisplayMode() == 1 || OverlayConfig.getDisplayMode() == 3) && this.getCurrentshellHeight() > this.cachedVisibleRows;
        if (showScrollbar) {
            int delta = scrollY > 0.0 ? -1 : 1;
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset + delta, ((VirtualShellMenu)this.menu).getMaxScrollOffset()));
            ((VirtualShellMenu)this.menu).scroll(delta);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.updateOverlayPositions();
    }

    public void onClose() {
        if (this.overlayManager != null) {
            this.overlayManager.resetUnpinnedWidgets();
        }
        super.onClose();
    }

    public void containerTick() {
        super.containerTick();
        if (this.overlayManager != null) {
            this.overlayManager.tick();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.overlayManager != null && this.overlayManager.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 81 && ((Boolean)OverlayConfig.ENABLE_ITEM_THROWING.get()).booleanValue()) {
            for (int i = 0; i < ((VirtualShellMenu)this.menu).slots.size(); ++i) {
                Slot slot = (Slot)((VirtualShellMenu)this.menu).slots.get(i);
                if (slot == null || !slot.hasItem()) continue;
                int slotX = this.leftPos + slot.x;
                int slotY = this.topPos + slot.y;
                if (!(this.lastMouseX >= (double)slotX) || !(this.lastMouseX < (double)(slotX + 16)) || !(this.lastMouseY >= (double)slotY) || !(this.lastMouseY < (double)(slotY + 16))) continue;
                boolean throwAll = Screen.hasControlDown();
                PacketDistributor.sendToServer((CustomPacketPayload)new ThrowItemPacket(i, throwAll), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        if (!(OverlayConfig.getDisplayMode() != 2 && OverlayConfig.getDisplayMode() != 3 || keyCode != 266 && keyCode != 267)) {
            int totalCols = this.overlayManager != null && this.overlayManager.getCachedDimensions() != null ? this.overlayManager.getCachedDimensions()[0] : this.shellWidth;
            int tabCount = Math.max(1, Math.min((Integer)OverlayConfig.SETTINGS_TAB_COUNT.get(), Math.max(1, totalCols)));
            int currentTab = Math.min(Math.max(0, (Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get()), tabCount - 1);
            int next = currentTab + (keyCode == 267 ? 1 : -1);
            if ((next = Math.max(0, Math.min(next, tabCount - 1))) != currentTab) {
                OverlayConfig.SETTINGS_CURRENT_TAB.set((Object)next);
                try {
                    OverlayConfig.SPEC.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.calculateScreenDimensions();
                ((VirtualShellMenu)this.menu).requestLayoutRefresh();
            }
            return true;
        }
        if (keyCode == 66) {
            this.onClose();
            return true;
        }
        if (ModKeyBindings.OPEN_shell.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        if (this.handleDimensionKeys(keyCode, scanCode)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.overlayManager != null && this.overlayManager.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private boolean handleDimensionKeys(int keyCode, int scanCode) {
        if (this.overlayManager != null) {
            if (ModKeyBindings.INCREASE_HEIGHT.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustHeight(1);
            }
            if (ModKeyBindings.DECREASE_HEIGHT.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustHeight(-1);
            }
            if (ModKeyBindings.INCREASE_WIDTH.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustWidth(1);
            }
            if (ModKeyBindings.DECREASE_WIDTH.matches(keyCode, scanCode)) {
                return this.overlayManager.adjustWidth(-1);
            }
        }
        return false;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        boolean slotInshellRegion;
        boolean baseWithin;
        boolean bl = baseWithin = mouseX >= (double)(x + this.leftPos) && mouseX < (double)(x + this.leftPos + width) && mouseY >= (double)(y + this.topPos) && mouseY < (double)(y + this.topPos + height);
        if (!baseWithin) {
            return false;
        }
        int rLeft = this.cachedshellLeft;
        int rTop = this.cachedshellTop;
        int rRight = rLeft + this.cachedVisibleCols * 18;
        int rBottom = rTop + this.cachedVisibleRows * 18;
        boolean bl2 = slotInshellRegion = y + this.topPos >= rTop && y + this.topPos < rBottom && x + this.leftPos >= this.leftPos + 8 && x + this.leftPos < rRight + ((VirtualShellMenu)this.menu).getshellWidth() * 18;
        if (slotInshellRegion) {
            return x + this.leftPos >= rLeft && x + this.leftPos < rRight && y + this.topPos >= rTop && y + this.topPos < rBottom;
        }
        return true;
    }

    private void drawTabs(GuiGraphics guiGraphics, int x, int y, int totalWidthColumns) {
        int tabCount = Math.max(1, Math.min((Integer)OverlayConfig.SETTINGS_TAB_COUNT.get(), Math.max(1, totalWidthColumns)));
        int currentTab = Math.min(Math.max(0, (Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get()), tabCount - 1);
        int tabWidth = 24;
        int spacing = 4;
        int totalWidth = tabCount * tabWidth + (tabCount - 1) * spacing;
        int startX = x + Math.max(0, (this.cachedVisibleCols * 18 - totalWidth) / 2);
        for (int i = 0; i < tabCount; ++i) {
            int tx = startX + i * (tabWidth + spacing);
            int ty = y;
            int bg = Theme.buttonBg(i == currentTab);
            guiGraphics.fill(tx, ty, tx + tabWidth, ty + 12, bg);
            guiGraphics.fill(tx, ty, tx + tabWidth, ty + 12, Theme.panelBorder());
            String label = String.valueOf(i + 1);
            int lw = this.font.width(label);
            guiGraphics.drawString(this.font, label, tx + (tabWidth - lw) / 2, ty + 2, Theme.textPrimary());
        }
    }

    private boolean handleTabClick(double mouseX, double mouseY) {
        int x = this.cachedshellLeft;
        int y = this.cachedshellTop - 14;
        int tabCount = Math.max(1, Math.min((Integer)OverlayConfig.SETTINGS_TAB_COUNT.get(), Math.max(1, this.overlayManager != null && this.overlayManager.getCachedDimensions() != null ? this.overlayManager.getCachedDimensions()[0] : this.shellWidth)));
        int currentTab = Math.min(Math.max(0, (Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get()), tabCount - 1);
        int tabWidth = 24;
        int spacing = 4;
        int totalWidth = tabCount * tabWidth + (tabCount - 1) * spacing;
        int startX = x + Math.max(0, (this.cachedVisibleCols * 18 - totalWidth) / 2);
        for (int i = 0; i < tabCount; ++i) {
            int tx = startX + i * (tabWidth + spacing);
            int ty = y;
            if (!(mouseX >= (double)tx) || !(mouseX <= (double)(tx + tabWidth)) || !(mouseY >= (double)ty) || !(mouseY <= (double)(ty + 12))) continue;
            if (i != currentTab) {
                OverlayConfig.SETTINGS_CURRENT_TAB.set((Object)i);
                try {
                    OverlayConfig.SPEC.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.calculateScreenDimensions();
                ((VirtualShellMenu)this.menu).requestLayoutRefresh();
            }
            return true;
        }
        return false;
    }
}

