/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.AnvilSlotInteractionPacket;
import com.etka.nomadsshell.network.AnvilSyncPacket;
import com.etka.nomadsshell.network.MoveItemToShellPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AnvilWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int SLOT_SIZE = 16;
    private static final int SLOT_STEP = 18;
    private static final int PANEL_PADDING = 6;
    private static final int GAP_SLOT_TO_ARROW = 8;
    private static final int ARROW_WIDTH = 18;
    private static final int GAP_ARROW_TO_RESULT = 8;
    private ItemStack inputItem = ItemStack.EMPTY;
    private ItemStack materialItem = ItemStack.EMPTY;
    private ItemStack resultItem = ItemStack.EMPTY;
    private int repairCost = 0;
    private String renameText = "";
    private boolean isRenaming = false;
    private int renameFieldX = 0;
    private int renameFieldY = 0;
    private int renameFieldWidth = 0;
    private boolean isFocused = false;
    private float animationTime = 0.0f;
    private boolean logoMode = false;
    private boolean collapsed = false;
    private boolean tempExpanded = false;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.ANVIL_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.ANVIL_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    @Override
    protected String getContextMenuLabel() {
        boolean imageEnabled = (Boolean)OverlayConfig.ANVIL_USE_IMAGE_MODE.get();
        return imageEnabled ? Component.translatable((String)"nomadsshell.ui.move_all_disable").getString() : Component.translatable((String)"nomadsshell.ui.move_all_enable").getString();
    }

    @Override
    protected void handleContextMenuAction(int index) {
        if (index == 0) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (!this.resultItem.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.ANVIL, MoveItemToShellPacket.SlotType.RESULT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!this.inputItem.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.ANVIL, MoveItemToShellPacket.SlotType.INPUT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!this.materialItem.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.ANVIL, MoveItemToShellPacket.SlotType.MATERIAL), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (index == 1) {
            boolean enabled = (Boolean)OverlayConfig.ANVIL_USE_IMAGE_MODE.get();
            OverlayConfig.ANVIL_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
            OverlayConfig.SPEC.save();
        }
    }

    private ItemStack loadInputFromshell() {
        ItemStack clientData = AnvilSyncPacket.AnvilClientData.getInputItem();
        if (!clientData.isEmpty()) {
            return clientData;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            return WidgetDataHelper.getAnvilInputItem((Player)mc.player);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack loadMaterialFromshell() {
        ItemStack clientData = AnvilSyncPacket.AnvilClientData.getMaterialItem();
        if (!clientData.isEmpty()) {
            return clientData;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            return WidgetDataHelper.getAnvilMaterialItem((Player)mc.player);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack loadResultFromshell() {
        ItemStack clientData = AnvilSyncPacket.AnvilClientData.getResultItem();
        if (!clientData.isEmpty()) {
            return clientData;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            return WidgetDataHelper.getAnvilResultItem((Player)mc.player);
        }
        return ItemStack.EMPTY;
    }

    private int loadRepairCostFromshell() {
        int clientData = AnvilSyncPacket.AnvilClientData.getRepairCost();
        if (clientData > 0) {
            return clientData;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            return WidgetDataHelper.getAnvilRepairCost((Player)mc.player);
        }
        return 0;
    }

    private String loadRenameTextFromshell() {
        String clientData = AnvilSyncPacket.AnvilClientData.getRenameText();
        if (!clientData.isEmpty()) {
            return clientData;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            return WidgetDataHelper.getAnvilRenameText((Player)mc.player);
        }
        return "";
    }

    private void savePositionToConfig() {
        OverlayConfig.ANVIL_X.set((Object)this.getX());
        OverlayConfig.ANVIL_Y.set((Object)this.getY());
        OverlayConfig.SPEC.save();
    }

    private void savePinStateToConfig() {
        OverlayConfig.ANVIL_PINNED.set((Object)this.isPinned());
        OverlayConfig.SPEC.save();
    }

    private void saveExpandedStateToConfig() {
        OverlayConfig.SPEC.save();
    }

    public AnvilWidget(int x, int y, Font font, IShellMenu menu) {
        super(AnvilWidget.loadPositionX(x), AnvilWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.anvil"), font, WidgetUnlockSystem.WidgetType.ANVIL, menu);
        this.inputItem = ItemStack.EMPTY;
        this.materialItem = ItemStack.EMPTY;
        this.resultItem = ItemStack.EMPTY;
        this.isPinned = (Boolean)OverlayConfig.ANVIL_PINNED.get();
        this.collapsed = (Boolean)OverlayConfig.ANVIL_COLLAPSED.get();
        this.requestInitialDataFromServer();
    }

    private void requestInitialDataFromServer() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AnvilSlotInteractionPacket(AnvilSlotInteractionPacket.SlotType.INPUT, AnvilSlotInteractionPacket.ActionType.PUT_ITEM, ItemStack.EMPTY, ""), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean hoveredPanel;
        boolean titleBarHovered;
        this.animationTime += partialTick;
        int x = this.getX();
        int y = this.getY();
        boolean imageEnabled = (Boolean)OverlayConfig.ANVIL_USE_IMAGE_MODE.get();
        boolean bl = this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.ANVIL);
        if (this.collapsed && this.logoMode) {
            this.tempExpanded = false;
        }
        boolean compact = this.isCompactActive();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 80.0f);
        if (compact) {
            boolean titleBarHovered2;
            this.width = 36;
            this.height = 36;
            this.drawTopBar(guiGraphics, x, y, this.width);
            int contentX = x;
            int contentY = y + 12;
            int contentW = this.width;
            int contentH = this.height - 12;
            guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, Theme.panelBg());
            boolean bl2 = titleBarHovered2 = mouseX >= x && mouseX <= x + this.width && mouseY >= y && mouseY <= y + 12;
            if (titleBarHovered2 || this.isDragging()) {
                int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
                guiGraphics.fill(x, y, x + this.width, y + 12, hoverOverlay);
            }
            int iconX = x + (this.width - 16) / 2;
            int iconY = y + 12 + (contentH - 16) / 2;
            this.renderLogoIcon(guiGraphics, iconX, iconY);
            if (this.showContextMenu) {
                this.renderContextMenu(guiGraphics, mouseX, mouseY);
            }
            guiGraphics.pose().popPose();
            return;
        }
        Layout layout = this.computeLayout(x, y);
        this.drawTopBar(guiGraphics, x, y, layout.panelW);
        boolean bl3 = titleBarHovered = mouseX >= x && mouseX <= x + layout.panelW && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging()) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + layout.panelW, y + 12, hoverOverlay);
        }
        this.width = layout.panelW;
        this.height = layout.panelH;
        boolean bl4 = hoveredPanel = mouseX >= x && mouseX <= x + layout.panelW && mouseY >= y && mouseY <= y + layout.panelH;
        if (this.logoMode && !hoveredPanel) {
            int contentX = x;
            int contentY = y + 12;
            int contentW = layout.panelW;
            int contentH = layout.panelH - 12;
            guiGraphics.fill(contentX, contentY, x + contentW, y + contentH, Theme.panelBg());
            int iconX = x + (layout.panelW - 16) / 2;
            int iconY = y + 12 + (contentH - 16) / 2;
            this.renderLogoIcon(guiGraphics, iconX, iconY);
            if (this.showContextMenu) {
                this.renderContextMenu(guiGraphics, mouseX, mouseY);
            }
            guiGraphics.pose().popPose();
            return;
        }
        int contentX = x;
        int contentY = y + 12;
        int contentW = layout.panelW;
        int contentH = layout.panelH - 12;
        guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, Theme.panelBg());
        if (!Theme.isLight()) {
            guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, 0x12FFFFFF);
        }
        this.drawAnvilInterface(guiGraphics, layout, mouseX, mouseY);
        if (this.showContextMenu) {
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }
        guiGraphics.pose().popPose();
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int iconX, int iconY) {
        ResourceLocation tex = Theme.icon("anvil");
        try {
            guiGraphics.blit(tex, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Throwable t) {
            int c = -5592406;
            guiGraphics.fill(iconX + 2, iconY + 2, iconX + 14, iconY + 14, Theme.panelBg());
            guiGraphics.fill(iconX + 1, iconY + 1, iconX + 15, iconY + 15, c);
        }
    }

    private void drawAnvilInterface(GuiGraphics guiGraphics, Layout l, int mouseX, int mouseY) {
        this.drawSlotBackground(guiGraphics, l.inputX, l.inputY);
        if (!this.inputItem.isEmpty()) {
            guiGraphics.renderItem(this.inputItem, l.inputX, l.inputY);
            if (this.inputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.inputItem, l.inputX, l.inputY);
            }
        }
        this.drawSlotBackground(guiGraphics, l.materialX, l.materialY);
        if (!this.materialItem.isEmpty()) {
            guiGraphics.renderItem(this.materialItem, l.materialX, l.materialY);
            if (this.materialItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.materialItem, l.materialX, l.materialY);
            }
        }
        int plusX = l.inputX + 16 + 4;
        int plusY = l.inputY + 2;
        this.drawPlusSign(guiGraphics, plusX, plusY);
        this.drawAnvilArrow(guiGraphics, l.arrowX, l.arrowY);
        this.drawSlotBackground(guiGraphics, l.resultX, l.resultY);
        if (!this.resultItem.isEmpty()) {
            guiGraphics.renderItem(this.resultItem, l.resultX, l.resultY);
            if (this.resultItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.resultItem, l.resultX, l.resultY);
            }
        }
        if (!this.inputItem.isEmpty() && this.resultItem.isEmpty()) {
            this.drawRedCross(guiGraphics, l.arrowX, l.arrowY);
        }
        this.renderCost(guiGraphics, l);
        this.drawRenameField(guiGraphics, l);
    }

    private void drawSlotBackground(GuiGraphics guiGraphics, int x, int y) {
        int slotBorder = Theme.slotBorder();
        int slotFill = Theme.slotFill();
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, slotBorder);
        guiGraphics.fill(x, y, x + 16, y + 16, slotFill);
    }

    private void drawRenameField(GuiGraphics guiGraphics, Layout l) {
        int textColor;
        Object displayText;
        int fieldX = l.inputX;
        int fieldY = l.inputY + 16 + 6;
        int fieldWidth = l.materialX + 16 - l.inputX;
        this.renameFieldX = fieldX;
        this.renameFieldY = fieldY;
        this.renameFieldWidth = fieldWidth;
        boolean hasInputItem = !this.inputItem.isEmpty();
        int borderColor = hasInputItem ? Theme.slotBorder() : -10066330;
        int fillColor = hasInputItem ? Theme.slotFill() : -13421773;
        Objects.requireNonNull(this.font);
        guiGraphics.fill(fieldX - 1, fieldY - 1, fieldX + fieldWidth + 1, fieldY + 9 + 1, borderColor);
        Objects.requireNonNull(this.font);
        guiGraphics.fill(fieldX, fieldY, fieldX + fieldWidth, fieldY + 9, fillColor);
        if (this.isFocused && this.isRenaming) {
            displayText = this.renameText + "_";
            textColor = Theme.textOnPanel();
        } else if (this.renameText.isEmpty()) {
            displayText = hasInputItem ? Component.translatable((String)"nomadsshell.ui.rename_item").getString() : Component.translatable((String)"nomadsshell.ui.place_item_to_rename").getString();
            textColor = -8355712;
        } else {
            displayText = this.renameText;
            int n = textColor = hasInputItem ? Theme.textOnPanel() : -10066330;
        }
        if (this.font.width((String)displayText) > fieldWidth - 4) {
            displayText = this.font.plainSubstrByWidth((String)displayText, fieldWidth - 4) + "...";
        }
        guiGraphics.drawString(this.font, (String)displayText, fieldX + 2, fieldY + 1, textColor);
    }

    private void drawPlusSign(GuiGraphics guiGraphics, int x, int y) {
        int plusColor = Theme.textOnPanel();
        guiGraphics.fill(x + 3, y + 7, x + 11, y + 9, plusColor);
        guiGraphics.fill(x + 6, y + 4, x + 8, y + 12, plusColor);
    }

    private void drawAnvilArrow(GuiGraphics guiGraphics, int x, int y) {
        int arrowColor = Theme.textOnPanel();
        guiGraphics.fill(x, y + 3, x + 12, y + 5, arrowColor);
        guiGraphics.fill(x + 12, y + 0, x + 12, y + 1, arrowColor);
        guiGraphics.fill(x + 12, y + 1, x + 13, y + 2, arrowColor);
        guiGraphics.fill(x + 12, y + 2, x + 14, y + 3, arrowColor);
        guiGraphics.fill(x + 12, y + 3, x + 15, y + 4, arrowColor);
        guiGraphics.fill(x + 12, y + 4, x + 15, y + 5, arrowColor);
        guiGraphics.fill(x + 12, y + 5, x + 14, y + 6, arrowColor);
        guiGraphics.fill(x + 12, y + 6, x + 13, y + 7, arrowColor);
        guiGraphics.fill(x + 12, y + 7, x + 12, y + 8, arrowColor);
    }

    private void drawRedCross(GuiGraphics guiGraphics, int x, int y) {
        int crossColor = -65536;
        guiGraphics.fill(x + 2, y + 2, x + 4, y + 4, crossColor);
        guiGraphics.fill(x + 10, y + 2, x + 12, y + 4, crossColor);
        guiGraphics.fill(x + 2, y + 10, x + 4, y + 12, crossColor);
        guiGraphics.fill(x + 10, y + 10, x + 12, y + 12, crossColor);
    }

    private void renderCost(GuiGraphics guiGraphics, Layout l) {
        if (this.repairCost <= 0) {
            return;
        }
        int x = l.resultX + 16 + 4;
        int n = l.resultY;
        Objects.requireNonNull(this.font);
        int y = n + (16 - 9) / 2;
        Minecraft mc = Minecraft.getInstance();
        boolean hasEnoughXP = mc.player != null && mc.player.experienceLevel >= this.repairCost;
        String costText = this.repairCost + " XP";
        int textWidth = this.font.width(costText);
        Objects.requireNonNull(this.font);
        guiGraphics.fill(x - 2, y - 1, x + textWidth + 2, y + 9 + 1, Integer.MIN_VALUE);
        int textColor = this.repairCost >= 40 ? -43691 : (this.resultItem.isEmpty() ? -8355712 : (!hasEnoughXP ? -22016 : -16711936));
        guiGraphics.drawString(this.font, costText, x, y, textColor);
    }

    private void drawTopBar(GuiGraphics g, int x, int y, int w) {
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x, y + 12 - 1, x + w, y + 12, Theme.titleBarBorder());
    }

    private Layout computeLayout(int x, int y) {
        Layout l = new Layout();
        l.panelX = x;
        l.panelY = y;
        int plusSignWidth = 14;
        int plusSignGap = 4;
        int slotW = 50 + plusSignWidth + plusSignGap * 2;
        l.panelW = 6 + slotW + 8 + 18 + 8 + 16 + 6;
        Objects.requireNonNull(this.font);
        l.panelH = 40 + 9 + 6 + 6;
        l.inputX = x + 6;
        l.inputY = y + 12 + 6;
        l.materialX = l.inputX + 16 + plusSignWidth + plusSignGap * 2;
        l.materialY = l.inputY;
        int centerY = l.inputY + 8;
        l.arrowX = l.materialX + 16 + 8;
        l.arrowY = centerY - 4;
        l.resultX = l.arrowX + 18 + 8;
        l.resultY = centerY - 8;
        return l;
    }

    private boolean isCompactActive() {
        boolean idle;
        if (!this.collapsed) {
            return false;
        }
        boolean bl = idle = (Boolean)OverlayConfig.ANVIL_USE_IMAGE_MODE.get() != false && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.ANVIL);
        return !this.tempExpanded || idle;
    }

    public void tick() {
        if (!this.isUnlocked()) {
            return;
        }
        this.syncFromshellData();
        if (this.isCompactActive()) {
            this.width = 36;
            this.height = 36;
        } else {
            Layout l = this.computeLayout(this.getX(), this.getY());
            this.width = l.panelW;
            this.height = l.panelH;
        }
    }

    private void syncFromshellData() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            ItemStack newInput = this.loadInputFromshell();
            ItemStack newMaterial = this.loadMaterialFromshell();
            ItemStack newResult = this.loadResultFromshell();
            int newRepairCost = this.loadRepairCostFromshell();
            String newRenameText = this.loadRenameTextFromshell();
            if (!AnvilWidget.itemStacksEqual(this.inputItem, newInput)) {
                this.inputItem = newInput;
                if (!this.isFocused && !this.isRenaming) {
                    if (!newInput.isEmpty()) {
                        this.renameText = newInput.getHoverName().getString();
                        this.sendRenameTextToServer();
                    } else {
                        this.renameText = "";
                        this.sendRenameTextToServer();
                    }
                }
            }
            if (!AnvilWidget.itemStacksEqual(this.materialItem, newMaterial)) {
                this.materialItem = newMaterial;
            }
            if (!AnvilWidget.itemStacksEqual(this.resultItem, newResult)) {
                this.resultItem = newResult;
            }
            if (this.repairCost != newRepairCost) {
                this.repairCost = newRepairCost;
            }
            if (!(this.renameText.equals(newRenameText) || this.isFocused || this.isRenaming)) {
                this.renameText = newRenameText;
            }
        }
    }

    private static boolean itemStacksEqual(ItemStack a, ItemStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) && a.getCount() == b.getCount();
    }

    @Override
    protected void stopDragging() {
        super.stopDragging();
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    public int getWidth() {
        if (this.isCompactActive()) {
            return 36;
        }
        Layout l = this.computeLayout(this.getX(), this.getY());
        return l.panelW;
    }

    public int getHeight() {
        if (this.isCompactActive()) {
            return 36;
        }
        Layout l = this.computeLayout(this.getX(), this.getY());
        return l.panelH;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean hoveredPanel;
        boolean overCollapse;
        boolean handled;
        if (!this.isActive()) {
            return false;
        }
        if (button == 0 && this.showContextMenu && (handled = super.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        ItemStack shellStack = this.getshellStack();
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.ANVIL, shellStack)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int pinX = x + w - 8 - 2;
        int pinY = y + 2;
        int collapseX = pinX - 8 - 2;
        int collapseY = pinY;
        boolean bl = overCollapse = mouseX >= (double)collapseX && mouseX <= (double)(collapseX + 8) && mouseY >= (double)collapseY && mouseY <= (double)(collapseY + 8);
        if (overCollapse && button == 0) {
            this.toggleCollapsed();
            return true;
        }
        if (this.collapsed && this.isCompactActive()) {
            boolean inside;
            boolean bl2 = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
            if (inside && button == 0) {
                OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.ANVIL);
                this.tempExpanded = true;
                return true;
            }
        }
        Layout l = this.computeLayout(x, y);
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.ANVIL) && mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.ANVIL);
            return true;
        }
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        boolean bl3 = hoveredPanel = mouseX >= (double)x && mouseX <= (double)(x + l.panelW) && mouseY >= (double)y && mouseY <= (double)(y + l.panelH);
        if (this.logoMode && hoveredPanel) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.ANVIL);
            return true;
        }
        if (this.isMouseOverRenameField(mouseX, mouseY) && !this.inputItem.isEmpty() && button == 0) {
            this.isRenaming = true;
            this.isFocused = true;
            this.sendRenameTextToServer();
            return true;
        }
        if (this.isFocused && !this.isMouseOverRenameField(mouseX, mouseY)) {
            this.isFocused = false;
            this.isRenaming = false;
            return true;
        }
        if (this.isMouseOverSlot(mouseX, mouseY, l.inputX, l.inputY)) {
            this.handleSlotClick(AnvilSlotInteractionPacket.SlotType.INPUT, button, Screen.hasShiftDown());
            return true;
        }
        if (this.isMouseOverSlot(mouseX, mouseY, l.materialX, l.materialY)) {
            this.handleSlotClick(AnvilSlotInteractionPacket.SlotType.MATERIAL, button, Screen.hasShiftDown());
            return true;
        }
        if (this.isMouseOverSlot(mouseX, mouseY, l.resultX, l.resultY)) {
            this.handleSlotClick(AnvilSlotInteractionPacket.SlotType.RESULT, button, Screen.hasShiftDown());
            return true;
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive() || !this.isUnlocked()) {
            return false;
        }
        if (this.isFocused && this.isRenaming) {
            if (keyCode == 257) {
                this.isRenaming = false;
                this.isFocused = false;
                this.sendRenameTextToServer();
                return true;
            }
            if (keyCode == 256) {
                this.isRenaming = false;
                this.isFocused = false;
                return true;
            }
            if (keyCode == 259 || keyCode == 8) {
                if (!this.renameText.isEmpty()) {
                    this.renameText = this.renameText.substring(0, this.renameText.length() - 1);
                }
                this.sendRenameTextToServer();
                return true;
            }
            if (keyCode == 69) {
                return true;
            }
            if (keyCode == 66) {
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.isActive() || !this.isUnlocked()) {
            return false;
        }
        if (this.isFocused && this.isRenaming) {
            if (this.renameText.length() < 35 && codePoint >= ' ' && codePoint <= '~') {
                this.renameText = this.renameText + codePoint;
                this.sendRenameTextToServer();
            }
            return true;
        }
        return false;
    }

    private void sendRenameTextToServer() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new AnvilSlotInteractionPacket(AnvilSlotInteractionPacket.SlotType.INPUT, AnvilSlotInteractionPacket.ActionType.RENAME, ItemStack.EMPTY, this.renameText), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private boolean isMouseOverSlot(double mouseX, double mouseY, int slotX, int slotY) {
        return mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMouseOverRenameField(double mouseX, double mouseY) {
        if (!(mouseX >= (double)this.renameFieldX)) return false;
        if (!(mouseX <= (double)(this.renameFieldX + this.renameFieldWidth))) return false;
        if (!(mouseY >= (double)this.renameFieldY)) return false;
        Objects.requireNonNull(this.font);
        if (!(mouseY <= (double)(this.renameFieldY + 9))) return false;
        return true;
    }

    private void handleSlotClick(AnvilSlotInteractionPacket.SlotType slotType, int button, boolean isShiftDown) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (slotType == AnvilSlotInteractionPacket.SlotType.RESULT && !this.resultItem.isEmpty()) {
            boolean hasEnoughXP;
            boolean bl = hasEnoughXP = mc.player.experienceLevel >= this.repairCost;
            if (!hasEnoughXP) {
                return;
            }
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ANVIL_USE, (float)1.0f, (float)1.0f));
        }
        ItemStack carried = mc.player.containerMenu.getCarried();
        AnvilSlotInteractionPacket.ActionType actionType = button == 0 ? (!carried.isEmpty() ? (isShiftDown ? AnvilSlotInteractionPacket.ActionType.PUT_ONE : AnvilSlotInteractionPacket.ActionType.PUT_ITEM) : (isShiftDown ? AnvilSlotInteractionPacket.ActionType.TAKE_HALF : AnvilSlotInteractionPacket.ActionType.TAKE_ITEM)) : (carried.isEmpty() ? AnvilSlotInteractionPacket.ActionType.TAKE_HALF : AnvilSlotInteractionPacket.ActionType.PUT_ONE);
        PacketDistributor.sendToServer((CustomPacketPayload)new AnvilSlotInteractionPacket(slotType, actionType, carried, this.renameText), (CustomPacketPayload[])new CustomPacketPayload[0]);
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)1.0f));
    }

    private void toggleCollapsed() {
        this.collapsed = !this.collapsed;
        OverlayConfig.ANVIL_COLLAPSED.set((Object)this.collapsed);
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        super.renderControlButtons(guiGraphics, mouseX, mouseY, currentWidth, currentHeight);
        int x = this.getX();
        int y = this.getY();
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        int collapseX = pinX - 8 - 2;
        int collapseY = pinY;
        boolean hovered = mouseX >= collapseX && mouseX <= collapseX + 8 && mouseY >= collapseY && mouseY <= collapseY + 8;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.fill(collapseX, collapseY, collapseX + 8, collapseY + 8, Theme.buttonBg(hovered));
        ResourceLocation icon = Theme.icon(this.collapsed ? "expand" : "collapse");
        try {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)collapseX, (float)collapseY, 0.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            guiGraphics.blit(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
        }
        catch (Throwable t) {
            int fg = Theme.isLight() ? -16777216 : -1;
            guiGraphics.fill(collapseX + 2, collapseY + 2, collapseX + 8 - 2, collapseY + 8 - 2, fg);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    protected void drawWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + currentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.panelBg());
    }

    private static class Layout {
        int panelX;
        int panelY;
        int panelW;
        int panelH;
        int inputX;
        int inputY;
        int materialX;
        int materialY;
        int arrowX;
        int arrowY;
        int resultX;
        int resultY;

        private Layout() {
        }
    }
}

