/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.UpdateCollectorSlotPacket;
import com.etka.nomadsshell.network.UpdateCollectorTagFilterPacket;
import com.etka.nomadsshell.network.UpdateCollectorTagRecorderGhostPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CollectorWidget
extends LockableWidget {
    private final IShellMenu menu;
    private boolean logoMode = false;
    private static final int TAG_BORDER_COLOR = -6596170;
    private static final int TAG_BG_COLOR = -12899525;
    private static final int MINI_BTN = 6;
    private int selectedTagRemoveIdx = 0;
    private int selectedTagGhostIdx = 0;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.COLLECTOR_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.COLLECTOR_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    public CollectorWidget(int x, int y, Font font, IShellMenu menu) {
        super(CollectorWidget.loadPositionX(x), CollectorWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.collector"), font, WidgetUnlockSystem.WidgetType.COLLECTOR, menu);
        this.menu = menu;
        this.isPinned = (Boolean)OverlayConfig.COLLECTOR_PINNED.get();
        this.updateWidgetDimensions();
    }

    @Override
    protected void updateWidgetDimensions() {
        int requiredHeight = this.calculateRequiredHeight();
        this.width = 140;
        this.height = requiredHeight;
    }

    private int calculateRequiredHeight() {
        ItemStack shell;
        int height = 20;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && !(shell = ShellItem.findWornshell((Player)player)).isEmpty()) {
            WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.COLLECTOR;
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
            int tierLevel = currentTier.getLevel();
            if (tierLevel >= 2) {
                height += 22;
            } else if (tierLevel >= 1) {
                height += 22;
            }
        }
        return Math.max(height, 36);
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float pt) {
        boolean titleBarHovered;
        boolean hoveredWidget;
        this.updateWidgetDimensions();
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean imageEnabled = (Boolean)OverlayConfig.COLLECTOR_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.COLLECTOR);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, w, h - 12);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.COLLECTOR;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x - 1, y - 1, x + w + 1, y + 12, Theme.panelBorder());
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        boolean bl2 = titleBarHovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            g.fill(x, y, x + w, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = h - 12;
        g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
        if (tierLevel >= 2) {
            int startX = x + 4;
            int startY = contentY + 4;
            for (int i = 0; i < 5; ++i) {
                int slotX = startX + i * 20;
                int slotY = startY;
                g.fill(slotX, slotY, slotX + 16, slotY + 16, Theme.slotFill());
                g.fill(slotX - 1, slotY - 1, slotX + 17, slotY, Theme.slotBorder());
                g.fill(slotX - 1, slotY + 16, slotX + 17, slotY + 17, Theme.slotBorder());
                g.fill(slotX - 1, slotY - 1, slotX, slotY + 17, Theme.slotBorder());
                g.fill(slotX + 16, slotY - 1, slotX + 17, slotY + 17, Theme.slotBorder());
                ItemStack stack = WidgetDataHelper.getCollectorItem((Player)player, i);
                if (stack.isEmpty()) continue;
                ItemStack ghost = stack.copy();
                ghost.setCount(1);
                g.renderItem(ghost, slotX, slotY);
            }
            int tagSlotX = startX + 100 + 4;
            int tagSlotY = startY;
            List<ResourceLocation> collectorTags = WidgetDataHelper.getCollectorTags((Player)player);
            boolean whitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)player);
            this.drawTagSelectorSlot(g, tagSlotX, tagSlotY, collectorTags.size(), whitelist, true, this.selectedTagRemoveIdx);
            ItemStack tagGhost = WidgetDataHelper.getCollectorTagGhost((Player)player);
            if (!tagGhost.isEmpty()) {
                ItemStack ghost = tagGhost.copy();
                ghost.setCount(1);
                g.renderItem(ghost, tagSlotX, tagSlotY);
            }
        } else if (tierLevel >= 1) {
            int startX = x + 4;
            int startY = contentY + 4;
            for (int i = 0; i < 3; ++i) {
                g.fill(startX + i * 20, startY, startX + i * 20 + 16, startY + 16, Theme.slotFill());
                g.fill(startX + i * 20 - 1, startY - 1, startX + i * 20 + 17, startY, Theme.slotBorder());
                g.fill(startX + i * 20 - 1, startY + 16, startX + i * 20 + 17, startY + 17, Theme.slotBorder());
                g.fill(startX + i * 20 - 1, startY - 1, startX + i * 20, startY + 17, Theme.slotBorder());
                g.fill(startX + i * 20 + 16, startY - 1, startX + i * 20 + 17, startY + 17, Theme.slotBorder());
                ItemStack stack = WidgetDataHelper.getCollectorItem((Player)player, i);
                if (stack.isEmpty()) continue;
                ItemStack ghost = stack.copy();
                ghost.setCount(1);
                g.renderItem(ghost, startX + i * 20, startY);
            }
        }
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.COLLECTOR_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.COLLECTOR_USE_IMAGE_MODE.get();
        OverlayConfig.COLLECTOR_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        guiGraphics.blit(Theme.icon("collect"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.COLLECTOR);
        this.logoMode = false;
        int collectorX = x + w - 16 - 4;
        int collectorY = y + 2;
        if (mouseX >= (double)collectorX && mouseX <= (double)(collectorX + 8) && mouseY >= (double)collectorY && mouseY <= (double)(collectorY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.COLLECTOR_ENABLED.get();
            OverlayConfig.COLLECTOR_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.COLLECTOR;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        if (tierLevel >= 1 && (button == 0 || button == 1)) {
            int startX = x + 4;
            int startY = y + 12 + 4;
            int slotCount = tierLevel >= 2 ? 5 : 3;
            for (int i = 0; i < slotCount; ++i) {
                if (!(mouseX >= (double)(startX + i * 20)) || !(mouseX <= (double)(startX + i * 20 + 16)) || !(mouseY >= (double)startY) || !(mouseY <= (double)(startY + 16))) continue;
                ItemStack carried = mc.player.containerMenu.getCarried();
                ItemStack toSend = button == 1 ? ItemStack.EMPTY : (carried.isEmpty() ? ItemStack.EMPTY : carried.copyWithCount(1));
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorSlotPacket(i, toSend), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            if (tierLevel >= 2) {
                int startXControls;
                int tagSlotX = startX + 100 + 4;
                int tagSlotY = startY;
                if (mouseX >= (double)tagSlotX && mouseX <= (double)(tagSlotX + 16) && mouseY >= (double)tagSlotY && mouseY <= (double)(tagSlotY + 16)) {
                    this.handleTagSelectorClick(tagSlotX, tagSlotY, mouseX, mouseY, button);
                    return true;
                }
                int cx = tagSlotX + 8;
                int cy = tagSlotY + 16 + 2;
                int spacing = 2;
                int totalW = 18 + spacing * 2;
                int minusX = startXControls = cx - totalW / 2;
                int wlX = startXControls + 6 + spacing;
                int plusX = wlX + 6 + spacing;
                if (mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) || mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) || mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6)) {
                    this.handleTagSelectorClick(tagSlotX, tagSlotY, mouseX, mouseY, button);
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.COLLECTOR_X.set((Object)this.getX());
            OverlayConfig.COLLECTOR_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.COLLECTOR_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void stopDragging() {
        super.stopDragging();
        this.savePositionToConfig();
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return true;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return true;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.COLLECTOR;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        if (tierLevel >= 2) {
            List<ResourceLocation> tags;
            boolean overPlus;
            int startXControls;
            int startX = x + 4;
            int startY = y + 12 + 4;
            int tagSlotX = startX + 100 + 4;
            int tagSlotY = startY;
            if (mouseX >= (double)tagSlotX && mouseX <= (double)(tagSlotX + 16) && mouseY >= (double)tagSlotY && mouseY <= (double)(tagSlotY + 16)) {
                List keys;
                ItemStack ghost = WidgetDataHelper.getCollectorTagGhost((Player)player);
                List<Object> list = keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
                if (!keys.isEmpty()) {
                    int dir = scrollY > 0.0 ? -1 : 1;
                    this.selectedTagGhostIdx = Math.floorMod(this.selectedTagGhostIdx + dir, keys.size());
                    OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.COLLECTOR);
                    return true;
                }
            }
            int cx = tagSlotX + 8;
            int cy = tagSlotY + 16 + 2;
            int spacing = 2;
            int totalW = 18 + spacing * 2;
            int minusX = startXControls = cx - totalW / 2;
            int wlX = startXControls + 6 + spacing;
            int plusX = wlX + 6 + spacing;
            boolean overMinus = mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
            boolean bl2 = overPlus = mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
            if (overPlus) {
                List keys;
                ItemStack ghost = WidgetDataHelper.getCollectorTagGhost((Player)player);
                List<Object> list = keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
                if (!keys.isEmpty()) {
                    int dir = scrollY > 0.0 ? -1 : 1;
                    this.selectedTagGhostIdx = Math.floorMod(this.selectedTagGhostIdx + dir, keys.size());
                    OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.COLLECTOR);
                    return true;
                }
            } else if (overMinus && !(tags = WidgetDataHelper.getCollectorTags((Player)player)).isEmpty()) {
                int dir = scrollY > 0.0 ? -1 : 1;
                this.selectedTagRemoveIdx = Math.floorMod(this.selectedTagRemoveIdx + dir, tags.size());
                OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.COLLECTOR);
                return true;
            }
        }
        return true;
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int collectorX = x + currentWidth - 16 - 4;
        int collectorY = y + 2;
        boolean collectorHovered = mouseX >= collectorX && mouseX <= collectorX + 8 && mouseY >= collectorY && mouseY <= collectorY + 8;
        boolean collectorEnabled = (Boolean)OverlayConfig.COLLECTOR_ENABLED.get();
        int n = buttonColor = collectorEnabled ? -11751600 : -769226;
        if (collectorHovered) {
            buttonColor = collectorEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(collectorX, collectorY, collectorX + 8, collectorY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, pinColor);
        } else {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, pinColor);
        }
        guiGraphics.pose().popPose();
    }

    private List<ResourceLocation> getItemTagKeys(ItemStack stack) {
        if (stack.isEmpty()) {
            return List.of();
        }
        return stack.getTags().map(tag -> tag.location()).toList();
    }

    private void drawTagSelectorSlot(GuiGraphics guiGraphics, int x, int y, int tagCount, boolean whitelist, boolean controlsBelow, int selectedIndex) {
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, -6596170);
        guiGraphics.fill(x, y, x + 16, y + 16, -12899525);
        int cx = x + 8;
        int cy = controlsBelow ? y + 16 + 2 : y - 6 - 2;
        int spacing = 2;
        int totalW = 18 + spacing * 2;
        int startX = cx - totalW / 2;
        guiGraphics.fill(startX, cy, startX + 6, cy + 6, -11916470);
        guiGraphics.fill(startX + 1, cy + 3, startX + 6 - 1, cy + 3 + 1, -1);
        int midX = startX + 6 + spacing;
        int wlBg = whitelist ? -13796794 : -8770259;
        guiGraphics.fill(midX, cy, midX + 6, cy + 6, wlBg);
        int g = -1;
        if (whitelist) {
            guiGraphics.fill(midX + 1, cy + 1, midX + 2, cy + 6 - 1, g);
            guiGraphics.fill(midX + 6 - 2, cy + 1, midX + 6 - 1, cy + 6 - 1, g);
            guiGraphics.fill(midX + 2, cy + 2, midX + 6 - 2, cy + 3, g);
        } else {
            guiGraphics.fill(midX + 1, cy + 1, midX + 6 - 1, cy + 2, g);
            guiGraphics.fill(midX + 1, cy + 6 - 2, midX + 6 - 1, cy + 6 - 1, g);
            guiGraphics.fill(midX + 1, cy + 1, midX + 2, cy + 6 - 1, g);
            guiGraphics.fill(midX + 6 - 2, cy + 2, midX + 6 - 1, cy + 6 - 2, g);
        }
        int plusX = midX + 6 + spacing;
        guiGraphics.fill(plusX, cy, plusX + 6, cy + 6, -11916470);
        guiGraphics.fill(plusX + 1, cy + 3, plusX + 6 - 1, cy + 3 + 1, -1);
        guiGraphics.fill(plusX + 3, cy + 1, plusX + 3 + 1, cy + 6 - 1, -1);
        int mouseX = Minecraft.getInstance().mouseHandler.xpos() == 0.0 ? -1 : (int)(Minecraft.getInstance().mouseHandler.xpos() / Minecraft.getInstance().getWindow().getGuiScale());
        int mouseY = Minecraft.getInstance().mouseHandler.ypos() == 0.0 ? -1 : (int)(Minecraft.getInstance().mouseHandler.ypos() / Minecraft.getInstance().getWindow().getGuiScale());
        int minusX = startX;
        if (mouseX >= minusX && mouseX <= minusX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showTagTooltip(guiGraphics, mouseX, mouseY, false);
        } else if (mouseX >= midX && mouseX <= midX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showWhitelistTooltip(guiGraphics, mouseX, mouseY, whitelist);
        } else if (mouseX >= plusX && mouseX <= plusX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showTagTooltip(guiGraphics, mouseX, mouseY, true);
        }
    }

    private void showTagTooltip(GuiGraphics g, int mx, int my, boolean isPlus) {
        String title;
        List<Object> list;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        List<Object> active = List.of();
        if (isPlus) {
            ItemStack ghost = WidgetDataHelper.getCollectorTagGhost((Player)mc.player);
            List keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
            list = keys;
            title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString() + ": Add tag";
            active = WidgetDataHelper.getCollectorTags((Player)mc.player);
        } else {
            list = WidgetDataHelper.getCollectorTags((Player)mc.player);
            title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString() + ": Remove tag";
        }
        if (list.isEmpty()) {
            return;
        }
        int sel = isPlus ? this.selectedTagGhostIdx : this.selectedTagRemoveIdx;
        int max = Math.min(8, list.size());
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        lines.add((CallSite)((Object)title));
        colors.add(-1);
        for (int i = 0; i < max; ++i) {
            ResourceLocation rl = (ResourceLocation)list.get(i);
            String name = rl.toString();
            boolean bl = isPlus && active.contains(rl);
            String label = (i == sel ? "> " : "  ") + (String)name + (bl ? " (added)" : "");
            lines.add((CallSite)((Object)label));
            colors.add(bl ? -11141291 : -1);
        }
        int pad = 4;
        int w = 0;
        for (String string : lines) {
            w = Math.max(w, this.font.width(string));
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int h = n * (9 + 1) + pad * 2;
        int n2 = w + pad * 2;
        int tx = mx + 8;
        int ty = my + 8;
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        if (tx + n2 > screenW) {
            tx = mx - n2 - 8;
        }
        if (ty + h > screenH) {
            ty = my - h - 8;
        }
        g.fill(tx + 2, ty + 2, tx + n2 + 2, ty + h + 2, 0x77000000);
        g.fill(tx, ty, tx + n2, ty + h, -870375649);
        g.fill(tx - 1, ty - 1, tx + n2 + 1, ty, -1);
        g.fill(tx - 1, ty + h, tx + n2 + 1, ty + h + 1, -1);
        g.fill(tx - 1, ty, tx, ty + h, -1);
        g.fill(tx + n2, ty, tx + n2 + 1, ty + h, -1);
        int y = ty + pad;
        for (int i = 0; i < lines.size(); ++i) {
            String s = (String)lines.get(i);
            int col = (Integer)colors.get(Math.min(i, colors.size() - 1));
            g.drawString(this.font, s, tx + pad, y, col, false);
            Objects.requireNonNull(this.font);
            y += 9 + 1;
        }
    }

    private void showWhitelistTooltip(GuiGraphics g, int mx, int my, boolean whitelist) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        String title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString();
        String mode = whitelist ? Component.translatable((String)"nomadsshell.ui.mode_whitelist").getString() : Component.translatable((String)"nomadsshell.ui.mode_blacklist").getString();
        int pad = 4;
        int w = Math.max(this.font.width(title), this.font.width(mode));
        Objects.requireNonNull(this.font);
        int h = (9 + 1) * 2 + pad * 2;
        int tw = w + pad * 2;
        int tx = mx + 8;
        int ty = my + 8;
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        if (tx + tw > screenW) {
            tx = mx - tw - 8;
        }
        if (ty + h > screenH) {
            ty = my - h - 8;
        }
        g.fill(tx + 2, ty + 2, tx + tw + 2, ty + h + 2, 0x77000000);
        g.fill(tx, ty, tx + tw, ty + h, -870375649);
        g.fill(tx - 1, ty - 1, tx + tw + 1, ty, -1);
        g.fill(tx - 1, ty + h, tx + tw + 1, ty + h + 1, -1);
        g.fill(tx - 1, ty, tx, ty + h, -1);
        g.fill(tx + tw, ty, tx + tw + 1, ty + h, -1);
        int y = ty + pad;
        g.drawString(this.font, title, tx + pad, y, -1, false);
        Objects.requireNonNull(this.font);
        g.drawString(this.font, mode, tx + pad, y += 9 + 1, whitelist ? -11141291 : -43691, false);
    }

    private void handleTagSelectorClick(int slotX, int slotY, double mouseX, double mouseY, int button) {
        int startX;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        int cx = slotX + 8;
        int cy = slotY + 16 + 2;
        int spacing = 2;
        int totalW = 18 + spacing * 2;
        int minusX = startX = cx - totalW / 2;
        int wlX = startX + 6 + spacing;
        int plusX = wlX + 6 + spacing;
        if (mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(WidgetDataHelper.getCollectorTags((Player)mc.player));
            if (!tags.isEmpty() && this.selectedTagRemoveIdx >= 0 && this.selectedTagRemoveIdx < tags.size()) {
                tags.remove(this.selectedTagRemoveIdx);
                boolean whitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)mc.player);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorTagFilterPacket(tags, whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.selectedTagRemoveIdx = Math.max(0, Math.min(this.selectedTagRemoveIdx, tags.size() - 1));
            }
            return;
        }
        if (mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            List<ResourceLocation> tags = WidgetDataHelper.getCollectorTags((Player)mc.player);
            boolean whitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)mc.player);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorTagFilterPacket(tags, !whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        if (mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            List<ResourceLocation> keys;
            ItemStack ghost = WidgetDataHelper.getCollectorTagGhost((Player)mc.player);
            if (!ghost.isEmpty() && !(keys = this.getItemTagKeys(ghost)).isEmpty()) {
                ResourceLocation sel = keys.get(Math.floorMod(this.selectedTagGhostIdx, keys.size()));
                ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(WidgetDataHelper.getCollectorTags((Player)mc.player));
                if (!tags.contains(sel)) {
                    tags.add(sel);
                    boolean whitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)mc.player);
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorTagFilterPacket(tags, whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.selectedTagRemoveIdx = tags.size() - 1;
                }
            }
            return;
        }
        if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16)) {
            if (button == 0) {
                ItemStack carried = mc.player.containerMenu.getCarried();
                if (!carried.isEmpty()) {
                    WidgetDataHelper.setCollectorTagGhost((Player)mc.player, carried.copy());
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorTagRecorderGhostPacket(carried.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    List<ResourceLocation> keys = this.getItemTagKeys(carried);
                    this.selectedTagGhostIdx = 0;
                }
            } else if (button == 1) {
                WidgetDataHelper.setCollectorTagGhost((Player)mc.player, ItemStack.EMPTY);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorTagRecorderGhostPacket(ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (button == 2) {
                List<ResourceLocation> tags = WidgetDataHelper.getCollectorTags((Player)mc.player);
                boolean whitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)mc.player);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCollectorTagFilterPacket(tags, !whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

