/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.AddAutoCrafterRecipePacket;
import com.etka.nomadsshell.network.CraftingTableSlotInteractionPacket;
import com.etka.nomadsshell.network.MoveItemToShellPacket;
import com.etka.nomadsshell.network.RemoveAutoCrafterRecipePacket;
import com.etka.nomadsshell.network.ToggleAutoCrafterPacket;
import com.etka.nomadsshell.util.AutoCraftRecipe;
import com.etka.nomadsshell.util.ItemStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class CraftingTableWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private List<ItemStack> craftingGrid = CraftingTableWidget.getEmptyGrid();
    private ItemStack resultItem = ItemStack.EMPTY;
    private float animationTime = 0.0f;
    private boolean paintingActive = false;
    private int paintingButton = -1;
    private final LinkedHashSet<Integer> visitedSlots = new LinkedHashSet();
    private int paintingFirstSlot = -1;
    private boolean leftInitialApplied = false;
    private boolean leftSplitMode = false;
    private ItemStack paintingCarriedItem = ItemStack.EMPTY;
    private Map<Integer, ItemStack> lastPreview = Collections.emptyMap();
    private long lastPreviewUntilMs = 0L;
    private long lastClickTimeMs = 0L;
    private int lastClickedSlot = -1;
    private static final long SYNC_INTERVAL_MS = 75L;
    private long nextSyncAllowedAtMs = 0L;
    private static final int SLOT_SIZE = 16;
    private static final int SLOT_STEP = 18;
    private static final int PANEL_PADDING = 6;
    private static final int GAP_GRID_TO_ARROW = 8;
    private static final int GAP_ARROW_TO_RESULT = 8;
    private static final int ARROW_WIDTH = 18;
    private boolean logoMode = false;
    private boolean collapsed = false;
    private boolean tempExpanded = false;
    private boolean showRecipeManagementDialog = false;
    private int recipeDialogX;
    private int recipeDialogY;
    private int recipeDialogW = 200;
    private int recipeDialogH = 150;
    private int recipeListStartY;
    private int recipeItemHeight = 20;
    private int recipeScrollOffset = 0;
    private int maxVisibleRecipes = 5;
    private boolean isDraggingRecipeScroll = false;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.CRAFTING_TABLE_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.CRAFTING_TABLE_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    @Override
    protected String getContextMenuLabel() {
        boolean imageEnabled = (Boolean)OverlayConfig.CRAFTING_TABLE_USE_IMAGE_MODE.get();
        return imageEnabled ? Component.translatable((String)"nomadsshell.ui.move_all_disable").getString() : Component.translatable((String)"nomadsshell.ui.move_all_enable").getString();
    }

    @Override
    protected void handleContextMenuAction(int index) {
        if (index == 0) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (!this.resultItem.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.CRAFTING_TABLE, MoveItemToShellPacket.SlotType.RESULT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            int limit = Math.min(9, this.craftingGrid.size());
            for (int i = 0; i < limit; ++i) {
                ItemStack s = this.craftingGrid.get(i);
                if (s == null || s.isEmpty()) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.CRAFTING_TABLE, MoveItemToShellPacket.SlotType.GRID, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (index == 1) {
            boolean enabled = (Boolean)OverlayConfig.CRAFTING_TABLE_USE_IMAGE_MODE.get();
            OverlayConfig.CRAFTING_TABLE_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
            OverlayConfig.SPEC.save();
        }
    }

    private List<ItemStack> loadGridFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return CraftingTableWidget.getEmptyGrid();
        }
        return WidgetDataHelper.getCraftingTableGrid((Player)mc.player);
    }

    private ItemStack loadResultFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return ItemStack.EMPTY;
        }
        return WidgetDataHelper.getCraftingTableResult((Player)mc.player);
    }

    private void savePositionToConfig() {
        OverlayConfig.CRAFTING_TABLE_X.set((Object)this.getX());
        OverlayConfig.CRAFTING_TABLE_Y.set((Object)this.getY());
        OverlayConfig.SPEC.save();
    }

    private void savePinStateToConfig() {
        OverlayConfig.CRAFTING_TABLE_PINNED.set((Object)this.isPinned());
        OverlayConfig.SPEC.save();
    }

    private void saveExpandedStateToConfig() {
        OverlayConfig.SPEC.save();
    }

    public CraftingTableWidget(int x, int y, Font font, IShellMenu menu) {
        super(CraftingTableWidget.loadPositionX(x), CraftingTableWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.crafting_table"), font, WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, menu);
        this.craftingGrid = new ArrayList<ItemStack>(this.loadGridFromshell());
        this.resultItem = this.loadResultFromshell();
        this.isPinned = (Boolean)OverlayConfig.CRAFTING_TABLE_PINNED.get();
        this.collapsed = (Boolean)OverlayConfig.CRAFTING_TABLE_COLLAPSED.get();
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderMainContent(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean hoveredPanel;
        boolean titleBarHovered;
        this.animationTime += partialTick;
        int x = this.getX();
        int y = this.getY();
        WidgetUnlockSystem.WidgetTier currentTier = this.getCurrentTier();
        boolean imageEnabled = (Boolean)OverlayConfig.CRAFTING_TABLE_USE_IMAGE_MODE.get();
        boolean bl = this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE);
        if (this.collapsed && this.logoMode) {
            this.tempExpanded = false;
        }
        boolean compact = this.isCompactActive();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 80.0f);
        if (compact) {
            boolean titleBarHovered2;
            this.width = 36;
            this.height = 36;
            this.drawTopBar(guiGraphics, x, y, this.width);
            int contentX = x;
            int contentY = y + 12;
            int contentW = this.width;
            int contentH = this.height - 12;
            guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, Theme.panelBg());
            boolean bl2 = titleBarHovered2 = mouseX >= x && mouseX <= x + this.width && mouseY >= y && mouseY <= y + 12;
            if (titleBarHovered2 || this.isDragging()) {
                int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
                guiGraphics.fill(x, y, x + this.width, y + 12, hoverOverlay);
            }
            int iconX = x + (this.width - 16) / 2;
            int iconY = y + 12 + (contentH - 16) / 2;
            this.renderLogoIcon(guiGraphics, iconX, iconY);
            if (this.showContextMenu) {
                this.renderContextMenu(guiGraphics, mouseX, mouseY);
            }
            guiGraphics.pose().popPose();
            return;
        }
        Layout layout = this.computeLayout(x, y, currentTier);
        this.drawTopBar(guiGraphics, x, y, layout.panelW);
        boolean bl3 = titleBarHovered = mouseX >= x && mouseX <= x + layout.panelW && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging()) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + layout.panelW, y + 12, hoverOverlay);
        }
        this.width = layout.panelW;
        this.height = layout.panelH;
        boolean bl4 = hoveredPanel = mouseX >= x && mouseX <= x + layout.panelW && mouseY >= y && mouseY <= y + layout.panelH;
        if (this.logoMode && !hoveredPanel) {
            int contentX = x;
            int contentY = y + 12;
            int contentW = layout.panelW;
            int contentH = layout.panelH - 12;
            guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, Theme.panelBg());
            int iconX = x + (layout.panelW - 16) / 2;
            int iconY = y + 12 + (contentH - 16) / 2;
            this.renderLogoIcon(guiGraphics, iconX, iconY);
            if (this.showContextMenu) {
                this.renderContextMenu(guiGraphics, mouseX, mouseY);
            }
            guiGraphics.pose().popPose();
            return;
        }
        int contentX = x;
        int contentY = y + 12;
        int contentW = layout.panelW;
        int contentH = layout.panelH - 12;
        guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, Theme.panelBg());
        if (!Theme.isLight()) {
            guiGraphics.fill(contentX, contentY, contentX + contentW, contentY + contentH, 0x12FFFFFF);
        }
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            this.drawTierTwoInterface(guiGraphics, layout, mouseX, mouseY);
        } else {
            this.drawTierOneInterface(guiGraphics, layout, mouseX, mouseY);
        }
        if (this.showContextMenu) {
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }
        guiGraphics.pose().popPose();
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int iconX, int iconY) {
        ResourceLocation tex = Theme.icon("crafting");
        try {
            guiGraphics.blit(tex, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Throwable t) {
            int c = -5592406;
            for (int r = 0; r < 3; ++r) {
                for (int cidx = 0; cidx < 3; ++cidx) {
                    int sx = iconX + cidx * 6;
                    int sy = iconY + r * 6;
                    guiGraphics.fill(sx, sy, sx + 5, sy + 5, Theme.panelBg());
                    guiGraphics.fill(sx - 1, sy - 1, sx + 6, sy + 6, c);
                }
            }
        }
    }

    private WidgetUnlockSystem.WidgetTier getCurrentTier() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack);
        }
        return WidgetUnlockSystem.WidgetTier.TIER_I;
    }

    private void drawTierOneInterface(GuiGraphics guiGraphics, Layout l, int mouseX, int mouseY) {
        Map<Object, Object> preview = Collections.emptyMap();
        if (this.paintingActive && this.isCarryingItem()) {
            preview = this.leftSplitMode ? this.computeLeftDragPreview() : this.computeRightDragPreview();
        } else if (System.currentTimeMillis() < this.lastPreviewUntilMs) {
            preview = this.lastPreview;
        }
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2; ++col) {
                boolean sameOrBetter;
                ItemStack ghost;
                int slotIndex = row * 3 + col;
                int slotX = l.gridStartX + col * 18;
                int slotY = l.gridStartY + row * 18;
                this.drawSlotBackground(guiGraphics, slotX, slotY);
                if (slotIndex < this.craftingGrid.size() && !this.craftingGrid.get(slotIndex).isEmpty()) {
                    ItemStack item = this.craftingGrid.get(slotIndex);
                    guiGraphics.renderItem(item, slotX, slotY);
                    if (item.getCount() > 1) {
                        guiGraphics.renderItemDecorations(this.font, item, slotX, slotY);
                    }
                }
                if (!preview.containsKey(slotIndex) || (ghost = (ItemStack)preview.get(slotIndex)).isEmpty()) continue;
                ItemStack base = slotIndex < this.craftingGrid.size() ? this.craftingGrid.get(slotIndex) : ItemStack.EMPTY;
                boolean bl = sameOrBetter = !base.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)ghost) && base.getCount() >= ghost.getCount();
                if (sameOrBetter) continue;
                guiGraphics.renderItem(ghost, slotX, slotY);
                if (ghost.getCount() <= 1) continue;
                guiGraphics.renderItemDecorations(this.font, ghost, slotX, slotY);
            }
        }
        if (Minecraft.getInstance().player != null && WidgetDataHelper.isAutoCrafterUnlocked((Player)Minecraft.getInstance().player)) {
            int startX;
            int buttonY = l.arrowY - 22;
            int buttonSize = 12;
            int buttonSpacing = 2;
            int totalWidth = buttonSize * 3 + buttonSpacing * 2;
            int saveX = startX = l.arrowX - 1;
            guiGraphics.fill(saveX, buttonY, saveX + buttonSize, buttonY + buttonSize, -11892150);
            int plusCx = saveX + 4;
            int plusCy = buttonY + 3;
            int plusColor = Theme.isLight() ? -15658735 : -1184275;
            guiGraphics.fill(plusCx, plusCy + 2, plusCx + 3, plusCy + 4, plusColor);
            guiGraphics.fill(plusCx + 1, plusCy + 1, plusCx + 2, plusCy + 5, plusColor);
            int manageX = startX + buttonSize + buttonSpacing;
            guiGraphics.fill(manageX, buttonY, manageX + buttonSize, buttonY + buttonSize, -7650029);
            int listCx = manageX + 3;
            int listCy = buttonY + 3;
            int listColor = Theme.isLight() ? -15658735 : -1184275;
            for (int i = 0; i < 3; ++i) {
                guiGraphics.fill(listCx, listCy + i * 2, listCx + 4, listCy + i * 2 + 1, listColor);
            }
            int toggleX = startX + (buttonSize + buttonSpacing) * 2;
            boolean enabled = WidgetDataHelper.isAutoCrafterEnabled((Player)Minecraft.getInstance().player);
            int bg = enabled ? -11892150 : -10066330;
            guiGraphics.fill(toggleX, buttonY, toggleX + buttonSize, buttonY + buttonSize, bg);
            int cx = toggleX + 4;
            int cy = buttonY + 3;
            int torch = Theme.isLight() ? -15658735 : -1184275;
            guiGraphics.fill(cx, cy, cx + 1, cy + 6, torch);
            guiGraphics.fill(cx - 1, cy + 6, cx + 2, cy + 7, torch);
        }
        this.drawCraftingArrow(guiGraphics, l.arrowX, l.arrowY);
        this.drawSlotBackground(guiGraphics, l.resultX, l.resultY);
        if (!this.resultItem.isEmpty()) {
            guiGraphics.renderItem(this.resultItem, l.resultX, l.resultY);
            if (this.resultItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.resultItem, l.resultX, l.resultY);
            }
        }
        if (this.showRecipeManagementDialog) {
            this.drawRecipeManagementDialog(guiGraphics, l);
        }
    }

    private void drawTierTwoInterface(GuiGraphics guiGraphics, Layout l, int mouseX, int mouseY) {
        Map<Object, Object> preview = Collections.emptyMap();
        if (this.paintingActive && this.isCarryingItem()) {
            preview = this.leftSplitMode ? this.computeLeftDragPreview() : this.computeRightDragPreview();
        } else if (System.currentTimeMillis() < this.lastPreviewUntilMs) {
            preview = this.lastPreview;
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                boolean sameOrBetter;
                ItemStack ghost;
                int slotIndex = row * 3 + col;
                int slotX = l.gridStartX + col * 18;
                int slotY = l.gridStartY + row * 18;
                this.drawSlotBackground(guiGraphics, slotX, slotY);
                if (slotIndex < this.craftingGrid.size() && !this.craftingGrid.get(slotIndex).isEmpty()) {
                    ItemStack item = this.craftingGrid.get(slotIndex);
                    guiGraphics.renderItem(item, slotX, slotY);
                    if (item.getCount() > 1) {
                        guiGraphics.renderItemDecorations(this.font, item, slotX, slotY);
                    }
                }
                if (!preview.containsKey(slotIndex) || (ghost = (ItemStack)preview.get(slotIndex)).isEmpty()) continue;
                ItemStack base = slotIndex < this.craftingGrid.size() ? this.craftingGrid.get(slotIndex) : ItemStack.EMPTY;
                boolean bl = sameOrBetter = !base.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)ghost) && base.getCount() >= ghost.getCount();
                if (sameOrBetter) continue;
                guiGraphics.renderItem(ghost, slotX, slotY);
                if (ghost.getCount() <= 1) continue;
                guiGraphics.renderItemDecorations(this.font, ghost, slotX, slotY);
            }
        }
        if (Minecraft.getInstance().player != null && WidgetDataHelper.isAutoCrafterUnlocked((Player)Minecraft.getInstance().player)) {
            int startX;
            int buttonY = l.arrowY - 22;
            int buttonSize = 12;
            int buttonSpacing = 2;
            int totalWidth = buttonSize * 3 + buttonSpacing * 2;
            int saveX = startX = l.arrowX - 1;
            guiGraphics.fill(saveX, buttonY, saveX + buttonSize, buttonY + buttonSize, -11892150);
            int plusCx = saveX + 4;
            int plusCy = buttonY + 3;
            int plusColor = Theme.isLight() ? -15658735 : -1184275;
            guiGraphics.fill(plusCx, plusCy + 2, plusCx + 3, plusCy + 4, plusColor);
            guiGraphics.fill(plusCx + 1, plusCy + 1, plusCx + 2, plusCy + 5, plusColor);
            int manageX = startX + buttonSize + buttonSpacing;
            guiGraphics.fill(manageX, buttonY, manageX + buttonSize, buttonY + buttonSize, -7650029);
            int listCx = manageX + 3;
            int listCy = buttonY + 3;
            int listColor = Theme.isLight() ? -15658735 : -1184275;
            for (int i = 0; i < 3; ++i) {
                guiGraphics.fill(listCx, listCy + i * 2, listCx + 4, listCy + i * 2 + 1, listColor);
            }
            int toggleX = startX + (buttonSize + buttonSpacing) * 2;
            boolean enabled = WidgetDataHelper.isAutoCrafterEnabled((Player)Minecraft.getInstance().player);
            int bg = enabled ? -11892150 : -10066330;
            guiGraphics.fill(toggleX, buttonY, toggleX + buttonSize, buttonY + buttonSize, bg);
            int cx = toggleX + 4;
            int cy = buttonY + 3;
            int torch = Theme.isLight() ? -15658735 : -1184275;
            guiGraphics.fill(cx, cy, cx + 1, cy + 6, torch);
            guiGraphics.fill(cx - 1, cy + 6, cx + 2, cy + 7, torch);
        }
        this.drawCraftingArrow(guiGraphics, l.arrowX, l.arrowY);
        this.drawSlotBackground(guiGraphics, l.resultX, l.resultY);
        if (!this.resultItem.isEmpty()) {
            guiGraphics.renderItem(this.resultItem, l.resultX, l.resultY);
            if (this.resultItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.resultItem, l.resultX, l.resultY);
            }
        }
        if (this.showRecipeManagementDialog) {
            this.drawRecipeManagementDialog(guiGraphics, l);
        }
    }

    private void drawSlotBackground(GuiGraphics guiGraphics, int x, int y) {
        int slotBorder = Theme.slotBorder();
        int slotFill = Theme.slotFill();
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, slotBorder);
        guiGraphics.fill(x, y, x + 16, y + 16, slotFill);
    }

    private void drawCraftingArrow(GuiGraphics guiGraphics, int x, int y) {
        int arrowColor = Theme.textOnPanel();
        guiGraphics.fill(x, y + 3, x + 12, y + 5, arrowColor);
        guiGraphics.fill(x + 12, y + 0, x + 12, y + 1, arrowColor);
        guiGraphics.fill(x + 12, y + 1, x + 13, y + 2, arrowColor);
        guiGraphics.fill(x + 12, y + 2, x + 14, y + 3, arrowColor);
        guiGraphics.fill(x + 12, y + 3, x + 15, y + 4, arrowColor);
        guiGraphics.fill(x + 12, y + 4, x + 15, y + 5, arrowColor);
        guiGraphics.fill(x + 12, y + 5, x + 14, y + 6, arrowColor);
        guiGraphics.fill(x + 12, y + 6, x + 13, y + 7, arrowColor);
        guiGraphics.fill(x + 12, y + 7, x + 12, y + 8, arrowColor);
    }

    private void drawTopBar(GuiGraphics g, int x, int y, int w) {
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x, y + 12 - 1, x + w, y + 12, Theme.titleBarBorder());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean hoveredPanel;
        boolean overCollapse;
        boolean handled;
        if (!this.isActive()) {
            return false;
        }
        if (button == 0 && this.showContextMenu && (handled = super.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        ItemStack shellStack = this.getshellStack();
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int craftingX = x + w - 24 - 6;
        int craftingY = y + 2;
        if (mouseX >= (double)craftingX && mouseX <= (double)(craftingX + 8) && mouseY >= (double)craftingY && mouseY <= (double)(craftingY + 8)) {
            if (Minecraft.getInstance().player != null) {
                boolean currentState = WidgetDataHelper.isAutoCrafterEnabled((Player)Minecraft.getInstance().player);
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleAutoCrafterPacket(!currentState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        if (this.showRecipeManagementDialog && this.handleRecipeDialogClick(mouseX, mouseY, button)) {
            return true;
        }
        if (Minecraft.getInstance().player != null && WidgetDataHelper.isAutoCrafterUnlocked((Player)Minecraft.getInstance().player)) {
            boolean overToggle;
            boolean overManage;
            boolean overSave;
            Layout l = this.computeLayout(x, y, this.getCurrentTier());
            int buttonY = l.arrowY - 22;
            int buttonSize = 12;
            int buttonSpacing = 2;
            int totalWidth = buttonSize * 3 + buttonSpacing * 2;
            int startX = l.arrowX - 1;
            int saveX = startX;
            boolean bl = overSave = mouseX >= (double)saveX && mouseX <= (double)(saveX + buttonSize) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonSize);
            if (overSave && button == 0) {
                this.saveCurrentRecipe();
                return true;
            }
            int manageX = startX + buttonSize + buttonSpacing;
            boolean bl2 = overManage = mouseX >= (double)manageX && mouseX <= (double)(manageX + buttonSize) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonSize);
            if (overManage && button == 0) {
                this.showRecipeManagementDialog = true;
                return true;
            }
            int toggleX = startX + (buttonSize + buttonSpacing) * 2;
            boolean bl3 = overToggle = mouseX >= (double)toggleX && mouseX <= (double)(toggleX + buttonSize) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonSize);
            if (overToggle && button == 0) {
                boolean newVal = !WidgetDataHelper.isAutoCrafterEnabled((Player)Minecraft.getInstance().player);
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleAutoCrafterPacket(newVal), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        int pinX = x + w - 8 - 2;
        int pinY = y + 2;
        int collapseX = pinX - 8 - 2;
        int collapseY = pinY;
        boolean bl = overCollapse = mouseX >= (double)collapseX && mouseX <= (double)(collapseX + 8) && mouseY >= (double)collapseY && mouseY <= (double)(collapseY + 8);
        if (overCollapse && button == 0) {
            this.toggleCollapsed();
            return true;
        }
        if (this.collapsed && this.isCompactActive()) {
            boolean inside;
            boolean bl4 = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
            if (inside && button == 0) {
                OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE);
                this.tempExpanded = true;
                return true;
            }
        }
        WidgetUnlockSystem.WidgetTier currentTier = this.getCurrentTier();
        Layout l = this.computeLayout(x, y, currentTier);
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE) && mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE);
        }
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        boolean bl5 = hoveredPanel = mouseX >= (double)x && mouseX <= (double)(x + l.panelW) && mouseY >= (double)y && mouseY <= (double)(y + l.panelH);
        if (this.logoMode && hoveredPanel) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE);
            return true;
        }
        int slotUnderMouse = this.findGridSlotIndexUnderMouse(mouseX, mouseY, l, currentTier);
        if (button == 0 && slotUnderMouse != -1) {
            long now = System.currentTimeMillis();
            if (this.lastClickedSlot == slotUnderMouse && now - this.lastClickTimeMs <= 250L) {
                this.handleDoubleClickCollect(slotUnderMouse);
                this.lastClickTimeMs = 0L;
                this.lastClickedSlot = -1;
                return true;
            }
            this.lastClickTimeMs = now;
            this.lastClickedSlot = slotUnderMouse;
        } else {
            this.lastClickedSlot = -1;
        }
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int slotIndex = row * 3 + col;
                    int slotX = l.gridStartX + col * 18;
                    int slotY = l.gridStartY + row * 18;
                    if (!this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) continue;
                    boolean shiftDown = Screen.hasShiftDown();
                    if (button == 0 && this.isCarryingItem() && !shiftDown) {
                        this.startPainting(button, slotIndex);
                        this.leftSplitMode = true;
                        return true;
                    }
                    this.handleGridSlotClick(slotIndex, button, shiftDown);
                    if (this.isCarryingItem() && (button == 1 || button == 0 && shiftDown)) {
                        this.startPainting(button, slotIndex);
                        if (button == 0) {
                            this.leftInitialApplied = true;
                        }
                        this.leftSplitMode = false;
                    }
                    return true;
                }
            }
            if (this.isMouseOverSlot(mouseX, mouseY, l.resultX, l.resultY)) {
                this.handleResultSlotClick(button, Screen.hasShiftDown());
                return true;
            }
        } else {
            int[] slotMapping = new int[]{0, 1, 3, 4};
            for (int i = 0; i < 4; ++i) {
                int row = i / 2;
                int col = i % 2;
                int slotIndex = slotMapping[i];
                int slotX = l.gridStartX + col * 18;
                int slotY = l.gridStartY + row * 18;
                if (!this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) continue;
                boolean shiftDown = Screen.hasShiftDown();
                if (button == 0 && this.isCarryingItem() && !shiftDown) {
                    this.startPainting(button, slotIndex);
                    this.leftSplitMode = true;
                    return true;
                }
                this.handleGridSlotClick(slotIndex, button, shiftDown);
                if (this.isCarryingItem() && (button == 1 || button == 0 && shiftDown)) {
                    this.startPainting(button, slotIndex);
                    if (button == 0) {
                        this.leftInitialApplied = true;
                    }
                    this.leftSplitMode = false;
                }
                return true;
            }
            if (this.isMouseOverSlot(mouseX, mouseY, l.resultX, l.resultY)) {
                this.handleResultSlotClick(button, Screen.hasShiftDown());
                return true;
            }
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isMouseOverSlot(double mouseX, double mouseY, int slotX, int slotY) {
        return mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        List<AutoCraftRecipe> recipes;
        if (this.showRecipeManagementDialog && this.isDraggingRecipeScroll && button == 0 && Minecraft.getInstance().player != null && (recipes = WidgetDataHelper.getAutoCrafterRecipes((Player)Minecraft.getInstance().player)).size() > this.maxVisibleRecipes) {
            int scrollbarX = this.recipeDialogX + this.recipeDialogW - 12;
            int scrollbarY = this.recipeListStartY;
            int scrollbarHeight = this.maxVisibleRecipes * this.recipeItemHeight - 4;
            int relativeY = (int)(mouseY - (double)scrollbarY);
            int maxScroll = recipes.size() - this.maxVisibleRecipes;
            int newScroll = relativeY * maxScroll / scrollbarHeight;
            this.recipeScrollOffset = Math.max(0, Math.min(newScroll, maxScroll));
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            if (this.paintingActive && (this.paintingButton == 0 || this.paintingButton == 1) && this.isCarryingItem()) {
                WidgetUnlockSystem.WidgetTier tier = this.getCurrentTier();
                Layout l = this.computeLayout(x, y, tier);
                int slot = this.findGridSlotIndexUnderMouse(mouseX, mouseY, l, tier);
                if (slot != -1 && !this.visitedSlots.contains(slot)) {
                    boolean shiftDown = Screen.hasShiftDown();
                    if (this.paintingButton == 0 && !shiftDown) {
                        this.visitedSlots.add(slot);
                        this.leftSplitMode = true;
                    } else {
                        this.paintOntoSlot(slot);
                        this.visitedSlots.add(slot);
                        this.leftSplitMode = false;
                    }
                }
                return true;
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.showRecipeManagementDialog && this.isDraggingRecipeScroll) {
            this.isDraggingRecipeScroll = false;
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            boolean shiftDown;
            if (this.paintingActive && this.paintingButton == 0 && this.isCarryingItem() && this.paintingFirstSlot != -1 && !(shiftDown = Screen.hasShiftDown())) {
                if (this.visitedSlots.size() <= 1) {
                    Minecraft mc = Minecraft.getInstance();
                    if (mc.player != null) {
                        ItemStack carried = mc.player.containerMenu.getCarried();
                        if (!carried.isEmpty()) {
                            ItemStack ghost;
                            ItemStack base;
                            ItemStack itemStack = base = this.paintingFirstSlot >= 0 && this.paintingFirstSlot < this.craftingGrid.size() ? this.craftingGrid.get(this.paintingFirstSlot) : ItemStack.EMPTY;
                            if (base.isEmpty()) {
                                ghost = carried.copy();
                                ghost.setCount(Math.min(ghost.getCount(), ghost.getMaxStackSize()));
                            } else if (ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)carried)) {
                                ghost = base.copy();
                                int max = Math.min(base.getMaxStackSize(), carried.getMaxStackSize());
                                ghost.setCount(Math.min(max, base.getCount() + carried.getCount()));
                            } else {
                                ghost = carried.copy();
                                ghost.setCount(Math.min(ghost.getCount(), ghost.getMaxStackSize()));
                            }
                            this.setTransientPreview(this.paintingFirstSlot, ghost, 200L);
                        }
                        PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.PUT_ITEM, this.paintingFirstSlot, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    this.lastPreview = this.computeLeftDragPreview();
                    this.lastPreviewUntilMs = System.currentTimeMillis() + 200L;
                    this.distributeLeftDragAcrossVisited();
                }
            }
            this.stopPainting();
            return true;
        }
        this.stopPainting();
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        List<AutoCraftRecipe> recipes;
        if (this.showRecipeManagementDialog && Minecraft.getInstance().player != null && (recipes = WidgetDataHelper.getAutoCrafterRecipes((Player)Minecraft.getInstance().player)).size() > this.maxVisibleRecipes) {
            int delta = scrollY > 0.0 ? -1 : 1;
            int maxScroll = recipes.size() - this.maxVisibleRecipes;
            this.recipeScrollOffset = Math.max(0, Math.min(this.recipeScrollOffset + delta, maxScroll));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private void distributeLeftDragAcrossVisited() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack carried = mc.player.containerMenu.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        ArrayList<Integer> order = new ArrayList<Integer>(this.visitedSlots);
        if (order.isEmpty() || (Integer)order.get(0) != this.paintingFirstSlot) {
            order.remove((Object)this.paintingFirstSlot);
            order.add(0, this.paintingFirstSlot);
        }
        int maxPerStack = carried.getMaxStackSize();
        ArrayList<Integer> eligible = new ArrayList<Integer>();
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            ItemStack inSlot;
            int idx = (Integer)iterator.next();
            if (idx < 0 || idx >= this.craftingGrid.size() || !(inSlot = this.craftingGrid.get(idx)).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)inSlot, (ItemStack)carried) || inSlot.getCount() >= maxPerStack)) continue;
            eligible.add(idx);
        }
        if (eligible.isEmpty()) {
            return;
        }
        int totalSlots = eligible.size();
        int totalItems = carried.getCount();
        int itemsPerSlot = totalItems / totalSlots;
        if (itemsPerSlot > 0) {
            Iterator iterator2 = eligible.iterator();
            while (iterator2.hasNext()) {
                int idx = (Integer)iterator2.next();
                ItemStack inSlot = this.craftingGrid.get(idx);
                int currentCount = inSlot.isEmpty() ? 0 : inSlot.getCount();
                int targetCount = Math.min(currentCount + itemsPerSlot, maxPerStack);
                int itemsToAdd = targetCount - currentCount;
                for (int i = 0; i < itemsToAdd; ++i) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.PUT_ONE, idx, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    private Map<Integer, ItemStack> computeLeftDragPreview() {
        Minecraft mc = Minecraft.getInstance();
        HashMap<Integer, ItemStack> out = new HashMap<Integer, ItemStack>();
        if (mc.player == null) {
            return out;
        }
        ItemStack carried = this.paintingCarriedItem;
        if (carried.isEmpty()) {
            return out;
        }
        ArrayList<Integer> order = new ArrayList<Integer>(this.visitedSlots);
        if (order.isEmpty()) {
            return out;
        }
        if ((Integer)order.get(0) != this.paintingFirstSlot) {
            order.remove((Object)this.paintingFirstSlot);
            order.add(0, this.paintingFirstSlot);
        }
        int maxPerStack = carried.getMaxStackSize();
        ArrayList<Integer> eligible = new ArrayList<Integer>();
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            ItemStack s;
            int idx = (Integer)iterator.next();
            if (idx < 0 || idx >= this.craftingGrid.size() || !(s = this.craftingGrid.get(idx)).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)carried) || s.getCount() >= maxPerStack)) continue;
            eligible.add(idx);
        }
        if (eligible.isEmpty()) {
            return out;
        }
        int totalSlots = eligible.size();
        int totalItems = carried.getCount();
        int itemsPerSlot = totalItems / totalSlots;
        if (itemsPerSlot > 0) {
            Iterator iterator2 = eligible.iterator();
            while (iterator2.hasNext()) {
                int newCount;
                int idx = (Integer)iterator2.next();
                ItemStack base = this.craftingGrid.get(idx);
                int targetCount = itemsPerSlot;
                if (base.isEmpty()) {
                    ItemStack ghost = carried.copy();
                    ghost.setCount(targetCount);
                    out.put(idx, ghost);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)carried) || (newCount = Math.min(base.getCount() + targetCount, maxPerStack)) <= base.getCount()) continue;
                ItemStack ghost = base.copy();
                ghost.setCount(newCount);
                out.put(idx, ghost);
            }
        }
        return out;
    }

    private Map<Integer, ItemStack> computeRightDragPreview() {
        Minecraft mc = Minecraft.getInstance();
        HashMap<Integer, ItemStack> out = new HashMap<Integer, ItemStack>();
        if (mc.player == null) {
            return out;
        }
        ItemStack carried = this.paintingCarriedItem;
        if (carried.isEmpty()) {
            return out;
        }
        int remainingItems = carried.getCount();
        Iterator iterator = this.visitedSlots.iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            if (slotIndex < 0 || slotIndex >= this.craftingGrid.size() || remainingItems <= 0) continue;
            ItemStack base = this.craftingGrid.get(slotIndex);
            ItemStack ghost = ItemStack.EMPTY;
            if (base.isEmpty()) {
                ghost = carried.copy();
                ghost.setCount(1);
                --remainingItems;
            } else if (ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)carried) && base.getCount() < base.getMaxStackSize()) {
                ghost = base.copy();
                ghost.setCount(base.getCount() + 1);
                --remainingItems;
            }
            if (ghost.isEmpty()) continue;
            out.put(slotIndex, ghost);
        }
        return out;
    }

    private void startPainting(int button, int firstSlot) {
        this.paintingActive = true;
        this.paintingButton = button;
        this.visitedSlots.clear();
        this.visitedSlots.add(firstSlot);
        this.paintingFirstSlot = firstSlot;
        this.leftInitialApplied = button != 0;
        Minecraft mc = Minecraft.getInstance();
        this.paintingCarriedItem = mc.player != null ? mc.player.containerMenu.getCarried().copy() : ItemStack.EMPTY;
    }

    private void stopPainting() {
        this.paintingActive = false;
        this.paintingButton = -1;
        this.visitedSlots.clear();
        this.paintingFirstSlot = -1;
        this.leftInitialApplied = false;
        this.leftSplitMode = false;
        this.paintingCarriedItem = ItemStack.EMPTY;
    }

    private void setTransientPreview(int slotIndex, ItemStack ghost, long durationMs) {
        if (slotIndex < 0 || slotIndex >= 9) {
            return;
        }
        if (ghost == null || ghost.isEmpty()) {
            return;
        }
        HashMap<Integer, ItemStack> np = new HashMap<Integer, ItemStack>(this.lastPreview);
        np.put(slotIndex, ghost);
        this.lastPreview = np;
        this.lastPreviewUntilMs = System.currentTimeMillis() + Math.max(50L, durationMs);
    }

    private boolean isCarryingItem() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        return this.paintingActive ? !this.paintingCarriedItem.isEmpty() : !mc.player.containerMenu.getCarried().isEmpty();
    }

    private int findGridSlotIndexUnderMouse(double mouseX, double mouseY, Layout l, WidgetUnlockSystem.WidgetTier tier) {
        if (tier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int slotIndex = row * 3 + col;
                    int slotX = l.gridStartX + col * 18;
                    int slotY = l.gridStartY + row * 18;
                    if (!this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) continue;
                    return slotIndex;
                }
            }
        } else {
            int[] map = new int[]{0, 1, 3, 4};
            for (int i = 0; i < 4; ++i) {
                int row = i / 2;
                int col = i % 2;
                int slotIndex = map[i];
                int slotX = l.gridStartX + col * 18;
                int slotY = l.gridStartY + row * 18;
                if (!this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) continue;
                return slotIndex;
            }
        }
        return -1;
    }

    private void paintOntoSlot(int slotIndex) {
        if (!this.isCarryingItem()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.PUT_ONE, slotIndex, Minecraft.getInstance().player != null ? Minecraft.getInstance().player.containerMenu.getCarried() : ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void handleDoubleClickCollect(int originSlot) {
        ItemStack target;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack carried = mc.player.containerMenu.getCarried();
        ItemStack origin = ItemStack.EMPTY;
        List<ItemStack> grid = this.craftingGrid;
        if (originSlot >= 0 && originSlot < grid.size()) {
            origin = grid.get(originSlot);
        }
        ItemStack itemStack = target = !carried.isEmpty() ? carried : origin;
        if (target.isEmpty()) {
            return;
        }
        for (int i = 0; i < Math.min(9, grid.size()); ++i) {
            ItemStack s = grid.get(i);
            if (s.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)target)) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.TAKE_ITEM, i, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void handleGridSlotClick(int slotIndex, int button, boolean isShiftDown) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack carried = mc.player.containerMenu.getCarried();
        if (button == 0) {
            if (!carried.isEmpty() && !isShiftDown && this.paintingActive && this.paintingButton == 0 && slotIndex == this.paintingFirstSlot) {
                return;
            }
            if (!carried.isEmpty()) {
                if (isShiftDown) {
                    ItemStack base = slotIndex >= 0 && slotIndex < this.craftingGrid.size() ? this.craftingGrid.get(slotIndex) : ItemStack.EMPTY;
                    ItemStack ghost = ItemStack.EMPTY;
                    if (base.isEmpty()) {
                        ghost = carried.copy();
                        ghost.setCount(1);
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)carried) && base.getCount() < base.getMaxStackSize()) {
                        ghost = base.copy();
                        ghost.setCount(base.getCount() + 1);
                    }
                    if (!ghost.isEmpty()) {
                        this.setTransientPreview(slotIndex, ghost, 150L);
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.PUT_ONE, slotIndex, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    ItemStack ghost;
                    ItemStack base;
                    ItemStack itemStack = base = slotIndex >= 0 && slotIndex < this.craftingGrid.size() ? this.craftingGrid.get(slotIndex) : ItemStack.EMPTY;
                    if (base.isEmpty()) {
                        ghost = carried.copy();
                        ghost.setCount(Math.min(ghost.getCount(), ghost.getMaxStackSize()));
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)carried)) {
                        ghost = base.copy();
                        int max = Math.min(base.getMaxStackSize(), carried.getMaxStackSize());
                        ghost.setCount(Math.min(max, base.getCount() + carried.getCount()));
                    } else {
                        ghost = carried.copy();
                        ghost.setCount(Math.min(ghost.getCount(), ghost.getMaxStackSize()));
                    }
                    this.setTransientPreview(slotIndex, ghost, 200L);
                    PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.PUT_ITEM, slotIndex, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (isShiftDown) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.CRAFTING_TABLE, MoveItemToShellPacket.SlotType.GRID, slotIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.TAKE_ITEM, slotIndex, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (button == 1) {
            if (carried.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.TAKE_HALF, slotIndex, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                ItemStack base = slotIndex >= 0 && slotIndex < this.craftingGrid.size() ? this.craftingGrid.get(slotIndex) : ItemStack.EMPTY;
                ItemStack ghost = ItemStack.EMPTY;
                if (base.isEmpty()) {
                    ghost = carried.copy();
                    ghost.setCount(1);
                } else if (ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)carried) && base.getCount() < base.getMaxStackSize()) {
                    ghost = base.copy();
                    ghost.setCount(base.getCount() + 1);
                }
                if (!ghost.isEmpty()) {
                    this.setTransientPreview(slotIndex, ghost, 150L);
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.GRID, CraftingTableSlotInteractionPacket.ActionType.PUT_ONE, slotIndex, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)1.0f));
    }

    private void handleResultSlotClick(int button, boolean isShiftDown) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (button == 0) {
            if (isShiftDown) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.CRAFTING_TABLE, MoveItemToShellPacket.SlotType.RESULT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new CraftingTableSlotInteractionPacket(CraftingTableSlotInteractionPacket.SlotType.RESULT, CraftingTableSlotInteractionPacket.ActionType.TAKE_ITEM, 0, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)1.0f));
        }
    }

    public void tick() {
        if (!this.isUnlocked()) {
            return;
        }
        if (!this.paintingActive) {
            this.syncFromshellData();
        }
        if (this.isCompactActive()) {
            this.width = 36;
            this.height = 36;
        } else {
            WidgetUnlockSystem.WidgetTier currentTier = this.getCurrentTier();
            this.width = this.computePanelWidth(currentTier);
            this.height = this.computePanelHeight(currentTier);
        }
    }

    private void syncFromshellData() {
        long now = System.currentTimeMillis();
        if (now < this.nextSyncAllowedAtMs) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            List<ItemStack> newGrid = this.loadGridFromshell();
            ItemStack newResult = this.loadResultFromshell();
            boolean gridChanged = false;
            if (!(this.craftingGrid instanceof ArrayList)) {
                this.craftingGrid = new ArrayList<ItemStack>(this.craftingGrid);
            }
            while (this.craftingGrid.size() < 9) {
                this.craftingGrid.add(ItemStack.EMPTY);
            }
            int limit = Math.min(9, newGrid.size());
            for (int i = 0; i < limit; ++i) {
                ItemStack ghost;
                ItemStack newS;
                ItemStack oldS = this.craftingGrid.get(i);
                if (CraftingTableWidget.itemStacksEqual(oldS, newS = newGrid.get(i))) continue;
                this.craftingGrid.set(i, newS);
                gridChanged = true;
                if (this.lastPreview.isEmpty() || (ghost = this.lastPreview.getOrDefault(i, ItemStack.EMPTY)).isEmpty() || !CraftingTableWidget.itemStacksEqual(newS, ghost)) continue;
                HashMap<Integer, ItemStack> np = new HashMap<Integer, ItemStack>(this.lastPreview);
                np.remove(i);
                this.lastPreview = np;
                if (!this.lastPreview.isEmpty()) continue;
                this.lastPreviewUntilMs = 0L;
            }
            if (!CraftingTableWidget.itemStacksEqual(this.resultItem, newResult)) {
                this.resultItem = newResult;
            }
        }
        this.nextSyncAllowedAtMs = now + 75L;
    }

    private static boolean itemStacksEqual(ItemStack a, ItemStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) && a.getCount() == b.getCount();
    }

    @Override
    protected void stopDragging() {
        super.stopDragging();
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    public int getCurrentWidth() {
        if (this.isCompactActive()) {
            return 36;
        }
        WidgetUnlockSystem.WidgetTier currentTier = this.getCurrentTier();
        return this.computePanelWidth(currentTier);
    }

    public int getCurrentHeight() {
        if (this.isCompactActive()) {
            return 36;
        }
        WidgetUnlockSystem.WidgetTier currentTier = this.getCurrentTier();
        return this.computePanelHeight(currentTier);
    }

    public int getWidth() {
        return this.getCurrentWidth();
    }

    public int getHeight() {
        return this.getCurrentHeight();
    }

    private static List<ItemStack> getEmptyGrid() {
        return Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    private Layout computeLayout(int x, int y, WidgetUnlockSystem.WidgetTier tier) {
        Layout l = new Layout();
        l.panelX = x;
        l.panelY = y;
        int cols = tier == WidgetUnlockSystem.WidgetTier.TIER_II ? 3 : 2;
        int rows = tier == WidgetUnlockSystem.WidgetTier.TIER_II ? 3 : 2;
        int gridW = cols * 16 + (cols - 1) * 2;
        int gridH = rows * 16 + (rows - 1) * 2;
        l.panelW = 6 + gridW + 8 + 18 + 8 + 16 + 6;
        l.panelH = 18 + gridH + 6;
        l.gridStartX = x + 6;
        l.gridStartY = y + 12 + 6;
        int gridCenterY = l.gridStartY + gridH / 2;
        l.arrowX = l.gridStartX + gridW + 8;
        l.arrowY = gridCenterY - 4;
        l.resultX = l.arrowX + 18 + 8;
        l.resultY = gridCenterY - 8;
        return l;
    }

    private int computePanelWidth(WidgetUnlockSystem.WidgetTier tier) {
        int cols = tier == WidgetUnlockSystem.WidgetTier.TIER_II ? 3 : 2;
        int gridW = cols * 16 + (cols - 1) * 2;
        return 6 + gridW + 8 + 18 + 8 + 16 + 6;
    }

    private int computePanelHeight(WidgetUnlockSystem.WidgetTier tier) {
        int rows = tier == WidgetUnlockSystem.WidgetTier.TIER_II ? 3 : 2;
        int gridH = rows * 16 + (rows - 1) * 2;
        return 18 + gridH + 6;
    }

    private void saveCurrentRecipe() {
        CraftingInput recipeInput;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ArrayList<ItemStack> grid = new ArrayList<ItemStack>(this.craftingGrid);
        while (grid.size() < 9) {
            grid.add(ItemStack.EMPTY);
        }
        Level level = mc.player.level();
        RecipeManager recipeManager = level.getRecipeManager();
        Optional opt = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)(recipeInput = CraftingInput.of((int)3, (int)3, grid)), level);
        if (opt.isEmpty()) {
            return;
        }
        RecipeHolder holder = (RecipeHolder)opt.get();
        CraftingRecipe recipe = (CraftingRecipe)holder.value();
        List<ItemStackData> templateData = grid.stream().map(stack -> stack.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(stack)).collect(Collectors.toList());
        ItemStack result = recipe.assemble((RecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess());
        String displayName = result.getHoverName().getString();
        AutoCraftRecipe autoRecipe = new AutoCraftRecipe(templateData, ItemStackData.of(result), holder.id(), displayName);
        List<AutoCraftRecipe> existingRecipes = WidgetDataHelper.getAutoCrafterRecipes((Player)mc.player);
        for (AutoCraftRecipe existing : existingRecipes) {
            if (!existing.recipeId().equals((Object)holder.id())) continue;
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new AddAutoCrafterRecipePacket(autoRecipe), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private boolean handleRecipeDialogClick(double mouseX, double mouseY, int button) {
        List<AutoCraftRecipe> recipes;
        if (button != 0) {
            return false;
        }
        int closeX = this.recipeDialogX + this.recipeDialogW - 20;
        int closeY = this.recipeDialogY + 4;
        if (mouseX >= (double)closeX && mouseX <= (double)(closeX + 16) && mouseY >= (double)closeY && mouseY <= (double)(closeY + 12)) {
            this.showRecipeManagementDialog = false;
            return true;
        }
        if (Minecraft.getInstance().player != null && (recipes = WidgetDataHelper.getAutoCrafterRecipes((Player)Minecraft.getInstance().player)).size() > this.maxVisibleRecipes) {
            int scrollbarX = this.recipeDialogX + this.recipeDialogW - 12;
            int scrollbarY = this.recipeListStartY;
            int scrollbarHeight = this.maxVisibleRecipes * this.recipeItemHeight - 4;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 8) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                this.isDraggingRecipeScroll = true;
                return true;
            }
        }
        if (Minecraft.getInstance().player != null) {
            recipes = WidgetDataHelper.getAutoCrafterRecipes((Player)Minecraft.getInstance().player);
            int startIndex = this.recipeScrollOffset;
            int endIndex = Math.min(startIndex + this.maxVisibleRecipes, recipes.size());
            for (int i = startIndex; i < endIndex; ++i) {
                int itemY = this.recipeListStartY + (i - startIndex) * this.recipeItemHeight;
                int removeX = this.recipeDialogX + this.recipeDialogW - (recipes.size() > this.maxVisibleRecipes ? 30 : 25);
                if (!(mouseX >= (double)removeX) || !(mouseX <= (double)(removeX + 16)) || !(mouseY >= (double)(itemY + 2)) || !(mouseY <= (double)(itemY + 14))) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new RemoveAutoCrafterRecipePacket(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return false;
    }

    private void drawRecipeManagementDialog(GuiGraphics g, Layout l) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        this.recipeDialogX = l.arrowX - 50;
        this.recipeDialogY = l.arrowY - 40;
        this.recipeListStartY = this.recipeDialogY + 20;
        g.fill(this.recipeDialogX, this.recipeDialogY, this.recipeDialogX + this.recipeDialogW, this.recipeDialogY + this.recipeDialogH, -13816531);
        g.fill(this.recipeDialogX + 1, this.recipeDialogY + 1, this.recipeDialogX + this.recipeDialogW - 1, this.recipeDialogY + this.recipeDialogH - 1, -12566464);
        g.drawString(this.font, Component.translatable((String)"nomadsshell.crafting.auto_recipes").getString(), this.recipeDialogX + 8, this.recipeDialogY + 6, 0xFFFFFF);
        int closeX = this.recipeDialogX + this.recipeDialogW - 20;
        int closeY = this.recipeDialogY + 4;
        g.fill(closeX, closeY, closeX + 16, closeY + 12, -10066330);
        g.drawString(this.font, Component.translatable((String)"nomadsshell.ui.close").getString(), closeX + 4, closeY + 2, 0xFFFFFF);
        List<AutoCraftRecipe> recipes = WidgetDataHelper.getAutoCrafterRecipes((Player)Minecraft.getInstance().player);
        int maxScroll = Math.max(0, recipes.size() - this.maxVisibleRecipes);
        this.recipeScrollOffset = Math.max(0, Math.min(this.recipeScrollOffset, maxScroll));
        if (recipes.size() > this.maxVisibleRecipes) {
            int scrollbarX = this.recipeDialogX + this.recipeDialogW - 12;
            int scrollbarY = this.recipeListStartY;
            int scrollbarHeight = this.maxVisibleRecipes * this.recipeItemHeight - 4;
            g.fill(scrollbarX, scrollbarY, scrollbarX + 8, scrollbarY + scrollbarHeight, -10066330);
            int thumbHeight = Math.max(8, scrollbarHeight * this.maxVisibleRecipes / recipes.size());
            int thumbY = scrollbarY + (scrollbarHeight - thumbHeight) * this.recipeScrollOffset / maxScroll;
            g.fill(scrollbarX + 1, thumbY, scrollbarX + 7, thumbY + thumbHeight, -6710887);
        }
        int startIndex = this.recipeScrollOffset;
        int endIndex = Math.min(startIndex + this.maxVisibleRecipes, recipes.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Object name;
            AutoCraftRecipe recipe = recipes.get(i);
            int itemY = this.recipeListStartY + (i - startIndex) * this.recipeItemHeight;
            g.fill(this.recipeDialogX + 8, itemY, this.recipeDialogX + this.recipeDialogW - (recipes.size() > this.maxVisibleRecipes ? 20 : 8), itemY + this.recipeItemHeight - 2, -11184811);
            ItemStack resultStack = recipe.resultItem().toItemStack();
            if (!resultStack.isEmpty()) {
                g.renderItem(resultStack, this.recipeDialogX + 10, itemY + 2);
            }
            if (((String)(name = recipe.getDisplayName())).length() > 20) {
                name = ((String)name).substring(0, 17) + "...";
            }
            g.drawString(this.font, (String)name, this.recipeDialogX + 30, itemY + 6, 0xFFFFFF);
            int removeX = this.recipeDialogX + this.recipeDialogW - (recipes.size() > this.maxVisibleRecipes ? 30 : 25);
            g.fill(removeX, itemY + 2, removeX + 16, itemY + 14, -7667712);
            g.drawString(this.font, Component.translatable((String)"nomadsshell.ui.remove").getString(), removeX + 5, itemY + 4, 0xFFFFFF);
        }
        if (recipes.isEmpty()) {
            g.drawString(this.font, Component.translatable((String)"nomadsshell.crafting.no_recipes").getString(), this.recipeDialogX + 8, this.recipeListStartY + 10, -7829368);
        }
    }

    private boolean isCompactActive() {
        boolean idle;
        if (!this.collapsed) {
            return false;
        }
        boolean bl = idle = (Boolean)OverlayConfig.CRAFTING_TABLE_USE_IMAGE_MODE.get() != false && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE);
        return !this.tempExpanded || idle;
    }

    private void toggleCollapsed() {
        this.collapsed = !this.collapsed;
        OverlayConfig.CRAFTING_TABLE_COLLAPSED.set((Object)this.collapsed);
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        super.renderControlButtons(guiGraphics, mouseX, mouseY, currentWidth, currentHeight);
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int craftingX = x + currentWidth - 24 - 6;
        int craftingY = y + 2;
        boolean craftingHovered = mouseX >= craftingX && mouseX <= craftingX + 8 && mouseY >= craftingY && mouseY <= craftingY + 8;
        boolean autocraftEnabled = Minecraft.getInstance().player != null && WidgetDataHelper.isAutoCrafterEnabled((Player)Minecraft.getInstance().player);
        int n = buttonColor = autocraftEnabled ? -11751600 : -769226;
        if (craftingHovered) {
            buttonColor = autocraftEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(craftingX, craftingY, craftingX + 8, craftingY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        int collapseX = pinX - 8 - 2;
        int collapseY = pinY;
        boolean hovered = mouseX >= collapseX && mouseX <= collapseX + 8 && mouseY >= collapseY && mouseY <= collapseY + 8;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.fill(collapseX, collapseY, collapseX + 8, collapseY + 8, Theme.buttonBg(hovered));
        ResourceLocation icon = Theme.icon(this.collapsed ? "expand" : "collapse");
        try {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)collapseX, (float)collapseY, 0.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            guiGraphics.blit(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
        }
        catch (Throwable t) {
            int fg = Theme.isLight() ? -16777216 : -1;
            guiGraphics.fill(collapseX + 2, collapseY + 2, collapseX + 8 - 2, collapseY + 8 - 2, fg);
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
    }

    @Override
    protected void drawWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.contentBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + currentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.contentBg());
    }

    public int getCursorCountOverride() {
        if (!(this.paintingActive && this.leftSplitMode && this.isCarryingItem())) {
            return -1;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return -1;
        }
        ItemStack carried = mc.player.containerMenu.getCarried();
        if (carried.isEmpty()) {
            return -1;
        }
        ArrayList<Integer> order = new ArrayList<Integer>(this.visitedSlots);
        if (order.isEmpty()) {
            return -1;
        }
        ArrayList<Integer> eligible = new ArrayList<Integer>();
        Iterator iterator = order.iterator();
        while (iterator.hasNext()) {
            ItemStack s;
            int idx = (Integer)iterator.next();
            if (idx < 0 || idx >= this.craftingGrid.size() || !(s = this.craftingGrid.get(idx)).isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)carried) || s.getCount() >= carried.getMaxStackSize())) continue;
            eligible.add(idx);
        }
        if (eligible.isEmpty()) {
            return -1;
        }
        int totalSlots = eligible.size();
        int totalItems = carried.getCount();
        int remainder = totalItems % totalSlots;
        return remainder;
    }

    private static class Layout {
        int panelX;
        int panelY;
        int panelW;
        int panelH;
        int gridStartX;
        int gridStartY;
        int arrowX;
        int arrowY;
        int resultX;
        int resultY;

        private Layout() {
        }
    }
}

