/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.DripstoneFarmActionPacket;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.network.PacketDistributor;

public class DripstoneFarmWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int DEFAULT_WIDTH = 168;
    private static final int DEFAULT_HEIGHT = 110;
    private boolean logoMode = false;
    private int pendingForceIndex = -1;
    private int warningTimer = 0;
    private static final int WARNING_TIMEOUT_TICKS = 60;
    private int pendingTakeSourceIndex = -1;
    private int takeSourceWarningTimer = 0;
    private static final int TAKE_SOURCE_WARNING_TIMEOUT_TICKS = 60;

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.DRIPSTONE_X.get();
        return cx != 0 ? cx : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.DRIPSTONE_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    public DripstoneFarmWidget(int x, int y, Font font, IShellMenu menu) {
        super(DripstoneFarmWidget.loadPositionX(x), DripstoneFarmWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.dripstone_farm"), font, WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, menu);
        this.width = 168;
        this.height = 110;
        this.isPinned = (Boolean)OverlayConfig.DRIPSTONE_PINNED.get();
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        try {
            OverlayConfig.DRIPSTONE_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.DRIPSTONE_X.set((Object)this.getX());
            OverlayConfig.DRIPSTONE_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        try {
            guiGraphics.blit(Theme.icon("drip"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        catch (Throwable t) {
            this.drawDripstoneIcon(guiGraphics, iconX, iconY, iconSize, iconSize);
        }
    }

    private void drawDripstoneIcon(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int dripstoneColor = -7638187;
        guiGraphics.fill(x + 6, y + 2, x + width - 6, y + height - 2, dripstoneColor);
        guiGraphics.fill(x + 7, y + 1, x + width - 7, y + 3, dripstoneColor);
        guiGraphics.fill(x + 8, y, x + width - 8, y + 2, dripstoneColor);
        int dripColor = -10575134;
        guiGraphics.fill(x + 7, y + height - 4, x + 8, y + height - 2, dripColor);
        guiGraphics.fill(x + 6, y + height - 3, x + 9, y + height - 1, dripColor);
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.get();
        OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void renderExpandedContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int i;
        int baseY;
        int baseX;
        int totalH;
        int lh;
        int maxTextW;
        boolean hoveredWidget;
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean imageEnabled = (Boolean)OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, w, h - 12);
            return;
        }
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x, y + 12 - 1, x + w, y + 12, Theme.titleBarBorder());
        int contentX = x + 4;
        int contentY = y + 12 + 1;
        int contentH = h - 12 - 2;
        g.fill(x, contentY, x + w, contentY + contentH, Theme.panelBg());
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int count = Math.max(0, Math.min(5, WidgetDataHelper.getDripCauldronCount((Player)player)));
        if (count <= 0) {
            g.drawString(this.font, Component.translatable((String)"nomadsshell.dripstone.unlock_cauldrons").getString(), contentX + 4, contentY + 6, Theme.textOnPanel());
            return;
        }
        int colW = 30;
        int gap = 6;
        int totalW = count * colW + (count - 1) * gap;
        int startX = contentX + (x + w - 4 - contentX - totalW) / 2;
        int topY = contentY + 8;
        int midY = topY + 26;
        int botY = midY + 26;
        for (int i2 = 0; i2 < count; ++i2) {
            boolean hasAutoTransfer;
            int col;
            FluidStackData src;
            int cx;
            block26: {
                cx = startX + i2 * (colW + gap);
                this.drawSlot(g, cx + 6, topY, mouseX, mouseY);
                src = WidgetDataHelper.getDripSourceFluidAt((Player)player, i2);
                if (!src.isEmpty()) {
                    int fluidBarW = 16;
                    int fluidBarH = 3;
                    int fluidBarX = cx + 7;
                    int fluidBarY = topY - 5;
                    int fluidColor = DripstoneFarmWidget.isLava(src) ? -1672674 : -10575134;
                    g.fill(fluidBarX, fluidBarY, fluidBarX + fluidBarW, fluidBarY + fluidBarH, fluidColor);
                    g.renderOutline(fluidBarX, fluidBarY, fluidBarW, fluidBarH, Theme.slotBorder());
                    int highlightColor = DripstoneFarmWidget.isLava(src) ? -19610 : -8665857;
                    g.fill(fluidBarX + 1, fluidBarY + 1, fluidBarX + fluidBarW - 1, fluidBarY + 2, highlightColor);
                    if (DripstoneFarmWidget.inside(fluidBarX, fluidBarY, fluidBarW, fluidBarH, mouseX, mouseY)) {
                        FluidStack display = new FluidStack(src.fluid(), Math.min(src.amount(), 1000));
                        String fluidName = display.getHoverName().getString();
                        this.drawTooltip(g, Component.translatable((String)"nomadsshell.dripstone.tooltip.source", (Object[])new Object[]{fluidName}).getString(), mouseX, mouseY);
                    }
                    int borderColor = DripstoneFarmWidget.isLava(src) ? -2132379106 : -2141281566;
                    g.renderOutline(cx + 5, topY - 1, 20, 20, borderColor);
                    try {
                        if (DripstoneFarmWidget.isLava(src)) {
                            ResourceLocation lavaTexture = ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"textures/gui/natural/lava.png");
                            g.blit(lavaTexture, cx + 7, topY + 1, 0.0f, 0.0f, 14, 14, 16, 16);
                            break block26;
                        }
                        ResourceLocation waterTexture = ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"textures/gui/natural/water.png");
                        g.blit(waterTexture, cx + 7, topY + 1, 0.0f, 0.0f, 14, 14, 16, 16);
                    }
                    catch (Exception e) {
                        if (DripstoneFarmWidget.isLava(src)) {
                            g.renderItem(new ItemStack((ItemLike)Items.LAVA_BUCKET), cx + 7, topY + 1);
                            break block26;
                        }
                        g.renderItem(new ItemStack((ItemLike)Items.WATER_BUCKET), cx + 7, topY + 1);
                    }
                } else {
                    int emptyBarW = 16;
                    int emptyBarH = 2;
                    int emptyBarX = cx + 7;
                    int emptyBarY = topY - 4;
                    g.fill(emptyBarX, emptyBarY, emptyBarX + emptyBarW, emptyBarY + emptyBarH, Theme.slotFill());
                    g.renderOutline(emptyBarX, emptyBarY, emptyBarW, emptyBarH, Theme.slotBorder());
                    if (DripstoneFarmWidget.inside(emptyBarX, emptyBarY, emptyBarW, emptyBarH, mouseX, mouseY)) {
                        this.drawTooltip(g, Component.translatable((String)"nomadsshell.dripstone.tooltip.no_source").getString(), mouseX, mouseY);
                    }
                }
            }
            g.renderItem(new ItemStack((ItemLike)Items.POINTED_DRIPSTONE), cx + 6, midY + 2);
            int mb = WidgetDataHelper.getDripCauldronMbAt((Player)player, i2);
            int pW = 18;
            int pH = 4;
            int pX = cx + 6;
            int pY = midY + 20;
            g.fill(pX, pY, pX + pW, pY + pH, Theme.slotFill());
            g.renderOutline(pX, pY, pW, pH, Theme.slotBorder());
            int filled = Math.min(pW - 2, Math.max(0, mb * (pW - 2) / 1000));
            int n = col = !src.isEmpty() && DripstoneFarmWidget.isLava(src) ? -1672674 : -10575134;
            if (filled > 0) {
                g.fill(pX + 1, pY + 1, pX + 1 + filled, pY + pH - 1, col);
            }
            this.drawSlot(g, cx + 6, botY, mouseX, mouseY);
            ItemStack bottom = WidgetDataHelper.getDripBottomItemAt((Player)player, i2);
            if (!bottom.isEmpty()) {
                g.renderItem(bottom, cx + 6, botY);
            }
            ItemStack shellStack = ShellItem.findWornshell((Player)player);
            int cauldronCount = WidgetDataHelper.getDripCauldronCount((Player)player);
            boolean bl2 = hasAutoTransfer = !shellStack.isEmpty() && WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack) == WidgetUnlockSystem.WidgetTier.TIER_II;
            if (hasAutoTransfer && cauldronCount >= 3) {
                int buttonY = botY + 20;
                int buttonW = 16;
                int buttonH = 12;
                int buttonX = cx + 8;
                int targetContainer = WidgetDataHelper.getDripTargetContainerAt((Player)player, i2);
                boolean isHovered = DripstoneFarmWidget.inside(buttonX, buttonY, buttonW, buttonH, mouseX, mouseY);
                int bgColor = Theme.buttonBg(isHovered);
                g.fill(buttonX, buttonY, buttonX + buttonW, buttonY + buttonH, bgColor);
                g.renderOutline(buttonX, buttonY, buttonW, buttonH, Theme.slotBorder());
                String buttonText = targetContainer == 0 ? "X" : String.valueOf(targetContainer);
                int textColor = Theme.textOnPanel();
                int textX = buttonX + (buttonW - this.font.width(buttonText)) / 2;
                Objects.requireNonNull(this.font);
                int textY = buttonY + (buttonH - 9) / 2 + 1;
                g.drawString(this.font, buttonText, textX, textY, textColor, false);
                if (DripstoneFarmWidget.inside(buttonX, buttonY, buttonW, buttonH, mouseX, mouseY)) {
                    int[] validTargets = WidgetDataHelper.getValidDripTargetContainers((Player)Minecraft.getInstance().player, i2);
                    Object tooltip = validTargets.length == 1 && validTargets[0] == 0 ? Component.translatable((String)"nomadsshell.dripstone.tooltip.auto_transfer_disabled").getString() : (targetContainer == 0 ? Component.translatable((String)"nomadsshell.dripstone.tooltip.enable_auto_transfer").getString() : Component.translatable((String)"nomadsshell.dripstone.tooltip.auto_transfer_cycle", (Object[])new Object[]{targetContainer}).getString());
                    if (validTargets.length > 1) {
                        ArrayList<String> availableTanks = new ArrayList<String>();
                        for (int j = 1; j < validTargets.length; ++j) {
                            availableTanks.add(String.valueOf(validTargets[j]));
                        }
                        if (!availableTanks.isEmpty()) {
                            tooltip = (String)tooltip + "\nAvailable tanks: " + String.join((CharSequence)", ", availableTanks);
                        }
                    }
                    this.drawTooltip(g, (String)tooltip, mouseX, mouseY);
                }
            }
            if (DripstoneFarmWidget.inside(cx + 6, topY, 18, 18, mouseX, mouseY)) {
                String tip;
                if (src.isEmpty()) {
                    tip = Component.translatable((String)"nomadsshell.ui.feed_filled_bucket").getString();
                } else {
                    FluidStack display = new FluidStack(src.fluid(), Math.min(src.amount(), 1000));
                    String fluidName = display.getHoverName().getString();
                    tip = Component.translatable((String)"nomadsshell.dripstone.tooltip.currently_dripping", (Object[])new Object[]{fluidName}).getString();
                }
                this.drawTooltip(g, tip, mouseX, mouseY);
            }
            if (!DripstoneFarmWidget.inside(cx + 6, botY, 18, 18, mouseX, mouseY)) continue;
            String tip = !bottom.isEmpty() ? (bottom.is(Items.BUCKET) ? Component.translatable((String)"nomadsshell.dripstone.tooltip.waiting").getString() : Component.translatable((String)"nomadsshell.dripstone.tooltip.ready").getString()) : (mb >= 1000 ? Component.translatable((String)"nomadsshell.dripstone.tooltip.full").getString() : Component.translatable((String)"nomadsshell.dripstone.tooltip.ready_mb", (Object[])new Object[]{mb}).getString());
            this.drawTooltip(g, tip, mouseX, mouseY);
        }
        if (this.pendingForceIndex >= 0) {
            String msg = Component.translatable((String)"nomadsshell.dripstone.confirm.change_source").getString();
            PoseStack pose = g.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 3000.0f);
            int pad = 4;
            maxTextW = w - pad * 2 - 4;
            List<String> lines = this.wrapToWidth(msg, maxTextW);
            Objects.requireNonNull(this.font);
            lh = 9;
            totalH = lines.size() * lh;
            baseX = x + pad + 2;
            baseY = y + this.height - 2 - totalH;
            for (i = 0; i < lines.size(); ++i) {
                g.drawString(this.font, lines.get(i), baseX, baseY + i * lh, -1, false);
            }
            pose.popPose();
        }
        if (this.pendingTakeSourceIndex >= 0) {
            String msg = Component.translatable((String)"nomadsshell.dripstone.confirm.take_source").getString();
            PoseStack pose = g.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 3000.0f);
            int pad = 4;
            maxTextW = w - pad * 2 - 4;
            List<String> lines = this.wrapToWidth(msg, maxTextW);
            Objects.requireNonNull(this.font);
            lh = 9;
            totalH = lines.size() * lh;
            baseX = x + pad + 2;
            baseY = y + this.height - 2 - totalH;
            for (i = 0; i < lines.size(); ++i) {
                g.drawString(this.font, lines.get(i), baseX, baseY + i * lh, -1, false);
            }
            pose.popPose();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int topYc;
        int gapc;
        int colWc;
        int totalWc;
        int contentWc;
        int startXc;
        int cxc;
        int countConf;
        int contentY;
        int idx;
        boolean inside;
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM);
        this.logoMode = false;
        int dripstoneX = x + w - 16 - 4;
        int dripstoneY = y + 2;
        if (mouseX >= (double)dripstoneX && mouseX <= (double)(dripstoneX + 8) && mouseY >= (double)dripstoneY && mouseY <= (double)(dripstoneY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.DRIPSTONE_FARM_ENABLED.get();
            OverlayConfig.DRIPSTONE_FARM_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (this.pendingForceIndex >= 0) {
            idx = this.pendingForceIndex;
            contentY = y + 12 + 1;
            if (DripstoneFarmWidget.inside(x, y, w, 12, (int)mouseX, (int)mouseY)) {
                this.pendingForceIndex = -1;
                return true;
            }
            countConf = WidgetDataHelper.getDripCauldronCount((Player)Minecraft.getInstance().player);
            if ((countConf = Math.max(0, Math.min(5, countConf))) > 0 && DripstoneFarmWidget.inside((cxc = (startXc = x + 4 + ((contentWc = this.width - 8) - (totalWc = countConf * (colWc = 30) + (countConf - 1) * (gapc = 6))) / 2) + idx * (colWc + gapc)) + 6, topYc = contentY + 6, 18, 18, (int)mouseX, (int)mouseY)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.FEED_SOURCE_BUCKET_FORCE, idx), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pendingForceIndex = -1;
                return true;
            }
            if (DripstoneFarmWidget.inside(x, contentY, w, this.height - (contentY - y), (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        if (this.pendingTakeSourceIndex >= 0) {
            idx = this.pendingTakeSourceIndex;
            contentY = y + 12 + 1;
            if (DripstoneFarmWidget.inside(x, y, w, 12, (int)mouseX, (int)mouseY)) {
                this.pendingTakeSourceIndex = -1;
                return true;
            }
            countConf = WidgetDataHelper.getDripCauldronCount((Player)Minecraft.getInstance().player);
            if ((countConf = Math.max(0, Math.min(5, countConf))) > 0 && DripstoneFarmWidget.inside((cxc = (startXc = x + 4 + ((contentWc = this.width - 8) - (totalWc = countConf * (colWc = 30) + (countConf - 1) * (gapc = 6))) / 2) + idx * (colWc + gapc)) + 6, topYc = contentY + 6, 18, 18, (int)mouseX, (int)mouseY)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.TAKE_SOURCE_BUCKET, idx), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pendingTakeSourceIndex = -1;
                return true;
            }
            if (DripstoneFarmWidget.inside(x, contentY, w, this.height - (contentY - y), (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        if (!this.isUnlocked()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int contentY2 = y + 12 + 1;
        int contentW = this.width - 8;
        int count = WidgetDataHelper.getDripCauldronCount((Player)Minecraft.getInstance().player);
        if ((count = Math.max(0, Math.min(5, count))) > 0) {
            int colW = 30;
            int gap = 6;
            int totalW = count * colW + (count - 1) * gap;
            int startX = x + 4 + (contentW - totalW) / 2;
            int topY = contentY2 + 6;
            int botY = topY + 26 + 26;
            for (int i = 0; i < count; ++i) {
                int buttonH;
                int buttonW;
                int buttonY;
                int buttonX;
                boolean hasAutoTransfer;
                int cx = startX + i * (colW + gap);
                if (DripstoneFarmWidget.inside(cx + 6, topY, 18, 18, (int)mouseX, (int)mouseY)) {
                    FluidStackData src;
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player == null) {
                        return true;
                    }
                    ItemStack carried = player.containerMenu.getCarried();
                    if (!carried.isEmpty()) {
                        src = WidgetDataHelper.getDripSourceFluidAt((Player)player, i);
                        if (src.isEmpty()) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.FEED_SOURCE_BUCKET, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            FluidStack fs;
                            Optional opt = FluidUtil.getFluidContained((ItemStack)carried);
                            if (opt.isPresent() && (fs = (FluidStack)opt.get()).getAmount() >= 1000 && src.fluid() != fs.getFluid()) {
                                this.openConfirmChangeFluid(i);
                            }
                        }
                    }
                    if (!carried.isEmpty() && carried.is(Items.BUCKET) && !(src = WidgetDataHelper.getDripSourceFluidAt((Player)player, i)).isEmpty()) {
                        this.openConfirmTakeSource(i);
                    }
                    return true;
                }
                if (DripstoneFarmWidget.inside(cx + 6, botY, 18, 18, (int)mouseX, (int)mouseY)) {
                    ItemStack bottom = WidgetDataHelper.getDripBottomItemAt((Player)Minecraft.getInstance().player, i);
                    if (!bottom.isEmpty()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.TAKE_BOTTOM_ITEM, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        ItemStack carried = Minecraft.getInstance().player.containerMenu.getCarried();
                        if (!carried.isEmpty() && carried.is(Items.BUCKET)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.PLACE_BOTTOM_BUCKET, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.COLLECT_OUTPUT_BUCKET, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                    return true;
                }
                ItemStack shellStack = ShellItem.findWornshell((Player)Minecraft.getInstance().player);
                int cauldronCount = WidgetDataHelper.getDripCauldronCount((Player)Minecraft.getInstance().player);
                boolean bl2 = hasAutoTransfer = !shellStack.isEmpty() && WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack) == WidgetUnlockSystem.WidgetTier.TIER_II;
                if (!hasAutoTransfer || cauldronCount < 3 || !DripstoneFarmWidget.inside(buttonX = cx + 8, buttonY = botY + 20, buttonW = 16, buttonH = 12, (int)mouseX, (int)mouseY)) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.CYCLE_TARGET_CONTAINER, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            if (button == 0 && DripstoneFarmWidget.inside(x, contentY2, w, this.height - (contentY2 - y), (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        if (button == 0 && DripstoneFarmWidget.inside(x, contentY2, w, this.height - (contentY2 - y), (int)mouseX, (int)mouseY)) {
            return true;
        }
        if (button != 0 && DripstoneFarmWidget.inside(x, y, w, h, (int)mouseX, (int)mouseY)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean inside;
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    private void drawSlot(GuiGraphics g, int x, int y, int mx, int my) {
        int fill = DripstoneFarmWidget.inside(x, y, 18, 18, mx, my) ? Theme.slotHoverFill() : Theme.slotFill();
        g.fill(x, y, x + 18, y + 18, fill);
        g.renderOutline(x, y, 18, 18, Theme.slotBorder());
    }

    private void drawTooltip(GuiGraphics g, String text, int x, int y) {
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 3000.0f);
        int maxWidth = 200;
        int padding = 4;
        List lines = this.font.getSplitter().splitLines(text, 200, Style.EMPTY);
        if (lines.isEmpty()) {
            pose.popPose();
            return;
        }
        int maxLineWidth = 0;
        for (FormattedText line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.font.width(line));
        }
        int tooltipWidth = maxLineWidth + 8;
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int tooltipHeight = n * 9 + 8;
        int tx = x + 8;
        int ty = y - tooltipHeight - 2;
        g.fill(tx, ty, tx + tooltipWidth, ty + tooltipHeight, Theme.overlayDim());
        int lineY = ty + 4;
        for (FormattedText line : lines) {
            g.drawString(this.font, line.getString(), tx + 4, lineY, -1, false);
            Objects.requireNonNull(this.font);
            lineY += 9;
        }
        pose.popPose();
    }

    private static boolean inside(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private static boolean isLava(FluidStackData data) {
        return !data.isEmpty() && data.fluid().builtInRegistryHolder().key().location().getPath().contains("lava");
    }

    private void openConfirmChangeFluid(int index) {
        this.pendingForceIndex = Math.max(0, Math.min(4, index));
        this.warningTimer = 0;
    }

    private void openConfirmTakeSource(int index) {
        this.pendingTakeSourceIndex = Math.max(0, Math.min(4, index));
        this.takeSourceWarningTimer = 0;
    }

    private String trimToWidth(String text, int maxWidth) {
        if (text == null) {
            return "";
        }
        if (this.font.width(text) <= maxWidth) {
            return text;
        }
        String ellipsis = "...";
        int ellipsisW = this.font.width(ellipsis);
        int target = Math.max(0, maxWidth - ellipsisW);
        int lo = 0;
        int hi = text.length();
        int best = 0;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            String sub = text.substring(0, Math.min(mid, text.length()));
            int w = this.font.width(sub);
            if (w <= target) {
                best = mid;
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        String base = text.substring(0, Math.min(best, text.length()));
        return base + ellipsis;
    }

    private List<String> wrapToWidth(String text, int maxWidth) {
        ArrayList<String> out = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return out;
        }
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String w : words) {
            String candidate;
            String string = candidate = line.isEmpty() ? w : String.valueOf(line) + " " + w;
            if (this.font.width(candidate) <= maxWidth) {
                line.setLength(0);
                line.append(candidate);
                continue;
            }
            if (!line.isEmpty()) {
                out.add(line.toString());
            }
            if (this.font.width(w) > maxWidth) {
                String remaining = w;
                while (!remaining.isEmpty() && this.font.width(remaining) > maxWidth) {
                    int lo = 1;
                    int hi = remaining.length();
                    int best = 1;
                    while (lo <= hi) {
                        int mid = lo + hi >>> 1;
                        String sub = remaining.substring(0, mid);
                        int wpx = this.font.width(sub);
                        if (wpx <= maxWidth) {
                            best = mid;
                            lo = mid + 1;
                            continue;
                        }
                        hi = mid - 1;
                    }
                    out.add(remaining.substring(0, best));
                    remaining = remaining.substring(best);
                }
                line.setLength(0);
                line.append(remaining);
                continue;
            }
            line.setLength(0);
            line.append(w);
        }
        if (!line.isEmpty()) {
            out.add(line.toString());
        }
        return out;
    }

    public void tick() {
        if (!this.isUnlocked()) {
            return;
        }
        if (this.pendingForceIndex >= 0) {
            ++this.warningTimer;
            if (this.warningTimer >= 60) {
                this.pendingForceIndex = -1;
                this.warningTimer = 0;
            }
        }
        if (this.pendingTakeSourceIndex >= 0) {
            ++this.takeSourceWarningTimer;
            if (this.takeSourceWarningTimer >= 60) {
                this.pendingTakeSourceIndex = -1;
                this.takeSourceWarningTimer = 0;
            }
        }
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int dripstoneX = x + currentWidth - 16 - 4;
        int dripstoneY = y + 2;
        boolean dripstoneHovered = mouseX >= dripstoneX && mouseX <= dripstoneX + 8 && mouseY >= dripstoneY && mouseY <= dripstoneY + 8;
        boolean dripstoneEnabled = (Boolean)OverlayConfig.DRIPSTONE_FARM_ENABLED.get();
        int n = buttonColor = dripstoneEnabled ? -11751600 : -769226;
        if (dripstoneHovered) {
            buttonColor = dripstoneEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(dripstoneX, dripstoneY, dripstoneX + 8, dripstoneY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, pinColor);
        } else {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, pinColor);
        }
        guiGraphics.pose().popPose();
    }
}

