/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.FurnaceSlotInteractionPacket;
import com.etka.nomadsshell.network.FurnaceTemplateSlotPacket;
import com.etka.nomadsshell.network.MoveItemToShellPacket;
import com.etka.nomadsshell.network.ToggleFurnaceInputSourcePacket;
import com.etka.nomadsshell.network.UpdateFurnaceLiquidFuelPacket;
import com.etka.nomadsshell.network.UpdateFurnaceTagFilterPacket;
import com.etka.nomadsshell.network.UpdateFurnaceTagRecorderGhostPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.PacketDistributor;

public class FurnaceWidget
extends LockableWidget {
    private ItemStack inputItem = ItemStack.EMPTY;
    private ItemStack fuelItem = ItemStack.EMPTY;
    private ItemStack outputItem = ItemStack.EMPTY;
    private int smeltingProgress = 0;
    private int fuelBurnTime = 0;
    private int maxFuelBurnTime = 0;
    private int maxSmeltingTime = 300;
    private int speedBonusPct = 0;
    private int fuelBonusPct = 0;
    private List<ItemStack> inputTemplates = Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    private List<ItemStack> fuelTemplates = Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    private boolean inputFromBoth = false;
    private float animationTime = 0.0f;
    private boolean isSmelting = false;
    private boolean isExpanded = false;
    private boolean logoMode = false;
    private String infoPopupText = null;
    private int infoPopupTimer = 0;
    private int infoPopupX = 0;
    private int infoPopupY = 0;
    private int topLabelX;
    private int topLabelY;
    private int topLabelW;
    private int topLabelH;
    private int bottomLabelX;
    private int bottomLabelY;
    private int bottomLabelW;
    private int bottomLabelH;
    private int saveCounter = 0;
    private static final int SAVE_INTERVAL = 20;
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int SLOT_SIZE = 16;
    private static final int COLLAPSED_WIDTH = 44;
    private static final int COLLAPSED_HEIGHT = 36;
    private static final int COLLAPSED_INPUT_X = 4;
    private static final int COLLAPSED_INPUT_Y = 6;
    private static final int COLLAPSED_OUTPUT_X = 24;
    private static final int COLLAPSED_OUTPUT_Y = 6;
    private static final int EXPANDED_WIDTH = 48;
    private static final int EXPANDED_HEIGHT = 62;
    private static final int EXPANDED_INPUT_X = 4;
    private static final int EXPANDED_INPUT_Y = 6;
    private static final int EXPANDED_FUEL_X = 4;
    private static final int EXPANDED_FUEL_Y = 28;
    private static final int EXPANDED_OUTPUT_X = 26;
    private static final int EXPANDED_OUTPUT_Y = 17;
    private static final int TIER_II_COLLAPSED_WIDTH = 44;
    private static final int TIER_II_COLLAPSED_HEIGHT = 36;
    private static final int TIER_II_COLLAPSED_INPUT_X = 4;
    private static final int TIER_II_COLLAPSED_INPUT_Y = 6;
    private static final int TIER_II_COLLAPSED_OUTPUT_X = 24;
    private static final int TIER_II_COLLAPSED_OUTPUT_Y = 6;
    private static final int TIER_II_EXPANDED_WIDTH = 150;
    private static final int TIER_II_EXPANDED_HEIGHT = 110;
    private static final int TIER_II_FURNACE_INPUT_X = 4;
    private static final int TIER_II_FURNACE_INPUT_Y = 26;
    private static final int TIER_II_FURNACE_FUEL_X = 4;
    private static final int TIER_II_FURNACE_FUEL_Y = 48;
    private static final int TIER_II_FURNACE_OUTPUT_X = 26;
    private static final int TIER_II_FURNACE_OUTPUT_Y = 37;
    private static final int TIER_II_INPUT_TEMPLATES_START_X = 4;
    private static final int TIER_II_INPUT_TEMPLATES_Y = 6;
    private static final int TIER_II_TEMPLATE_SPACING = 18;
    private static final int TIER_II_FUEL_TEMPLATES_START_X = 4;
    private static final int TIER_II_FUEL_TEMPLATES_Y = 68;
    private static final int TIER_II_INPUT_BUTTON_X = 48;
    private static final int TIER_II_INPUT_BUTTON_Y = 37;
    private static final int TIER_II_INPUT_BUTTON_SIZE = 16;
    private static final int TAG_BORDER_COLOR = -6596170;
    private static final int TAG_BG_COLOR = -12899525;
    private static final int MINI_BTN = 6;
    private int selectedInputGhostIdx = 0;
    private int selectedFuelGhostIdx = 0;
    private int selectedInputRemoveIdx = 0;
    private int selectedFuelRemoveIdx = 0;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.FURNACE_X.get();
        return configX != 0 ? configX : defaultX;
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.FURNACE_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.FURNACE_USE_IMAGE_MODE.get();
        OverlayConfig.FURNACE_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.FURNACE_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    private ItemStack loadInputItemFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return ItemStack.EMPTY;
        }
        return WidgetDataHelper.getFurnaceInputItem((Player)mc.player);
    }

    private ItemStack loadFuelItemFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return ItemStack.EMPTY;
        }
        return WidgetDataHelper.getFurnaceFuelItem((Player)mc.player);
    }

    private ItemStack loadOutputItemFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return ItemStack.EMPTY;
        }
        return WidgetDataHelper.getFurnaceOutputItem((Player)mc.player);
    }

    private int loadSmeltingProgressFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return 0;
        }
        return WidgetDataHelper.getFurnaceSmeltingProgress((Player)mc.player);
    }

    private int loadFuelBurnTimeFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return 0;
        }
        return WidgetDataHelper.getFurnaceFuelBurnTime((Player)mc.player);
    }

    private int loadMaxFuelBurnTimeFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return 0;
        }
        return WidgetDataHelper.getFurnaceMaxFuelBurnTime((Player)mc.player);
    }

    private List<ItemStack> loadInputTemplatesFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
        }
        return WidgetDataHelper.getFurnaceInputTemplates((Player)mc.player);
    }

    private List<ItemStack> loadFuelTemplatesFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
        }
        return WidgetDataHelper.getFurnaceFuelTemplates((Player)mc.player);
    }

    private boolean loadInputSourceFromshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        return WidgetDataHelper.getFurnaceInputFromBoth((Player)mc.player);
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.FURNACE_X.set((Object)this.getX());
            OverlayConfig.FURNACE_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.FURNACE_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveExpandedStateToConfig() {
        try {
            OverlayConfig.FURNACE_EXPANDED.set((Object)this.isExpanded);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FurnaceWidget(int x, int y, Font font, IShellMenu menu) {
        super(FurnaceWidget.loadPositionX(x), FurnaceWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.furnace"), font, WidgetUnlockSystem.WidgetType.FURNACE, menu);
        this.inputItem = this.loadInputItemFromshell();
        this.fuelItem = this.loadFuelItemFromshell();
        this.outputItem = this.loadOutputItemFromshell();
        this.isPinned = (Boolean)OverlayConfig.FURNACE_PINNED.get();
        this.isExpanded = (Boolean)OverlayConfig.FURNACE_EXPANDED.get();
        this.smeltingProgress = this.loadSmeltingProgressFromshell();
        this.fuelBurnTime = this.loadFuelBurnTimeFromshell();
        this.maxFuelBurnTime = this.loadMaxFuelBurnTimeFromshell();
        this.inputTemplates = this.loadInputTemplatesFromshell();
        this.fuelTemplates = this.loadFuelTemplatesFromshell();
        this.inputFromBoth = this.loadInputSourceFromshell();
    }

    private void refreshFromshell() {
        this.inputItem = this.loadInputItemFromshell();
        this.fuelItem = this.loadFuelItemFromshell();
        this.outputItem = this.loadOutputItemFromshell();
        this.smeltingProgress = this.loadSmeltingProgressFromshell();
        this.fuelBurnTime = this.loadFuelBurnTimeFromshell();
        this.maxFuelBurnTime = this.loadMaxFuelBurnTimeFromshell();
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            int perfLevel = WidgetDataHelper.getFurnacePerfUpgradeLevel((Player)mc.player);
            this.speedBonusPct = 0;
            if (perfLevel >= 1) {
                this.speedBonusPct += 25;
            }
            if (perfLevel >= 3) {
                this.speedBonusPct += 25;
            }
            if (perfLevel >= 5) {
                this.speedBonusPct += 50;
            }
            this.fuelBonusPct = 0;
            if (perfLevel >= 2) {
                this.fuelBonusPct += 25;
            }
            if (perfLevel >= 4) {
                this.fuelBonusPct += 25;
            }
            if (perfLevel >= 6) {
                this.fuelBonusPct += 50;
            }
            int baseSmeltTicks = 300;
            double speedFactor = 1.0 + (double)this.speedBonusPct / 100.0;
            this.maxSmeltingTime = Math.max(1, (int)Math.round((double)baseSmeltTicks / speedFactor));
        } else {
            this.maxSmeltingTime = 300;
            this.speedBonusPct = 0;
            this.fuelBonusPct = 0;
        }
        this.inputTemplates = this.loadInputTemplatesFromshell();
        this.fuelTemplates = this.loadFuelTemplatesFromshell();
        this.inputFromBoth = this.loadInputSourceFromshell();
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean hoveredWidget;
        boolean titleBarHovered;
        int currentHeight;
        int currentWidth;
        boolean imageEnabled;
        if (!this.isUnlocked()) {
            return;
        }
        this.refreshFromshell();
        int x = this.getX();
        int y = this.getY();
        this.animationTime += partialTick;
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        boolean bl = this.logoMode = (imageEnabled = ((Boolean)OverlayConfig.FURNACE_USE_IMAGE_MODE.get()).booleanValue()) && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            currentWidth = this.isExpanded ? 150 : 44;
            currentHeight = this.isExpanded ? 110 : 36;
        } else {
            currentWidth = this.isExpanded ? 48 : 44;
            currentHeight = this.isExpanded ? 62 : 36;
        }
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        boolean bl2 = titleBarHovered = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + currentWidth, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = currentHeight - 12;
        guiGraphics.fill(x, contentY, x + currentWidth, contentY + contentHeight, Theme.panelBg());
        this.renderControlButtons(guiGraphics, mouseX, mouseY, currentWidth, currentHeight);
        boolean bl3 = hoveredWidget = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + currentHeight;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(guiGraphics, x, contentY, currentWidth, contentHeight);
            return;
        }
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            if (this.isExpanded) {
                this.drawTierTwoExpandedInterface(guiGraphics, x, contentY, mouseX, mouseY);
            } else {
                this.drawTierTwoCollapsedInterface(guiGraphics, x, contentY, mouseX, mouseY);
            }
        } else if (this.isExpanded) {
            this.drawExpandedInterface(guiGraphics, x, contentY, mouseX, mouseY);
        } else {
            this.drawCollapsedInterface(guiGraphics, x, contentY, mouseX, mouseY);
        }
        if (this.infoPopupText != null && this.infoPopupTimer > 0) {
            int pad = 4;
            int popupW = this.font.width(this.infoPopupText) + pad * 2;
            Objects.requireNonNull(this.font);
            int popupH = 9 + pad * 2;
            int px = this.infoPopupX;
            int py = this.infoPopupY;
            guiGraphics.fill(px + 2, py + 2, px + popupW + 2, py + popupH + 2, 0x77000000);
            guiGraphics.fill(px, py, px + popupW, py + popupH, -870375649);
            guiGraphics.fill(px - 1, py - 1, px + popupW + 1, py, -1);
            guiGraphics.fill(px - 1, py + popupH, px + popupW + 1, py + popupH + 1, -1);
            guiGraphics.fill(px - 1, py, px, py + popupH, -1);
            guiGraphics.fill(px + popupW, py, px + popupW + 1, py + popupH, -1);
            guiGraphics.drawString(this.font, this.infoPopupText, px + pad, py + pad, -1, false);
        }
        if (this.showContextMenu) {
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        guiGraphics.blit(Theme.icon("fire"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    private void drawControlButtons(GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY) {
        int pinX = x + width - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, -1);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, -1);
        } else {
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, -5592406);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, -5592406);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, -5592406);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, -5592406);
        }
        int expandX = x + width - 8 - 2 - 8 - 2;
        int expandY = y + 2;
        boolean expandHovered = mouseX >= expandX && mouseX <= expandX + 8 && mouseY >= expandY && mouseY <= expandY + 8;
        guiGraphics.fill(expandX, expandY, expandX + 8, expandY + 8, Theme.buttonBg(expandHovered));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)expandX, (float)expandY, 0.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        ResourceLocation icon = Theme.icon(this.isExpanded ? "collapse" : "expand");
        try {
            guiGraphics.blit(icon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Throwable t) {
            guiGraphics.pose().popPose();
            int iconColor = -1;
            if (this.isExpanded) {
                guiGraphics.fill(expandX + 2, expandY + 4, expandX + 6, expandY + 5, iconColor);
            } else {
                guiGraphics.fill(expandX + 2, expandY + 4, expandX + 6, expandY + 5, iconColor);
                guiGraphics.fill(expandX + 4, expandY + 2, expandX + 5, expandY + 6, iconColor);
            }
            return;
        }
        guiGraphics.pose().popPose();
    }

    private void drawFurnaceInterface(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isExpanded) {
            this.drawExpandedInterface(guiGraphics, x, y, mouseX, mouseY);
        } else {
            this.drawCollapsedInterface(guiGraphics, x, y, mouseX, mouseY);
        }
    }

    private void drawCollapsedInterface(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        this.drawInputSlotWithProgress(guiGraphics, x + 4, y + 6);
        this.drawSlotBackground(guiGraphics, x + 24, y + 6);
        if (!this.inputItem.isEmpty()) {
            guiGraphics.renderItem(this.inputItem, x + 4, y + 6);
            if (this.inputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.inputItem, x + 4, y + 6);
            }
        }
        if (!this.outputItem.isEmpty()) {
            guiGraphics.renderItem(this.outputItem, x + 24, y + 6);
            if (this.outputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.outputItem, x + 24, y + 6);
            }
        }
        if (this.fuelBurnTime > 0) {
            float fuelPercent = (float)this.fuelBurnTime / (float)this.maxFuelBurnTime;
            int indicatorX = x + 14;
            int indicatorY = y + 18;
            int indicatorWidth = 6;
            int fillWidth = (int)((float)indicatorWidth * fuelPercent);
            guiGraphics.fill(indicatorX, indicatorY, indicatorX + indicatorWidth, indicatorY + 2, -10066330);
            guiGraphics.fill(indicatorX, indicatorY, indicatorX + fillWidth, indicatorY + 2, -29670);
        }
    }

    private void drawExpandedInterface(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        this.drawInputSlotWithProgress(guiGraphics, x + 4, y + 6);
        this.drawFuelSlotWithIndicator(guiGraphics, x + 4, y + 28);
        this.drawSlotBackground(guiGraphics, x + 26, y + 17);
        if (!this.inputItem.isEmpty()) {
            guiGraphics.renderItem(this.inputItem, x + 4, y + 6);
            if (this.inputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.inputItem, x + 4, y + 6);
            }
        }
        if (!this.fuelItem.isEmpty()) {
            guiGraphics.renderItem(this.fuelItem, x + 4, y + 28);
            if (this.fuelItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.fuelItem, x + 4, y + 28);
            }
        }
        if (!this.outputItem.isEmpty()) {
            guiGraphics.renderItem(this.outputItem, x + 26, y + 17);
            if (this.outputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.outputItem, x + 26, y + 17);
            }
        }
        this.drawPerfBadges(guiGraphics, x + 26, y + 17);
    }

    private void drawSlotBackground(GuiGraphics guiGraphics, int x, int y) {
        int slotBorder = Theme.slotBorder();
        int slotFill = Theme.slotFill();
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, slotBorder);
        guiGraphics.fill(x, y, x + 16, y + 16, slotFill);
    }

    private void drawFuelSlotWithIndicator(GuiGraphics guiGraphics, int x, int y) {
        int slotBorder = Theme.slotBorder();
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, slotBorder);
        float fuelPercent = 0.0f;
        if (this.maxFuelBurnTime > 0) {
            fuelPercent = (float)this.fuelBurnTime / (float)this.maxFuelBurnTime;
        }
        int slotFill = Theme.slotFill();
        guiGraphics.fill(x, y, x + 16, y + 16, slotFill);
        if (fuelPercent > 0.0f) {
            int fillHeight = (int)(16.0f * fuelPercent);
            int fillY = y + 16 - fillHeight;
            int orangeColor = -29670;
            guiGraphics.fill(x, fillY, x + 16, y + 16, orangeColor);
        }
    }

    private void drawInputSlotWithProgress(GuiGraphics guiGraphics, int x, int y) {
        int slotBorder = Theme.slotBorder();
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, slotBorder);
        float progressPercent = 0.0f;
        if (this.maxSmeltingTime > 0) {
            progressPercent = (float)this.smeltingProgress / (float)this.maxSmeltingTime;
        }
        int slotFill = Theme.slotFill();
        guiGraphics.fill(x, y, x + 16, y + 16, slotFill);
        if (progressPercent > 0.0f) {
            int fillWidth = (int)(16.0f * progressPercent);
            int greenColor = -13447886;
            guiGraphics.fill(x, y, x + fillWidth, y + 16, greenColor);
        }
    }

    private void drawPerfBadges(GuiGraphics guiGraphics, int slotX, int slotY) {
        int speed = Math.max(0, 50 + this.speedBonusPct);
        int fuel = Math.max(0, 25 + this.fuelBonusPct);
        int centerX = slotX + 8;
        int color = -4144960;
        String top = "%" + speed;
        int topW = this.font.width(top);
        int topX = centerX - topW / 2;
        Objects.requireNonNull(this.font);
        int topY = slotY - 9 - 2;
        guiGraphics.drawString(this.font, top, topX, topY, color, false);
        this.topLabelX = topX;
        this.topLabelY = topY;
        this.topLabelW = topW;
        Objects.requireNonNull(this.font);
        this.topLabelH = 9;
        String bottom = "%" + fuel;
        int botW = this.font.width(bottom);
        int botX = centerX - botW / 2;
        int botY = slotY + 16 + 2;
        guiGraphics.drawString(this.font, bottom, botX, botY, color, false);
        this.bottomLabelX = botX;
        this.bottomLabelY = botY;
        this.bottomLabelW = botW;
        Objects.requireNonNull(this.font);
        this.bottomLabelH = 9;
    }

    private void drawTierTwoInterface(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isExpanded) {
            this.drawTierTwoExpandedInterface(guiGraphics, x, y, mouseX, mouseY);
        } else {
            this.drawTierTwoCollapsedInterface(guiGraphics, x, y, mouseX, mouseY);
        }
    }

    private void drawTierTwoExpandedInterface(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        boolean isTagRecorder;
        boolean tagUnlocked;
        int slotY;
        int slotX;
        int i;
        this.drawInputSlotWithProgress(guiGraphics, x + 4, y + 26);
        if (!this.inputItem.isEmpty()) {
            guiGraphics.renderItem(this.inputItem, x + 4, y + 26);
            if (this.inputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.inputItem, x + 4, y + 26);
            }
        }
        this.drawFuelSlotWithIndicator(guiGraphics, x + 4, y + 48);
        if (!this.fuelItem.isEmpty()) {
            guiGraphics.renderItem(this.fuelItem, x + 4, y + 48);
            if (this.fuelItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.fuelItem, x + 4, y + 48);
            }
        }
        this.drawSlotBackground(guiGraphics, x + 26, y + 37);
        if (!this.outputItem.isEmpty()) {
            guiGraphics.renderItem(this.outputItem, x + 26, y + 37);
            if (this.outputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.outputItem, x + 26, y + 37);
            }
        }
        this.drawPerfBadges(guiGraphics, x + 26, y + 37);
        int allowed = 3;
        if (Minecraft.getInstance().player != null) {
            allowed = WidgetDataHelper.getAllowedTemplateSlots((Player)Minecraft.getInstance().player);
        }
        allowed = Math.max(0, Math.min(8, allowed));
        for (i = 0; i < allowed; ++i) {
            slotX = x + 4 + i * 18;
            slotY = y + 6;
            tagUnlocked = allowed >= 8;
            boolean bl = isTagRecorder = tagUnlocked && i == allowed - 1;
            if (isTagRecorder) {
                this.drawTagRecorderSlot(guiGraphics, slotX, slotY, WidgetDataHelper.getFurnaceInputTags((Player)Minecraft.getInstance().player).size(), WidgetDataHelper.isFurnaceInputTagWhitelist((Player)Minecraft.getInstance().player), true, this.selectedInputGhostIdx);
                ItemStack ghost = WidgetDataHelper.getInputTagRecorderGhost((Player)Minecraft.getInstance().player);
                if (!ghost.isEmpty()) {
                    guiGraphics.renderItem(ghost, slotX, slotY);
                }
            } else {
                this.drawTemplateSlotBackground(guiGraphics, slotX, slotY);
            }
            if (i >= this.inputTemplates.size() || this.inputTemplates.get(i).isEmpty()) continue;
            ItemStack templateItem = this.inputTemplates.get(i);
            guiGraphics.renderItem(templateItem, slotX, slotY);
        }
        for (i = 0; i < allowed; ++i) {
            boolean isLiquidFuelSlot;
            slotX = x + 4 + i * 18;
            slotY = y + 68;
            tagUnlocked = allowed >= 8;
            isTagRecorder = tagUnlocked && i == allowed - 1;
            boolean bl = isLiquidFuelSlot = tagUnlocked && i == allowed - 2;
            if (isTagRecorder) {
                this.drawTagRecorderSlot(guiGraphics, slotX, slotY, WidgetDataHelper.getFurnaceFuelTags((Player)Minecraft.getInstance().player).size(), WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)Minecraft.getInstance().player), false, this.selectedFuelGhostIdx);
                ItemStack ghost = WidgetDataHelper.getFuelTagRecorderGhost((Player)Minecraft.getInstance().player);
                if (!ghost.isEmpty()) {
                    guiGraphics.renderItem(ghost, slotX, slotY);
                }
            } else if (isLiquidFuelSlot) {
                this.drawLiquidFuelSlot(guiGraphics, slotX, slotY, mouseX, mouseY);
            } else {
                this.drawTemplateSlotBackground(guiGraphics, slotX, slotY);
            }
            if (isLiquidFuelSlot || i >= this.fuelTemplates.size() || this.fuelTemplates.get(i).isEmpty()) continue;
            ItemStack templateItem = this.fuelTemplates.get(i);
            guiGraphics.renderItem(templateItem, slotX, slotY);
        }
        this.drawInputSourceButton(guiGraphics, x + 48, y + 37, mouseX, mouseY);
    }

    private void drawTierTwoCollapsedInterface(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        this.drawInputSlotWithProgress(guiGraphics, x + 4, y + 6);
        this.drawSlotBackground(guiGraphics, x + 24, y + 6);
        if (!this.inputItem.isEmpty()) {
            guiGraphics.renderItem(this.inputItem, x + 4, y + 6);
            if (this.inputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.inputItem, x + 4, y + 6);
            }
        }
        if (!this.outputItem.isEmpty()) {
            guiGraphics.renderItem(this.outputItem, x + 24, y + 6);
            if (this.outputItem.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, this.outputItem, x + 24, y + 6);
            }
        }
        if (this.fuelBurnTime > 0) {
            float fuelPercent = (float)this.fuelBurnTime / (float)this.maxFuelBurnTime;
            int indicatorX = x + 14;
            int indicatorY = y + 18;
            int indicatorWidth = 6;
            int fillWidth = (int)((float)indicatorWidth * fuelPercent);
            guiGraphics.fill(indicatorX, indicatorY, indicatorX + indicatorWidth, indicatorY + 2, -10066330);
            guiGraphics.fill(indicatorX, indicatorY, indicatorX + fillWidth, indicatorY + 2, -29670);
        }
    }

    private void drawInputSourceButton(GuiGraphics guiGraphics, int buttonX, int buttonY, int mouseX, int mouseY) {
        boolean hovered;
        boolean bl = hovered = mouseX >= buttonX && mouseX <= buttonX + 16 && mouseY >= buttonY && mouseY <= buttonY + 16;
        int backgroundColor = this.inputFromBoth ? (hovered ? -8934793 : -11163051) : (hovered ? -8947849 : -11184811);
        guiGraphics.fill(buttonX, buttonY, buttonX + 16, buttonY + 16, backgroundColor);
        int borderColor = hovered ? -1 : -16777216;
        guiGraphics.fill(buttonX - 1, buttonY - 1, buttonX + 16 + 1, buttonY + 16 + 1, borderColor);
        guiGraphics.fill(buttonX, buttonY, buttonX + 16, buttonY + 16, backgroundColor);
        if (this.inputFromBoth) {
            guiGraphics.fill(buttonX + 3, buttonY + 3, buttonX + 6, buttonY + 6, -1);
            guiGraphics.fill(buttonX + 10, buttonY + 10, buttonX + 13, buttonY + 13, -1);
            guiGraphics.fill(buttonX + 7, buttonY + 4, buttonX + 9, buttonY + 5, -1);
            guiGraphics.fill(buttonX + 7, buttonY + 11, buttonX + 9, buttonY + 12, -1);
        } else {
            guiGraphics.fill(buttonX + 3, buttonY + 6, buttonX + 6, buttonY + 9, -1);
            guiGraphics.fill(buttonX + 7, buttonY + 7, buttonX + 10, buttonY + 8, -1);
        }
        if (hovered) {
            String string = this.inputFromBoth ? "Pull from both" : "Pull from backpack only";
        }
    }

    private void drawTemplateSlotBackground(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, -9790511);
        guiGraphics.fill(x, y, x + 16, y + 16, -14005670);
    }

    private void drawTagRecorderSlot(GuiGraphics guiGraphics, int x, int y, int tagCount, boolean whitelist, boolean controlsBelow, int selectedIndex) {
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, -6596170);
        guiGraphics.fill(x, y, x + 16, y + 16, -12899525);
        int cx = x + 8;
        int cy = controlsBelow ? y + 16 + 2 : y - 6 - 2;
        int spacing = 2;
        int totalW = 18 + spacing * 2;
        int startX = cx - totalW / 2;
        guiGraphics.fill(startX, cy, startX + 6, cy + 6, -11916470);
        guiGraphics.fill(startX + 1, cy + 3, startX + 6 - 1, cy + 3 + 1, -1);
        int midX = startX + 6 + spacing;
        int wlBg = whitelist ? -13796794 : -8770259;
        guiGraphics.fill(midX, cy, midX + 6, cy + 6, wlBg);
        int g = -1;
        if (whitelist) {
            guiGraphics.fill(midX + 1, cy + 1, midX + 2, cy + 6 - 1, g);
            guiGraphics.fill(midX + 6 - 2, cy + 1, midX + 6 - 1, cy + 6 - 1, g);
            guiGraphics.fill(midX + 2, cy + 2, midX + 6 - 2, cy + 3, g);
        } else {
            guiGraphics.fill(midX + 1, cy + 1, midX + 6 - 1, cy + 2, g);
            guiGraphics.fill(midX + 1, cy + 6 - 2, midX + 6 - 1, cy + 6 - 1, g);
            guiGraphics.fill(midX + 1, cy + 1, midX + 2, cy + 6 - 1, g);
            guiGraphics.fill(midX + 6 - 2, cy + 2, midX + 6 - 1, cy + 6 - 2, g);
        }
        int plusX = midX + 6 + spacing;
        guiGraphics.fill(plusX, cy, plusX + 6, cy + 6, -11916470);
        guiGraphics.fill(plusX + 1, cy + 3, plusX + 6 - 1, cy + 3 + 1, -1);
        guiGraphics.fill(plusX + 3, cy + 1, plusX + 3 + 1, cy + 6 - 1, -1);
        int mouseX = Minecraft.getInstance().mouseHandler.xpos() == 0.0 ? -1 : (int)(Minecraft.getInstance().mouseHandler.xpos() / Minecraft.getInstance().getWindow().getGuiScale());
        int mouseY = Minecraft.getInstance().mouseHandler.ypos() == 0.0 ? -1 : (int)(Minecraft.getInstance().mouseHandler.ypos() / Minecraft.getInstance().getWindow().getGuiScale());
        int minusX = startX;
        if (mouseX >= minusX && mouseX <= minusX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showTagTooltip(guiGraphics, mouseX, mouseY, false, controlsBelow);
        } else if (mouseX >= midX && mouseX <= midX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showWhitelistTooltip(guiGraphics, mouseX, mouseY, whitelist);
        } else if (mouseX >= plusX && mouseX <= plusX + 6 && mouseY >= cy && mouseY <= cy + 6) {
            this.showTagTooltip(guiGraphics, mouseX, mouseY, true, controlsBelow);
        }
    }

    private void showTagTooltip(GuiGraphics g, int mx, int my, boolean isPlus, boolean isInputRow) {
        String title;
        List<Object> list;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        boolean isInput = isInputRow;
        List<Object> active = List.of();
        if (isPlus) {
            ItemStack ghost = isInput ? WidgetDataHelper.getInputTagRecorderGhost((Player)mc.player) : WidgetDataHelper.getFuelTagRecorderGhost((Player)mc.player);
            List keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
            list = keys;
            title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString() + ": Add tag";
            active = isInput ? WidgetDataHelper.getFurnaceInputTags((Player)mc.player) : WidgetDataHelper.getFurnaceFuelTags((Player)mc.player);
        } else {
            list = isInput ? WidgetDataHelper.getFurnaceInputTags((Player)mc.player) : WidgetDataHelper.getFurnaceFuelTags((Player)mc.player);
            title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString() + ": Remove tag";
        }
        if (list.isEmpty()) {
            return;
        }
        int sel = isPlus ? (isInput ? this.selectedInputGhostIdx : this.selectedFuelGhostIdx) : (isInput ? this.selectedInputRemoveIdx : this.selectedFuelRemoveIdx);
        int max = Math.min(8, list.size());
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        lines.add((CallSite)((Object)title));
        colors.add(-1);
        for (int i = 0; i < max; ++i) {
            ResourceLocation rl = (ResourceLocation)list.get(i);
            String name = rl.toString();
            boolean bl = isPlus && active.contains(rl);
            String label = (i == sel ? "> " : "  ") + (String)name + (bl ? " (added)" : "");
            lines.add((CallSite)((Object)label));
            colors.add(bl ? -11141291 : -1);
        }
        int pad = 4;
        int w = 0;
        for (String string : lines) {
            w = Math.max(w, this.font.width(string));
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int h = n * (9 + 1) + pad * 2;
        int n2 = w + pad * 2;
        int tx = mx + 8;
        int ty = my + 8;
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        if (tx + n2 > screenW) {
            tx = mx - n2 - 8;
        }
        if (ty + h > screenH) {
            ty = my - h - 8;
        }
        g.fill(tx + 2, ty + 2, tx + n2 + 2, ty + h + 2, 0x77000000);
        g.fill(tx, ty, tx + n2, ty + h, -870375649);
        g.fill(tx - 1, ty - 1, tx + n2 + 1, ty, -1);
        g.fill(tx - 1, ty + h, tx + n2 + 1, ty + h + 1, -1);
        g.fill(tx - 1, ty, tx, ty + h, -1);
        g.fill(tx + n2, ty, tx + n2 + 1, ty + h, -1);
        int y = ty + pad;
        for (int i = 0; i < lines.size(); ++i) {
            String s = (String)lines.get(i);
            int col = (Integer)colors.get(Math.min(i, colors.size() - 1));
            g.drawString(this.font, s, tx + pad, y, col, false);
            Objects.requireNonNull(this.font);
            y += 9 + 1;
        }
    }

    private void showWhitelistTooltip(GuiGraphics g, int mx, int my, boolean whitelist) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        String title = Component.translatable((String)"nomadsshell.furnace.tag_puller").getString();
        String mode = whitelist ? Component.translatable((String)"nomadsshell.ui.mode_whitelist").getString() : Component.translatable((String)"nomadsshell.ui.mode_blacklist").getString();
        int pad = 4;
        int w = Math.max(this.font.width(title), this.font.width(mode));
        Objects.requireNonNull(this.font);
        int h = (9 + 1) * 2 + pad * 2;
        int tw = w + pad * 2;
        int tx = mx + 8;
        int ty = my + 8;
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        if (tx + tw > screenW) {
            tx = mx - tw - 8;
        }
        if (ty + h > screenH) {
            ty = my - h - 8;
        }
        g.fill(tx + 2, ty + 2, tx + tw + 2, ty + h + 2, 0x77000000);
        g.fill(tx, ty, tx + tw, ty + h, -870375649);
        g.fill(tx - 1, ty - 1, tx + tw + 1, ty, -1);
        g.fill(tx - 1, ty + h, tx + tw + 1, ty + h + 1, -1);
        g.fill(tx - 1, ty, tx, ty + h, -1);
        g.fill(tx + tw, ty, tx + tw + 1, ty + h, -1);
        int y = ty + pad;
        g.drawString(this.font, title, tx + pad, y, -1, false);
        Objects.requireNonNull(this.font);
        g.drawString(this.font, mode, tx + pad, y += 9 + 1, whitelist ? -11141291 : -43691, false);
    }

    private void handleTagRecorderClick(boolean isInput, int slotX, int slotY, double mouseX, double mouseY, int button) {
        int startX;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        int cx = slotX + 8;
        boolean controlsBelow = isInput;
        int cy = controlsBelow ? slotY + 16 + 2 : slotY - 6 - 2;
        int spacing = 2;
        int totalW = 18 + spacing * 2;
        int minusX = startX = cx - totalW / 2;
        int wlX = startX + 6 + spacing;
        int plusX = wlX + 6 + spacing;
        if (mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(isInput ? WidgetDataHelper.getFurnaceInputTags((Player)mc.player) : WidgetDataHelper.getFurnaceFuelTags((Player)mc.player));
            if (!tags.isEmpty()) {
                int idx;
                int n = idx = isInput ? this.selectedInputRemoveIdx : this.selectedFuelRemoveIdx;
                if (idx >= 0 && idx < tags.size()) {
                    tags.remove(idx);
                    boolean whitelist = isInput ? WidgetDataHelper.isFurnaceInputTagWhitelist((Player)mc.player) : WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)mc.player);
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagFilterPacket(isInput ? UpdateFurnaceTagFilterPacket.Slot.INPUT : UpdateFurnaceTagFilterPacket.Slot.FUEL, tags, whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    if (isInput) {
                        this.selectedInputRemoveIdx = Math.max(0, Math.min(this.selectedInputRemoveIdx, tags.size() - 1));
                    } else {
                        this.selectedFuelRemoveIdx = Math.max(0, Math.min(this.selectedFuelRemoveIdx, tags.size() - 1));
                    }
                }
            }
            return;
        }
        if (mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            List<ResourceLocation> tags = isInput ? WidgetDataHelper.getFurnaceInputTags((Player)mc.player) : WidgetDataHelper.getFurnaceFuelTags((Player)mc.player);
            boolean whitelist = isInput ? WidgetDataHelper.isFurnaceInputTagWhitelist((Player)mc.player) : WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)mc.player);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagFilterPacket(isInput ? UpdateFurnaceTagFilterPacket.Slot.INPUT : UpdateFurnaceTagFilterPacket.Slot.FUEL, tags, !whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        if (mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6) && button == 0) {
            int idx;
            ResourceLocation sel;
            ArrayList<ResourceLocation> tags;
            List<ResourceLocation> keys;
            ItemStack ghost;
            ItemStack itemStack = ghost = isInput ? WidgetDataHelper.getInputTagRecorderGhost((Player)mc.player) : WidgetDataHelper.getFuelTagRecorderGhost((Player)mc.player);
            if (!(ghost.isEmpty() || (keys = this.getItemTagKeys(ghost)).isEmpty() || (tags = new ArrayList<ResourceLocation>(isInput ? WidgetDataHelper.getFurnaceInputTags((Player)mc.player) : WidgetDataHelper.getFurnaceFuelTags((Player)mc.player))).contains(sel = keys.get(Math.floorMod(idx = isInput ? this.selectedInputGhostIdx : this.selectedFuelGhostIdx, keys.size()))))) {
                tags.add(sel);
                boolean whitelist = isInput ? WidgetDataHelper.isFurnaceInputTagWhitelist((Player)mc.player) : WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)mc.player);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagFilterPacket(isInput ? UpdateFurnaceTagFilterPacket.Slot.INPUT : UpdateFurnaceTagFilterPacket.Slot.FUEL, tags, whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (isInput) {
                    this.selectedInputRemoveIdx = tags.size() - 1;
                } else {
                    this.selectedFuelRemoveIdx = tags.size() - 1;
                }
            }
            return;
        }
        if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16)) {
            if (button == 0) {
                ItemStack carried = mc.player.containerMenu.getCarried();
                if (!carried.isEmpty()) {
                    if (isInput) {
                        WidgetDataHelper.setInputTagRecorderGhost((Player)mc.player, carried.copy());
                        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagRecorderGhostPacket(UpdateFurnaceTagRecorderGhostPacket.Slot.INPUT, carried.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        WidgetDataHelper.setFuelTagRecorderGhost((Player)mc.player, carried.copy());
                        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagRecorderGhostPacket(UpdateFurnaceTagRecorderGhostPacket.Slot.FUEL, carried.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    List<ResourceLocation> keys = this.getItemTagKeys(carried);
                    if (isInput) {
                        this.selectedInputGhostIdx = 0;
                    } else {
                        this.selectedFuelGhostIdx = 0;
                    }
                }
            } else if (button == 1) {
                if (isInput) {
                    WidgetDataHelper.setInputTagRecorderGhost((Player)mc.player, ItemStack.EMPTY);
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagRecorderGhostPacket(UpdateFurnaceTagRecorderGhostPacket.Slot.INPUT, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    WidgetDataHelper.setFuelTagRecorderGhost((Player)mc.player, ItemStack.EMPTY);
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagRecorderGhostPacket(UpdateFurnaceTagRecorderGhostPacket.Slot.FUEL, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (button == 2) {
                List<ResourceLocation> tags = isInput ? WidgetDataHelper.getFurnaceInputTags((Player)mc.player) : WidgetDataHelper.getFurnaceFuelTags((Player)mc.player);
                boolean whitelist = isInput ? WidgetDataHelper.isFurnaceInputTagWhitelist((Player)mc.player) : WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)mc.player);
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceTagFilterPacket(isInput ? UpdateFurnaceTagFilterPacket.Slot.INPUT : UpdateFurnaceTagFilterPacket.Slot.FUEL, tags, !whitelist), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private List<ResourceLocation> getItemTagKeys(ItemStack stack) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        try {
            Holder holder = BuiltInRegistries.ITEM.wrapAsHolder((Object)stack.getItem());
            holder.tags().forEach(tagKey -> list.add(tagKey.location()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    public void tick() {
        if (!this.isUnlocked()) {
            return;
        }
        if (OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE)) {
            this.logoMode = true;
            return;
        }
        this.logoMode = false;
        this.refreshFromshell();
        boolean bl = this.isSmelting = this.smeltingProgress > 0 && this.fuelBurnTime > 0;
        if (this.infoPopupTimer > 0) {
            --this.infoPopupTimer;
            if (this.infoPopupTimer == 0) {
                this.infoPopupText = null;
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int buttonAreaWidth;
        int currentHeight;
        int currentWidth;
        if (!this.isUnlocked()) {
            int currentHeight2;
            boolean handled = super.mouseClicked(mouseX, mouseY, button);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            int currentWidth2 = this.isExpanded ? 48 : 44;
            int n = currentHeight2 = this.isExpanded ? 62 : 36;
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth2) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight2);
        }
        int x = this.getX();
        int y = this.getY();
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        boolean idle = OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            currentWidth = this.isExpanded ? 150 : 44;
            currentHeight = this.isExpanded ? 110 : 36;
        } else {
            currentWidth = this.isExpanded ? 48 : 44;
            int n = currentHeight = this.isExpanded ? 62 : 36;
        }
        if (button == 1) {
            int titleBarHeight = 12;
            if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + titleBarHeight)) {
                this.showContextMenu = true;
                this.contextMenuX = (int)mouseX;
                this.contextMenuY = (int)mouseY;
                return true;
            }
        }
        if (button == 0 && this.showContextMenu) {
            if (this.handleContextMenuClick(mouseX, mouseY)) {
                return true;
            }
            this.showContextMenu = false;
        }
        if (mouseX < (double)x || mouseX > (double)(x + currentWidth) || mouseY < (double)y || mouseY > (double)(y + currentHeight)) {
            return false;
        }
        if (idle) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
        int furnaceY = y + 2;
        int requiredWidthForThreeButtons = 30;
        int furnaceX = currentWidth >= requiredWidthForThreeButtons ? x + currentWidth - 24 - 6 : x + currentWidth - 16 - 4;
        if (mouseX >= (double)furnaceX && mouseX <= (double)(furnaceX + 8) && mouseY >= (double)furnaceY && mouseY <= (double)(furnaceY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.FURNACE_ENABLED.get();
            OverlayConfig.FURNACE_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
            this.togglePin();
            return true;
        }
        if (currentWidth >= requiredWidthForThreeButtons) {
            int expandX = x + currentWidth - 8 - 2 - 8 - 2;
            int expandY = y + 2;
            if (mouseX >= (double)expandX && mouseX <= (double)(expandX + 8) && mouseY >= (double)expandY && mouseY <= (double)(expandY + 8)) {
                this.toggleExpand();
                return true;
            }
        }
        int n = buttonAreaWidth = currentWidth >= requiredWidthForThreeButtons ? 30 : 20;
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth - buttonAreaWidth) && mouseY >= (double)y && mouseY <= (double)(y + 12) && button == 0) {
            this.startDragging((int)mouseX, (int)mouseY);
            return true;
        }
        int contentY = y + 12;
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            if (this.isExpanded) {
                boolean tagUnlocked;
                int slotY;
                int slotX;
                int i;
                if (this.isPointIn(this.topLabelX, this.topLabelY, this.topLabelW, this.topLabelH, mouseX, mouseY) || this.isPointIn(this.bottomLabelX, this.bottomLabelY, this.bottomLabelW, this.bottomLabelH, mouseX, mouseY)) {
                    this.showInfoPopup(mouseX, mouseY, this.isPointIn(this.topLabelX, this.topLabelY, this.topLabelW, this.topLabelH, mouseX, mouseY));
                    return true;
                }
                int allowed = 3;
                if (Minecraft.getInstance().player != null) {
                    allowed = WidgetDataHelper.getAllowedTemplateSlots((Player)Minecraft.getInstance().player);
                }
                allowed = Math.max(0, Math.min(8, allowed));
                for (i = 0; i < allowed; ++i) {
                    slotX = x + 4 + i * 18;
                    slotY = contentY + 6;
                    boolean bl = tagUnlocked = allowed >= 8;
                    if (tagUnlocked && i == allowed - 1) {
                        boolean overPlus;
                        int startX;
                        int cx = slotX + 8;
                        boolean controlsBelow = true;
                        int cy = controlsBelow ? slotY + 16 + 2 : slotY - 6 - 2;
                        int spacing = 2;
                        int totalW = 18 + spacing * 2;
                        int minusX = startX = cx - totalW / 2;
                        int wlX = startX + 6 + spacing;
                        int plusX = wlX + 6 + spacing;
                        boolean overSlot = this.isMouseOverSlot(mouseX, mouseY, slotX, slotY);
                        boolean overMinus = mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                        boolean overWl = mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                        boolean bl2 = overPlus = mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                        if (!overSlot && !overMinus && !overWl && !overPlus) continue;
                        this.handleTagRecorderClick(true, slotX, slotY, mouseX, mouseY, button);
                        return true;
                    }
                    if (!this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) continue;
                    this.handleTemplateSlotClick(FurnaceTemplateSlotPacket.SlotType.INPUT, i, button);
                    return true;
                }
                for (i = 0; i < allowed; ++i) {
                    boolean isLiquidFuelSlot;
                    slotX = x + 4 + i * 18;
                    slotY = contentY + 68;
                    tagUnlocked = allowed >= 8;
                    boolean bl = isLiquidFuelSlot = tagUnlocked && i == allowed - 2;
                    if (tagUnlocked && i == allowed - 1) {
                        boolean overPlus;
                        int startX;
                        int cx = slotX + 8;
                        boolean controlsBelow = false;
                        int cy = controlsBelow ? slotY + 16 + 2 : slotY - 6 - 2;
                        int spacing = 2;
                        int totalW = 18 + spacing * 2;
                        int minusX = startX = cx - totalW / 2;
                        int wlX = startX + 6 + spacing;
                        int plusX = wlX + 6 + spacing;
                        boolean overSlot = this.isMouseOverSlot(mouseX, mouseY, slotX, slotY);
                        boolean overMinus = mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                        boolean overWl = mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                        boolean bl3 = overPlus = mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                        if (!overSlot && !overMinus && !overWl && !overPlus) continue;
                        this.handleTagRecorderClick(false, slotX, slotY, mouseX, mouseY, button);
                        return true;
                    }
                    if (isLiquidFuelSlot) {
                        if (!this.handleLiquidFuelSlotClick(slotX, slotY, mouseX, mouseY, button)) continue;
                        return true;
                    }
                    if (!this.isMouseOverSlot(mouseX, mouseY, slotX, slotY)) continue;
                    this.handleTemplateSlotClick(FurnaceTemplateSlotPacket.SlotType.FUEL, i, button);
                    return true;
                }
                if (this.isMouseOverSlot(mouseX, mouseY, x + 4, contentY + 26)) {
                    this.handleSlotClick(SlotType.INPUT, button, Screen.hasShiftDown());
                    return true;
                }
                if (this.isMouseOverSlot(mouseX, mouseY, x + 4, contentY + 48)) {
                    this.handleSlotClick(SlotType.FUEL, button, Screen.hasShiftDown());
                    return true;
                }
                if (this.isMouseOverSlot(mouseX, mouseY, x + 26, contentY + 37)) {
                    this.handleSlotClick(SlotType.OUTPUT, button, Screen.hasShiftDown());
                    return true;
                }
                int buttonX = x + 48;
                int buttonY = contentY + 37;
                if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + 16) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 16) && button == 0) {
                    this.handleInputSourceToggle();
                    return true;
                }
            } else {
                if (this.isMouseOverSlot(mouseX, mouseY, x + 4, contentY + 6)) {
                    this.handleSlotClick(SlotType.INPUT, button, Screen.hasShiftDown());
                    return true;
                }
                if (this.isMouseOverSlot(mouseX, mouseY, x + 24, contentY + 6)) {
                    this.handleSlotClick(SlotType.OUTPUT, button, Screen.hasShiftDown());
                    return true;
                }
            }
        } else if (this.isExpanded) {
            if (this.isPointIn(this.topLabelX, this.topLabelY, this.topLabelW, this.topLabelH, mouseX, mouseY) || this.isPointIn(this.bottomLabelX, this.bottomLabelY, this.bottomLabelW, this.bottomLabelH, mouseX, mouseY)) {
                this.showInfoPopup(mouseX, mouseY, this.isPointIn(this.topLabelX, this.topLabelY, this.topLabelW, this.topLabelH, mouseX, mouseY));
                return true;
            }
            if (this.isMouseOverSlot(mouseX, mouseY, x + 4, contentY + 6)) {
                this.handleSlotClick(SlotType.INPUT, button, Screen.hasShiftDown());
                return true;
            }
            if (this.isMouseOverSlot(mouseX, mouseY, x + 4, contentY + 28)) {
                this.handleSlotClick(SlotType.FUEL, button, Screen.hasShiftDown());
                return true;
            }
            if (this.isMouseOverSlot(mouseX, mouseY, x + 26, contentY + 17)) {
                this.handleSlotClick(SlotType.OUTPUT, button, Screen.hasShiftDown());
                return true;
            }
        } else {
            if (this.isMouseOverSlot(mouseX, mouseY, x + 4, contentY + 6)) {
                this.handleSlotClick(SlotType.INPUT, button, Screen.hasShiftDown());
                return true;
            }
            if (this.isMouseOverSlot(mouseX, mouseY, x + 24, contentY + 6)) {
                this.handleSlotClick(SlotType.OUTPUT, button, Screen.hasShiftDown());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int currentHeight;
        int currentWidth;
        if (!this.isUnlocked()) {
            int currentHeight2;
            int currentWidth2;
            boolean handled = super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            Minecraft mc = Minecraft.getInstance();
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
            if (mc.player != null) {
                ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
                currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
            }
            boolean idle = OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
            if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
                currentWidth2 = this.isExpanded ? 150 : 44;
                currentHeight2 = this.isExpanded ? 110 : 36;
            } else {
                currentWidth2 = this.isExpanded ? 48 : 44;
                int n = currentHeight2 = this.isExpanded ? 62 : 36;
            }
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth2) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight2);
        }
        if (this.isDragging && button == 0) {
            this.setPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            if (!OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE)) {
                OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
            }
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        boolean idle = OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            currentWidth = this.isExpanded ? 150 : 44;
            currentHeight = this.isExpanded ? 110 : 36;
        } else {
            currentWidth = this.isExpanded ? 48 : 44;
            int n = currentHeight = this.isExpanded ? 62 : 36;
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight)) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int currentHeight;
        int currentWidth;
        if (!this.isUnlocked()) {
            int currentHeight2;
            int currentWidth2;
            boolean handled = super.mouseReleased(mouseX, mouseY, button);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            Minecraft mc = Minecraft.getInstance();
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
            if (mc.player != null) {
                ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
                currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
            }
            if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
                currentWidth2 = this.isExpanded ? 150 : 44;
                currentHeight2 = this.isExpanded ? 110 : 36;
            } else {
                currentWidth2 = this.isExpanded ? 48 : 44;
                int n = currentHeight2 = this.isExpanded ? 62 : 36;
            }
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth2) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight2);
        }
        if (this.isDragging && button == 0) {
            this.stopDragging();
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        boolean idle = OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            currentWidth = this.isExpanded ? 150 : 44;
            currentHeight = this.isExpanded ? 110 : 36;
        } else {
            currentWidth = this.isExpanded ? 48 : 44;
            int n = currentHeight = this.isExpanded ? 62 : 36;
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight)) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int currentHeight;
        int currentWidth;
        if (!this.isUnlocked()) {
            int currentHeight2;
            int currentWidth2;
            boolean handled = super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
            if (handled) {
                return true;
            }
            int x = this.getX();
            int y = this.getY();
            Minecraft mc = Minecraft.getInstance();
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
            if (mc.player != null) {
                ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
                currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
            }
            if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
                currentWidth2 = this.isExpanded ? 150 : 44;
                currentHeight2 = this.isExpanded ? 110 : 36;
            } else {
                currentWidth2 = this.isExpanded ? 48 : 44;
                int n = currentHeight2 = this.isExpanded ? 62 : 36;
            }
            return mouseX >= (double)x && mouseX <= (double)(x + currentWidth2) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight2);
        }
        int x = this.getX();
        int y = this.getY();
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        boolean idle = OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            int n = idle ? 44 : (currentWidth = this.isExpanded ? 150 : 44);
            currentHeight = idle ? 36 : (this.isExpanded ? 110 : 36);
        } else {
            int n = idle ? 44 : (currentWidth = this.isExpanded ? 48 : 44);
            int n2 = idle ? 36 : (currentHeight = this.isExpanded ? 62 : 36);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight)) {
            if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II && this.isExpanded) {
                int startX;
                int allowed = 3;
                if (Minecraft.getInstance().player != null) {
                    allowed = WidgetDataHelper.getAllowedTemplateSlots((Player)Minecraft.getInstance().player);
                }
                boolean tagUnlocked = (allowed = Math.max(0, Math.min(8, allowed))) >= 8;
                int inputTagX = x + 4 + (allowed - 1) * 18;
                int inputTagY = y + 12 + 6;
                int fuelTagX = x + 4 + (allowed - 1) * 18;
                int fuelTagY = y + 12 + 68;
                boolean overInputTag = false;
                boolean overFuelTag = false;
                int cx = inputTagX + 8;
                boolean controlsBelow = true;
                int cy = controlsBelow ? inputTagY + 16 + 2 : inputTagY - 6 - 2;
                int spacing = 2;
                int totalW = 18 + spacing * 2;
                int minusX = startX = cx - totalW / 2;
                int wlX = startX + 6 + spacing;
                int plusX = wlX + 6 + spacing;
                boolean overSlot = this.isMouseOverSlot(mouseX, mouseY, inputTagX, inputTagY);
                boolean overMinus = mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                boolean overWl = mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                boolean overPlus = mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                overInputTag = overSlot || overMinus || overWl || overPlus;
                cx = fuelTagX + 8;
                controlsBelow = false;
                cy = controlsBelow ? fuelTagY + 16 + 2 : fuelTagY - 6 - 2;
                spacing = 2;
                totalW = 18 + spacing * 2;
                minusX = startX = cx - totalW / 2;
                wlX = startX + 6 + spacing;
                plusX = wlX + 6 + spacing;
                overSlot = this.isMouseOverSlot(mouseX, mouseY, fuelTagX, fuelTagY);
                overMinus = mouseX >= (double)minusX && mouseX <= (double)(minusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                overWl = mouseX >= (double)wlX && mouseX <= (double)(wlX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                overPlus = mouseX >= (double)plusX && mouseX <= (double)(plusX + 6) && mouseY >= (double)cy && mouseY <= (double)(cy + 6);
                boolean bl = overFuelTag = overSlot || overMinus || overWl || overPlus;
                if (tagUnlocked && (overInputTag || overFuelTag)) {
                    int dir;
                    int startX2;
                    boolean isInput = overInputTag;
                    int cx2 = (isInput ? inputTagX : fuelTagX) + 8;
                    boolean controlsBelow2 = isInput;
                    int cy2 = controlsBelow2 ? (isInput ? inputTagY : fuelTagY) + 16 + 2 : (isInput ? inputTagY : fuelTagY) - 6 - 2;
                    int spacing2 = 2;
                    int totalW2 = 18 + spacing2 * 2;
                    int minusX2 = startX2 = cx2 - totalW2 / 2;
                    int wlX2 = startX2 + 6 + spacing2;
                    int plusX2 = wlX2 + 6 + spacing2;
                    overMinus = mouseX >= (double)minusX2 && mouseX <= (double)(minusX2 + 6) && mouseY >= (double)cy2 && mouseY <= (double)(cy2 + 6);
                    boolean overPlus2 = mouseX >= (double)plusX2 && mouseX <= (double)(plusX2 + 6) && mouseY >= (double)cy2 && mouseY <= (double)(cy2 + 6);
                    int n = dir = deltaY > 0.0 ? -1 : 1;
                    if (overPlus2) {
                        List keys;
                        ItemStack ghost = isInput ? WidgetDataHelper.getInputTagRecorderGhost((Player)Minecraft.getInstance().player) : WidgetDataHelper.getFuelTagRecorderGhost((Player)Minecraft.getInstance().player);
                        List<Object> list = keys = ghost.isEmpty() ? List.of() : this.getItemTagKeys(ghost);
                        if (!keys.isEmpty()) {
                            if (isInput) {
                                this.selectedInputGhostIdx = Math.floorMod(this.selectedInputGhostIdx + dir, keys.size());
                            } else {
                                this.selectedFuelGhostIdx = Math.floorMod(this.selectedFuelGhostIdx + dir, keys.size());
                            }
                            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
                            return true;
                        }
                    } else if (overMinus) {
                        List<ResourceLocation> tags;
                        List<ResourceLocation> list = tags = isInput ? WidgetDataHelper.getFurnaceInputTags((Player)Minecraft.getInstance().player) : WidgetDataHelper.getFurnaceFuelTags((Player)Minecraft.getInstance().player);
                        if (!tags.isEmpty()) {
                            if (isInput) {
                                this.selectedInputRemoveIdx = Math.floorMod(this.selectedInputRemoveIdx + dir, tags.size());
                            } else {
                                this.selectedFuelRemoveIdx = Math.floorMod(this.selectedFuelRemoveIdx + dir, tags.size());
                            }
                            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
                            return true;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isUnlocked()) {
            boolean handled = super.keyPressed(keyCode, scanCode, modifiers);
            if (handled) {
                return true;
            }
            return this.isHovered();
        }
        if (this.isHovered() && keyCode == 81) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void toggleExpand() {
        this.isExpanded = !this.isExpanded;
        this.saveExpandedStateToConfig();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)1.0f));
    }

    private boolean isMouseOverSlot(double mouseX, double mouseY, int slotX, int slotY) {
        return mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16);
    }

    private boolean isPointIn(int rx, int ry, int rw, int rh, double px, double py) {
        return px >= (double)rx && px <= (double)(rx + rw) && py >= (double)ry && py <= (double)(ry + rh);
    }

    private void showInfoPopup(double mouseX, double mouseY, boolean isTop) {
        if (this.isHovered()) {
            OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
        }
        String which = isTop ? "speed" : "fuel efficiency";
        this.infoPopupText = "Currently your backpack's " + which + " to normal furnace, you can improve it in upgrade";
        this.infoPopupTimer = 60;
        int pad = 4;
        int popupW = this.font.width(this.infoPopupText) + pad * 2;
        Objects.requireNonNull(this.font);
        int popupH = 9 + pad * 2;
        Minecraft mc = Minecraft.getInstance();
        int screenW = mc.getWindow().getGuiScaledWidth();
        int screenH = mc.getWindow().getGuiScaledHeight();
        int px = (int)mouseX + 8;
        int py = (int)mouseY + 8;
        if (px + popupW > screenW) {
            px = (int)mouseX - popupW - 8;
        }
        if (py + popupH > screenH) {
            py = (int)mouseY - popupH - 8;
        }
        px = Math.max(0, px);
        py = Math.max(0, py);
        this.infoPopupX = px;
        this.infoPopupY = py;
    }

    private void handleSlotClick(SlotType slotType, int button, boolean isShiftDown) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.gameMode == null) {
            return;
        }
        if (isShiftDown && button == 0) {
            MoveItemToShellPacket.SlotType packetSlotType = switch (slotType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> MoveItemToShellPacket.SlotType.INPUT;
                case 1 -> MoveItemToShellPacket.SlotType.FUEL;
                case 2 -> MoveItemToShellPacket.SlotType.OUTPUT;
            };
            PacketDistributor.sendToServer((CustomPacketPayload)new MoveItemToShellPacket(MoveItemToShellPacket.WidgetType.FURNACE, packetSlotType), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        ItemStack carried = mc.player.containerMenu.getCarried();
        switch (slotType.ordinal()) {
            case 0: {
                if (button == 0) {
                    if (!carried.isEmpty()) {
                        if (this.inputItem.isEmpty()) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.INPUT, FurnaceSlotInteractionPacket.ActionType.PUT_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            break;
                        }
                        if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)this.inputItem)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.INPUT, FurnaceSlotInteractionPacket.ActionType.MERGE_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            break;
                        }
                        PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.INPUT, FurnaceSlotInteractionPacket.ActionType.PUT_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        break;
                    }
                    if (this.inputItem.isEmpty()) break;
                    PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.INPUT, FurnaceSlotInteractionPacket.ActionType.TAKE_ITEM, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                if (button != 1) break;
                if (carried.isEmpty() && !this.inputItem.isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.INPUT, FurnaceSlotInteractionPacket.ActionType.TAKE_HALF, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                if (carried.isEmpty() || !this.inputItem.isEmpty()) break;
                PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.INPUT, FurnaceSlotInteractionPacket.ActionType.PUT_ONE, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case 1: {
                ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
                WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
                if (!this.isExpanded && currentTier != WidgetUnlockSystem.WidgetTier.TIER_II) break;
                if (button == 0) {
                    if (!carried.isEmpty()) {
                        if (carried.getBurnTime(RecipeType.SMELTING) <= 0) break;
                        if (this.fuelItem.isEmpty()) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.FUEL, FurnaceSlotInteractionPacket.ActionType.PUT_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            break;
                        }
                        if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)this.fuelItem)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.FUEL, FurnaceSlotInteractionPacket.ActionType.MERGE_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            break;
                        }
                        PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.FUEL, FurnaceSlotInteractionPacket.ActionType.PUT_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        break;
                    }
                    if (this.fuelItem.isEmpty()) break;
                    PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.FUEL, FurnaceSlotInteractionPacket.ActionType.TAKE_ITEM, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                if (button != 1) break;
                if (carried.isEmpty() && !this.fuelItem.isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.FUEL, FurnaceSlotInteractionPacket.ActionType.TAKE_HALF, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                if (carried.isEmpty() || !this.fuelItem.isEmpty() || carried.getBurnTime(RecipeType.SMELTING) <= 0) break;
                PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.FUEL, FurnaceSlotInteractionPacket.ActionType.PUT_ONE, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case 2: {
                if (button == 0) {
                    if (carried.isEmpty() && !this.outputItem.isEmpty()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.OUTPUT, FurnaceSlotInteractionPacket.ActionType.TAKE_ITEM, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        break;
                    }
                    if (carried.isEmpty() || this.outputItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)this.outputItem)) break;
                    PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.OUTPUT, FurnaceSlotInteractionPacket.ActionType.MERGE_ITEM, carried), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                if (button != 1 || !carried.isEmpty() || this.outputItem.isEmpty()) break;
                PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceSlotInteractionPacket(FurnaceSlotInteractionPacket.SlotType.OUTPUT, FurnaceSlotInteractionPacket.ActionType.TAKE_HALF, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private void handleTemplateSlotClick(FurnaceTemplateSlotPacket.SlotType slotType, int slotIndex, int button) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (button == 0) {
            ItemStack carried = mc.player.containerMenu.getCarried();
            if (!carried.isEmpty()) {
                ItemStack templateItem = carried.copy();
                templateItem.setCount(1);
                PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceTemplateSlotPacket(slotType, slotIndex, templateItem), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)1.0f, (float)1.2f));
            }
        } else if (button == 1) {
            PacketDistributor.sendToServer((CustomPacketPayload)new FurnaceTemplateSlotPacket(slotType, slotIndex, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)0.8f, (float)0.9f));
        }
    }

    @Override
    protected void stopDragging() {
        super.stopDragging();
        this.savePositionToConfig();
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.FURNACE);
    }

    private void handleInputSourceToggle() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleFurnaceInputSourcePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int expandX;
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int furnaceY = y + 2;
        int requiredWidthForThreeButtons = 30;
        int furnaceX = currentWidth >= requiredWidthForThreeButtons ? x + currentWidth - 24 - 6 : x + currentWidth - 16 - 4;
        boolean furnaceHovered = mouseX >= furnaceX && mouseX <= furnaceX + 8 && mouseY >= furnaceY && mouseY <= furnaceY + 8;
        boolean furnaceEnabled = (Boolean)OverlayConfig.FURNACE_ENABLED.get();
        int n = buttonColor = furnaceEnabled ? -11751600 : -769226;
        if (furnaceHovered) {
            buttonColor = furnaceEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(furnaceX, furnaceY, furnaceX + 8, furnaceY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, pinColor);
        } else {
            pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, pinColor);
        }
        int expandY = y + 2;
        boolean expandHovered = false;
        if (currentWidth >= requiredWidthForThreeButtons) {
            expandX = x + currentWidth - 8 - 2 - 8 - 2;
            expandHovered = mouseX >= expandX && mouseX <= expandX + 8 && mouseY >= expandY && mouseY <= expandY + 8;
        } else {
            expandX = -1;
        }
        if (expandX >= 0) {
            guiGraphics.fill(expandX, expandY, expandX + 8, expandY + 8, Theme.buttonBg(expandHovered));
        }
        if (expandX >= 0) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)expandX, (float)expandY, 0.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            ResourceLocation icon2 = Theme.icon(this.isExpanded ? "collapse" : "expand");
            try {
                guiGraphics.blit(icon2, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            catch (Throwable t) {
                guiGraphics.pose().popPose();
                int iconColor2 = -1;
                if (this.isExpanded) {
                    guiGraphics.fill(expandX + 2, expandY + 4, expandX + 6, expandY + 5, iconColor2);
                } else {
                    guiGraphics.fill(expandX + 2, expandY + 4, expandX + 6, expandY + 5, iconColor2);
                    guiGraphics.fill(expandX + 4, expandY + 2, expandX + 5, expandY + 6, iconColor2);
                }
                return;
            }
            guiGraphics.pose().popPose();
        }
        if (pinHovered) {
            String pinText = this.isPinned ? Component.translatable((String)"nomadsshell.ui.unpin").getString() : Component.translatable((String)"nomadsshell.ui.pin").getString();
            guiGraphics.drawString(this.font, pinText, pinX - 15, pinY - 12, -1);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    protected void drawWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        if (this.isUnlocked()) {
            super.drawWidgetBackground(guiGraphics, currentWidth, currentHeight);
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int currentHeight;
        int currentWidth;
        boolean imageEnabled2;
        if (!this.isUnlocked()) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        boolean bl = this.logoMode = (imageEnabled2 = ((Boolean)OverlayConfig.FURNACE_USE_IMAGE_MODE.get()).booleanValue()) && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.FURNACE);
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            currentWidth = this.isExpanded ? 150 : 44;
            currentHeight = this.isExpanded ? 110 : 36;
        } else {
            currentWidth = this.isExpanded ? 48 : 44;
            currentHeight = this.isExpanded ? 62 : 36;
        }
        this.width = currentWidth;
        this.height = currentHeight;
        this.drawFurnaceWidgetBackground(guiGraphics, currentWidth, currentHeight);
        this.renderMainContent(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawFurnaceWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + currentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.panelBg());
        if (this.isHovered() || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, hoverOverlay);
        }
    }

    private void saveInputToshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            WidgetDataHelper.setFurnaceInputItem((Player)mc.player, this.inputItem);
        }
    }

    private void saveFuelToshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            WidgetDataHelper.setFurnaceFuelItem((Player)mc.player, this.fuelItem);
        }
    }

    private void saveOutputToshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            WidgetDataHelper.setFurnaceOutputItem((Player)mc.player, this.outputItem);
        }
    }

    private void saveProgressToshell() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            WidgetDataHelper.setFurnaceSmeltingProgress((Player)mc.player, this.smeltingProgress);
            WidgetDataHelper.setFurnaceFuelBurnTime((Player)mc.player, this.fuelBurnTime);
            WidgetDataHelper.setFurnaceMaxFuelBurnTime((Player)mc.player, this.maxFuelBurnTime);
        }
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public ItemStack getFuelItem() {
        return this.fuelItem;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public boolean isSmelting() {
        return this.isSmelting;
    }

    public float getSmeltingProgress() {
        return (float)this.smeltingProgress / (float)this.maxSmeltingTime;
    }

    public float getFuelProgress() {
        return this.maxFuelBurnTime > 0 ? (float)this.fuelBurnTime / (float)this.maxFuelBurnTime : 0.0f;
    }

    public int getCurrentWidth() {
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            return this.isExpanded ? 150 : 44;
        }
        return this.isExpanded ? 48 : 44;
    }

    public int getCurrentHeight() {
        Minecraft mc = Minecraft.getInstance();
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.WidgetTier.TIER_I;
        if (mc.player != null) {
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            currentTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
        }
        if (currentTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            return this.isExpanded ? 110 : 36;
        }
        return this.isExpanded ? 62 : 36;
    }

    public int getWidth() {
        return this.getCurrentWidth();
    }

    public int getHeight() {
        return this.getCurrentHeight();
    }

    private void drawLiquidFuelSlot(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int labelColor;
        String tankLabel;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        int LIQUID_FUEL_BORDER_COLOR = -1672674;
        int LIQUID_FUEL_BG_COLOR = -7650029;
        guiGraphics.fill(x - 1, y - 1, x + 16 + 1, y + 16 + 1, -1672674);
        guiGraphics.fill(x, y, x + 16, y + 16, -7650029);
        boolean enabled = WidgetDataHelper.isFurnaceLiquidFuelEnabled((Player)mc.player);
        int targetTank = WidgetDataHelper.getFurnaceLiquidFuelTargetTank((Player)mc.player);
        if (targetTank == 0) {
            tankLabel = "X";
            labelColor = -38037;
        } else {
            tankLabel = String.valueOf(targetTank);
            labelColor = enabled ? -9699477 : -5215233;
        }
        int labelWidth = this.font.width(tankLabel);
        int labelX = x + (16 - labelWidth) / 2;
        Objects.requireNonNull(this.font);
        int labelY = y + (16 - 9) / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)labelX, (float)labelY, 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.0f);
        guiGraphics.drawString(this.font, tankLabel, 0, 0, labelColor, false);
        guiGraphics.pose().popPose();
        if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
            String tooltip = Component.translatable((String)"nomadsshell.furnace.liquid_fuel.cycle_tooltip").getString();
            this.drawTooltip(guiGraphics, tooltip, mouseX, mouseY);
        }
    }

    private boolean handleLiquidFuelSlotClick(int slotX, int slotY, double mouseX, double mouseY, int button) {
        if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16)) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                boolean cycleForward = button == 0;
                WidgetDataHelper.cycleFurnaceLiquidFuelTargetTank((Player)mc.player, cycleForward);
                int newTargetTank = WidgetDataHelper.getFurnaceLiquidFuelTargetTank((Player)mc.player);
                if (newTargetTank > 0) {
                    WidgetDataHelper.setFurnaceLiquidFuelEnabled((Player)mc.player, true);
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFurnaceLiquidFuelPacket(WidgetDataHelper.isFurnaceLiquidFuelEnabled((Player)mc.player), newTargetTank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return false;
    }

    private void drawTooltip(GuiGraphics guiGraphics, String text, int mouseX, int mouseY) {
        int pad = 4;
        int textWidth = this.font.width(text);
        int tooltipWidth = textWidth + pad * 2;
        Objects.requireNonNull(this.font);
        int tooltipHeight = 9 + pad * 2;
        int tooltipX = mouseX + 8;
        int tooltipY = mouseY + 8;
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        if (tooltipX + tooltipWidth > screenWidth) {
            tooltipX = mouseX - tooltipWidth - 8;
        }
        if (tooltipY + tooltipHeight > screenHeight) {
            tooltipY = mouseY - tooltipHeight - 8;
        }
        tooltipX = Math.max(0, tooltipX);
        tooltipY = Math.max(0, tooltipY);
        guiGraphics.fill(tooltipX + 2, tooltipY + 2, tooltipX + tooltipWidth + 2, tooltipY + tooltipHeight + 2, 0x77000000);
        guiGraphics.fill(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -870375649);
        guiGraphics.fill(tooltipX - 1, tooltipY - 1, tooltipX + tooltipWidth + 1, tooltipY, -1);
        guiGraphics.fill(tooltipX - 1, tooltipY + tooltipHeight, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, -1);
        guiGraphics.fill(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight, -1);
        guiGraphics.fill(tooltipX + tooltipWidth, tooltipY, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight, -1);
        guiGraphics.drawString(this.font, text, tooltipX + pad, tooltipY + pad, -1, false);
    }

    private static enum SlotType {
        INPUT,
        FUEL,
        OUTPUT;

    }
}

