/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.menu.IShellMenu;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class MagnetWidget
extends LockableWidget {
    private final IShellMenu menu;
    private boolean logoMode = false;
    private int pullRange = 8;

    public MagnetWidget(int x, int y, Font font, IShellMenu menu) {
        super(MagnetWidget.loadPositionX(x), MagnetWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.magnet"), font, WidgetUnlockSystem.WidgetType.MAGNET, menu);
        this.menu = menu;
        this.isPinned = (Boolean)OverlayConfig.MAGNET_PINNED.get();
        this.updateWidgetDimensions();
    }

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.MAGNET_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.MAGNET_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    @Override
    protected void updateWidgetDimensions() {
        this.width = 36;
        this.height = 36;
    }

    @Override
    protected void renderExpandedContent(GuiGraphics g, int mouseX, int mouseY, float pt) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float pt) {
        boolean titleBarHovered;
        boolean hoveredWidget;
        this.updateWidgetDimensions();
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean imageEnabled = (Boolean)OverlayConfig.MAGNET_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.MAGNET);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, w, h - 12);
            return;
        }
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x - 1, y - 1, x + w + 1, y + 12, Theme.panelBorder());
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        boolean bl2 = titleBarHovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            g.fill(x, y, x + w, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = h - 12;
        g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
        int rangeY = contentY + 4;
        g.drawString(this.font, String.valueOf(this.pullRange), x + 4, rangeY, Theme.textOnPanel());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.magnet.blocks").getString(), x + 4, rangeY + 10, Theme.textOnPanel());
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int magnetX = x + currentWidth - 16 - 4;
        int magnetY = y + 2;
        boolean magnetHovered = mouseX >= magnetX && mouseX <= magnetX + 8 && mouseY >= magnetY && mouseY <= magnetY + 8;
        boolean magnetEnabled = (Boolean)OverlayConfig.MAGNET_ENABLED.get();
        int n = buttonColor = magnetEnabled ? -11751600 : -769226;
        if (magnetHovered) {
            buttonColor = magnetEnabled ? -10044566 : -38037;
        }
        guiGraphics.fill(magnetX, magnetY, magnetX + 8, magnetY + 8, buttonColor);
        if (!magnetEnabled) {
            int c = -1;
            guiGraphics.fill(magnetX + 1, magnetY + 3, magnetX + 7, magnetY + 3, c);
            guiGraphics.fill(magnetX + 1, magnetY + 4, magnetX + 7, magnetY + 4, c);
            guiGraphics.fill(magnetX + 2, magnetY + 1, magnetX + 3, magnetY + 1, c);
            guiGraphics.fill(magnetX + 5, magnetY + 1, magnetX + 6, magnetY + 1, c);
            guiGraphics.fill(magnetX + 2, magnetY + 2, magnetX + 2, magnetY + 3, c);
            guiGraphics.fill(magnetX + 5, magnetY + 2, magnetX + 5, magnetY + 3, c);
            guiGraphics.fill(magnetX + 2, magnetY + 6, magnetX + 3, magnetY + 6, c);
            guiGraphics.fill(magnetX + 5, magnetY + 6, magnetX + 6, magnetY + 6, c);
            guiGraphics.fill(magnetX + 2, magnetY + 4, magnetX + 2, magnetY + 5, c);
            guiGraphics.fill(magnetX + 5, magnetY + 4, magnetX + 5, magnetY + 5, c);
        }
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, pinColor);
        } else {
            int pinColor = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, pinColor);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, pinColor);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.MAGNET_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.MAGNET_USE_IMAGE_MODE.get();
        OverlayConfig.MAGNET_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void renderLogoIcon(GuiGraphics g, int x, int y, int w, int h) {
        int iconSize = 16;
        int iconX = x + (w - iconSize) / 2;
        int iconY = y + (h - iconSize) / 2;
        g.blit(Theme.icon("magnet"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean onTitleBar;
        boolean inside;
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.MAGNET);
        this.logoMode = false;
        int magnetX = x + w - 16 - 4;
        int magnetY = y + 2;
        if (mouseX >= (double)magnetX && mouseX <= (double)(magnetX + 8) && mouseY >= (double)magnetY && mouseY <= (double)(magnetY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.MAGNET_ENABLED.get();
            OverlayConfig.MAGNET_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        int pinX = x + w - 8 - 2;
        int pinY = y + 2;
        if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
            this.togglePin();
            return true;
        }
        int titleBarHeight = 12;
        boolean bl2 = onTitleBar = mouseY >= (double)y && mouseY <= (double)(y + titleBarHeight);
        if (onTitleBar) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int x = this.getX();
        int y = this.getY();
        if (mouseX >= (double)x && mouseX <= (double)(x + this.width) && mouseY >= (double)y && mouseY <= (double)(y + this.height)) {
            this.pullRange = delta > 0.0 ? Math.min(16, this.pullRange + 1) : Math.max(1, this.pullRange - 1);
            return true;
        }
        return false;
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    protected void savePositionToConfig() {
        OverlayConfig.MAGNET_X.set((Object)this.getX());
        OverlayConfig.MAGNET_Y.set((Object)this.getY());
    }

    protected void savePinStateToConfig() {
        OverlayConfig.MAGNET_PINNED.set((Object)this.isPinned());
    }
}

