/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import java.util.EnumMap;
import java.util.Map;

public final class OverlayIdleState {
    private static final long TIMEOUT_MS = 10000L;
    private static final Map<WidgetUnlockSystem.WidgetType, Long> lastInteractionMs = new EnumMap<WidgetUnlockSystem.WidgetType, Long>(WidgetUnlockSystem.WidgetType.class);

    private OverlayIdleState() {
    }

    private static void ensureInitialized(WidgetUnlockSystem.WidgetType type) {
        lastInteractionMs.computeIfAbsent(type, t -> System.currentTimeMillis());
    }

    public static void recordInteraction(WidgetUnlockSystem.WidgetType type) {
        lastInteractionMs.put(type, System.currentTimeMillis());
    }

    public static boolean isTimedOut(WidgetUnlockSystem.WidgetType type) {
        OverlayIdleState.ensureInitialized(type);
        long last = lastInteractionMs.get((Object)type);
        return System.currentTimeMillis() - last >= 10000L;
    }

    public static long millisSinceLastInteraction(WidgetUnlockSystem.WidgetType type) {
        OverlayIdleState.ensureInitialized(type);
        return System.currentTimeMillis() - lastInteractionMs.get((Object)type);
    }
}

