/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.AllSettingsScreen;
import com.etka.nomadsshell.client.screen.overlay.OverlayManager;
import com.etka.nomadsshell.client.screen.overlay.OverlayWidget;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.UpdateShellDimensionsPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.network.PacketDistributor;

public class SettingsWidget
extends OverlayWidget {
    private static final int MIN_WIDTH = 1;
    private static final int MIN_HEIGHT = 1;
    private static final int SETTINGS_EXPANDED_WIDTH = 150;
    private static final int SETTINGS_EXPANDED_HEIGHT = 60;
    private final IShellMenu menu;
    private final OverlayManager overlayManager;
    private boolean isHovering = false;
    private boolean isInitializing = true;
    private int shellWidth = 0;
    private int shellHeight = 0;
    private int maxWidth = 16;
    private int maxHeight = 16;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private boolean hasPendingChanges = false;
    private float animationTime = 0.0f;
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int CONTENT_MARGIN = 4;
    private static final int BUTTON_SIZE = 12;
    private static final int BUTTON_SPACING = 2;
    private static final int MEM_BTN_W = 130;
    private static final int MEM_BTN_H = 12;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.SETTINGS_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.SETTINGS_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    @Override
    protected void toggleExpansion() {
        super.toggleExpansion();
        this.saveExpandedStateToConfig();
        this.width = this.isExpanded ? 150 : 36;
        this.height = this.isExpanded ? Math.max(60, this.calculateExpandedHeight()) : 36;
    }

    private void savePositionToConfig() {
        if (this.isInitializing) {
            return;
        }
        try {
            OverlayConfig.SETTINGS_X.set((Object)this.getX());
            OverlayConfig.SETTINGS_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePinStateToConfig() {
        if (this.isInitializing) {
            return;
        }
        try {
            OverlayConfig.SETTINGS_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveExpandedStateToConfig() {
        if (this.isInitializing) {
            return;
        }
        try {
            OverlayConfig.SETTINGS_EXPANDED.set((Object)this.isExpanded);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SettingsWidget(int x, int y, Font font, IShellMenu menu, OverlayManager overlayManager) {
        super(SettingsWidget.loadPositionX(x), SettingsWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.settings"), font);
        this.menu = menu;
        this.overlayManager = overlayManager;
        this.canExpand = true;
        this.isPinned = (Boolean)OverlayConfig.SETTINGS_PINNED.get();
        this.isExpanded = (Boolean)OverlayConfig.SETTINGS_EXPANDED.get();
        this.width = this.isExpanded ? 150 : 36;
        this.height = this.isExpanded ? Math.max(60, this.calculateExpandedHeight()) : 36;
        this.updateCurrentDimensions();
        this.isInitializing = false;
    }

    @Override
    protected void drawWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
    }

    private int calculateExpandedHeight() {
        int contentTop = 12;
        int lineY = contentTop + 10;
        int lastBottom = lineY + 10;
        lastBottom = (lineY += 18) + 10;
        lastBottom = (lineY += 18) + 10;
        lastBottom = (lineY += 18) + 10;
        lastBottom = (lineY += 18) + 10;
        lastBottom = (lineY += 20) + 10;
        lastBottom = (lineY += 18) + 10;
        lastBottom = (lineY += 18) + 10;
        int mode = OverlayConfig.getDisplayMode();
        if (mode == 1 || mode == 3) {
            lastBottom = (lineY += 18) + 10;
        }
        if (mode == 2 || mode == 3) {
            lastBottom = (lineY += 18) + 10;
        }
        int bottomPadding = 8;
        return lastBottom + bottomPadding;
    }

    private void updateCurrentDimensions() {
        if (this.menu.getshellStack() != null && !this.menu.getshellStack().isEmpty()) {
            ShellItem shell = (ShellItem)this.menu.getshellStack().getItem();
            int actualWidth = shell.getWidth(this.menu.getshellStack());
            int actualHeight = shell.getHeight(this.menu.getshellStack());
            if (this.hasPendingChanges && this.cachedWidth == actualWidth && this.cachedHeight == actualHeight) {
                this.hasPendingChanges = false;
            }
            if (this.hasPendingChanges && this.cachedWidth != -1 && this.cachedHeight != -1) {
                this.shellWidth = this.cachedWidth;
                this.shellHeight = this.cachedHeight;
            } else {
                this.shellWidth = actualWidth;
                this.shellHeight = actualHeight;
                if (this.cachedWidth == -1 || this.cachedHeight == -1) {
                    this.cachedWidth = this.shellWidth;
                    this.cachedHeight = this.shellHeight;
                }
            }
            ShellTier tier = shell.getTier();
            this.maxWidth = ShellConfig.SERVER.getWidth(tier);
            this.maxHeight = ShellConfig.SERVER.getHeight(tier);
        } else {
            this.shellWidth = 9;
            this.shellHeight = 6;
            this.maxWidth = 9;
            this.maxHeight = 6;
            this.cachedWidth = this.shellWidth;
            this.cachedHeight = this.shellHeight;
            this.hasPendingChanges = false;
        }
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean titleBarHovered;
        int x = this.getX();
        int y = this.getY();
        this.animationTime += partialTick;
        int currentWidth = this.isExpanded ? 150 : 36;
        int dynamicExpandedHeight = Math.max(60, this.calculateExpandedHeight());
        int currentHeight = this.isExpanded ? dynamicExpandedHeight : 36;
        this.width = currentWidth;
        this.height = currentHeight;
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + 12, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        boolean bl = titleBarHovered = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + currentWidth, y + 12, hoverOverlay);
        }
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, -1);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, -1);
        } else {
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, -5592406);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, -5592406);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, -5592406);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, -5592406);
        }
        int expandX = x + currentWidth - 8 - 2 - 8 - 2;
        int expandY = y + 2;
        boolean expandHovered = mouseX >= expandX && mouseX <= expandX + 8 && mouseY >= expandY && mouseY <= expandY + 8;
        guiGraphics.fill(expandX, expandY, expandX + 8, expandY + 8, Theme.buttonBg(expandHovered));
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        float scale = 0.5f;
        int drawSize = 8;
        int iconX = expandX + (8 - drawSize) / 2;
        int iconY = expandY + (8 - drawSize) / 2;
        pose.translate((float)iconX, (float)iconY, 0.0f);
        pose.scale(scale, scale, 1.0f);
        ResourceLocation expandIcon = Theme.icon(this.isExpanded ? "collapse" : "expand");
        guiGraphics.blit(expandIcon, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        pose.popPose();
        int contentY = y + 12;
        int contentHeight = currentHeight - 12;
        guiGraphics.fill(x, contentY, x + currentWidth, contentY + contentHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, contentY - 1, x + currentWidth + 1, contentY + contentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, contentY, x + currentWidth, contentY + contentHeight, Theme.panelBg());
        if (!this.isExpanded) {
            this.renderSettingsIcon(guiGraphics, x + 18 - 8, contentY + 12 - 8);
        } else {
            this.renderExpandedContent(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.isHovering = this.isMouseOver(mouseX, mouseY);
        if (this.isHovering && !this.isExpanded) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, contentY, x + 36, contentY + 24, hoverOverlay);
        }
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
    }

    private void renderSettingsIcon(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(Theme.icon("setting"), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int buttonAreaWidth;
        int contentY;
        if (!this.visible || !this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int currentWidth = this.isExpanded ? 150 : 36;
        int currentHeight = this.isExpanded ? Math.max(60, this.calculateExpandedHeight()) : 36;
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
            this.togglePin();
            return true;
        }
        int expandX = x + currentWidth - 8 - 2 - 8 - 2;
        int expandY = y + 2;
        if (mouseX >= (double)expandX && mouseX <= (double)(expandX + 8) && mouseY >= (double)expandY && mouseY <= (double)(expandY + 8)) {
            this.toggleExpansion();
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        if (this.isExpanded && button == 0) {
            int allBtnX = x + 10;
            contentY = y + 12;
            int lineY = contentY + 10;
            int allBtnY = lineY - 2;
            int allBtnW = 130;
            int allBtnH = 12;
            if (this.isMouseOver((int)mouseX, (int)mouseY, allBtnX, allBtnY, allBtnW, allBtnH)) {
                this.openAllSettingsScreen();
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int memBtnX = x + 10;
            int memBtnY = lineY + 18 - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, memBtnX, memBtnY, 130, 12)) {
                if (this.overlayManager != null) {
                    this.overlayManager.setMemorizeMode(!this.overlayManager.isMemorizeModeActive());
                }
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int tooltipBtnX = x + 10;
            int tooltipBtnY = lineY + 36 - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, tooltipBtnX, tooltipBtnY, 130, 12)) {
                boolean currentValue = (Boolean)OverlayConfig.MEMORIZE_SLOT_SHOW_TOOLTIPS.get();
                OverlayConfig.MEMORIZE_SLOT_SHOW_TOOLTIPS.set((Object)(!currentValue ? 1 : 0));
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int throwBtnX = x + 10;
            int throwBtnY = lineY + 54 - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, throwBtnX, throwBtnY, 130, 12)) {
                boolean currentValue = (Boolean)OverlayConfig.ENABLE_ITEM_THROWING.get();
                OverlayConfig.ENABLE_ITEM_THROWING.set((Object)(!currentValue ? 1 : 0));
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int widthLineY = lineY + 72;
            int heightLineY = widthLineY + 20;
            this.updateCurrentDimensions();
            int widthDecX = x + 60;
            int widthDecY = widthLineY - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, widthDecX, widthDecY, 12, 12) && this.shellWidth > 1) {
                this.changeDimension(this.shellWidth - 1, this.shellHeight);
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int widthIncX = x + 120;
            int widthIncY = widthLineY - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, widthIncX, widthIncY, 12, 12) && this.shellWidth < this.maxWidth) {
                this.changeDimension(this.shellWidth + 1, this.shellHeight);
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int heightDecX = x + 60;
            int heightDecY = heightLineY - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, heightDecX, heightDecY, 12, 12) && this.shellHeight > 1) {
                this.changeDimension(this.shellWidth, this.shellHeight - 1);
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int heightIncX = x + 120;
            int heightIncY = heightLineY - 2;
            if (this.isMouseOver((int)mouseX, (int)mouseY, heightIncX, heightIncY, 12, 12) && this.shellHeight < this.maxHeight) {
                this.changeDimension(this.shellWidth, this.shellHeight + 1);
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int modeBtnX = x + 60;
            int modeLineY = heightLineY + 18;
            int modeBtnY = modeLineY - 2;
            int modeBtnW = 74;
            int modeBtnH = 12;
            if (this.isMouseOver((int)mouseX, (int)mouseY, modeBtnX, modeBtnY, modeBtnW, modeBtnH)) {
                this.cycleDisplayMode();
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            int mode = OverlayConfig.getDisplayMode();
            int nextLineY = modeLineY + 18;
            if (mode == 1 || mode == 3) {
                int rowsDecX = x + 60;
                int rowsDecY = nextLineY - 2;
                int rowsIncX = x + 120;
                int rowsIncY = nextLineY - 2;
                if (this.isMouseOver((int)mouseX, (int)mouseY, rowsDecX, rowsDecY, 12, 12)) {
                    this.adjustVisibleHeight(-1);
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    return true;
                }
                if (this.isMouseOver((int)mouseX, (int)mouseY, rowsIncX, rowsIncY, 12, 12)) {
                    this.adjustVisibleHeight(1);
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    return true;
                }
                nextLineY += 18;
            }
            if (mode == 2 || mode == 3) {
                int tabsDecX = x + 60;
                int tabsDecY = nextLineY - 2;
                int tabsIncX = x + 120;
                int tabsIncY = nextLineY - 2;
                if (this.isMouseOver((int)mouseX, (int)mouseY, tabsDecX, tabsDecY, 12, 12)) {
                    this.adjustTabCount(-1);
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    return true;
                }
                if (this.isMouseOver((int)mouseX, (int)mouseY, tabsIncX, tabsIncY, 12, 12)) {
                    this.adjustTabCount(1);
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    return true;
                }
            }
        }
        contentY = y + 12;
        int contentHeight = currentHeight - 12;
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)contentY && mouseY <= (double)(contentY + contentHeight)) {
            if (!this.isExpanded) {
                this.toggleExpansion();
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            return true;
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + 12) && button == 0 && mouseX <= (double)(x + currentWidth - (buttonAreaWidth = 20))) {
            this.startDragging((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    private void changeDimension(int newWidth, int newHeight) {
        this.updateCurrentDimensions();
        if (newWidth < 1 || newWidth > this.maxWidth) {
            return;
        }
        if (newHeight < 1 || newHeight > this.maxHeight) {
            return;
        }
        this.cachedWidth = newWidth;
        this.cachedHeight = newHeight;
        this.hasPendingChanges = true;
        this.shellWidth = newWidth;
        this.shellHeight = newHeight;
        if (this.overlayManager != null) {
            this.overlayManager.triggerScreenRecalculation();
        }
        try {
            this.menu.applyDimensions(newWidth, newHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateShellDimensionsPacket(newWidth, newHeight), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (Exception e) {
            if (this.menu.getshellStack() != null && !this.menu.getshellStack().isEmpty()) {
                ShellItem shell = (ShellItem)this.menu.getshellStack().getItem();
                this.cachedWidth = shell.getWidth(this.menu.getshellStack());
                this.cachedHeight = shell.getHeight(this.menu.getshellStack());
                this.shellWidth = this.cachedWidth;
                this.shellHeight = this.cachedHeight;
            }
            this.hasPendingChanges = false;
        }
    }

    public int[] getCachedDimensions() {
        return new int[]{this.shellWidth, this.shellHeight};
    }

    public static void updateDimensions(int width, int height) {
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f));
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY();
        int expandedWidth = 150;
        int expandedHeight = Math.max(60, this.calculateExpandedHeight());
        int contentY = y + 12;
        guiGraphics.fill(x, contentY, x + expandedWidth, y + expandedHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, contentY - 1, x + expandedWidth + 1, y + expandedHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, contentY, x + expandedWidth, y + expandedHeight, Theme.panelBg());
        this.updateCurrentDimensions();
        int lineY = contentY + 10;
        int allBtnX = x + 10;
        int allBtnY = lineY - 2;
        int allBtnW = 130;
        int allBtnH = 12;
        boolean allBtnHover = this.isMouseOver(mouseX, mouseY, allBtnX, allBtnY, allBtnW, allBtnH);
        guiGraphics.fill(allBtnX, allBtnY, allBtnX + allBtnW, allBtnY + allBtnH, Theme.buttonBg(allBtnHover));
        guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.settings.all_setting").getString(), allBtnX + 4, lineY, Theme.textOnPanel());
        int memBtnX = x + 10;
        int memBtnY = (lineY += 18) - 2;
        boolean memActive = this.overlayManager != null && this.overlayManager.isMemorizeModeActive();
        boolean memBtnHover = this.isMouseOver(mouseX, mouseY, memBtnX, memBtnY, 130, 12);
        guiGraphics.fill(memBtnX, memBtnY, memBtnX + 130, memBtnY + 12, Theme.buttonBg(memBtnHover));
        String memLabel = (memActive ? "[" : "") + Component.translatable((String)"nomadsshell.settings.memorize").getString() + (memActive ? "]" : "");
        guiGraphics.drawString(this.font, memLabel, memBtnX + 4, lineY, Theme.textOnPanel());
        int tooltipBtnX = x + 10;
        int tooltipBtnY = (lineY += 18) - 2;
        boolean tooltipActive = (Boolean)OverlayConfig.MEMORIZE_SLOT_SHOW_TOOLTIPS.get();
        boolean tooltipBtnHover = this.isMouseOver(mouseX, mouseY, tooltipBtnX, tooltipBtnY, 130, 12);
        guiGraphics.fill(tooltipBtnX, tooltipBtnY, tooltipBtnX + 130, tooltipBtnY + 12, Theme.buttonBg(tooltipBtnHover));
        String tooltipLabel = (tooltipActive ? "[" : "") + Component.translatable((String)"nomadsshell.settings.tooltips").getString() + (tooltipActive ? "]" : "");
        guiGraphics.drawString(this.font, tooltipLabel, tooltipBtnX + 4, lineY, Theme.textOnPanel());
        int throwBtnX = x + 10;
        int throwBtnY = (lineY += 18) - 2;
        boolean throwActive = (Boolean)OverlayConfig.ENABLE_ITEM_THROWING.get();
        boolean throwBtnHover = this.isMouseOver(mouseX, mouseY, throwBtnX, throwBtnY, 130, 12);
        guiGraphics.fill(throwBtnX, throwBtnY, throwBtnX + 130, throwBtnY + 12, Theme.buttonBg(throwBtnHover));
        String throwLabel = (throwActive ? "[" : "") + Component.translatable((String)"nomadsshell.settings.item_throwing").getString() + (throwActive ? "]" : "");
        guiGraphics.drawString(this.font, throwLabel, throwBtnX + 4, lineY, Theme.textOnPanel());
        guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.settings.width").getString(), x + 10, lineY += 18, Theme.textOnPanel());
        int widthDecX = x + 60;
        int widthDecY = lineY - 2;
        boolean widthDecHover = this.isMouseOver(mouseX, mouseY, widthDecX, widthDecY, 12, 12);
        boolean canDecreaseWidth = this.shellWidth > 1;
        int widthDecColor = canDecreaseWidth ? Theme.buttonBg(widthDecHover) : -14540254;
        guiGraphics.fill(widthDecX, widthDecY, widthDecX + 12, widthDecY + 12, widthDecColor);
        guiGraphics.drawString(this.font, "-", widthDecX + 4, lineY, canDecreaseWidth ? Theme.textOnPanel() : -10066330);
        String widthText = this.shellWidth + "/" + this.maxWidth;
        guiGraphics.drawString(this.font, widthText, x + 80, lineY, Theme.textOnPanel());
        int widthIncX = x + 120;
        int widthIncY = lineY - 2;
        boolean widthIncHover = this.isMouseOver(mouseX, mouseY, widthIncX, widthIncY, 12, 12);
        boolean canIncreaseWidth = this.shellWidth < this.maxWidth;
        int widthIncColor = canIncreaseWidth ? Theme.buttonBg(widthIncHover) : -14540254;
        guiGraphics.fill(widthIncX, widthIncY, widthIncX + 12, widthIncY + 12, widthIncColor);
        guiGraphics.drawString(this.font, "+", widthIncX + 4, lineY, canIncreaseWidth ? Theme.textOnPanel() : -10066330);
        guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.settings.height").getString(), x + 10, lineY += 20, Theme.textOnPanel());
        int heightDecX = x + 60;
        int heightDecY = lineY - 2;
        boolean heightDecHover = this.isMouseOver(mouseX, mouseY, heightDecX, heightDecY, 12, 12);
        boolean canDecreaseHeight = this.shellHeight > 1;
        int heightDecColor = canDecreaseHeight ? Theme.buttonBg(heightDecHover) : -14540254;
        guiGraphics.fill(heightDecX, heightDecY, heightDecX + 12, heightDecY + 12, heightDecColor);
        guiGraphics.drawString(this.font, "-", heightDecX + 4, lineY, canDecreaseHeight ? Theme.textOnPanel() : -10066330);
        String heightText = this.shellHeight + "/" + this.maxHeight;
        guiGraphics.drawString(this.font, heightText, x + 80, lineY, Theme.textOnPanel());
        int heightIncX = x + 120;
        int heightIncY = lineY - 2;
        boolean heightIncHover = this.isMouseOver(mouseX, mouseY, heightIncX, heightIncY, 12, 12);
        boolean canIncreaseHeight = this.shellHeight < this.maxHeight;
        int heightIncColor = canIncreaseHeight ? Theme.buttonBg(heightIncHover) : -14540254;
        guiGraphics.fill(heightIncX, heightIncY, heightIncX + 12, heightIncY + 12, heightIncColor);
        guiGraphics.drawString(this.font, "+", heightIncX + 4, lineY, canIncreaseHeight ? Theme.textOnPanel() : -10066330);
        lineY += 18;
        int mode = OverlayConfig.getDisplayMode();
        String modeText = switch (mode) {
            case 1 -> Component.translatable((String)"nomadsshell.settings.mode.scroll_bar").getString();
            case 2 -> Component.translatable((String)"nomadsshell.settings.mode.tabs").getString();
            case 3 -> Component.translatable((String)"nomadsshell.settings.mode.both").getString();
            default -> Component.translatable((String)"nomadsshell.settings.mode.default").getString();
        };
        guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.settings.mode").getString(), x + 10, lineY, Theme.textOnPanel());
        int modeBtnX = x + 60;
        int modeBtnY = lineY - 2;
        int modeBtnW = 74;
        int modeBtnH = 12;
        boolean modeHover = this.isMouseOver(mouseX, mouseY, modeBtnX, modeBtnY, modeBtnW, modeBtnH);
        guiGraphics.fill(modeBtnX, modeBtnY, modeBtnX + modeBtnW, modeBtnY + modeBtnH, Theme.buttonBg(modeHover));
        guiGraphics.drawString(this.font, modeText, modeBtnX + 4, lineY, Theme.textOnPanel());
        int nextLineY = lineY + 18;
        if (mode == 1 || mode == 3) {
            guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.settings.visible_height").getString(), x + 10, nextLineY, Theme.textOnPanel());
            int rowsDecX = x + 60;
            int rowsDecY = nextLineY - 2;
            boolean rowsDecHover = this.isMouseOver(mouseX, mouseY, rowsDecX, rowsDecY, 12, 12);
            guiGraphics.fill(rowsDecX, rowsDecY, rowsDecX + 12, rowsDecY + 12, Theme.buttonBg(rowsDecHover));
            guiGraphics.drawString(this.font, "-", rowsDecX + 4, nextLineY, Theme.textOnPanel());
            int visibleH = (Integer)OverlayConfig.SETTINGS_VISIBLE_HEIGHT.get();
            int currentVisible = visibleH > 0 ? visibleH : Math.min(this.shellHeight, 25);
            guiGraphics.drawString(this.font, currentVisible + "/" + this.shellHeight, x + 80, nextLineY, Theme.textOnPanel());
            int rowsIncX = x + 120;
            int rowsIncY = nextLineY - 2;
            boolean rowsIncHover = this.isMouseOver(mouseX, mouseY, rowsIncX, rowsIncY, 12, 12);
            guiGraphics.fill(rowsIncX, rowsIncY, rowsIncX + 12, rowsIncY + 12, Theme.buttonBg(rowsIncHover));
            guiGraphics.drawString(this.font, "+", rowsIncX + 4, nextLineY, Theme.textOnPanel());
            nextLineY += 18;
        }
        if (mode == 2 || mode == 3) {
            guiGraphics.drawString(this.font, Component.translatable((String)"nomadsshell.settings.tabs").getString(), x + 10, nextLineY, Theme.textOnPanel());
            int tabsDecX = x + 60;
            int tabsDecY = nextLineY - 2;
            boolean tabsDecHover = this.isMouseOver(mouseX, mouseY, tabsDecX, tabsDecY, 12, 12);
            guiGraphics.fill(tabsDecX, tabsDecY, tabsDecX + 12, tabsDecY + 12, Theme.buttonBg(tabsDecHover));
            guiGraphics.drawString(this.font, "-", tabsDecX + 4, nextLineY, Theme.textOnPanel());
            int tabCount = (Integer)OverlayConfig.SETTINGS_TAB_COUNT.get();
            int maxTabs = Math.max(1, this.shellWidth);
            tabCount = Math.max(1, Math.min(tabCount, maxTabs));
            guiGraphics.drawString(this.font, tabCount + "/" + maxTabs, x + 80, nextLineY, Theme.textOnPanel());
            int tabsIncX = x + 120;
            int tabsIncY = nextLineY - 2;
            boolean tabsIncHover = this.isMouseOver(mouseX, mouseY, tabsIncX, tabsIncY, 12, 12);
            guiGraphics.fill(tabsIncX, tabsIncY, tabsIncX + 12, tabsIncY + 12, Theme.buttonBg(tabsIncHover));
            guiGraphics.drawString(this.font, "+", tabsIncX + 4, nextLineY, Theme.textOnPanel());
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, "Settings Widget");
        if (this.isHovering) {
            narrationElementOutput.add(NarratedElementType.USAGE, "Click to open settings");
        }
    }

    public boolean adjustHeight(int delta) {
        this.updateCurrentDimensions();
        int newHeight = this.shellHeight + delta;
        if (newHeight < 1) {
            return false;
        }
        if (newHeight > this.maxHeight) {
            return false;
        }
        this.changeDimension(this.shellWidth, newHeight);
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        return true;
    }

    public boolean adjustWidth(int delta) {
        this.updateCurrentDimensions();
        int newWidth = this.shellWidth + delta;
        if (newWidth < 1) {
            return false;
        }
        if (newWidth > this.maxWidth) {
            return false;
        }
        this.changeDimension(newWidth, this.shellHeight);
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        return true;
    }

    private void openAllSettingsScreen() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null) {
                mc.setScreen((Screen)new AllSettingsScreen());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cycleDisplayMode() {
        int mode = OverlayConfig.getDisplayMode();
        mode = (mode + 1) % 4;
        try {
            OverlayConfig.SETTINGS_DISPLAY_MODE.set((Object)mode);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mode == 2 || mode == 3) {
            OverlayConfig.SETTINGS_CURRENT_TAB.set((Object)Math.min((Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get(), Math.max(0, (Integer)OverlayConfig.SETTINGS_TAB_COUNT.get() - 1)));
        }
        this.menu.requestLayoutRefresh();
        if (this.overlayManager != null) {
            this.overlayManager.triggerScreenRecalculation();
        }
    }

    private void adjustVisibleHeight(int delta) {
        int visible = (Integer)OverlayConfig.SETTINGS_VISIBLE_HEIGHT.get();
        if (visible <= 0) {
            visible = Math.min(this.shellHeight, 25);
        }
        int newVal = Math.max(1, Math.min(this.shellHeight, visible + delta));
        try {
            OverlayConfig.SETTINGS_VISIBLE_HEIGHT.set((Object)newVal);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.menu.requestLayoutRefresh();
        if (this.overlayManager != null) {
            this.overlayManager.triggerScreenRecalculation();
        }
    }

    private void adjustTabCount(int delta) {
        int maxTabs = Math.max(1, this.shellWidth);
        int newTabs = Math.max(1, Math.min(maxTabs, (Integer)OverlayConfig.SETTINGS_TAB_COUNT.get() + delta));
        try {
            OverlayConfig.SETTINGS_TAB_COUNT.set((Object)newTabs);
            OverlayConfig.SETTINGS_CURRENT_TAB.set((Object)Math.min((Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get(), newTabs - 1));
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.menu.requestLayoutRefresh();
        if (this.overlayManager != null) {
            this.overlayManager.triggerScreenRecalculation();
        }
    }
}

