/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.UpgradeNodeConfig;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpgradeTreeRegistry {
    private static final Map<String, UpgradeNodeConfig> nodes = new HashMap<String, UpgradeNodeConfig>();
    private static final Map<String, List<String>> connections = new HashMap<String, List<String>>();
    private static final Map<String, List<UpgradeNodeConfig>> nodesByWidget = new HashMap<String, List<UpgradeNodeConfig>>();

    public static void registerNode(UpgradeNodeConfig node) {
        nodes.put(node.id, node);
        nodesByWidget.computeIfAbsent(node.widgetType.name(), k -> new ArrayList()).add(node);
    }

    public static void registerConnection(String fromNodeId, String toNodeId) {
        connections.computeIfAbsent(fromNodeId, k -> new ArrayList()).add(toNodeId);
    }

    public static UpgradeNodeConfig getNode(String nodeId) {
        return nodes.get(nodeId);
    }

    public static List<UpgradeNodeConfig> getNodesForWidget(WidgetUnlockSystem.WidgetType widgetType) {
        List widgetNodes = nodesByWidget.getOrDefault(widgetType.name(), Collections.emptyList());
        return widgetNodes.stream().sorted(Comparator.comparingInt(node -> node.tier)).collect(Collectors.toList());
    }

    public static List<String> getConnections(String nodeId) {
        return connections.getOrDefault(nodeId, Collections.emptyList());
    }

    public static List<String> getIncomingConnections(String nodeId) {
        return connections.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(nodeId)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static boolean hasNode(String nodeId) {
        return nodes.containsKey(nodeId);
    }

    public static Collection<UpgradeNodeConfig> getAllNodes() {
        return nodes.values();
    }

    public static void clear() {
        nodes.clear();
        connections.clear();
        nodesByWidget.clear();
    }

    public static int getNodeCount() {
        return nodes.size();
    }
}

