/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.UpgradeLayoutEngine;
import com.etka.nomadsshell.client.screen.overlay.UpgradeNodeConfig;
import com.etka.nomadsshell.client.screen.overlay.UpgradeTreeRegistry;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;

public class UpgradeTreeSetup {
    public static void initializeUpgradeTree() {
        UpgradeTreeRegistry.clear();
        UpgradeTreeSetup.setupGuardianNodes();
        UpgradeTreeSetup.setupDripstoneNodes();
        UpgradeTreeSetup.setupFurnaceNodes();
        UpgradeTreeSetup.setupFluidNodes();
        UpgradeTreeSetup.setupCraftingChainNodes();
        UpgradeTreeSetup.setupTeleporterNodes();
        UpgradeTreeSetup.setupTravelersGardenNodes();
        UpgradeTreeSetup.setupAnvilNodes();
    }

    private static void setupGuardianNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("guardian_base", WidgetUnlockSystem.WidgetType.GUARDIAN, 1, 64, 64, Arrays.asList("start_node"), new ItemStack((ItemLike)Items.ELYTRA), "Guardian Widget", "vertical"));
        for (int tier = 2; tier <= 10; ++tier) {
            String nodeId = "guardian_tier_" + tier;
            String prevNodeId = tier == 2 ? "guardian_base" : "guardian_tier_" + (tier - 1);
            UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig(nodeId, WidgetUnlockSystem.WidgetType.GUARDIAN, tier, 64, 64 + (tier - 1) * 32, Arrays.asList(prevNodeId), UpgradeTreeSetup.getGuardianTierIcon(tier), "Guardian Tier " + tier, "vertical"));
            UpgradeTreeRegistry.registerConnection(prevNodeId, nodeId);
        }
    }

    private static void setupDripstoneNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("dripstone_cauldron_1", WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, 1, -45, -70, Arrays.asList("start_node"), new ItemStack((ItemLike)Items.CAULDRON), "Cauldron 1", "vertical"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("dripstone_cauldron_2", WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, 3, -45, -100, Arrays.asList("dripstone_cauldron_1"), new ItemStack((ItemLike)Items.CAULDRON), "Cauldron 2", "vertical"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("dripstone_cauldron_3", WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, 4, -45, -130, Arrays.asList("dripstone_cauldron_2"), new ItemStack((ItemLike)Items.CAULDRON), "Cauldron 3", "vertical"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("dripstone_auto_transfer", WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, 5, -45, -160, Arrays.asList("dripstone_cauldron_3"), new ItemStack((ItemLike)Items.HOPPER), "Auto Transfer", "vertical"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("dripstone_cauldron_4", WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, 6, -45, -190, Arrays.asList("dripstone_auto_transfer"), new ItemStack((ItemLike)Items.CAULDRON), "Cauldron 4", "vertical"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("dripstone_cauldron_5", WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, 7, -45, -220, Arrays.asList("dripstone_cauldron_4"), new ItemStack((ItemLike)Items.CAULDRON), "Cauldron 5", "vertical"));
        UpgradeTreeRegistry.registerConnection("start_node", "dripstone_cauldron_1");
        UpgradeTreeRegistry.registerConnection("dripstone_cauldron_1", "dripstone_cauldron_2");
        UpgradeTreeRegistry.registerConnection("dripstone_cauldron_2", "dripstone_cauldron_3");
        UpgradeTreeRegistry.registerConnection("dripstone_cauldron_3", "dripstone_auto_transfer");
        UpgradeTreeRegistry.registerConnection("dripstone_auto_transfer", "dripstone_cauldron_4");
        UpgradeTreeRegistry.registerConnection("dripstone_cauldron_4", "dripstone_cauldron_5");
    }

    private static void setupFurnaceNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("furnace_unlock", WidgetUnlockSystem.WidgetType.FURNACE, 1, 90, 0, Arrays.asList("start_node"), new ItemStack((ItemLike)Items.FURNACE), "Furnace", "horizontal"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("furnace_upgrade", WidgetUnlockSystem.WidgetType.FURNACE, 2, 120, 0, Arrays.asList("furnace_unlock"), new ItemStack((ItemLike)Items.BLAST_FURNACE), "Furnace Upgrade", "horizontal"));
        UpgradeTreeRegistry.registerConnection("start_node", "furnace_unlock");
        UpgradeTreeRegistry.registerConnection("furnace_unlock", "furnace_upgrade");
    }

    private static void setupFluidNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("fluid_base", WidgetUnlockSystem.WidgetType.FLUID_TANK, 1, -45, 64, Arrays.asList("start_node"), new ItemStack((ItemLike)Items.BUCKET), "Fluid Tank", "vertical"));
        for (int tier = 2; tier <= 8; ++tier) {
            String nodeId = "fluid_tier_" + tier;
            String prevNodeId = tier == 2 ? "fluid_base" : "fluid_tier_" + (tier - 1);
            UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig(nodeId, WidgetUnlockSystem.WidgetType.FLUID_TANK, tier, -45, 64 + (tier - 1) * 50, Arrays.asList(prevNodeId), new ItemStack((ItemLike)Items.WATER_BUCKET), "Fluid Tier " + tier, "vertical"));
            UpgradeTreeRegistry.registerConnection(prevNodeId, nodeId);
        }
    }

    private static void setupCraftingChainNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("craft_trash_link", WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, 2, -220, -140, Arrays.asList("crafting_upgrade"), new ItemStack((ItemLike)Items.LAVA_BUCKET), "Trash Bin", "horizontal"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("auto_crafter", WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, 3, -360, -140, Arrays.asList("craft_trash_link"), new ItemStack((ItemLike)Items.REDSTONE_TORCH), "Auto Crafter", "horizontal"));
        UpgradeTreeRegistry.registerConnection("crafting_upgrade", "craft_trash_link");
        UpgradeTreeRegistry.registerConnection("craft_trash_link", "auto_crafter");
    }

    private static void setupTeleporterNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("teleporter_base", WidgetUnlockSystem.WidgetType.TELEPORTER, 1, 0, 64, Arrays.asList("start_node"), new ItemStack((ItemLike)Items.ENDER_PEARL), "Teleporter", "vertical"));
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("teleporter_tier_2", WidgetUnlockSystem.WidgetType.TELEPORTER, 2, 0, 96, Arrays.asList("teleporter_base"), new ItemStack((ItemLike)Items.FLINT_AND_STEEL), "Teleporter Tier 2", "vertical"));
        UpgradeTreeRegistry.registerConnection("teleporter_base", "teleporter_tier_2");
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("teleporter_tier_3", WidgetUnlockSystem.WidgetType.TELEPORTER, 3, 0, 128, Arrays.asList("teleporter_tier_2"), new ItemStack((ItemLike)Items.ENDER_EYE), "Teleporter Tier 3", "vertical"));
        UpgradeTreeRegistry.registerConnection("teleporter_tier_2", "teleporter_tier_3");
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("teleporter_tier_4", WidgetUnlockSystem.WidgetType.TELEPORTER, 4, 0, 160, Arrays.asList("teleporter_tier_3"), new ItemStack((ItemLike)Items.ENDER_CHEST), "Teleporter Tier 4", "vertical"));
        UpgradeTreeRegistry.registerConnection("teleporter_tier_3", "teleporter_tier_4");
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("teleporter_tier_5", WidgetUnlockSystem.WidgetType.TELEPORTER, 5, 0, 192, Arrays.asList("teleporter_tier_4"), new ItemStack((ItemLike)Items.ENDER_EYE), "Teleporter Tier 5", "vertical"));
        UpgradeTreeRegistry.registerConnection("teleporter_tier_4", "teleporter_tier_5");
    }

    private static void setupTravelersGardenNodes() {
        try {
            if (!ModList.get().isLoaded("travelersgarden")) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("tg_base", WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, 1, 128, 64, Arrays.asList("start_node"), new ItemStack((ItemLike)Items.OAK_SAPLING), "Traveler's Garden", "vertical"));
        for (int tier = 2; tier <= 6; ++tier) {
            String nodeId = "tg_tier_" + tier;
            String prevNodeId = tier == 2 ? "tg_base" : "tg_tier_" + (tier - 1);
            UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig(nodeId, WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, tier, 128, 64 + (tier - 1) * 30, Arrays.asList(prevNodeId), new ItemStack((ItemLike)Items.OAK_SAPLING), "Traveler's Garden Tier " + tier, "vertical"));
            UpgradeTreeRegistry.registerConnection(prevNodeId, nodeId);
        }
    }

    private static void setupAnvilNodes() {
        UpgradeTreeRegistry.registerNode(new UpgradeNodeConfig("anvil_base", WidgetUnlockSystem.WidgetType.ANVIL, 1, -210, 0, Arrays.asList("auto_crafter"), new ItemStack((ItemLike)Items.ANVIL), "Portable Anvil", "horizontal"));
        UpgradeTreeRegistry.registerConnection("auto_crafter", "anvil_base");
    }

    private static ItemStack getGuardianTierIcon(int tier) {
        return switch (tier) {
            case 1 -> new ItemStack((ItemLike)Items.ELYTRA);
            case 2 -> new ItemStack((ItemLike)Items.FEATHER);
            case 3 -> new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE);
            case 4 -> new ItemStack((ItemLike)Items.END_ROD);
            case 5 -> new ItemStack((ItemLike)Items.END_CRYSTAL);
            case 6 -> new ItemStack((ItemLike)Items.TORCH);
            case 7 -> new ItemStack((ItemLike)Items.DRAGON_HEAD);
            case 8 -> new ItemStack((ItemLike)Items.DRAGON_EGG);
            case 9 -> new ItemStack((ItemLike)Items.NETHER_STAR);
            case 10 -> new ItemStack((ItemLike)Items.BEACON);
            default -> new ItemStack((ItemLike)Items.ELYTRA);
        };
    }

    public static void insertUpgradeBetween(String beforeNodeId, String afterNodeId, UpgradeNodeConfig newNode) {
        UpgradeTreeRegistry.registerNode(newNode);
        ArrayList<String> connections = new ArrayList<String>(UpgradeTreeRegistry.getConnections(beforeNodeId));
        connections.remove(afterNodeId);
        UpgradeTreeRegistry.registerConnection(beforeNodeId, newNode.id);
        UpgradeTreeRegistry.registerConnection(newNode.id, afterNodeId);
        List<UpgradeNodeConfig> widgetNodes = UpgradeTreeRegistry.getNodesForWidget(newNode.widgetType);
        UpgradeLayoutEngine.calculatePositions(widgetNodes, newNode.layoutType);
    }
}

