/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.OverlayWidget;
import com.etka.nomadsshell.client.screen.overlay.UpgradeDefinitions;
import com.etka.nomadsshell.client.screen.overlay.UpgradeGridConfig;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.PurchaseAutoCrafterPacket;
import com.etka.nomadsshell.network.PurchaseDripstoneCauldronPacket;
import com.etka.nomadsshell.network.PurchaseFurnacePerfUpgradePacket;
import com.etka.nomadsshell.network.PurchaseFurnaceSlotUpgradePacket;
import com.etka.nomadsshell.network.PurchaseWidgetPacket;
import com.etka.nomadsshell.util.InventoryUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class UpgradeWidget
extends OverlayWidget {
    private final IShellMenu menu;
    private boolean fullscreenOpen = false;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private boolean panning = false;
    private int panStartMouseX;
    private int panStartMouseY;
    private float panStartX;
    private float panStartY;
    private boolean showDetailsPanel = false;
    private String selectedNodeId = null;
    private int detailsPanelX;
    private int detailsPanelY;
    private int detailsPanelW;
    private int detailsPanelH;
    private int unlockButtonX;
    private int unlockButtonY;
    private int unlockButtonW = 200;
    private int unlockButtonH = 24;
    private int closeButtonX;
    private int closeButtonY;
    private int closeButtonW = 24;
    private int closeButtonH = 24;
    private Map<String, Boolean> nodeUnlockCache = new HashMap<String, Boolean>();
    private ItemStack cachedShellStack = ItemStack.EMPTY;

    public UpgradeWidget(int x, int y, Font font, IShellMenu menu) {
        super(UpgradeWidget.loadPositionX(x), UpgradeWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.upgrade.button"), font);
        this.menu = menu;
        this.isPinned = (Boolean)OverlayConfig.UPGRADE_PINNED.get();
        UpgradeDefinitions.getAllNodes();
    }

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.UPGRADE_X.get();
        return cx != 0 ? cx : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.UPGRADE_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.UPGRADE_X.set((Object)this.getX());
            OverlayConfig.UPGRADE_X.save();
            OverlayConfig.UPGRADE_Y.set((Object)this.getY());
            OverlayConfig.UPGRADE_Y.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.UPGRADE_PINNED.set((Object)this.isPinned);
            OverlayConfig.UPGRADE_PINNED.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        if (!this.fullscreenOpen) {
            int x = this.getX();
            int y = this.getY();
            int w = this.width;
            int h = this.height;
            g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
            g.fill(x - 1, y - 1, x + w + 1, y + 12, Theme.panelBorder());
            g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
            if (this.isTitleBarHovered(mouseX, mouseY) || this.isDragging) {
                int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
                g.fill(x, y, x + w, y + 12, hoverOverlay);
            }
            int contentY = y + 12;
            int contentHeight = h - 12;
            g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
            g.fill(x - 1, contentY - 1, x + w + 1, contentY + contentHeight + 1, Theme.panelBorder());
            g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
            this.renderMainContent(g, mouseX, mouseY, partialTick);
            this.renderControlButtons(g, mouseX, mouseY, w, h);
        } else {
            this.renderFullscreenGrid(g, mouseX, mouseY);
        }
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        int contentY = y + 12;
        int contentHeight = h - 12;
        int iconSize = 16;
        int iconX = x + (w - iconSize) / 2;
        int iconY = contentY + (contentHeight - iconSize) / 2;
        g.blit(Theme.icon("upgrade"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    @Override
    protected void renderExpandedContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
    }

    private void renderFullscreenGrid(GuiGraphics g, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        PoseStack pose = g.pose();
        pose.pushPose();
        g.fill(0, 0, sw, sh, -15066598);
        this.drawGridDots(g, sw, sh);
        pose.pushPose();
        pose.translate((float)sw / 2.0f + this.panX, (float)sh / 2.0f + this.panY, 0.0f);
        pose.scale(this.zoom, this.zoom, 1.0f);
        this.drawConnections(g);
        this.drawNodes(g, mouseX, mouseY, sw, sh);
        pose.popPose();
        if (this.showDetailsPanel && this.selectedNodeId != null) {
            this.drawDetailsPanel(g, sw, sh, mouseX, mouseY);
        }
        this.drawZoomControls(g, sw, sh, mouseX, mouseY);
        this.drawCloseButton(g, sw, sh, mouseX, mouseY);
        pose.popPose();
    }

    private void drawGridDots(GuiGraphics g, int sw, int sh) {
        int spacing = 40;
        int startX = (int)(((float)(-sw / 2) - this.panX) / this.zoom / (float)spacing) * spacing;
        int endX = (int)(((float)(sw / 2) - this.panX) / this.zoom / (float)spacing + 1.0f) * spacing;
        int startY = (int)(((float)(-sh / 2) - this.panY) / this.zoom / (float)spacing) * spacing;
        int endY = (int)(((float)(sh / 2) - this.panY) / this.zoom / (float)spacing + 1.0f) * spacing;
        for (int x = startX; x <= endX; x += spacing) {
            for (int y = startY; y <= endY; y += spacing) {
                int screenX = (int)((float)x * this.zoom + (float)(sw / 2) + this.panX);
                int screenY = (int)((float)y * this.zoom + (float)(sh / 2) + this.panY);
                if (screenX < 0 || screenX >= sw || screenY < 0 || screenY >= sh) continue;
                g.fill(screenX, screenY, screenX + 1, screenY + 1, 0x1AFFFFFF);
            }
        }
    }

    private void drawConnections(GuiGraphics g) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
            int startX = UpgradeGridConfig.gridToPixel(node.gridX);
            int startY = UpgradeGridConfig.gridToPixelY(node.gridY);
            for (String connectionId : node.connections) {
                UpgradeDefinitions.UpgradeNode targetNode = UpgradeDefinitions.getNode(connectionId);
                if (targetNode == null) continue;
                int endX = UpgradeGridConfig.gridToPixel(targetNode.gridX);
                int endY = UpgradeGridConfig.gridToPixelY(targetNode.gridY);
                boolean startUnlocked = this.isNodeUnlocked(node, shellStack);
                boolean endUnlocked = this.isNodeUnlocked(targetNode, shellStack);
                int lineColor = startUnlocked && endUnlocked ? -11886849 : (startUnlocked ? -10461088 : -12566464);
                this.drawLine(g, startX, startY, endX, endY, lineColor);
            }
        }
    }

    private void drawLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color) {
        int lineWidth = 2;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        int steps = (int)length;
        for (int i = 0; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            int x = (int)((float)x1 + (float)dx * t);
            int y = (int)((float)y1 + (float)dy * t);
            g.fill(x - lineWidth / 2, y - lineWidth / 2, x + lineWidth / 2, y + lineWidth / 2, color);
        }
    }

    private void drawNodes(GuiGraphics g, int mouseX, int mouseY, int sw, int sh) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
            int borderColor;
            int nodeColor;
            int worldX = UpgradeGridConfig.gridToPixel(node.gridX);
            int worldY = UpgradeGridConfig.gridToPixelY(node.gridY);
            if (!node.alwaysVisible && !this.canSeeNode(node, shellStack)) continue;
            boolean unlocked = this.isNodeUnlocked(node, shellStack);
            boolean available = this.isNodeAvailable(node, shellStack);
            boolean hovered = this.isNodeHovered(worldX, worldY, mouseX, mouseY, sw, sh);
            boolean isStartNode = node.id.equals("start");
            if (isStartNode) {
                nodeColor = -217853;
                borderColor = -2387198;
                if (hovered) {
                    nodeColor = this.brightenColor(nodeColor);
                }
            } else if (unlocked) {
                nodeColor = -217853;
                borderColor = -2387198;
                if (hovered) {
                    nodeColor = this.brightenColor(nodeColor);
                }
            } else if (available) {
                boolean hasEnoughItems = this.hasRequiredItems(node, (Player)player);
                if (hasEnoughItems) {
                    nodeColor = -30669;
                    borderColor = -2263262;
                    if (hovered) {
                        nodeColor = this.brightenColor(nodeColor);
                    }
                } else {
                    nodeColor = -3394765;
                    borderColor = -5627358;
                    if (hovered) {
                        nodeColor = this.brightenColor(nodeColor);
                    }
                }
            } else {
                nodeColor = -12961222;
                borderColor = -14013910;
                if (hovered) {
                    nodeColor = this.brightenColor(nodeColor);
                }
            }
            int nodeSize = 24;
            int halfSize = nodeSize / 2;
            g.fill(worldX - halfSize - 1, worldY - halfSize - 1, worldX + halfSize + 1, worldY + halfSize + 1, borderColor);
            g.fill(worldX - halfSize, worldY - halfSize, worldX + halfSize, worldY + halfSize, nodeColor);
            if (node.icon.isEmpty()) continue;
            PoseStack pose = g.pose();
            pose.pushPose();
            int iconSize = 16;
            pose.translate((float)(worldX - iconSize / 2), (float)(worldY - iconSize / 2), 1.0f);
            pose.scale((float)iconSize / 16.0f, (float)iconSize / 16.0f, 1.0f);
            g.renderItem(node.icon, 0, 0);
            pose.popPose();
        }
    }

    private int brightenColor(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.min(255, (int)((float)red * 1.3f));
        green = Math.min(255, (int)((float)green * 1.3f));
        blue = Math.min(255, (int)((float)blue * 1.3f));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private boolean isNodeHovered(int worldX, int worldY, int mouseX, int mouseY, int sw, int sh) {
        float worldMouseX = ((float)mouseX - (float)sw / 2.0f - this.panX) / this.zoom;
        float worldMouseY = -((float)mouseY - (float)sh / 2.0f - this.panY) / this.zoom;
        int halfSize = 12;
        return worldMouseX >= (float)(worldX - halfSize) && worldMouseX <= (float)(worldX + halfSize) && worldMouseY >= (float)(worldY - halfSize) && worldMouseY <= (float)(worldY + halfSize);
    }

    private boolean canSeeNode(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (node.alwaysVisible) {
            return true;
        }
        for (UpgradeDefinitions.UpgradeNode other : UpgradeDefinitions.getAllNodes()) {
            if (!other.connections.contains(node.id) || !this.isNodeUnlocked(other, shellStack)) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeAvailable(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (this.isNodeUnlocked(node, shellStack)) {
            return false;
        }
        if (node.id.equals("start")) {
            return true;
        }
        for (UpgradeDefinitions.UpgradeNode other : UpgradeDefinitions.getAllNodes()) {
            if (!other.connections.contains(node.id) || !this.isNodeUnlocked(other, shellStack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredItems(UpgradeDefinitions.UpgradeNode node, Player player) {
        int playerHas;
        if (player == null) {
            return false;
        }
        if (node.tagRequirement != null && node.tagCount > 0 && (playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell(player, ResourceLocation.parse((String)node.tagRequirement))) < node.tagCount) {
            return false;
        }
        for (ItemStack req : node.requirements) {
            int playerHas2 = InventoryUtils.countItemAcrossInventoryAndshell(player, req.getItem());
            if (playerHas2 >= req.getCount()) continue;
            return false;
        }
        return true;
    }

    private boolean isNodeUnlocked(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (node.id.equals("start")) {
            return true;
        }
        if (node.widgetType != null) {
            boolean widgetUnlocked = WidgetUnlockSystem.isUnlocked(node.widgetType, shellStack);
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(node.widgetType, shellStack);
            return widgetUnlocked && currentTier.getLevel() >= node.tier.getLevel();
        }
        return this.isSubUpgradeUnlocked(node.id, shellStack);
    }

    private boolean isSubUpgradeUnlocked(String nodeId, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return false;
        }
        if (nodeId.startsWith("furnace_smelt_speed_") || nodeId.startsWith("furnace_fuel_eff_")) {
            int n;
            try {
                n = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            int requiredLevel = nodeId.startsWith("furnace_smelt_speed_") ? Math.max(1, 2 * n - 1) : Math.min(6, 2 * n);
            int perfLevel = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)0);
            return perfLevel >= requiredLevel;
        }
        switch (nodeId) {
            case "furnace_template_1": 
            case "furnace_template_2": 
            case "furnace_template_3": 
            case "furnace_template_4": 
            case "furnace_template_5": {
                int templateSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
                int requiredSlots = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
                return templateSlots >= requiredSlots;
            }
            case "furnace_tag_puller": {
                int tagPullerSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
                return tagPullerSlots >= 5;
            }
            case "auto_crafter_unlock": {
                return (Boolean)shellStack.getOrDefault(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)false);
            }
            case "dripstone_2": 
            case "dripstone_3": 
            case "dripstone_4": 
            case "dripstone_5": {
                int cauldronCount = (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
                int requiredCauldrons = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
                return cauldronCount >= requiredCauldrons;
            }
            case "dripstone_auto_transfer": {
                if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack)) {
                    return false;
                }
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
        }
        return false;
    }

    private void drawDetailsPanel(GuiGraphics g, int sw, int sh, int mouseX, int mouseY) {
        int playerHas;
        UpgradeDefinitions.UpgradeNode node = UpgradeDefinitions.getNode(this.selectedNodeId);
        if (node == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        this.detailsPanelW = 280;
        this.detailsPanelH = sh;
        this.detailsPanelX = sw - this.detailsPanelW;
        this.detailsPanelY = 0;
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        RenderSystem.disableDepthTest();
        g.fill(this.detailsPanelX - 1, this.detailsPanelY, this.detailsPanelX, this.detailsPanelH, -12566464);
        g.fill(this.detailsPanelX, this.detailsPanelY, this.detailsPanelX + this.detailsPanelW, this.detailsPanelH, -534765536);
        int contentX = this.detailsPanelX + 12;
        int contentY = 12;
        this.closeButtonX = this.detailsPanelX + this.detailsPanelW - 32;
        this.closeButtonY = 8;
        boolean closeHovered = mouseX >= this.closeButtonX && mouseX <= this.closeButtonX + this.closeButtonW && mouseY >= this.closeButtonY && mouseY <= this.closeButtonY + this.closeButtonH;
        g.fill(this.closeButtonX, this.closeButtonY, this.closeButtonX + this.closeButtonW, this.closeButtonY + this.closeButtonH, closeHovered ? -11513776 : -12961222);
        g.drawString(this.font, "\u00d7", this.closeButtonX + 8, this.closeButtonY + 8, -1);
        if (!node.icon.isEmpty()) {
            PoseStack itemPose = g.pose();
            itemPose.pushPose();
            itemPose.translate((float)contentX, (float)contentY, 100.0f);
            g.renderItem(node.icon, 0, 0);
            itemPose.popPose();
        }
        String title = Component.translatable((String)node.titleKey).getString();
        g.drawString(this.font, title, contentX + 24, contentY + 4, -1);
        contentY += 28;
        String desc = Component.translatable((String)node.descriptionKey).getString();
        List<String> descLines = this.wrapText(desc, this.detailsPanelW - 24);
        for (String line : descLines) {
            g.drawString(this.font, line, contentX, contentY, -5592406);
            contentY += 12;
        }
        contentY += 8;
        if (!node.requirements.isEmpty() || node.tagRequirement != null) {
            g.drawString(this.font, Component.translatable((String)"nomadsshell.ui.requirements").getString(), contentX, contentY, -3355444);
            contentY += 14;
            if (node.tagRequirement != null && node.tagCount > 0) {
                List<Item> applicableItems = InventoryUtils.getTagExpansion(node.tagRequirement);
                int cycleIndex = 0;
                if (!applicableItems.isEmpty()) {
                    long currentTime = System.currentTimeMillis();
                    cycleIndex = (int)(currentTime / 1500L % (long)applicableItems.size());
                }
                PoseStack tagPose = g.pose();
                tagPose.pushPose();
                tagPose.translate((float)contentX, (float)contentY, 100.0f);
                Item displayItem = applicableItems.isEmpty() ? Items.COBBLESTONE : (Item)applicableItems.get(cycleIndex);
                g.renderItem(new ItemStack((ItemLike)displayItem), 0, 0);
                tagPose.popPose();
                playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)node.tagRequirement));
                int required = node.tagCount;
                String tagTranslationKey = "nomadsshell.tag." + node.tagRequirement.replace(":", ".");
                MutableComponent tagNameComponent = Component.translatable((String)tagTranslationKey);
                String reqText = required + "x " + tagNameComponent.getString();
                g.drawString(this.font, reqText, contentX + 20, contentY + 4, -1);
                MutableComponent countComponent = Component.translatable((String)"nomadsshell.upgrade.requirement.you_have", (Object[])new Object[]{playerHas});
                int textColor = playerHas >= required ? -16711936 : -65536;
                g.drawString(this.font, countComponent.getString(), contentX + 20, contentY + 16, textColor);
                contentY += 32;
            }
            for (ItemStack req : node.requirements) {
                PoseStack reqPose = g.pose();
                reqPose.pushPose();
                reqPose.translate((float)contentX, (float)contentY, 100.0f);
                g.renderItem(req, 0, 0);
                reqPose.popPose();
                int playerHas2 = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                int required = req.getCount();
                String reqText = required + "x " + req.getHoverName().getString();
                g.drawString(this.font, reqText, contentX + 20, contentY + 4, -1);
                String countText = Component.translatable((String)"nomadsshell.ui.you_have", (Object[])new Object[]{playerHas2}).getString();
                int textColor = playerHas2 >= required ? -16711936 : -65536;
                g.drawString(this.font, countText, contentX + 20, contentY + 16, textColor);
                contentY += 32;
            }
        }
        boolean unlocked = this.isNodeUnlocked(node, shellStack);
        boolean available = this.isNodeAvailable(node, shellStack);
        this.unlockButtonX = contentX;
        this.unlockButtonY = contentY += 12;
        if (unlocked) {
            g.fill(this.unlockButtonX, this.unlockButtonY, this.unlockButtonX + this.unlockButtonW, this.unlockButtonY + this.unlockButtonH, -13792723);
            text = Component.translatable((String)"nomadsshell.ui.unlocked").getString();
            int textW = this.font.width(text);
            g.drawString(this.font, text, this.unlockButtonX + (this.unlockButtonW - textW) / 2, this.unlockButtonY + 8, -1);
        } else if (available) {
            boolean btnHovered;
            boolean isCreative;
            boolean hasRequiredItems = isCreative = player != null && player.getAbilities().instabuild;
            if (!isCreative) {
                hasRequiredItems = true;
                if (node.tagRequirement != null && node.tagCount > 0 && (playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)node.tagRequirement))) < node.tagCount) {
                    hasRequiredItems = false;
                }
                if (hasRequiredItems) {
                    for (ItemStack req : node.requirements) {
                        int playerHas3 = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                        if (playerHas3 >= req.getCount()) continue;
                        hasRequiredItems = false;
                        break;
                    }
                }
            }
            boolean bl = btnHovered = mouseX >= this.unlockButtonX && mouseX <= this.unlockButtonX + this.unlockButtonW && mouseY >= this.unlockButtonY && mouseY <= this.unlockButtonY + this.unlockButtonH;
            int btnColor = hasRequiredItems ? (btnHovered ? -9783553 : -11886849) : -12566464;
            g.fill(this.unlockButtonX, this.unlockButtonY, this.unlockButtonX + this.unlockButtonW, this.unlockButtonY + this.unlockButtonH, btnColor);
            String text = hasRequiredItems ? Component.translatable((String)"nomadsshell.ui.unlock").getString() : Component.translatable((String)"nomadsshell.ui.need_items").getString();
            int textW = this.font.width(text);
            int textColor = hasRequiredItems ? -1 : -8355712;
            g.drawString(this.font, text, this.unlockButtonX + (this.unlockButtonW - textW) / 2, this.unlockButtonY + 8, textColor);
        } else {
            g.fill(this.unlockButtonX, this.unlockButtonY, this.unlockButtonX + this.unlockButtonW, this.unlockButtonY + this.unlockButtonH, -12566464);
            text = Component.translatable((String)"nomadsshell.ui.locked").getString();
            int textW = this.font.width(text);
            g.drawString(this.font, text, this.unlockButtonX + (this.unlockButtonW - textW) / 2, this.unlockButtonY + 8, -8355712);
        }
        RenderSystem.enableDepthTest();
        pose.popPose();
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (this.font.width(String.valueOf(currentLine) + word) > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void drawZoomControls(GuiGraphics g, int sw, int sh, int mouseX, int mouseY) {
        int btnSize = 32;
        int btnX = sw - 48;
        int btnY = sh - 48 - btnSize * 3;
        boolean zoomInHovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= btnY && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, zoomInHovered ? -11513776 : -12961222);
        g.drawString(this.font, "+", btnX + 12, btnY + 12, -1);
        boolean zoomOutHovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= (btnY += btnSize + 8) && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, zoomOutHovered ? -11513776 : -12961222);
        g.drawString(this.font, "-", btnX + 13, btnY + 12, -1);
        boolean resetHovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= (btnY += btnSize + 8) && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, resetHovered ? -11513776 : -12961222);
        g.drawString(this.font, "\u25cb", btnX + 11, btnY + 12, -1);
    }

    private void drawCloseButton(GuiGraphics g, int sw, int sh, int mouseX, int mouseY) {
        int btnSize = 32;
        int btnX = 16;
        int btnY = 16;
        boolean hovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= btnY && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, hovered ? -11513776 : -12961222);
        g.drawString(this.font, "\u2715", btnX + 10, btnY + 12, -1);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.fullscreenOpen) {
            int x = this.getX();
            int y = this.getY();
            int w = this.width;
            int pinX = x + w - 8 - 2;
            int pinY = y + 2;
            if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
                this.togglePin();
                return true;
            }
            if (this.isTitleBarHovered((int)mouseX, (int)mouseY)) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
                this.fullscreenOpen = true;
                return true;
            }
        } else {
            Minecraft mc = Minecraft.getInstance();
            int sw = mc.getWindow().getGuiScaledWidth();
            int sh = mc.getWindow().getGuiScaledHeight();
            int closeBtnX = 16;
            int closeBtnY = 16;
            int closeBtnSize = 32;
            if (mouseX >= (double)closeBtnX && mouseX <= (double)(closeBtnX + closeBtnSize) && mouseY >= (double)closeBtnY && mouseY <= (double)(closeBtnY + closeBtnSize)) {
                this.fullscreenOpen = false;
                this.showDetailsPanel = false;
                return true;
            }
            if (this.showDetailsPanel && mouseX >= (double)this.closeButtonX && mouseX <= (double)(this.closeButtonX + this.closeButtonW) && mouseY >= (double)this.closeButtonY && mouseY <= (double)(this.closeButtonY + this.closeButtonH)) {
                this.showDetailsPanel = false;
                this.selectedNodeId = null;
                return true;
            }
            if (this.showDetailsPanel && mouseX >= (double)this.unlockButtonX && mouseX <= (double)(this.unlockButtonX + this.unlockButtonW) && mouseY >= (double)this.unlockButtonY && mouseY <= (double)(this.unlockButtonY + this.unlockButtonH)) {
                this.handleUnlockClick();
                return true;
            }
            int btnSize = 32;
            int btnX = sw - 48;
            int btnY = sh - 48 - btnSize * 3;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnSize) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnSize)) {
                this.zoom = UpgradeGridConfig.clampZoom(this.zoom + 0.2f);
                return true;
            }
            btnY += btnSize + 8;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnSize) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnSize)) {
                this.zoom = UpgradeGridConfig.clampZoom(this.zoom - 0.2f);
                return true;
            }
            btnY += btnSize + 8;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnSize) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnSize)) {
                this.zoom = 1.0f;
                this.panX = 0.0f;
                this.panY = 0.0f;
                return true;
            }
            if (button == 0) {
                LocalPlayer player = mc.player;
                if (player != null) {
                    ItemStack shellStack = ShellItem.findWornshell((Player)player);
                    for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
                        int worldY;
                        int worldX;
                        if (!node.alwaysVisible && !this.canSeeNode(node, shellStack) || !this.isNodeHovered(worldX = UpgradeGridConfig.gridToPixel(node.gridX), worldY = UpgradeGridConfig.gridToPixel(node.gridY), (int)mouseX, (int)mouseY, sw, sh)) continue;
                        this.selectedNodeId = node.id;
                        this.showDetailsPanel = true;
                        return true;
                    }
                }
                this.panning = true;
                this.panStartMouseX = (int)mouseX;
                this.panStartMouseY = (int)mouseY;
                this.panStartX = this.panX;
                this.panStartY = this.panY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.panning && button == 0) {
            this.panning = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.panning) {
            this.panX = this.panStartX + (float)((int)mouseX - this.panStartMouseX);
            this.panY = this.panStartY + (float)((int)mouseY - this.panStartMouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.fullscreenOpen) {
            float zoomDelta = (float)scrollY * 0.1f;
            this.zoom = UpgradeGridConfig.clampZoom(this.zoom + zoomDelta);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private void handleUnlockClick() {
        boolean isCreative;
        if (this.selectedNodeId == null) {
            return;
        }
        UpgradeDefinitions.UpgradeNode node = UpgradeDefinitions.getNode(this.selectedNodeId);
        if (node == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (!this.isNodeAvailable(node, shellStack) || this.isNodeUnlocked(node, shellStack)) {
            return;
        }
        boolean hasRequiredItems = isCreative = player.getAbilities().instabuild;
        if (!isCreative) {
            int playerHas;
            hasRequiredItems = true;
            if (node.tagRequirement != null && node.tagCount > 0 && (playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)node.tagRequirement))) < node.tagCount) {
                hasRequiredItems = false;
            }
            if (hasRequiredItems) {
                for (ItemStack req : node.requirements) {
                    int playerHas2 = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                    if (playerHas2 >= req.getCount()) continue;
                    hasRequiredItems = false;
                    break;
                }
            }
            if (!hasRequiredItems) {
                return;
            }
        }
        if (node.widgetType != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseWidgetPacket(node.widgetType, node.tier), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            this.handleSubUpgradeUnlock(node.id, (Player)player);
        }
        this.nodeUnlockCache.clear();
        this.cachedShellStack = ItemStack.EMPTY;
    }

    private void handleSubUpgradeUnlock(String nodeId, Player player) {
        if (nodeId.startsWith("furnace_smelt_speed_") || nodeId.startsWith("furnace_fuel_eff_")) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseFurnacePerfUpgradePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        switch (nodeId) {
            case "furnace_template_1": 
            case "furnace_template_2": 
            case "furnace_template_3": 
            case "furnace_template_4": 
            case "furnace_tag_puller": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseFurnaceSlotUpgradePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case "auto_crafter_unlock": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseAutoCrafterPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case "dripstone_2": 
            case "dripstone_3": 
            case "dripstone_4": 
            case "dripstone_5": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseDripstoneCauldronPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case "dripstone_auto_transfer": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseWidgetPacket(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, WidgetUnlockSystem.WidgetTier.TIER_II), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            default: {
                if (player == null) break;
                player.sendSystemMessage((Component)Component.translatable((String)"nomadsshell.ui.unknown_upgrade", (Object[])new Object[]{nodeId}));
            }
        }
    }

    public boolean isFullscreenOpen() {
        return this.fullscreenOpen;
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"nomadsshell.widget.upgrade_tree"));
    }
}

