/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay.guardian;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.ToggleGuardianSettingPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuardianWidget
extends LockableWidget {
    private final IShellMenu menu;
    private boolean logoMode = false;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.GUARDIAN_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.GUARDIAN_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    public GuardianWidget(int x, int y, Font font, IShellMenu menu) {
        super(GuardianWidget.loadPositionX(x), GuardianWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.guardian"), font, WidgetUnlockSystem.WidgetType.GUARDIAN, menu);
        this.menu = menu;
        this.isPinned = (Boolean)OverlayConfig.GUARDIAN_PINNED.get();
        this.updateWidgetDimensions();
    }

    @Override
    protected void updateWidgetDimensions() {
        int requiredHeight = this.calculateRequiredHeight();
        this.width = 140;
        this.height = requiredHeight;
    }

    private int calculateRequiredHeight() {
        ItemStack shell;
        int height = 20;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && !(shell = ShellItem.findWornshell((Player)player)).isEmpty()) {
            WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.GUARDIAN;
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
            int tierLevel = currentTier.getLevel();
            int availableWidth = 132;
            int buttonWidth = 30;
            int spacing = 10;
            int textWidth = availableWidth - buttonWidth - spacing;
            if (tierLevel >= 6) {
                height += this.calculateTextHeight("nomadsshell.guardian.torch_light", textWidth);
            }
            if (tierLevel >= 7) {
                height += this.calculateTextHeight("nomadsshell.guardian.powder_snow_assist", textWidth);
            }
            if (tierLevel >= 8) {
                height += this.calculateTextHeight("nomadsshell.guardian.piglin_friendly", textWidth);
            }
            if (tierLevel >= 9) {
                height += this.calculateTextHeight("nomadsshell.guardian.stealth_slowfall", textWidth);
            }
            if (tierLevel >= 10) {
                height += this.calculateTextHeight("nomadsshell.guardian.standing_invisibility", textWidth);
            }
            if (tierLevel >= 1) {
                height += 12;
            }
        }
        return Math.max(height, 36);
    }

    private int calculateTextHeight(String translationKey, int maxWidth) {
        String text = Component.translatable((String)translationKey).getString();
        if (this.font.width(text) <= maxWidth) {
            return 14;
        }
        String[] words = text.split(" ");
        int lines = 1;
        int currentWidth = 0;
        for (String word : words) {
            int wordWidth = this.font.width(word + " ");
            if (currentWidth + wordWidth > maxWidth) {
                ++lines;
                currentWidth = wordWidth;
                continue;
            }
            currentWidth += wordWidth;
        }
        Objects.requireNonNull(this.font);
        return Math.max(14, lines * 9 + 2);
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float pt) {
        String armorInfo;
        boolean titleBarHovered;
        boolean hoveredWidget;
        this.updateWidgetDimensions();
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean imageEnabled = (Boolean)OverlayConfig.GUARDIAN_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.GUARDIAN);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, w, h - 12);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.GUARDIAN;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x - 1, y - 1, x + w + 1, y + 12, Theme.panelBorder());
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        boolean bl2 = titleBarHovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            g.fill(x, y, x + w, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = h - 12;
        g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
        boolean torch = WidgetDataHelper.isGuardianTorchEnabled((Player)player);
        boolean snow = WidgetDataHelper.isGuardianSnowEnabled((Player)player);
        boolean pig = WidgetDataHelper.isGuardianPiglinEnabled((Player)player);
        boolean slowFall = WidgetDataHelper.isGuardianSlowfallEnabled((Player)player);
        boolean invisibility = WidgetDataHelper.isGuardianInvisibilityEnabled((Player)player);
        int by = contentY + 4;
        int availableWidth = w - 8;
        int buttonWidth = 30;
        int spacing = 10;
        int textWidth = availableWidth - buttonWidth - spacing;
        if (tierLevel >= 6) {
            this.drawToggle(g, x + 4, by, availableWidth, 12, torch, Component.translatable((String)"nomadsshell.guardian.torch_light").getString());
            by += this.calculateTextHeight("nomadsshell.guardian.torch_light", textWidth);
        }
        if (tierLevel >= 7) {
            this.drawToggle(g, x + 4, by, availableWidth, 12, snow, Component.translatable((String)"nomadsshell.guardian.powder_snow_assist").getString());
            by += this.calculateTextHeight("nomadsshell.guardian.powder_snow_assist", textWidth);
        }
        if (tierLevel >= 8) {
            this.drawToggle(g, x + 4, by, availableWidth, 12, pig, Component.translatable((String)"nomadsshell.guardian.piglin_friendly").getString());
            by += this.calculateTextHeight("nomadsshell.guardian.piglin_friendly", textWidth);
        }
        if (tierLevel >= 9) {
            this.drawToggle(g, x + 4, by, availableWidth, 12, slowFall, Component.translatable((String)"nomadsshell.guardian.stealth_slowfall").getString());
            by += this.calculateTextHeight("nomadsshell.guardian.stealth_slowfall", textWidth);
        }
        if (tierLevel >= 10) {
            this.drawToggle(g, x + 4, by, availableWidth, 12, invisibility, Component.translatable((String)"nomadsshell.guardian.standing_invisibility").getString());
            by += this.calculateTextHeight("nomadsshell.guardian.standing_invisibility", textWidth);
        }
        if (!(armorInfo = this.getArmorInfoForTier(tierLevel)).isEmpty()) {
            g.drawString(this.font, armorInfo, x + 4, by, Theme.textSecondary());
        }
    }

    private String getArmorInfoForTier(int tierLevel) {
        return switch (tierLevel) {
            case 1 -> Component.translatable((String)"nomadsshell.guardian.armor.leather").getString();
            case 2 -> Component.translatable((String)"nomadsshell.guardian.armor.golden").getString();
            case 3 -> Component.translatable((String)"nomadsshell.guardian.armor.iron").getString();
            case 4 -> Component.translatable((String)"nomadsshell.guardian.armor.diamond").getString();
            case 5 -> Component.translatable((String)"nomadsshell.guardian.armor.netherite").getString();
            case 6 -> Component.translatable((String)"nomadsshell.guardian.armor.netherite_torch").getString();
            case 7 -> Component.translatable((String)"nomadsshell.guardian.armor.netherite_snow").getString();
            case 8 -> Component.translatable((String)"nomadsshell.guardian.armor.netherite_piglin").getString();
            case 9 -> Component.translatable((String)"nomadsshell.guardian.armor.netherite_slowfall").getString();
            case 10 -> Component.translatable((String)"nomadsshell.guardian.armor.netherite_invisibility").getString();
            default -> "";
        };
    }

    private void drawToggle(GuiGraphics g, int x, int y, int w, int h, boolean on, String label) {
        String toggleText = on ? Component.translatable((String)"nomadsshell.ui.on").getString() : Component.translatable((String)"nomadsshell.ui.off").getString();
        int toggleTextWidth = this.font.width(toggleText);
        Objects.requireNonNull(this.font);
        int toggleTextHeight = 9;
        int buttonBg = on ? -14001622 : -10868182;
        int buttonBorder = on ? -11141291 : -43691;
        g.fill(x + 4, y + 1, x + 4 + toggleTextWidth + 6, y + 1 + toggleTextHeight + 2, buttonBg);
        g.fill(x + 3, y, x + 4 + toggleTextWidth + 7, y + 1, buttonBorder);
        g.fill(x + 3, y + toggleTextHeight + 2, x + 4 + toggleTextWidth + 7, y + toggleTextHeight + 3, buttonBorder);
        g.fill(x + 3, y, x + 4, y + toggleTextHeight + 3, buttonBorder);
        g.fill(x + 4 + toggleTextWidth + 6, y, x + 4 + toggleTextWidth + 7, y + toggleTextHeight + 3, buttonBorder);
        g.drawString(this.font, toggleText, x + 7, y + 2, -1);
        int labelStartX = x + 4 + toggleTextWidth + 10;
        int availableWidth = w - (labelStartX - x) - 4;
        this.drawWrappedText(g, label, labelStartX, y + 2, availableWidth, Theme.textPrimary());
    }

    private void drawWrappedText(GuiGraphics g, String text, int x, int y, int maxWidth, int color) {
        if (this.font.width(text) <= maxWidth) {
            g.drawString(this.font, text, x, y, color);
        } else {
            String[] words = text.split(" ");
            StringBuilder currentLine = new StringBuilder();
            int currentY = y;
            for (String word : words) {
                String testLine;
                String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
                if (this.font.width(testLine) <= maxWidth) {
                    currentLine = new StringBuilder(testLine);
                    continue;
                }
                if (currentLine.length() > 0) {
                    g.drawString(this.font, currentLine.toString(), x, currentY, color);
                    Objects.requireNonNull(this.font);
                    currentY += 9;
                }
                currentLine = new StringBuilder(word);
            }
            if (currentLine.length() > 0) {
                g.drawString(this.font, currentLine.toString(), x, currentY, color);
            }
        }
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.GUARDIAN_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.GUARDIAN_USE_IMAGE_MODE.get();
        OverlayConfig.GUARDIAN_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int contentY, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = contentY + (currentHeight - iconSize) / 2;
        guiGraphics.blit(Theme.icon("shield"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.GUARDIAN);
        this.logoMode = false;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.GUARDIAN;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        if (button == 0) {
            int by = y + 16;
            int availableWidth = w - 8;
            int buttonWidth = 30;
            int spacing = 10;
            int textWidth = availableWidth - buttonWidth - spacing;
            if (tierLevel >= 6) {
                if (this.isClickingOnToggle(mouseX, mouseY, x + 4, by)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ToggleGuardianSettingPacket(ToggleGuardianSettingPacket.Setting.TORCH), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                by += this.calculateTextHeight("nomadsshell.guardian.torch_light", textWidth);
            }
            if (tierLevel >= 7) {
                if (this.isClickingOnToggle(mouseX, mouseY, x + 4, by)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ToggleGuardianSettingPacket(ToggleGuardianSettingPacket.Setting.SNOW), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                by += this.calculateTextHeight("nomadsshell.guardian.powder_snow_assist", textWidth);
            }
            if (tierLevel >= 8) {
                if (this.isClickingOnToggle(mouseX, mouseY, x + 4, by)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ToggleGuardianSettingPacket(ToggleGuardianSettingPacket.Setting.PIGLIN), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                by += this.calculateTextHeight("nomadsshell.guardian.piglin_friendly", textWidth);
            }
            if (tierLevel >= 9) {
                if (this.isClickingOnToggle(mouseX, mouseY, x + 4, by)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ToggleGuardianSettingPacket(ToggleGuardianSettingPacket.Setting.STEALTH), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                by += this.calculateTextHeight("nomadsshell.guardian.stealth_slowfall", textWidth);
            }
            if (tierLevel >= 10 && this.isClickingOnToggle(mouseX, mouseY, x + 4, by)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ToggleGuardianSettingPacket(ToggleGuardianSettingPacket.Setting.INVISIBILITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isClickingOnToggle(double mouseX, double mouseY, int x, int y) {
        int buttonWidth = 35;
        return mouseX >= (double)(x + 4) && mouseX <= (double)(x + 4 + buttonWidth) && mouseY >= (double)y && mouseY <= (double)(y + 12);
    }

    private boolean inside(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx <= (double)(x + w) && my >= (double)y && my <= (double)(y + h);
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.GUARDIAN_X.set((Object)this.getX());
            OverlayConfig.GUARDIAN_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.GUARDIAN_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void stopDragging() {
        super.stopDragging();
        this.savePositionToConfig();
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean inside;
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean inside;
        if (!this.isActive()) {
            return false;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        return inside;
    }
}

