/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class OverlayConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.BooleanValue ENABLE_TRASH_BIN;
    public static final ModConfigSpec.BooleanValue ENABLE_FURNACE;
    public static final ModConfigSpec.BooleanValue ENABLE_CRAFTING_TABLE;
    public static final ModConfigSpec.BooleanValue ENABLE_SETTINGS;
    public static final ModConfigSpec.BooleanValue ENABLE_UPGRADE;
    public static final ModConfigSpec.BooleanValue ENABLE_OVERLAY_FEATURES;
    public static final ModConfigSpec.IntValue TRASH_DELETE_DELAY;
    public static final ModConfigSpec.BooleanValue TRASH_BIN_PINNED;
    public static final ModConfigSpec.IntValue TRASH_BIN_X;
    public static final ModConfigSpec.IntValue TRASH_BIN_Y;
    public static final ModConfigSpec.ConfigValue<String> TRASH_BIN_ITEM_NBT;
    public static final ModConfigSpec.IntValue TRASH_BIN_ITEM_COUNT;
    public static final ModConfigSpec.BooleanValue TRASH_BIN_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue FURNACE_PINNED;
    public static final ModConfigSpec.BooleanValue FURNACE_EXPANDED;
    public static final ModConfigSpec.IntValue FURNACE_X;
    public static final ModConfigSpec.IntValue FURNACE_Y;
    public static final ModConfigSpec.ConfigValue<String> FURNACE_INPUT_NBT;
    public static final ModConfigSpec.IntValue FURNACE_INPUT_COUNT;
    public static final ModConfigSpec.ConfigValue<String> FURNACE_FUEL_NBT;
    public static final ModConfigSpec.IntValue FURNACE_FUEL_COUNT;
    public static final ModConfigSpec.ConfigValue<String> FURNACE_OUTPUT_NBT;
    public static final ModConfigSpec.IntValue FURNACE_OUTPUT_COUNT;
    public static final ModConfigSpec.IntValue FURNACE_SMELTING_PROGRESS;
    public static final ModConfigSpec.IntValue FURNACE_FUEL_BURN_TIME;
    public static final ModConfigSpec.IntValue FURNACE_MAX_FUEL_BURN_TIME;
    public static final ModConfigSpec.BooleanValue FURNACE_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue TRAVELERS_GARDEN_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue CRAFTING_TABLE_PINNED;
    public static final ModConfigSpec.BooleanValue CRAFTING_TABLE_EXPANDED;
    public static final ModConfigSpec.IntValue CRAFTING_TABLE_X;
    public static final ModConfigSpec.IntValue CRAFTING_TABLE_Y;
    public static final ModConfigSpec.BooleanValue CRAFTING_TABLE_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue CRAFTING_TABLE_COLLAPSED;
    public static final ModConfigSpec.BooleanValue SETTINGS_PINNED;
    public static final ModConfigSpec.BooleanValue SETTINGS_EXPANDED;
    public static final ModConfigSpec.IntValue SETTINGS_X;
    public static final ModConfigSpec.IntValue SETTINGS_Y;
    public static final ModConfigSpec.BooleanValue MEMORIZE_SLOT_SHOW_TOOLTIPS;
    public static final ModConfigSpec.BooleanValue ENABLE_ITEM_THROWING;
    public static final ModConfigSpec.IntValue SETTINGS_DISPLAY_MODE;
    public static final ModConfigSpec.IntValue SETTINGS_VISIBLE_HEIGHT;
    public static final ModConfigSpec.IntValue SETTINGS_TAB_COUNT;
    public static final ModConfigSpec.IntValue SETTINGS_CURRENT_TAB;
    public static final ModConfigSpec.IntValue UI_THEME;
    public static final ModConfigSpec.BooleanValue UPGRADE_PINNED;
    public static final ModConfigSpec.IntValue UPGRADE_X;
    public static final ModConfigSpec.IntValue UPGRADE_Y;
    public static final ModConfigSpec.BooleanValue FLUID_TANK_PINNED;
    public static final ModConfigSpec.IntValue FLUID_TANK_X;
    public static final ModConfigSpec.IntValue FLUID_TANK_Y;
    public static final ModConfigSpec.BooleanValue FLUID_TANK_EXPANDED;
    public static final ModConfigSpec.BooleanValue FLUID_TANK_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue DRIPSTONE_PINNED;
    public static final ModConfigSpec.IntValue DRIPSTONE_X;
    public static final ModConfigSpec.IntValue DRIPSTONE_Y;
    public static final ModConfigSpec.BooleanValue DRIPSTONE_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue TRAVELERS_GARDEN_PINNED;
    public static final ModConfigSpec.BooleanValue TRAVELERS_GARDEN_EXPANDED;
    public static final ModConfigSpec.IntValue TRAVELERS_GARDEN_X;
    public static final ModConfigSpec.IntValue TRAVELERS_GARDEN_Y;
    public static final ModConfigSpec.BooleanValue TELEPORTER_PINNED;
    public static final ModConfigSpec.IntValue TELEPORTER_X;
    public static final ModConfigSpec.IntValue TELEPORTER_Y;
    public static final ModConfigSpec.BooleanValue TELEPORTER_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue GUARDIAN_PINNED;
    public static final ModConfigSpec.IntValue GUARDIAN_X;
    public static final ModConfigSpec.IntValue GUARDIAN_Y;
    public static final ModConfigSpec.BooleanValue GUARDIAN_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue ANVIL_PINNED;
    public static final ModConfigSpec.IntValue ANVIL_X;
    public static final ModConfigSpec.IntValue ANVIL_Y;
    public static final ModConfigSpec.BooleanValue ANVIL_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue ANVIL_COLLAPSED;
    public static final ModConfigSpec.BooleanValue COLLECTOR_PINNED;
    public static final ModConfigSpec.IntValue COLLECTOR_X;
    public static final ModConfigSpec.IntValue COLLECTOR_Y;
    public static final ModConfigSpec.BooleanValue COLLECTOR_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_PINNED;
    public static final ModConfigSpec.IntValue AUTO_FEEDER_X;
    public static final ModConfigSpec.IntValue AUTO_FEEDER_Y;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_ENABLED;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_FEED_ON_DAMAGE;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_WAIT_FOR_FULL_HUNGER;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_WAIT_FOR_FULL_DAMAGE;
    public static final ModConfigSpec.BooleanValue MAGNET_PINNED;
    public static final ModConfigSpec.IntValue MAGNET_X;
    public static final ModConfigSpec.IntValue MAGNET_Y;
    public static final ModConfigSpec.BooleanValue MAGNET_USE_IMAGE_MODE;
    public static final ModConfigSpec.BooleanValue MAGNET_ENABLED;
    public static final ModConfigSpec.BooleanValue TRASH_BIN_ENABLED;
    public static final ModConfigSpec.BooleanValue FURNACE_ENABLED;
    public static final ModConfigSpec.BooleanValue CRAFTING_TABLE_ENABLED;
    public static final ModConfigSpec.BooleanValue DRIPSTONE_FARM_ENABLED;
    public static final ModConfigSpec.BooleanValue TRAVELERS_GARDEN_ENABLED;
    public static final ModConfigSpec.BooleanValue COLLECTOR_ENABLED;
    public static final ModConfigSpec.BooleanValue AUTO_FEEDER_ENABLED_GLOBAL;

    public static void setFurnaceConfig(String key, Object value) {
        switch (key) {
            case "furnaceInputNBT": {
                FURNACE_INPUT_NBT.set((Object)((String)value));
                break;
            }
            case "furnaceInputCount": {
                FURNACE_INPUT_COUNT.set((Object)((Integer)value));
                break;
            }
            case "furnaceFuelNBT": {
                FURNACE_FUEL_NBT.set((Object)((String)value));
                break;
            }
            case "furnaceFuelCount": {
                FURNACE_FUEL_COUNT.set((Object)((Integer)value));
                break;
            }
            case "furnaceOutputNBT": {
                FURNACE_OUTPUT_NBT.set((Object)((String)value));
                break;
            }
            case "furnaceOutputCount": {
                FURNACE_OUTPUT_COUNT.set((Object)((Integer)value));
            }
        }
    }

    public static int getDisplayMode() {
        Integer value = (Integer)SETTINGS_DISPLAY_MODE.get();
        return value != null ? value : 0;
    }

    public static int getUiTheme() {
        Integer value = (Integer)UI_THEME.get();
        return value != null ? value : 0;
    }

    static {
        BUILDER.push("Overlay Features");
        ENABLE_OVERLAY_FEATURES = BUILDER.comment("Enable overlay features like trash bin, sorting, etc.").define("enableOverlayFeatures", true);
        ENABLE_TRASH_BIN = BUILDER.comment("Enable the trash bin overlay widget").define("enableTrashBin", true);
        ENABLE_FURNACE = BUILDER.comment("Enable the furnace overlay widget").define("enableFurnace", true);
        ENABLE_CRAFTING_TABLE = BUILDER.comment("Enable the crafting table overlay widget").define("enableCraftingTable", true);
        ENABLE_SETTINGS = BUILDER.comment("Enable the settings overlay widget").define("enableSettings", true);
        ENABLE_UPGRADE = BUILDER.comment("Enable the upgrade overlay widget").define("enableUpgrade", true);
        TRASH_DELETE_DELAY = BUILDER.comment("Delay in ticks before items are deleted from trash bin (20 ticks = 1 second)").defineInRange("trashDeleteDelay", 30, 10, 200);
        BUILDER.pop();
        BUILDER.push("Upgrade Widget State");
        UPGRADE_PINNED = BUILDER.comment("Whether the upgrade widget is pinned").define("upgradePinned", false);
        UPGRADE_X = BUILDER.comment("X position of the upgrade widget").defineInRange("upgradeX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        UPGRADE_Y = BUILDER.comment("Y position of the upgrade widget").defineInRange("upgradeY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Fluid Tank Widget State");
        FLUID_TANK_PINNED = BUILDER.comment("Whether the fluid tank widget is pinned").define("fluidTankPinned", false);
        FLUID_TANK_X = BUILDER.comment("X position of the fluid tank widget").defineInRange("fluidTankX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        FLUID_TANK_Y = BUILDER.comment("Y position of the fluid tank widget").defineInRange("fluidTankY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        FLUID_TANK_EXPANDED = BUILDER.comment("Whether the fluid tank widget is expanded").define("fluidTankExpanded", false);
        FLUID_TANK_USE_IMAGE_MODE = BUILDER.comment("Whether the fluid tank widget uses image (cauldron) mode when idle").define("fluidTankUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Dripstone Farm Widget State");
        DRIPSTONE_PINNED = BUILDER.comment("Whether the dripstone farm widget is pinned").define("dripstonePinned", false);
        DRIPSTONE_X = BUILDER.comment("X position of the dripstone farm widget").defineInRange("dripstoneX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        DRIPSTONE_Y = BUILDER.comment("Y position of the dripstone farm widget").defineInRange("dripstoneY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        DRIPSTONE_USE_IMAGE_MODE = BUILDER.comment("Whether the dripstone farm widget uses image (logo) mode when idle").define("dripstoneUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Travelers Garden Widget State");
        TRAVELERS_GARDEN_PINNED = BUILDER.comment("Whether the travelers garden widget is pinned").define("travelersGardenPinned", false);
        TRAVELERS_GARDEN_EXPANDED = BUILDER.comment("Whether the travelers garden widget is expanded").define("travelersGardenExpanded", false);
        TRAVELERS_GARDEN_X = BUILDER.comment("X position of the travelers garden widget").defineInRange("travelersGardenX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        TRAVELERS_GARDEN_Y = BUILDER.comment("Y position of the travelers garden widget").defineInRange("travelersGardenY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        TELEPORTER_PINNED = BUILDER.comment("Whether the teleporter widget is pinned").define("teleporterPinned", false);
        TELEPORTER_X = BUILDER.comment("X position of the teleporter widget").defineInRange("teleporterX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        TELEPORTER_Y = BUILDER.comment("Y position of the teleporter widget").defineInRange("teleporterY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        TELEPORTER_USE_IMAGE_MODE = BUILDER.comment("Whether the teleporter widget uses image (logo) mode when idle").define("teleporterUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Guardian Widget State");
        GUARDIAN_PINNED = BUILDER.comment("Whether the guardian widget is pinned").define("guardianPinned", false);
        GUARDIAN_X = BUILDER.comment("X position of the guardian widget").defineInRange("guardianX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        GUARDIAN_Y = BUILDER.comment("Y position of the guardian widget").defineInRange("guardianY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        GUARDIAN_USE_IMAGE_MODE = BUILDER.comment("Whether the guardian widget uses image (logo) mode when idle").define("guardianUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Anvil Widget State");
        ANVIL_PINNED = BUILDER.comment("Whether the anvil widget is pinned").define("anvilPinned", false);
        ANVIL_X = BUILDER.comment("X position of the anvil widget").defineInRange("anvilX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        ANVIL_Y = BUILDER.comment("Y position of the anvil widget").defineInRange("anvilY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        ANVIL_USE_IMAGE_MODE = BUILDER.comment("Whether the anvil widget uses image (logo) mode when idle").define("anvilUseImageMode", true);
        ANVIL_COLLAPSED = BUILDER.comment("Whether the anvil widget is collapsed").define("anvilCollapsed", false);
        BUILDER.pop();
        BUILDER.push("Enchantment Table Widget State");
        BUILDER.pop();
        BUILDER.push("Collector Widget State");
        COLLECTOR_PINNED = BUILDER.comment("Whether the collector widget is pinned").define("collectorPinned", false);
        COLLECTOR_X = BUILDER.comment("X position of the collector widget").defineInRange("collectorX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        COLLECTOR_Y = BUILDER.comment("Y position of the collector widget").defineInRange("collectorY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        COLLECTOR_USE_IMAGE_MODE = BUILDER.comment("Whether the collector widget uses image (logo) mode when idle").define("collectorUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Auto Feeder Widget State");
        AUTO_FEEDER_PINNED = BUILDER.comment("Whether the auto feeder widget is pinned").define("autoFeederPinned", false);
        AUTO_FEEDER_X = BUILDER.comment("X position of the auto feeder widget").defineInRange("autoFeederX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        AUTO_FEEDER_Y = BUILDER.comment("Y position of the auto feeder widget").defineInRange("autoFeederY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        AUTO_FEEDER_USE_IMAGE_MODE = BUILDER.comment("Whether the auto feeder widget uses image (logo) mode when idle").define("autoFeederUseImageMode", true);
        AUTO_FEEDER_ENABLED = BUILDER.comment("Whether the auto feeder functionality is enabled").define("autoFeederEnabled", true);
        AUTO_FEEDER_FEED_ON_DAMAGE = BUILDER.comment("Whether to feed when player takes damage").define("autoFeederFeedOnDamage", true);
        AUTO_FEEDER_WAIT_FOR_FULL_HUNGER = BUILDER.comment("Whether to wait for full hunger before feeding").define("autoFeederWaitForFullHunger", false);
        AUTO_FEEDER_WAIT_FOR_FULL_DAMAGE = BUILDER.comment("Whether to wait for full damage before feeding").define("autoFeederWaitForFullDamage", false);
        BUILDER.pop();
        BUILDER.push("Magnet Widget State");
        MAGNET_PINNED = BUILDER.comment("Whether the magnet widget is pinned").define("magnetPinned", false);
        MAGNET_X = BUILDER.comment("X position of the magnet widget").defineInRange("magnetX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        MAGNET_Y = BUILDER.comment("Y position of the magnet widget").defineInRange("magnetY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        MAGNET_USE_IMAGE_MODE = BUILDER.comment("Whether the magnet widget uses image (logo) mode when idle").define("magnetUseImageMode", true);
        MAGNET_ENABLED = BUILDER.comment("Whether the magnet functionality is enabled").define("magnetEnabled", true);
        BUILDER.pop();
        BUILDER.push("Widget Enable/Disable States");
        TRASH_BIN_ENABLED = BUILDER.comment("Whether the trash bin functionality is enabled").define("trashBinEnabled", true);
        FURNACE_ENABLED = BUILDER.comment("Whether the furnace functionality is enabled").define("furnaceEnabled", true);
        CRAFTING_TABLE_ENABLED = BUILDER.comment("Whether the crafting table (including autocrafter) functionality is enabled").define("craftingTableEnabled", true);
        DRIPSTONE_FARM_ENABLED = BUILDER.comment("Whether the dripstone farm functionality is enabled").define("dripstoneFarmEnabled", true);
        TRAVELERS_GARDEN_ENABLED = BUILDER.comment("Whether the traveler's garden functionality is enabled").define("travelersGardenEnabled", true);
        COLLECTOR_ENABLED = BUILDER.comment("Whether the collector functionality is enabled").define("collectorEnabled", true);
        AUTO_FEEDER_ENABLED_GLOBAL = BUILDER.comment("Whether the auto feeder functionality is globally enabled").define("autoFeederEnabledGlobal", true);
        BUILDER.pop();
        BUILDER.push("Trash Bin Widget State");
        TRASH_BIN_PINNED = BUILDER.comment("Whether the trash bin widget is pinned").define("trashBinPinned", false);
        TRASH_BIN_X = BUILDER.comment("X position of the trash bin widget").defineInRange("trashBinX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        TRASH_BIN_Y = BUILDER.comment("Y position of the trash bin widget").defineInRange("trashBinY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        TRASH_BIN_ITEM_NBT = BUILDER.comment("NBT data of the item held in the trash bin (base64 encoded)").define("trashBinItemNBT", (Object)"");
        TRASH_BIN_ITEM_COUNT = BUILDER.comment("Count of the item held in the trash bin").defineInRange("trashBinItemCount", 0, 0, Integer.MAX_VALUE);
        TRASH_BIN_USE_IMAGE_MODE = BUILDER.comment("Whether the trash bin widget uses image (logo) mode when idle").define("trashBinUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Furnace Widget State");
        FURNACE_PINNED = BUILDER.comment("Whether the furnace widget is pinned").define("furnacePinned", false);
        FURNACE_EXPANDED = BUILDER.comment("Whether the furnace widget is expanded").define("furnaceExpanded", false);
        FURNACE_X = BUILDER.comment("X position of the furnace widget").defineInRange("furnaceX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        FURNACE_Y = BUILDER.comment("Y position of the furnace widget").defineInRange("furnaceY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        FURNACE_INPUT_NBT = BUILDER.comment("NBT data of the input item in the furnace (base64 encoded)").define("furnaceInputNBT", (Object)"");
        FURNACE_INPUT_COUNT = BUILDER.comment("Count of the input item in the furnace").defineInRange("furnaceInputCount", 0, 0, Integer.MAX_VALUE);
        FURNACE_FUEL_NBT = BUILDER.comment("NBT data of the fuel item in the furnace (base64 encoded)").define("furnaceFuelNBT", (Object)"");
        FURNACE_FUEL_COUNT = BUILDER.comment("Count of the fuel item in the furnace").defineInRange("furnaceFuelCount", 0, 0, Integer.MAX_VALUE);
        FURNACE_OUTPUT_NBT = BUILDER.comment("NBT data of the output item in the furnace (base64 encoded)").define("furnaceOutputNBT", (Object)"");
        FURNACE_OUTPUT_COUNT = BUILDER.comment("Count of the output item in the furnace").defineInRange("furnaceOutputCount", 0, 0, Integer.MAX_VALUE);
        FURNACE_SMELTING_PROGRESS = BUILDER.comment("Current smelting progress in ticks").defineInRange("furnaceSmeltingProgress", 0, 0, Integer.MAX_VALUE);
        FURNACE_FUEL_BURN_TIME = BUILDER.comment("Current fuel burn time remaining").defineInRange("furnaceFuelBurnTime", 0, 0, Integer.MAX_VALUE);
        FURNACE_MAX_FUEL_BURN_TIME = BUILDER.comment("Maximum fuel burn time for current fuel").defineInRange("furnaceMaxFuelBurnTime", 0, 0, Integer.MAX_VALUE);
        FURNACE_USE_IMAGE_MODE = BUILDER.comment("Whether the furnace widget uses image (logo) mode when idle").define("furnaceUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("travelersGarden");
        TRAVELERS_GARDEN_USE_IMAGE_MODE = BUILDER.comment("Whether the traveler's garden widget uses image (logo) mode when idle").define("travelersGardenUseImageMode", true);
        BUILDER.pop();
        BUILDER.push("Crafting Table Widget State");
        CRAFTING_TABLE_PINNED = BUILDER.comment("Whether the crafting table widget is pinned").define("craftingTablePinned", false);
        CRAFTING_TABLE_EXPANDED = BUILDER.comment("Whether the crafting table widget is expanded").define("craftingTableExpanded", false);
        CRAFTING_TABLE_X = BUILDER.comment("X position of the crafting table widget").defineInRange("craftingTableX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        CRAFTING_TABLE_Y = BUILDER.comment("Y position of the crafting table widget").defineInRange("craftingTableY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        CRAFTING_TABLE_USE_IMAGE_MODE = BUILDER.comment("Whether the crafting table widget uses image (logo) mode when idle").define("craftingTableUseImageMode", true);
        CRAFTING_TABLE_COLLAPSED = BUILDER.comment("Whether the crafting table widget is user-collapsed (compact tile)").define("craftingTableCollapsed", false);
        BUILDER.pop();
        BUILDER.push("Settings Widget State");
        SETTINGS_PINNED = BUILDER.comment("Whether the settings widget is pinned").define("settingsPinned", false);
        SETTINGS_EXPANDED = BUILDER.comment("Whether the settings widget is expanded").define("settingsExpanded", false);
        SETTINGS_X = BUILDER.comment("X position of the settings widget").defineInRange("settingsX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        SETTINGS_Y = BUILDER.comment("Y position of the settings widget").defineInRange("settingsY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        SETTINGS_DISPLAY_MODE = BUILDER.comment("Display mode: 0=Default, 1=Scroll Bar, 2=Tabs, 3=Both").defineInRange("settingsDisplayMode", 0, 0, 3);
        SETTINGS_VISIBLE_HEIGHT = BUILDER.comment("Visible height (rows) when Scroll Bar or Both is selected; 0 uses auto").defineInRange("settingsVisibleHeight", 0, 0, 512);
        SETTINGS_TAB_COUNT = BUILDER.comment("Tab count when Tabs or Both is selected; minimum 1 (no tabs)").defineInRange("settingsTabCount", 1, 1, 64);
        SETTINGS_CURRENT_TAB = BUILDER.comment("Currently selected tab index (0-based), persisted per session").defineInRange("settingsCurrentTab", 0, 0, Integer.MAX_VALUE);
        UI_THEME = BUILDER.comment("UI theme for overlay widgets and settings screens: 0=Dark, 1=Light, 2=Minecraft").defineInRange("uiTheme", 0, 0, 2);
        MEMORIZE_SLOT_SHOW_TOOLTIPS = BUILDER.comment("Show vanilla tooltips for items in backpack slots (can be disabled in memorize slot settings)").define("memorizeSlotShowTooltips", true);
        ENABLE_ITEM_THROWING = BUILDER.comment("Enable Q/Ctrl+Q key to throw items from backpack inventory (Q throws one, Ctrl+Q throws all)").define("enableItemThrowing", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

