/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.config;

import com.etka.nomadsshell.item.ShellTier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ShellConfig {
    public static final ModConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ModConfigSpec.IntValue leatherWidth;
        public final ModConfigSpec.IntValue leatherHeight;
        public final ModConfigSpec.IntValue copperWidth;
        public final ModConfigSpec.IntValue copperHeight;
        public final ModConfigSpec.IntValue ironWidth;
        public final ModConfigSpec.IntValue ironHeight;
        public final ModConfigSpec.IntValue goldWidth;
        public final ModConfigSpec.IntValue goldHeight;
        public final ModConfigSpec.IntValue emeraldWidth;
        public final ModConfigSpec.IntValue emeraldHeight;
        public final ModConfigSpec.IntValue diamondWidth;
        public final ModConfigSpec.IntValue diamondHeight;
        public final ModConfigSpec.IntValue diamondBlockWidth;
        public final ModConfigSpec.IntValue diamondBlockHeight;
        public final ModConfigSpec.IntValue netheriteWidth;
        public final ModConfigSpec.IntValue netheriteHeight;
        public final ModConfigSpec.IntValue teleporterPocketWidth;
        public final ModConfigSpec.IntValue teleporterPocketLength;
        public final ModConfigSpec.IntValue teleporterPocketHeight;
        public final ModConfigSpec.IntValue teleporterPocketBackground;

        Server(ModConfigSpec.Builder builder) {
            builder.comment("Nomad's Shell Configuration").comment("Configure the dimensions for each shell tier").comment("Width = columns, Height = rows").comment("Total slots = width * height").push("shell_dimensions");
            builder.comment("Leather shell dimensions").push("leather");
            this.leatherWidth = builder.comment("Width (columns) of leather shell").defineInRange("width", 8, 1, Integer.MAX_VALUE);
            this.leatherHeight = builder.comment("Height (rows) of leather shell").defineInRange("height", 4, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Teleporter personal pocket settings (server-wide)").push("teleporter_pocket");
            this.teleporterPocketWidth = builder.defineInRange("width", 17, 1, Integer.MAX_VALUE);
            this.teleporterPocketLength = builder.defineInRange("length", 17, 1, Integer.MAX_VALUE);
            this.teleporterPocketHeight = builder.defineInRange("height", 25, 3, Integer.MAX_VALUE);
            this.teleporterPocketBackground = builder.comment("Background sky: 0 = End, 1 = Overworld").defineInRange("background", 0, 0, 1);
            builder.pop();
            builder.comment("Copper shell dimensions").push("copper");
            this.copperWidth = builder.comment("Width (columns) of copper shell").defineInRange("width", 8, 1, Integer.MAX_VALUE);
            this.copperHeight = builder.comment("Height (rows) of copper shell").defineInRange("height", 6, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Iron shell dimensions").push("iron");
            this.ironWidth = builder.comment("Width (columns) of iron shell").defineInRange("width", 10, 1, Integer.MAX_VALUE);
            this.ironHeight = builder.comment("Height (rows) of iron shell").defineInRange("height", 8, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Gold shell dimensions").push("gold");
            this.goldWidth = builder.comment("Width (columns) of gold shell").defineInRange("width", 10, 1, Integer.MAX_VALUE);
            this.goldHeight = builder.comment("Height (rows) of gold shell").defineInRange("height", 10, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Emerald shell dimensions").push("emerald");
            this.emeraldWidth = builder.comment("Width (columns) of emerald shell").defineInRange("width", 10, 1, Integer.MAX_VALUE);
            this.emeraldHeight = builder.comment("Height (rows) of emerald shell").defineInRange("height", 11, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Diamond shell dimensions").push("diamond");
            this.diamondWidth = builder.comment("Width (columns) of diamond shell").defineInRange("width", 10, 1, Integer.MAX_VALUE);
            this.diamondHeight = builder.comment("Height (rows) of diamond shell").defineInRange("height", 12, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Diamond Block shell dimensions").push("diamond_block");
            this.diamondBlockWidth = builder.comment("Width (columns) of diamond block shell").defineInRange("width", 12, 1, Integer.MAX_VALUE);
            this.diamondBlockHeight = builder.comment("Height (rows) of diamond block shell").defineInRange("height", 16, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Netherite shell dimensions").push("netherite");
            this.netheriteWidth = builder.comment("Width (columns) of netherite shell").defineInRange("width", 14, 1, Integer.MAX_VALUE);
            this.netheriteHeight = builder.comment("Height (rows) of netherite shell").defineInRange("height", 20, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
        }

        public int getWidth(ShellTier tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case ShellTier.LEATHER -> (Integer)this.leatherWidth.get();
                case ShellTier.COPPER -> (Integer)this.copperWidth.get();
                case ShellTier.IRON -> (Integer)this.ironWidth.get();
                case ShellTier.GOLD -> (Integer)this.goldWidth.get();
                case ShellTier.EMERALD -> (Integer)this.emeraldWidth.get();
                case ShellTier.DIAMOND -> (Integer)this.diamondWidth.get();
                case ShellTier.DIAMOND_BLOCK -> (Integer)this.diamondBlockWidth.get();
                case ShellTier.NETHERITE -> (Integer)this.netheriteWidth.get();
            };
        }

        public int getHeight(ShellTier tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case ShellTier.LEATHER -> (Integer)this.leatherHeight.get();
                case ShellTier.COPPER -> (Integer)this.copperHeight.get();
                case ShellTier.IRON -> (Integer)this.ironHeight.get();
                case ShellTier.GOLD -> (Integer)this.goldHeight.get();
                case ShellTier.EMERALD -> (Integer)this.emeraldHeight.get();
                case ShellTier.DIAMOND -> (Integer)this.diamondHeight.get();
                case ShellTier.DIAMOND_BLOCK -> (Integer)this.diamondBlockHeight.get();
                case ShellTier.NETHERITE -> (Integer)this.netheriteHeight.get();
            };
        }

        public int getTotalSlots(ShellTier tier) {
            return this.getWidth(tier) * this.getHeight(tier);
        }

        public boolean isCustomDimensionsEnabled() {
            return true;
        }

        public int getMaxWidth() {
            return 0;
        }

        public int getMaxHeight() {
            return 0;
        }

        public void setDimensions(ShellTier tier, int width, int height) {
            switch (tier) {
                case LEATHER: {
                    this.leatherWidth.set((Object)width);
                    this.leatherHeight.set((Object)height);
                    break;
                }
                case COPPER: {
                    this.copperWidth.set((Object)width);
                    this.copperHeight.set((Object)height);
                    break;
                }
                case IRON: {
                    this.ironWidth.set((Object)width);
                    this.ironHeight.set((Object)height);
                    break;
                }
                case GOLD: {
                    this.goldWidth.set((Object)width);
                    this.goldHeight.set((Object)height);
                    break;
                }
                case EMERALD: {
                    this.emeraldWidth.set((Object)width);
                    this.emeraldHeight.set((Object)height);
                    break;
                }
                case DIAMOND: {
                    this.diamondWidth.set((Object)width);
                    this.diamondHeight.set((Object)height);
                    break;
                }
                case DIAMOND_BLOCK: {
                    this.diamondBlockWidth.set((Object)width);
                    this.diamondBlockHeight.set((Object)height);
                    break;
                }
                case NETHERITE: {
                    this.netheriteWidth.set((Object)width);
                    this.netheriteHeight.set((Object)height);
                }
            }
        }
    }
}

