/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.event;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.command.WidgetDebugCommand;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.menu.VirtualShellMenu;
import com.etka.nomadsshell.network.UpdatePlantProgressPacket;
import com.etka.nomadsshell.util.AutoCraftRecipe;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.ItemStackData;
import com.etka.nomadsshell.util.VirtualInventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.etka.nomadsshell.world.PocketDimensionHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class ServerEventHandler {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        WidgetDebugCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
            ServerEventHandler.tickPlayerFurnace(player);
            ServerEventHandler.tickDripstoneFarm(player);
            ServerEventHandler.tickTravelersGarden(player);
            ServerEventHandler.tickGuardian(player);
            ServerEventHandler.tickAutoCrafter(player);
            ServerEventHandler.tickCollector(player);
            ServerEventHandler.tickAutoFeeder(player);
            ServerEventHandler.tickMagnet(player);
            ServerEventHandler.enforcePocketBounds(player);
            ServerEventHandler.enforcePocketSafety(player);
        }
    }

    private static void enforcePocketBounds(ServerPlayer player) {
        boolean outOfBounds;
        ServerLevel level = player.serverLevel();
        ResourceKey dim = level.dimension();
        if (!dim.equals(PocketDimensionHelper.POCKET_LEVEL_END) && !dim.equals(PocketDimensionHelper.POCKET_LEVEL_OVERWORLD)) {
            return;
        }
        UUID id = player.getUUID();
        long a = id.getMostSignificantBits();
        long b = id.getLeastSignificantBits();
        int grid = 384;
        int cellX = (int)((a ^ a >>> 32) & 0x7FFFL);
        int cellZ = (int)((b ^ b >>> 32) & 0x7FFFL);
        int baseX = cellX % 256 * grid;
        int baseZ = cellZ % 256 * grid;
        int baseY = 80;
        BlockPos base = new BlockPos(baseX, baseY, baseZ);
        int width = Math.max(1, (Integer)ShellConfig.SERVER.teleporterPocketWidth.get());
        int length = Math.max(1, (Integer)ShellConfig.SERVER.teleporterPocketLength.get());
        int height = Math.max(3, (Integer)ShellConfig.SERVER.teleporterPocketHeight.get());
        int halfW = width / 2;
        int halfL = length / 2;
        BlockPos min = new BlockPos(base.getX() - halfW, base.getY(), base.getZ() - halfL);
        BlockPos max = new BlockPos(base.getX() + halfW, base.getY() + height - 1, base.getZ() + halfL);
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        boolean bl = outOfBounds = x < (double)min.getX() || x > (double)(max.getX() + 1) || z < (double)min.getZ() || z > (double)(max.getZ() + 1) || y < (double)min.getY() || y > (double)max.getY() + 1.5;
        if (outOfBounds) {
            Vec3 spawn = new Vec3((double)base.getX() + 0.5, (double)base.getY() + 1.0, (double)base.getZ() + 0.5);
            player.fallDistance = 0.0f;
            player.teleportTo(level, spawn.x, spawn.y, spawn.z, player.getYRot(), player.getXRot());
        }
    }

    private static void enforcePocketSafety(ServerPlayer player) {
        BlockPos max;
        ServerLevel level = player.serverLevel();
        ResourceKey dim = level.dimension();
        if (!dim.equals(PocketDimensionHelper.POCKET_LEVEL_END) && !dim.equals(PocketDimensionHelper.POCKET_LEVEL_OVERWORLD)) {
            return;
        }
        BlockPos pos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
        BlockPos feet = BlockPos.containing((double)player.getX(), (double)(player.getY() - 0.2), (double)player.getZ());
        BlockPos below = feet.below();
        boolean inLava = level.getFluidState(pos).is((Fluid)Fluids.LAVA) || level.getBlockState(pos).is(Blocks.LAVA);
        boolean onHazard = ServerEventHandler.isHazardousBlock(level.getBlockState(feet)) || ServerEventHandler.isHazardousBlock(level.getBlockState(below));
        boolean burning = player.isOnFire();
        if (!(inLava || onHazard || burning)) {
            return;
        }
        UUID id = player.getUUID();
        long a = id.getMostSignificantBits();
        long b = id.getLeastSignificantBits();
        int grid = 384;
        int cellX = (int)((a ^ a >>> 32) & 0x7FFFL);
        int cellZ = (int)((b ^ b >>> 32) & 0x7FFFL);
        int baseX = cellX % 256 * grid;
        int baseZ = cellZ % 256 * grid;
        int baseY = 80;
        BlockPos base = new BlockPos(baseX, baseY, baseZ);
        int width = Math.max(1, (Integer)ShellConfig.SERVER.teleporterPocketWidth.get());
        int length = Math.max(1, (Integer)ShellConfig.SERVER.teleporterPocketLength.get());
        int height = Math.max(3, (Integer)ShellConfig.SERVER.teleporterPocketHeight.get());
        int halfW = width / 2;
        int halfL = length / 2;
        BlockPos min = new BlockPos(base.getX() - halfW, base.getY(), base.getZ() - halfL);
        Vec3 safe = ServerEventHandler.findSafeSpot(level, base, min, max = new BlockPos(base.getX() + halfW, base.getY() + height - 1, base.getZ() + halfL));
        if (safe == null) {
            safe = new Vec3((double)base.getX() + 0.5, (double)base.getY() + 1.0, (double)base.getZ() + 0.5);
        }
        player.fallDistance = 0.0f;
        if (burning) {
            player.clearFire();
        }
        player.teleportTo(level, safe.x, safe.y, safe.z, player.getYRot(), player.getXRot());
    }

    private static Vec3 findSafeSpot(ServerLevel level, BlockPos base, BlockPos min, BlockPos max) {
        int y = base.getY();
        if (ServerEventHandler.isSafeFloor(level, new BlockPos(base.getX(), y, base.getZ())) && ServerEventHandler.isOpenAbove(level, new BlockPos(base.getX(), y + 1, base.getZ()))) {
            return new Vec3((double)base.getX() + 0.5, (double)y + 1.0, (double)base.getZ() + 0.5);
        }
        for (int x = min.getX(); x <= max.getX(); ++x) {
            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                BlockPos floor = new BlockPos(x, y, z);
                if (!ServerEventHandler.isSafeFloor(level, floor) || !ServerEventHandler.isOpenAbove(level, floor.above())) continue;
                return new Vec3((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
            }
        }
        return null;
    }

    private static boolean isSafeFloor(ServerLevel level, BlockPos floor) {
        BlockState st = level.getBlockState(floor);
        if (st.isAir()) {
            return false;
        }
        if (ServerEventHandler.isHazardousBlock(st)) {
            return false;
        }
        return level.getFluidState(floor).isEmpty();
    }

    private static boolean isOpenAbove(ServerLevel level, BlockPos posAbove) {
        BlockState s1 = level.getBlockState(posAbove);
        BlockState s2 = level.getBlockState(posAbove.above());
        if (!s1.getCollisionShape((BlockGetter)level, posAbove).isEmpty()) {
            return false;
        }
        if (!s2.getCollisionShape((BlockGetter)level, posAbove.above()).isEmpty()) {
            return false;
        }
        if (!level.getFluidState(posAbove).isEmpty()) {
            return false;
        }
        if (!level.getFluidState(posAbove.above()).isEmpty()) {
            return false;
        }
        return !ServerEventHandler.isHazardousBlock(s1) && !ServerEventHandler.isHazardousBlock(s2);
    }

    private static boolean isHazardousBlock(BlockState st) {
        return st.is(Blocks.LAVA) || st.is(Blocks.FIRE) || st.is(Blocks.CAMPFIRE) || st.is(Blocks.SOUL_CAMPFIRE) || st.is(Blocks.MAGMA_BLOCK) || st.is(Blocks.CACTUS) || st.is(Blocks.WITHER_ROSE) || st.is(Blocks.SWEET_BERRY_BUSH) || st.is(Blocks.POWDER_SNOW) || st.is(Blocks.COBWEB) || st.is(Blocks.LIGHTNING_ROD);
    }

    private static void tickDripstoneFarm(ServerPlayer player) {
        if (!((Boolean)OverlayConfig.DRIPSTONE_FARM_ENABLED.get()).booleanValue()) {
            return;
        }
        int count = WidgetDataHelper.getDripCauldronCount((Player)player);
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < Math.min(5, count); ++i) {
            double p;
            FluidStackData src = WidgetDataHelper.getDripSourceFluidAt((Player)player, i);
            if (src.isEmpty()) continue;
            int mb = WidgetDataHelper.getDripCauldronMbAt((Player)player, i);
            if (mb >= 1000) {
                IFluidHandlerItem handler;
                int filled;
                Optional opt;
                ItemStack bottom;
                int targetContainer;
                boolean autoTransferred = false;
                if (WidgetDataHelper.shouldAutoTransferAt((Player)player, i) && (targetContainer = WidgetDataHelper.getDripTargetContainerAt((Player)player, i)) > 0) {
                    autoTransferred = ServerEventHandler.transferToFluidTank(player, i, targetContainer, src.fluid(), 1000);
                }
                if (autoTransferred || (bottom = WidgetDataHelper.getDripBottomItemAt((Player)player, i)).isEmpty() || !bottom.is(Items.BUCKET) || bottom.getCount() != 1 || !(opt = FluidUtil.getFluidHandler((ItemStack)bottom.copy())).isPresent() || (filled = (handler = (IFluidHandlerItem)opt.get()).fill(new FluidStack(src.fluid(), 1000), IFluidHandler.FluidAction.EXECUTE)) != 1000) continue;
                ItemStack filledOut = handler.getContainer();
                WidgetDataHelper.setDripBottomItemAt((Player)player, i, filledOut);
                WidgetDataHelper.setDripCauldronMbAt((Player)player, i, 0);
                continue;
            }
            double d = p = ServerEventHandler.isWater(src) ? 0.005 : 0.0025;
            if (player.getRandom().nextDouble() < p) {
                mb = Math.min(1000, mb + 50);
                WidgetDataHelper.setDripCauldronMbAt((Player)player, i, mb);
            }
            WidgetDataHelper.setDripProgressAt((Player)player, i, 0);
        }
    }

    private static String mapFarmToCrop(String farmId) {
        return switch (farmId) {
            case "travelersgarden:wheat_farm" -> "minecraft:wheat";
            case "travelersgarden:carrot_farm" -> "minecraft:carrot";
            case "travelersgarden:potato_farm" -> "minecraft:potato";
            case "travelersgarden:beetroot_farm" -> "minecraft:beetroot";
            case "travelersgarden:nether_wart_farm" -> "minecraft:nether_wart";
            case "travelersgarden:red_mushroom_farm" -> "minecraft:red_mushroom";
            case "travelersgarden:brown_mushroom_farm" -> "minecraft:brown_mushroom";
            case "travelersgarden:sweet_berries_farm" -> "minecraft:sweet_berries";
            case "travelersgarden:torchflower_farm" -> "minecraft:torchflower";
            case "travelersgarden:pitcher_plant_farm" -> "minecraft:pitcher_plant";
            default -> null;
        };
    }

    private static void tickTravelersGarden(ServerPlayer player) {
        if (!((Boolean)OverlayConfig.TRAVELERS_GARDEN_ENABLED.get()).booleanValue()) {
            return;
        }
        try {
            ItemStack shell = ShellItem.findWornshell((Player)player);
            if (shell.isEmpty()) {
                return;
            }
            if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, shell)) {
                return;
            }
            int maxPlants = (Integer)shell.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
            int speedBonus = (Integer)shell.getOrDefault(ModDataComponents.TG_SPEED_BONUS.get(), (Object)0);
            List plants = (List)shell.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList());
            if (plants.isEmpty()) {
                return;
            }
            for (int i = 0; i < Math.min(maxPlants, plants.size()); ++i) {
                CompoundTag tag = (CompoundTag)plants.get(i);
                if (tag == null || !tag.contains("cropId")) continue;
                String cropId = tag.getString("cropId");
                int progress = tag.getInt("progress");
                int targetTicks = 37200;
                try {
                    Class<?> cfg = Class.forName("com.etka.travelersgarden.Config");
                    Method m = cfg.getMethod("calculateGrowthTime", String.class);
                    Object result = m.invoke(null, cropId);
                    if (result instanceof Integer) {
                        Integer ti = (Integer)result;
                        targetTicks = ti;
                    }
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
                double multiplier = Math.max(0.1, 1.0 - (double)speedBonus / 100.0);
                int effectiveTarget = Math.max(20, (int)Math.round((double)targetTicks * multiplier));
                if (++progress >= effectiveTarget) {
                    ResourceLocation rl;
                    Item item;
                    progress = 0;
                    String actualCropId = ServerEventHandler.mapFarmToCrop(cropId);
                    if (actualCropId == null) {
                        actualCropId = cropId;
                    }
                    if ((item = (Item)BuiltInRegistries.ITEM.get(rl = ResourceLocation.parse((String)actualCropId))) != null && item != Items.AIR) {
                        try {
                            int quantity = player.getRandom().nextInt(4) + 1;
                            ItemStack out = new ItemStack((ItemLike)item, quantity);
                            int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                            ArrayList<ItemStackData> buffer = new ArrayList<ItemStackData>((Collection)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList()));
                            boolean autoPushEnabled = (Boolean)shell.getOrDefault(ModDataComponents.TG_AUTO_PUSH_ENABLED.get(), (Object)false);
                            if (autoPushEnabled) {
                                ItemStack leftover = InventoryUtils.addItemToShell((Player)player, out);
                                if (!leftover.isEmpty() && !(leftover = InventoryUtils.addItemToPlayerInventory((Player)player, leftover)).isEmpty()) {
                                    player.drop(leftover, false);
                                }
                            } else {
                                boolean buffered = false;
                                for (int b = 0; b < buffer.size(); ++b) {
                                    ItemStackData d = (ItemStackData)buffer.get(b);
                                    ItemStack st = d.toItemStack();
                                    if (st.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)st, (ItemStack)out) || st.getCount() >= st.getMaxStackSize()) continue;
                                    int canAdd = Math.min(out.getCount(), st.getMaxStackSize() - st.getCount());
                                    st.grow(canAdd);
                                    buffer.set(b, ItemStackData.of(st));
                                    out.shrink(canAdd);
                                    if (!out.isEmpty()) continue;
                                    buffered = true;
                                    break;
                                }
                                if (!buffered && buffer.size() < harvestSlots) {
                                    buffer.add(ItemStackData.of(out));
                                    buffered = true;
                                }
                                if (buffered) {
                                    shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), buffer);
                                } else {
                                    ItemStack leftover = InventoryUtils.addItemToShell((Player)player, out);
                                    if (!leftover.isEmpty() && !(leftover = InventoryUtils.addItemToPlayerInventory((Player)player, leftover)).isEmpty()) {
                                        player.drop(leftover, false);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                tag.putInt("progress", progress);
                plants.set(i, tag);
                shell.set(ModDataComponents.TG_PLANTS.get(), (Object)plants);
            }
            if (player.tickCount % 20 == 0) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdatePlantProgressPacket(plants), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isLava(FluidStackData data) {
        return !data.isEmpty() && data.fluid().builtInRegistryHolder().key().location().getPath().contains("lava");
    }

    private static boolean isWater(FluidStackData data) {
        return !data.isEmpty() && data.fluid().builtInRegistryHolder().key().location().getPath().contains("water");
    }

    private static boolean transferToFluidTank(ServerPlayer player, int dripIndex, int targetContainer, Fluid fluid, int amount) {
        try {
            int currentAmount;
            int maxTanks;
            ItemStack shell = ShellItem.findWornshell((Player)player);
            if (shell.isEmpty()) {
                return false;
            }
            if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell)) {
                return false;
            }
            WidgetUnlockSystem.WidgetTier tankTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
            switch (tankTier) {
                default: {
                    throw new MatchException(null, null);
                }
                case TIER_0: 
                case TIER_I: {
                    int n = 1;
                    break;
                }
                case TIER_II: {
                    int n = 2;
                    break;
                }
                case TIER_III: {
                    int n = 3;
                    break;
                }
                case TIER_IV: {
                    int n = 4;
                    break;
                }
                case TIER_V: 
                case TIER_VI: 
                case TIER_VII: 
                case TIER_VIII: 
                case TIER_IX: 
                case TIER_X: {
                    int n = maxTanks = 5;
                }
            }
            if (targetContainer < 1 || targetContainer > maxTanks) {
                return false;
            }
            FluidStackData currentFluid = WidgetDataHelper.getTankFluid((Player)player, targetContainer);
            if (!currentFluid.isEmpty() && currentFluid.fluid() != fluid) {
                return false;
            }
            int tankCapacity = WidgetDataHelper.getTankCapacity((Player)player, targetContainer);
            int availableSpace = tankCapacity - (currentAmount = currentFluid.amount());
            if (availableSpace < amount) {
                return false;
            }
            int newAmount = currentAmount + amount;
            FluidStackData newFluidData = new FluidStackData(fluid, newAmount);
            WidgetDataHelper.setTankFluid((Player)player, targetContainer, newFluidData);
            WidgetDataHelper.setDripCauldronMbAt((Player)player, dripIndex, 0);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static void tickPlayerFurnace(ServerPlayer player) {
        ItemStack remaining;
        ItemStack currentOutput;
        if (!((Boolean)OverlayConfig.FURNACE_ENABLED.get()).booleanValue()) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        WidgetUnlockSystem.WidgetTier furnaceTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shell);
        if (furnaceTier == WidgetUnlockSystem.WidgetTier.TIER_II) {
            ServerEventHandler.handleTierTwoAutoPulling(player);
        }
        if (furnaceTier == WidgetUnlockSystem.WidgetTier.TIER_II && !(currentOutput = WidgetDataHelper.getFurnaceOutputItem((Player)player)).isEmpty() && (remaining = InventoryUtils.addItemToShell((Player)player, currentOutput)).getCount() < currentOutput.getCount()) {
            WidgetDataHelper.setFurnaceOutputItem((Player)player, remaining);
        }
        ItemStack inputItem = WidgetDataHelper.getFurnaceInputItem((Player)player);
        ItemStack fuelItem = WidgetDataHelper.getFurnaceFuelItem((Player)player);
        ItemStack outputItem = WidgetDataHelper.getFurnaceOutputItem((Player)player);
        int smeltingProgress = WidgetDataHelper.getFurnaceSmeltingProgress((Player)player);
        int fuelBurnTime = WidgetDataHelper.getFurnaceFuelBurnTime((Player)player);
        int maxFuelBurnTime = WidgetDataHelper.getFurnaceMaxFuelBurnTime((Player)player);
        int perfLevel = WidgetDataHelper.getFurnacePerfUpgradeLevel((Player)player);
        int speedBonusPct = 0;
        if (perfLevel >= 1) {
            speedBonusPct += 25;
        }
        if (perfLevel >= 3) {
            speedBonusPct += 25;
        }
        if (perfLevel >= 5) {
            speedBonusPct += 50;
        }
        int fuelBonusPct = 0;
        if (perfLevel >= 2) {
            fuelBonusPct += 25;
        }
        if (perfLevel >= 4) {
            fuelBonusPct += 25;
        }
        if (perfLevel >= 6) {
            fuelBonusPct += 50;
        }
        int baseSmeltTicks = 300;
        double speedFactor = 1.0 + (double)speedBonusPct / 100.0;
        int effectiveSmeltTicks = Math.max(1, (int)Math.round(300.0 / speedFactor));
        ItemStack previousInputItem = WidgetDataHelper.getFurnacePreviousInputItem((Player)player);
        boolean inputItemChanged = false;
        if (!inputItem.isEmpty() && !previousInputItem.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)inputItem, (ItemStack)previousInputItem)) {
                inputItemChanged = true;
            }
        } else if (inputItem.isEmpty() != previousInputItem.isEmpty()) {
            inputItemChanged = true;
        }
        if (inputItemChanged && smeltingProgress > 0) {
            smeltingProgress = 0;
            WidgetDataHelper.setFurnaceSmeltingProgress((Player)player, smeltingProgress);
        }
        WidgetDataHelper.setFurnacePreviousInputItem((Player)player, inputItem.isEmpty() ? ItemStack.EMPTY : inputItem.copyWithCount(1));
        boolean progressChanged = false;
        if (fuelBurnTime > 0) {
            --fuelBurnTime;
            progressChanged = true;
        }
        if (ServerEventHandler.canSmelt(player.serverLevel(), inputItem, outputItem)) {
            int burnTime;
            int targetTank;
            if (fuelBurnTime <= 0 && WidgetDataHelper.shouldUseFurnaceLiquidFuel((Player)player) && (targetTank = WidgetDataHelper.getFurnaceLiquidFuelTargetTank((Player)player)) > 0 && ServerEventHandler.tryConsumeLiquidFuel(player, targetTank)) {
                int adjusted;
                int lavaBurnTime = 20000;
                double eff = 0.25 * (1.0 + (double)fuelBonusPct / 100.0);
                fuelBurnTime = adjusted = Math.max(1, (int)Math.floor((double)lavaBurnTime * eff));
                maxFuelBurnTime = adjusted;
                progressChanged = true;
            }
            if (fuelBurnTime <= 0 && !fuelItem.isEmpty() && (burnTime = fuelItem.getBurnTime(RecipeType.SMELTING)) > 0) {
                int adjusted;
                double eff = 0.25 * (1.0 + (double)fuelBonusPct / 100.0);
                fuelBurnTime = adjusted = Math.max(1, (int)Math.floor((double)burnTime * eff));
                maxFuelBurnTime = adjusted;
                if (fuelItem.getItem() == Items.LAVA_BUCKET) {
                    ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
                    InventoryUtils.addItemToShell((Player)player, emptyBucket);
                }
                fuelItem.shrink(1);
                ItemStack newFuelItem = fuelItem.isEmpty() ? ItemStack.EMPTY : fuelItem.copy();
                WidgetDataHelper.setFurnaceFuelItem((Player)player, newFuelItem);
                progressChanged = true;
            }
            if (fuelBurnTime > 0) {
                progressChanged = true;
                if (++smeltingProgress >= effectiveSmeltTicks) {
                    ServerEventHandler.completeSmelting(player);
                    smeltingProgress = 0;
                    progressChanged = true;
                }
            }
        } else if (smeltingProgress > 0) {
            smeltingProgress = 0;
            progressChanged = true;
        }
        if (progressChanged) {
            WidgetDataHelper.setFurnaceSmeltingProgress((Player)player, smeltingProgress);
            WidgetDataHelper.setFurnaceFuelBurnTime((Player)player, fuelBurnTime);
            WidgetDataHelper.setFurnaceMaxFuelBurnTime((Player)player, maxFuelBurnTime);
        }
    }

    private static boolean canSmelt(ServerLevel level, ItemStack inputItem, ItemStack outputItem) {
        if (inputItem.isEmpty()) {
            return false;
        }
        Optional recipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(inputItem), (Level)level);
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess());
        if (outputItem.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)outputItem, (ItemStack)result)) {
            return false;
        }
        return outputItem.getCount() + result.getCount() <= outputItem.getMaxStackSize();
    }

    private static void completeSmelting(ServerPlayer player) {
        ItemStack remaining;
        WidgetUnlockSystem.WidgetTier furnaceTier;
        ItemStack newOutputItem;
        ServerLevel level = player.serverLevel();
        ItemStack currentInput = WidgetDataHelper.getFurnaceInputItem((Player)player);
        ItemStack currentOutput = WidgetDataHelper.getFurnaceOutputItem((Player)player);
        if (currentInput.isEmpty()) {
            return;
        }
        Optional recipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(currentInput), (Level)level);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack result = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
        if (!currentOutput.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)currentOutput, (ItemStack)result)) {
            return;
        }
        ItemStack newInputItem = currentInput.copy();
        newInputItem.shrink(1);
        if (newInputItem.isEmpty()) {
            newInputItem = ItemStack.EMPTY;
        }
        if (currentOutput.isEmpty()) {
            newOutputItem = result.copy();
        } else {
            int space = currentOutput.getMaxStackSize() - currentOutput.getCount();
            if (space <= 0) {
                return;
            }
            int toAdd = Math.min(space, result.getCount());
            newOutputItem = currentOutput.copy();
            newOutputItem.grow(toAdd);
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (!shell.isEmpty() && (furnaceTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shell)) == WidgetUnlockSystem.WidgetTier.TIER_II && (remaining = InventoryUtils.addItemToShell((Player)player, newOutputItem)).getCount() < newOutputItem.getCount()) {
            newOutputItem = remaining;
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.PLAYERS, 1.0f, 1.0f);
        WidgetDataHelper.setFurnaceInputItem((Player)player, newInputItem);
        WidgetDataHelper.setFurnaceOutputItem((Player)player, newOutputItem);
    }

    private static void tickGuardian(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.GUARDIAN, shell)) {
            return;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.GUARDIAN;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shell);
        int tierLevel = currentTier.getLevel();
        ServerEventHandler.applyGuardianArmorEffects(player, tierLevel);
        if (tierLevel >= 6 && WidgetDataHelper.isGuardianTorchEnabled((Player)player)) {
            ServerEventHandler.createTorchLightEffect(player);
        } else {
            ServerEventHandler.cleanupTorchLightEffect(player);
        }
        if (tierLevel >= 7 && WidgetDataHelper.isGuardianSnowEnabled((Player)player)) {
            player.setTicksFrozen(0);
        }
        if (tierLevel >= 9 && WidgetDataHelper.isGuardianSlowfallEnabled((Player)player)) {
            boolean inshellUi;
            boolean bl = inshellUi = player.containerMenu instanceof ShellMenu || player.containerMenu instanceof VirtualShellMenu;
            if (inshellUi) {
                player.fallDistance = 0.0f;
                Holder effect = MobEffects.SLOW_FALLING;
                MobEffectInstance inst = new MobEffectInstance(effect, 10, 0, false, false, false);
                player.addEffect(inst);
            }
        }
        if (tierLevel >= 10 && WidgetDataHelper.isGuardianInvisibilityEnabled((Player)player)) {
            boolean isStandingStill;
            double movement = player.getDeltaMovement().lengthSqr();
            boolean bl = isStandingStill = movement < 0.001;
            if (isStandingStill) {
                Holder invis = MobEffects.INVISIBILITY;
                MobEffectInstance inst2 = new MobEffectInstance(invis, 10, 0, false, false, false);
                player.addEffect(inst2);
            } else if (player.hasEffect(MobEffects.INVISIBILITY)) {
                player.removeEffect(MobEffects.INVISIBILITY);
            }
        }
    }

    private static void tickAutoCrafter(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shell)) {
            return;
        }
        if (!WidgetDataHelper.isAutoCrafterUnlocked((Player)player)) {
            return;
        }
        if (!WidgetDataHelper.isAutoCrafterEnabled((Player)player)) {
            return;
        }
        List<AutoCraftRecipe> recipes = WidgetDataHelper.getAutoCrafterRecipes((Player)player);
        if (recipes.isEmpty()) {
            return;
        }
        if (player.tickCount % 3 != 0) {
            return;
        }
        boolean usingOpenMenu = player.containerMenu instanceof VirtualShellMenu;
        VirtualInventory openInv = null;
        if (usingOpenMenu) {
            openInv = ((VirtualShellMenu)player.containerMenu).getVirtualInventory();
        }
        for (AutoCraftRecipe recipe : recipes) {
            ItemStack remaining;
            boolean hasSpace;
            Object is2;
            if (!recipe.isValid()) continue;
            List template = recipe.templateGrid().stream().map(data -> data.toItemStack()).collect(Collectors.toList());
            HashMap<Item, Integer> required = new HashMap<Item, Integer>();
            for (Object is2 : template) {
                if (is2.isEmpty()) continue;
                required.merge(is2.getItem(), 1, Integer::sum);
            }
            boolean canCraft = true;
            is2 = required.entrySet().iterator();
            while (is2.hasNext()) {
                Map.Entry e;
                int have = usingOpenMenu ? openInv.countItem((Item)e.getKey()) : VirtualInventoryUtils.countItemInVirtualShell((Player)player, (Item)e.getKey());
                if (have >= (Integer)(e = (Map.Entry)is2.next()).getValue()) continue;
                canCraft = false;
                break;
            }
            if (!canCraft) continue;
            ItemStack result = recipe.resultItem().toItemStack();
            boolean bl = hasSpace = usingOpenMenu ? ServerEventHandler.hasSpaceInVirtualInventory(openInv, result) : VirtualInventoryUtils.hasSpaceForItem((Player)player, result);
            if (!hasSpace) continue;
            Iterator have = required.entrySet().iterator();
            while (have.hasNext()) {
                Map.Entry e;
                int removed = usingOpenMenu ? ServerEventHandler.removeItemFromVirtualInventory(openInv, (Item)e.getKey(), (Integer)e.getValue()) : VirtualInventoryUtils.removeItemFromVirtualShell((Player)player, (Item)e.getKey(), (Integer)e.getValue());
                if (removed >= (Integer)(e = have.next()).getValue()) continue;
                canCraft = false;
                break;
            }
            if (!canCraft) continue;
            if (usingOpenMenu) {
                remaining = openInv.addItem(result.copy());
                if (!remaining.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(remaining);
                }
                ShellItem.setVirtualInventory(shell, openInv);
                player.containerMenu.broadcastChanges();
                continue;
            }
            remaining = VirtualInventoryUtils.addItemToVirtualShell((Player)player, result.copy());
            if (remaining.isEmpty()) continue;
            player.getInventory().placeItemBackInInventory(remaining);
        }
    }

    private static int removeItemFromVirtualInventory(VirtualInventory inventory, Item item, int count) {
        int removed = 0;
        for (int slot = 0; slot < inventory.getTotalSlots() && removed < count; ++slot) {
            ItemStack stack = inventory.getItem(slot);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            int toRemove = Math.min(count - removed, stack.getCount());
            ItemStack removedStack = inventory.removeItem(slot, toRemove);
            removed += removedStack.getCount();
        }
        return removed;
    }

    private static boolean hasSpaceInVirtualInventory(VirtualInventory inventory, ItemStack itemStack) {
        if (inventory.findFirstEmptySlot() != -1) {
            return true;
        }
        for (int slot = 0; slot < inventory.getTotalSlots(); ++slot) {
            int space;
            ItemStack existing = inventory.getItem(slot);
            if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)itemStack) || (space = existing.getMaxStackSize() - existing.getCount()) <= 0) continue;
            return true;
        }
        return false;
    }

    private static void applyGuardianArmorEffects(ServerPlayer player, int tierLevel) {
        Holder armorAttribute = Attributes.ARMOR;
        Holder toughnessAttribute = Attributes.ARMOR_TOUGHNESS;
        for (AttributeModifier modifier : player.getAttribute(armorAttribute).getModifiers()) {
            if (!modifier.id().toString().contains("guardian_armor_")) continue;
            player.getAttribute(armorAttribute).removeModifier(modifier.id());
        }
        for (AttributeModifier modifier : player.getAttribute(toughnessAttribute).getModifiers()) {
            if (!modifier.id().toString().contains("guardian_toughness_")) continue;
            player.getAttribute(toughnessAttribute).removeModifier(modifier.id());
        }
        switch (tierLevel) {
            case 1: {
                player.getAttribute(armorAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_armor_1"), 1.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 2: {
                player.getAttribute(armorAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_armor_2"), 2.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 3: {
                player.getAttribute(armorAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_armor_3"), 2.0, AttributeModifier.Operation.ADD_VALUE));
                player.getAttribute(toughnessAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_toughness_3"), 1.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 4: {
                player.getAttribute(armorAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_armor_4"), 3.0, AttributeModifier.Operation.ADD_VALUE));
                player.getAttribute(toughnessAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_toughness_4"), 1.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 5: {
                player.getAttribute(armorAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_armor_5"), 3.0, AttributeModifier.Operation.ADD_VALUE));
                player.getAttribute(toughnessAttribute).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"guardian_toughness_5"), 2.0, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    private static void handleTierTwoAutoPulling(ServerPlayer player) {
        ItemStack currentFuel;
        ItemStack currentInput = WidgetDataHelper.getFurnaceInputItem((Player)player);
        List<ItemStack> inputTemplates = WidgetDataHelper.getFurnaceInputTemplates((Player)player);
        int allowedInput = WidgetDataHelper.getAllowedTemplateSlots((Player)player);
        if (allowedInput >= 8 && inputTemplates.size() >= allowedInput) {
            inputTemplates = new ArrayList<ItemStack>(inputTemplates.subList(0, Math.max(0, allowedInput - 1)));
        }
        List<ResourceLocation> inputTags = WidgetDataHelper.getFurnaceInputTags((Player)player);
        boolean inputWhitelist = WidgetDataHelper.isFurnaceInputTagWhitelist((Player)player);
        for (ItemStack template : inputTemplates) {
            int finalSpaceAvailable;
            boolean pulled;
            int spaceAvailable;
            if (!inputTags.isEmpty() && !WidgetDataHelper.itemMatchesTags(template, inputTags, inputWhitelist) || template.isEmpty() || !WidgetDataHelper.hasTemplateItem((Player)player, template)) continue;
            if (currentInput.isEmpty()) {
                spaceAvailable = template.getMaxStackSize();
            } else {
                if (!ItemStack.isSameItemSameComponents((ItemStack)currentInput, (ItemStack)template)) continue;
                spaceAvailable = currentInput.getMaxStackSize() - currentInput.getCount();
            }
            while (spaceAvailable > 0 && WidgetDataHelper.hasTemplateItem((Player)player, template) && (pulled = WidgetDataHelper.pullTemplateItem((Player)player, template, arg_0 -> ServerEventHandler.lambda$handleTierTwoAutoPulling$1(player, finalSpaceAvailable = spaceAvailable, arg_0)))) {
                currentInput = WidgetDataHelper.getFurnaceInputItem((Player)player);
                if (currentInput.isEmpty()) {
                    spaceAvailable = template.getMaxStackSize();
                    continue;
                }
                spaceAvailable = currentInput.getMaxStackSize() - currentInput.getCount();
            }
            if (spaceAvailable > 0) continue;
            break;
        }
        if ((currentInput.isEmpty() || currentInput.getCount() < currentInput.getMaxStackSize()) && !inputTags.isEmpty()) {
            ItemStack pulled;
            while ((currentInput.isEmpty() || currentInput.getCount() < currentInput.getMaxStackSize()) && !(pulled = WidgetDataHelper.extractItemMatchingTags((Player)player, inputTags, inputWhitelist, false, currentInput)).isEmpty()) {
                if (currentInput.isEmpty()) {
                    currentInput = pulled.copy();
                    WidgetDataHelper.setFurnaceInputItem((Player)player, currentInput);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)currentInput, (ItemStack)pulled) || currentInput.getCount() >= currentInput.getMaxStackSize()) break;
                currentInput.grow(1);
                WidgetDataHelper.setFurnaceInputItem((Player)player, currentInput);
            }
        }
        if ((currentFuel = WidgetDataHelper.getFurnaceFuelItem((Player)player)).isEmpty() || currentFuel.getCount() < currentFuel.getMaxStackSize() / 2) {
            List<ItemStack> fuelTemplates = WidgetDataHelper.getFurnaceFuelTemplates((Player)player);
            int allowedFuel = WidgetDataHelper.getAllowedTemplateSlots((Player)player);
            if (allowedFuel >= 8 && fuelTemplates.size() >= allowedFuel) {
                fuelTemplates = new ArrayList<ItemStack>(fuelTemplates.subList(0, Math.max(0, allowedFuel - 1)));
            }
            List<ResourceLocation> fuelTags = WidgetDataHelper.getFurnaceFuelTags((Player)player);
            boolean fuelWhitelist = WidgetDataHelper.isFurnaceFuelTagWhitelist((Player)player);
            for (ItemStack template : fuelTemplates) {
                int finalSpaceAvailable;
                boolean pulled;
                int spaceAvailable;
                if (!fuelTags.isEmpty() && !WidgetDataHelper.itemMatchesTags(template, fuelTags, fuelWhitelist) || template.isEmpty() || template.getBurnTime(RecipeType.SMELTING) <= 0 || !WidgetDataHelper.hasTemplateItem((Player)player, template)) continue;
                if (currentFuel.isEmpty()) {
                    spaceAvailable = Math.min(template.getMaxStackSize(), 64);
                } else {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)currentFuel, (ItemStack)template)) continue;
                    spaceAvailable = Math.min(currentFuel.getMaxStackSize() - currentFuel.getCount(), 64 - currentFuel.getCount());
                }
                while (spaceAvailable > 0 && WidgetDataHelper.hasTemplateItem((Player)player, template) && (pulled = WidgetDataHelper.pullTemplateItem((Player)player, template, arg_0 -> ServerEventHandler.lambda$handleTierTwoAutoPulling$2(player, finalSpaceAvailable = spaceAvailable, arg_0)))) {
                    currentFuel = WidgetDataHelper.getFurnaceFuelItem((Player)player);
                    if (currentFuel.isEmpty()) {
                        spaceAvailable = Math.min(template.getMaxStackSize(), 64);
                        continue;
                    }
                    spaceAvailable = Math.min(currentFuel.getMaxStackSize() - currentFuel.getCount(), 64 - currentFuel.getCount());
                }
                if (spaceAvailable > 0) continue;
                break;
            }
            if ((currentFuel.isEmpty() || currentFuel.getCount() < Math.min(64, currentFuel.getMaxStackSize())) && !fuelTags.isEmpty()) {
                ItemStack pulled;
                while ((currentFuel.isEmpty() || currentFuel.getCount() < Math.min(64, currentFuel.getMaxStackSize())) && !(pulled = WidgetDataHelper.extractItemMatchingTags((Player)player, fuelTags, fuelWhitelist, true, currentFuel)).isEmpty()) {
                    if (currentFuel.isEmpty()) {
                        currentFuel = pulled.copy();
                        WidgetDataHelper.setFurnaceFuelItem((Player)player, currentFuel);
                        continue;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)currentFuel, (ItemStack)pulled) || currentFuel.getCount() >= Math.min(64, currentFuel.getMaxStackSize())) break;
                    currentFuel.grow(1);
                    WidgetDataHelper.setFurnaceFuelItem((Player)player, currentFuel);
                }
            }
        }
    }

    private static boolean tryConsumeLiquidFuel(ServerPlayer player, int targetTank) {
        int currentAmount;
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return false;
        }
        FluidStackData fluidData = null;
        switch (targetTank) {
            case 1: {
                fluidData = (FluidStackData)shell.get(ModDataComponents.TANK1_FLUID.get());
                break;
            }
            case 2: {
                fluidData = (FluidStackData)shell.get(ModDataComponents.TANK2_FLUID.get());
                break;
            }
            case 3: {
                fluidData = (FluidStackData)shell.get(ModDataComponents.TANK3_FLUID.get());
                break;
            }
            case 4: {
                fluidData = (FluidStackData)shell.get(ModDataComponents.TANK4_FLUID.get());
                break;
            }
            case 5: {
                fluidData = (FluidStackData)shell.get(ModDataComponents.TANK5_FLUID.get());
                break;
            }
            default: {
                return false;
            }
        }
        if (fluidData == null || fluidData.isEmpty()) {
            return false;
        }
        if (fluidData.fluid().builtInRegistryHolder().key().location().getPath().contains("lava") && (currentAmount = fluidData.amount()) >= 1000) {
            FluidStackData newFluidData = new FluidStackData(fluidData.fluid(), currentAmount - 1000);
            switch (targetTank) {
                case 1: {
                    shell.set(ModDataComponents.TANK1_FLUID.get(), (Object)newFluidData);
                    break;
                }
                case 2: {
                    shell.set(ModDataComponents.TANK2_FLUID.get(), (Object)newFluidData);
                    break;
                }
                case 3: {
                    shell.set(ModDataComponents.TANK3_FLUID.get(), (Object)newFluidData);
                    break;
                }
                case 4: {
                    shell.set(ModDataComponents.TANK4_FLUID.get(), (Object)newFluidData);
                    break;
                }
                case 5: {
                    shell.set(ModDataComponents.TANK5_FLUID.get(), (Object)newFluidData);
                }
            }
            return true;
        }
        return false;
    }

    private static void createTorchLightEffect(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        BlockPos pos = player.blockPosition();
        int[] lastPosArray = player.getPersistentData().getIntArray("NomadsShell:torch_light_pos");
        BlockPos lastPos = null;
        if (lastPosArray.length == 3) {
            lastPos = new BlockPos(lastPosArray[0], lastPosArray[1], lastPosArray[2]);
        }
        if (pos.equals(lastPos)) {
            return;
        }
        Set<BlockPos> newLightPositions = ServerEventHandler.calculateLightPositions(pos);
        HashSet oldLightPositions = lastPos != null ? ServerEventHandler.calculateLightPositions(lastPos) : new HashSet();
        HashSet toRemove = new HashSet(oldLightPositions);
        toRemove.removeAll(newLightPositions);
        for (BlockPos p : toRemove) {
            if (!level.getBlockState(p).is(Blocks.LIGHT)) continue;
            level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
        }
        for (BlockPos p : newLightPositions) {
            int lightLevel;
            if (!level.getBlockState(p).isAir() && !level.getBlockState(p).is(Blocks.LIGHT) || (lightLevel = ServerEventHandler.calculateLightLevelFor(p, pos)) <= 0) continue;
            level.setBlock(p, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(lightLevel)), 3);
        }
        player.getPersistentData().putIntArray("NomadsShell:torch_light_pos", new int[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    private static void cleanupTorchLightEffect(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        int[] lastPosArray = player.getPersistentData().getIntArray("NomadsShell:torch_light_pos");
        if (lastPosArray.length == 3) {
            BlockPos lastPos = new BlockPos(lastPosArray[0], lastPosArray[1], lastPosArray[2]);
            Set<BlockPos> toRemove = ServerEventHandler.calculateLightPositions(lastPos);
            for (BlockPos p : toRemove) {
                if (!level.getBlockState(p).is(Blocks.LIGHT)) continue;
                level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        player.getPersistentData().remove("NomadsShell:torch_light_pos");
    }

    private static Set<BlockPos> calculateLightPositions(BlockPos center) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                positions.add(center.offset(x, 0, z));
            }
        }
        positions.add(center.above());
        return positions;
    }

    private static int calculateLightLevelFor(BlockPos target, BlockPos center) {
        if (target.getY() > center.getY()) {
            return 4;
        }
        double distance = Math.sqrt(target.distSqr((Vec3i)center));
        if (distance <= 0.5) {
            return 5;
        }
        if (distance <= 1.0) {
            return 4;
        }
        return 3;
    }

    private static void tickCollector(ServerPlayer player) {
        boolean hasTagFilters;
        if (!((Boolean)OverlayConfig.COLLECTOR_ENABLED.get()).booleanValue()) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.COLLECTOR, shell)) {
            return;
        }
        if (player.tickCount % 1 != 0) {
            return;
        }
        WidgetUnlockSystem.WidgetTier collectorTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.COLLECTOR, shell);
        int slotCount = collectorTier.getLevel() >= 2 ? 5 : 3;
        ItemStack[] ghostItems = new ItemStack[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            ghostItems[i] = WidgetDataHelper.getCollectorItem((Player)player, i);
        }
        List<Object> collectorTags = List.of();
        boolean tagWhitelist = true;
        if (collectorTier.getLevel() >= 2) {
            collectorTags = WidgetDataHelper.getCollectorTags((Player)player);
            tagWhitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)player);
        }
        boolean hasGhostItems = false;
        for (ItemStack ghost : ghostItems) {
            if (ghost.isEmpty()) continue;
            hasGhostItems = true;
            break;
        }
        boolean bl = hasTagFilters = !collectorTags.isEmpty();
        if (!hasGhostItems && !hasTagFilters) {
            return;
        }
        Level level = player.level();
        double pickupRange = 2.0;
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(pickupRange), itemEntity -> !itemEntity.isRemoved() && !itemEntity.getItem().isEmpty() && itemEntity.getAge() > 5);
        for (ItemEntity itemEntity2 : nearbyItems) {
            ItemStack remaining;
            ItemStack itemStack = itemEntity2.getItem();
            if (itemStack.isEmpty()) continue;
            boolean itemMatches = false;
            for (ItemStack ghostItem : ghostItems) {
                if (ghostItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)ghostItem)) continue;
                itemMatches = true;
                break;
            }
            if (!itemMatches && hasTagFilters) {
                Set itemTags = itemStack.getTags().map(tag -> tag.location()).collect(Collectors.toSet());
                itemMatches = tagWhitelist ? collectorTags.stream().anyMatch(itemTags::contains) : collectorTags.stream().noneMatch(itemTags::contains);
            }
            if (!itemMatches || (remaining = InventoryUtils.addItemToShell((Player)player, itemStack)).getCount() >= itemStack.getCount()) continue;
            int taken = itemStack.getCount() - remaining.getCount();
            if (taken > 0) {
                ClientboundTakeItemEntityPacket takePkt = new ClientboundTakeItemEntityPacket(itemEntity2.getId(), player.getId(), taken);
                player.connection.send((Packet)takePkt);
            }
            if (remaining.isEmpty()) {
                itemEntity2.discard();
            } else {
                itemEntity2.setItem(remaining);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f);
            return;
        }
    }

    private static void tickAutoFeeder(ServerPlayer player) {
        boolean tagWhitelist;
        if (!((Boolean)OverlayConfig.AUTO_FEEDER_ENABLED.get()).booleanValue()) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.AUTO_FEEDER, shell)) {
            return;
        }
        if (player.tickCount % 20 != 0) {
            return;
        }
        if (!ServerEventHandler.shouldFeedPlayer(player)) {
            return;
        }
        int slotCount = 4;
        ItemStack[] foodItems = new ItemStack[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            foodItems[i] = WidgetDataHelper.getAutoFeederFood((Player)player, i);
        }
        List<ResourceLocation> autoFeederTags = WidgetDataHelper.getAutoFeederTags((Player)player);
        ItemStack foodToFeed = ServerEventHandler.findSuitableFood(player, foodItems, autoFeederTags, tagWhitelist = WidgetDataHelper.isAutoFeederTagWhitelist((Player)player));
        if (!foodToFeed.isEmpty()) {
            ServerEventHandler.feedPlayer(player, foodToFeed);
        }
    }

    private static boolean shouldFeedPlayer(ServerPlayer player) {
        int foodHungerValue;
        boolean feedOnDamage = WidgetDataHelper.isAutoFeederFeedOnDamage((Player)player);
        boolean waitForFullDamage = WidgetDataHelper.isAutoFeederWaitForFullDamage((Player)player);
        if (feedOnDamage) {
            float health = player.getHealth();
            float maxHealth = player.getMaxHealth();
            if (waitForFullDamage && health > maxHealth - 4.0f) {
                return false;
            }
        }
        int hungerLevel = player.getFoodData().getFoodLevel();
        float saturationLevel = player.getFoodData().getSaturationLevel();
        boolean waitForFullHunger = WidgetDataHelper.isAutoFeederWaitForFullHunger((Player)player);
        return !(waitForFullHunger ? ((foodHungerValue = ServerEventHandler.getNextFoodHungerValue(player)) > 0 ? hungerLevel > 20 - foodHungerValue : hungerLevel >= 20) : hungerLevel >= 20 || saturationLevel > 0.0f);
    }

    private static int getNextFoodHungerValue(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return 0;
        }
        int slotCount = 4;
        ItemStack[] foodItems = new ItemStack[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            foodItems[i] = WidgetDataHelper.getAutoFeederFood((Player)player, i);
        }
        for (ItemStack foodItem : foodItems) {
            FoodProperties foodProperties;
            ItemStack found;
            if (foodItem.isEmpty() || (found = ServerEventHandler.findExactFoodInshell(player, foodItem)).isEmpty() || (foodProperties = found.getFoodProperties((LivingEntity)player)) == null) continue;
            return foodProperties.nutrition();
        }
        return 0;
    }

    private static ItemStack findSuitableFood(ServerPlayer player, ItemStack[] foodItems, List<ResourceLocation> autoFeederTags, boolean tagWhitelist) {
        for (ItemStack foodItem : foodItems) {
            ItemStack found;
            if (foodItem.isEmpty() || (found = ServerEventHandler.findExactFoodInshell(player, foodItem)).isEmpty()) continue;
            return found;
        }
        if (!autoFeederTags.isEmpty()) {
            return ServerEventHandler.findFoodByTags(player, autoFeederTags, tagWhitelist);
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack findFoodByTags(ServerPlayer player, List<ResourceLocation> tags, boolean whitelist) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        for (int i = 0; i < inventory.getTotalSlots(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || stack.getFoodProperties((LivingEntity)player) == null) continue;
            Set itemTags = stack.getTags().map(tag -> tag.location()).collect(Collectors.toSet());
            boolean matchesTags = whitelist ? tags.stream().anyMatch(itemTags::contains) : tags.stream().noneMatch(itemTags::contains);
            if (!matchesTags) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static void feedPlayer(ServerPlayer player, ItemStack food) {
        if (food.isEmpty() || food.getFoodProperties((LivingEntity)player) == null) {
            return;
        }
        ItemStack toEat = food.copy();
        toEat.setCount(1);
        boolean removed = ServerEventHandler.removeExactFoodFromshell(player, food, 1);
        if (removed) {
            if (toEat.getItem() == Items.CHORUS_FRUIT) {
                ServerEventHandler.applyChorusFruitTeleportation(player);
            }
            player.eat(player.level(), toEat);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static ItemStack findExactFoodInshell(ServerPlayer player, ItemStack targetFood) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        for (int i = 0; i < inventory.getTotalSlots(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || stack.getItem() != targetFood.getItem() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetFood)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static boolean removeExactFoodFromshell(ServerPlayer player, ItemStack targetFood, int count) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return false;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            for (int i = 0; i < ShellMenu2.getshellSlotCount(); ++i) {
                ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetFood)) continue;
                int toRemove = Math.min(count, stack.getCount());
                ItemStack newStack = stack.copy();
                newStack.shrink(toRemove);
                ShellMenu2.getshellContainer().setItem(i, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                return true;
            }
        } else {
            AbstractContainerMenu i = player.containerMenu;
            if (i instanceof VirtualShellMenu) {
                VirtualShellMenu virtualMenu = (VirtualShellMenu)i;
                VirtualInventory inv = virtualMenu.getVirtualInventory();
                int total = inv.getTotalSlots();
                for (int i2 = 0; i2 < total; ++i2) {
                    ItemStack stack = inv.getItem(i2);
                    if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetFood)) continue;
                    int toRemove = Math.min(count, stack.getCount());
                    inv.removeItem(i2, toRemove);
                    if (!player.level().isClientSide) {
                        ShellItem.setVirtualInventory(virtualMenu.getshellStack(), inv);
                    }
                    return true;
                }
            } else {
                VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
                for (int i3 = 0; i3 < inventory.getTotalSlots(); ++i3) {
                    ItemStack stack = inventory.getItem(i3);
                    if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetFood)) continue;
                    int toRemove = Math.min(count, stack.getCount());
                    stack.shrink(toRemove);
                    inventory.setItem(i3, stack);
                    ShellItem.setVirtualInventory(shell, inventory);
                    return true;
                }
            }
        }
        return false;
    }

    private static void applyChorusFruitTeleportation(ServerPlayer player) {
        Level level = player.level();
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        boolean isUnderwater = player.isUnderWater();
        for (int i = 0; i < 16; ++i) {
            double newX = x + (player.getRandom().nextDouble() - 0.5) * 16.0;
            double newY = Math.max((double)level.getMinBuildHeight(), Math.min((double)(level.getMaxBuildHeight() - 1), y + (player.getRandom().nextDouble() - 0.5) * 16.0));
            double newZ = z + (player.getRandom().nextDouble() - 0.5) * 16.0;
            boolean teleported = false;
            if (isUnderwater) {
                player.setPos(newX, newY, newZ);
                player.setDeltaMovement(0.0, 0.0, 0.0);
                teleported = true;
            } else {
                teleported = player.randomTeleport(newX, newY, newZ, true);
            }
            if (!teleported) continue;
            level.playSound(null, x, y, z, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.playSound(null, newX, newY, newZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            break;
        }
    }

    private static void tickMagnet(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.MAGNET, shell)) {
            return;
        }
        if (!((Boolean)OverlayConfig.MAGNET_ENABLED.get()).booleanValue()) {
            return;
        }
        if (player.tickCount % 1 != 0) {
            return;
        }
        WidgetUnlockSystem.WidgetTier collectorTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.COLLECTOR, shell);
        int slotCount = collectorTier.getLevel() >= 2 ? 5 : 3;
        ItemStack[] ghostItems = new ItemStack[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            ghostItems[i] = WidgetDataHelper.getCollectorItem((Player)player, i);
        }
        List<Object> collectorTags = List.of();
        boolean tagWhitelist = true;
        if (collectorTier.getLevel() >= 2) {
            collectorTags = WidgetDataHelper.getCollectorTags((Player)player);
            tagWhitelist = WidgetDataHelper.isCollectorTagWhitelist((Player)player);
        }
        double pullRange = 8.0;
        Level level = player.level();
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(pullRange), itemEntity -> !itemEntity.isRemoved() && !itemEntity.getItem().isEmpty() && itemEntity.getAge() > 5);
        for (ItemEntity itemEntity2 : nearbyItems) {
            ItemStack remainingAfterRoute;
            ItemStack itemStack = itemEntity2.getItem();
            if (itemStack.isEmpty()) continue;
            boolean itemMatches = false;
            for (ItemStack ghostItem : ghostItems) {
                if (ghostItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)ghostItem)) continue;
                itemMatches = true;
                break;
            }
            if (!itemMatches && !collectorTags.isEmpty()) {
                Set itemTags = itemStack.getTags().map(tag -> tag.location()).collect(Collectors.toSet());
                itemMatches = tagWhitelist ? collectorTags.stream().anyMatch(itemTags::contains) : collectorTags.stream().noneMatch(itemTags::contains);
            }
            if ((remainingAfterRoute = itemMatches ? InventoryUtils.addItemToShell((Player)player, itemStack) : InventoryUtils.addItemToPlayerInventory((Player)player, itemStack)).getCount() >= itemStack.getCount()) continue;
            int taken = itemStack.getCount() - remainingAfterRoute.getCount();
            if (taken > 0) {
                ClientboundTakeItemEntityPacket takePkt = new ClientboundTakeItemEntityPacket(itemEntity2.getId(), player.getId(), taken);
                player.connection.send((Packet)takePkt);
            }
            if (remainingAfterRoute.isEmpty()) {
                itemEntity2.discard();
            } else {
                itemEntity2.setItem(remainingAfterRoute);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.25f, 1.0f);
            return;
        }
    }

    private static /* synthetic */ void lambda$handleTierTwoAutoPulling$2(ServerPlayer player, int finalSpaceAvailable, ItemStack pulledItem) {
        ItemStack updatedFuel = WidgetDataHelper.getFurnaceFuelItem((Player)player);
        if (updatedFuel.isEmpty()) {
            int amountToAdd = Math.min(pulledItem.getCount(), finalSpaceAvailable);
            ItemStack newFuel = pulledItem.copy();
            newFuel.setCount(amountToAdd);
            WidgetDataHelper.setFurnaceFuelItem((Player)player, newFuel);
        } else {
            int amountToAdd = Math.min(pulledItem.getCount(), finalSpaceAvailable);
            updatedFuel.grow(amountToAdd);
            WidgetDataHelper.setFurnaceFuelItem((Player)player, updatedFuel);
        }
    }

    private static /* synthetic */ void lambda$handleTierTwoAutoPulling$1(ServerPlayer player, int finalSpaceAvailable, ItemStack pulledItem) {
        ItemStack updatedInput = WidgetDataHelper.getFurnaceInputItem((Player)player);
        if (updatedInput.isEmpty()) {
            int amountToAdd = Math.min(pulledItem.getCount(), finalSpaceAvailable);
            ItemStack newInput = pulledItem.copy();
            newInput.setCount(amountToAdd);
            WidgetDataHelper.setFurnaceInputItem((Player)player, newInput);
        } else {
            int amountToAdd = Math.min(pulledItem.getCount(), finalSpaceAvailable);
            updatedInput.grow(amountToAdd);
            WidgetDataHelper.setFurnaceInputItem((Player)player, updatedInput);
        }
    }
}

