/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.menu;

import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VirtualAnvilMenu
extends AnvilMenu {
    private final ServerPlayer player;
    private int repairCost = 0;
    private String renameText = "";
    private boolean processingOnTakeLogic = false;

    public VirtualAnvilMenu(int containerId, Inventory playerInventory, ServerPlayer player) {
        super(containerId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
        this.player = player;
    }

    public void setInputItem(ItemStack item) {
        this.inputSlots.setItem(0, item);
        this.slotsChanged(this.inputSlots);
    }

    public void setMaterialItem(ItemStack item) {
        this.inputSlots.setItem(1, item);
        this.slotsChanged(this.inputSlots);
    }

    public ItemStack getInputItem() {
        return this.inputSlots.getItem(0);
    }

    public ItemStack getMaterialItem() {
        return this.inputSlots.getItem(1);
    }

    public ItemStack getResultItem() {
        return this.resultSlots.getItem(0);
    }

    public int getRepairCost() {
        try {
            Field costField = AnvilMenu.class.getDeclaredField("cost");
            costField.setAccessible(true);
            Object costValue = costField.get((Object)this);
            if (costValue instanceof DataSlot) {
                DataSlot dataSlot = (DataSlot)costValue;
                return dataSlot.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void setRenameText(String text) {
        this.renameText = text;
        try {
            Field itemNameField = AnvilMenu.class.getDeclaredField("itemName");
            itemNameField.setAccessible(true);
            itemNameField.set((Object)this, text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRenameText() {
        return this.renameText;
    }

    public boolean isProcessingOnTakeLogic() {
        return this.processingOnTakeLogic;
    }

    public void updateResult() {
        super.createResult();
    }

    public ItemStack takeResult() {
        ItemStack result = this.resultSlots.getItem(0);
        if (!result.isEmpty()) {
            this.inputSlots.setItem(0, ItemStack.EMPTY);
            this.inputSlots.setItem(1, ItemStack.EMPTY);
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.renameText = "";
            this.setRenameText("");
            this.updateResult();
        }
        return result;
    }

    public boolean canCraft() {
        return !this.resultSlots.getItem(0).isEmpty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
    }

    protected void onTake(Player player, ItemStack stack) {
        this.processingOnTakeLogic = true;
        try {
            super.onTake(player, stack);
        }
        finally {
            this.processingOnTakeLogic = false;
        }
    }
}

