/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.menu;

import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModMenuTypes;
import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VirtualShellMenu
extends AbstractContainerMenu
implements IShellMenu {
    private final ItemStack shellStack;
    private VirtualInventory virtualInventory;
    private int shellWidth;
    private int shellHeight;
    private int totalSlots;
    private int scrollOffset = 0;
    private int maxVisibleRows;
    private boolean needsScrolling;
    private int slotsPerRow;
    private int visibleRows;
    private int startColumn = 0;
    private final Inventory playerInventory;

    public VirtualShellMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buffer) {
        super(ModMenuTypes.VIRTUAL_shell_MENU.get(), containerId);
        Item item;
        ItemStack wornshell;
        this.playerInventory = playerInventory;
        this.shellStack = wornshell = ShellItem.findWornshell(playerInventory.player);
        if (!wornshell.isEmpty() && (item = wornshell.getItem()) instanceof ShellItem) {
            ShellItem ShellItem2 = (ShellItem)item;
            this.shellWidth = ShellItem2.getWidth(wornshell);
            this.shellHeight = ShellItem2.getHeight(wornshell);
            this.virtualInventory = ShellItem.getVirtualInventory(wornshell);
        } else {
            this.shellWidth = 9;
            this.shellHeight = 4;
            this.virtualInventory = new VirtualInventory(9, 4);
        }
        this.initialiseComputedFields();
        this.setupSlots(playerInventory);
    }

    public VirtualShellMenu(int containerId, Inventory playerInventory, ItemStack shellStack) {
        super(ModMenuTypes.VIRTUAL_shell_MENU.get(), containerId);
        this.playerInventory = playerInventory;
        this.shellStack = shellStack;
        this.virtualInventory = ShellItem.getVirtualInventory(shellStack);
        Item item = shellStack.getItem();
        if (item instanceof ShellItem) {
            ShellItem ShellItem2 = (ShellItem)item;
            this.shellWidth = ShellItem2.getWidth(shellStack);
            this.shellHeight = ShellItem2.getHeight(shellStack);
        } else {
            this.shellWidth = 9;
            this.shellHeight = 4;
        }
        this.initialiseComputedFields();
        this.setupSlots(playerInventory);
    }

    private void initialiseComputedFields() {
        this.totalSlots = this.shellWidth * this.shellHeight;
        this.slotsPerRow = this.computeVisibleColumnsAndStart();
        this.maxVisibleRows = this.calculateMaxVisibleRows();
        this.visibleRows = this.computeVisibleRows();
        this.needsScrolling = this.shellHeight > this.visibleRows;
        this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, this.shellHeight - this.visibleRows));
    }

    private int calculateMaxVisibleRows() {
        int requested;
        int displayMode = OverlayConfig.getDisplayMode();
        if ((displayMode == 1 || displayMode == 3) && (requested = ((Integer)OverlayConfig.SETTINGS_VISIBLE_HEIGHT.get()).intValue()) > 0) {
            return Math.min(requested, this.shellHeight);
        }
        return Math.min(25, this.shellHeight);
    }

    private int computeVisibleRows() {
        int requested;
        int displayMode = OverlayConfig.getDisplayMode();
        if ((displayMode == 1 || displayMode == 3) && (requested = ((Integer)OverlayConfig.SETTINGS_VISIBLE_HEIGHT.get()).intValue()) > 0) {
            return Math.max(1, Math.min(requested, this.shellHeight));
        }
        return Math.min(this.shellHeight, this.maxVisibleRows);
    }

    private int computeVisibleColumnsAndStart() {
        int displayMode = OverlayConfig.getDisplayMode();
        if (displayMode == 2 || displayMode == 3) {
            int tabCount = Math.max(1, Math.min((Integer)OverlayConfig.SETTINGS_TAB_COUNT.get(), Math.max(1, this.shellWidth)));
            int currentTab = Math.min(Math.max(0, (Integer)OverlayConfig.SETTINGS_CURRENT_TAB.get()), tabCount - 1);
            int base = this.shellWidth / tabCount;
            int rem = this.shellWidth % tabCount;
            int cols = base + (currentTab < rem ? 1 : 0);
            this.startColumn = currentTab * base + Math.min(currentTab, rem);
            return Math.max(1, Math.min(cols, this.shellWidth));
        }
        this.startColumn = 0;
        return this.shellWidth;
    }

    private void setupSlots(Inventory playerInventory) {
        int xOffset = -(this.startColumn * 18);
        int firstVisibleRow = Math.max(0, Math.min(this.scrollOffset, this.shellHeight));
        int lastVisibleRowExclusive = Math.max(firstVisibleRow, Math.min(this.scrollOffset + this.visibleRows, this.shellHeight));
        int OFFSCREEN_Y = 100000;
        for (int row = 0; row < this.shellHeight; ++row) {
            for (int col = 0; col < this.shellWidth; ++col) {
                int y;
                int slotIndex = row * this.shellWidth + col;
                int x = 8 + col * 18 + xOffset;
                if (row >= firstVisibleRow && row < lastVisibleRowExclusive) {
                    int yOffset = -firstVisibleRow * 18;
                    y = 18 + row * 18 + yOffset;
                } else {
                    y = 100000;
                }
                this.addSlot(new VirtualshellSlot(slotIndex, x, y));
            }
        }
        int shellPixelWidth = this.slotsPerRow * 18;
        int playerInvWidth = 162;
        int playerInvOffset = Math.max(0, (shellPixelWidth - playerInvWidth) / 2);
        int playerInvStartY = 18 + this.visibleRows * 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18 + playerInvOffset, playerInvStartY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18 + playerInvOffset, playerInvStartY + 58));
        }
    }

    public void scroll(int delta) {
        if (!this.needsScrolling) {
            return;
        }
        int newOffset = this.scrollOffset + delta;
        int maxOffset = this.shellHeight - this.visibleRows;
        this.scrollOffset = Math.max(0, Math.min(newOffset, maxOffset));
        this.requestLayoutRefresh();
    }

    private void updateVisibleSlots() {
    }

    private int getActualSlotIndex(int virtualIndex) {
        return Math.max(0, Math.min(virtualIndex, this.totalSlots - 1));
    }

    public VirtualInventory getVirtualInventory() {
        return this.virtualInventory;
    }

    public int getshellWidth() {
        return this.shellWidth;
    }

    public int getshellHeight() {
        return this.shellHeight;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getVisibleColumns() {
        return this.slotsPerRow;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public boolean needsScrolling() {
        return this.needsScrolling;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public int getMaxScrollOffset() {
        return Math.max(0, this.shellHeight - this.visibleRows);
    }

    @Override
    public void applyDimensions(int newWidth, int newHeight) {
        if (newWidth == this.shellWidth && newHeight == this.shellHeight) {
            return;
        }
        VirtualInventory oldInv = this.virtualInventory;
        int oldTotal = oldInv != null ? oldInv.getTotalSlots() : 0;
        int newTotal = newWidth * newHeight;
        if (oldInv != null && newTotal < oldTotal && !this.playerInventory.player.level().isClientSide) {
            for (int i = newTotal; i < oldTotal; ++i) {
                ItemStack extra = oldInv.getItem(i);
                if (extra.isEmpty() || this.playerInventory.player.addItem(extra.copy())) continue;
                this.playerInventory.player.drop(extra.copy(), false);
            }
        }
        this.shellWidth = newWidth;
        this.shellHeight = newHeight;
        this.virtualInventory = oldInv != null ? new VirtualInventory(newWidth, newHeight, oldInv.getAllItems()) : new VirtualInventory(newWidth, newHeight);
        if (!this.playerInventory.player.level().isClientSide) {
            ShellItem.setVirtualInventory(this.shellStack, this.virtualInventory);
        }
        this.initialiseComputedFields();
        this.slots.clear();
        this.setupSlots(this.playerInventory);
    }

    @Override
    public void requestLayoutRefresh() {
        this.slots.clear();
        this.initialiseComputedFields();
        this.setupSlots(this.playerInventory);
    }

    @Override
    public Container getshellContainer() {
        return new SimpleContainer(0);
    }

    @Override
    public ItemStack getshellStack() {
        return this.shellStack;
    }

    public Slot getSlot(int index) {
        if (index < 0 || index >= this.slots.size()) {
            System.err.println("VirtualShellMenu: Attempted to access slot index " + index + " but slots size is " + this.slots.size());
            return null;
        }
        return super.getSlot(index);
    }

    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carriedItem) {
        int maxSlots = this.slots.size();
        int itemsToProcess = Math.min(items.size(), maxSlots);
        for (int i = 0; i < itemsToProcess; ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot == null) continue;
            slot.set(items.get(i));
        }
        this.setCarried(carriedItem);
        this.broadcastChanges();
        if (!this.playerInventory.player.level().isClientSide) {
            System.out.println("VirtualShellMenu: Initialized with " + itemsToProcess + " items, max slots: " + maxSlots);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        if (index < 0 || index >= this.slots.size()) {
            System.err.println("VirtualShellMenu: quickMoveStack attempted to access slot index " + index + " but slots size is " + this.slots.size());
            return ItemStack.EMPTY;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemstack = slotStack.copy();
            int shellSlotCount = this.totalSlots;
            if (index < shellSlotCount) {
                if (!this.moveItemStackTo(slotStack, shellSlotCount, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Map<String, ItemStack> mem = WidgetDataHelper.getMemorizedSlots(player);
                for (Map.Entry<String, ItemStack> e : mem.entrySet()) {
                    int tgt = Integer.parseInt(e.getKey());
                    ItemStack tpl = e.getValue();
                    if (tpl.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)tpl, (ItemStack)slotStack) || !this.moveItemStackTo(slotStack, tgt, tgt + 1, false) || !slotStack.isEmpty()) continue;
                    break;
                }
                int firstVisibleRow = Math.max(0, Math.min(this.scrollOffset, this.shellHeight));
                int lastVisibleRowExclusive = Math.max(firstVisibleRow, Math.min(this.scrollOffset + this.visibleRows, this.shellHeight));
                int firstVisibleCol = Math.max(0, Math.min(this.startColumn, this.shellWidth));
                int lastVisibleColExclusive = Math.max(firstVisibleCol, Math.min(this.startColumn + this.slotsPerRow, this.shellWidth));
                boolean moved = false;
                for (int row = firstVisibleRow; row < lastVisibleRowExclusive && !slotStack.isEmpty(); ++row) {
                    int start = row * this.shellWidth + firstVisibleCol;
                    int endExclusive = row * this.shellWidth + lastVisibleColExclusive;
                    if (start >= endExclusive || !this.moveItemStackTo(slotStack, start, endExclusive, false)) continue;
                    moved = true;
                }
                if (!slotStack.isEmpty() ? !this.moveItemStackTo(slotStack, 0, shellSlotCount, false) : !moved) {
                    return ItemStack.EMPTY;
                }
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            ItemStack shellToSave = this.shellStack;
            if (shellToSave.isEmpty()) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack stack = player.getInventory().getItem(i);
                    if (stack.isEmpty() || !(stack.getItem() instanceof ShellItem)) continue;
                    shellToSave = stack;
                    break;
                }
            }
            if (!shellToSave.isEmpty() && shellToSave.getItem() instanceof ShellItem) {
                ShellItem.setVirtualInventory(shellToSave, this.virtualInventory);
            }
        }
    }

    public class VirtualshellSlot
    extends Slot {
        private final int virtualSlotIndex;

        public VirtualshellSlot(int virtualSlotIndex, int x, int y) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.virtualSlotIndex = virtualSlotIndex;
        }

        public ItemStack getItem() {
            int actualSlot = VirtualShellMenu.this.getActualSlotIndex(this.virtualSlotIndex);
            return VirtualShellMenu.this.virtualInventory.getItem(actualSlot);
        }

        public void set(ItemStack stack) {
            int actualSlot = VirtualShellMenu.this.getActualSlotIndex(this.virtualSlotIndex);
            VirtualShellMenu.this.virtualInventory.setItem(actualSlot, stack);
            this.setChanged();
        }

        public ItemStack remove(int count) {
            int actualSlot = VirtualShellMenu.this.getActualSlotIndex(this.virtualSlotIndex);
            ItemStack result = VirtualShellMenu.this.virtualInventory.removeItem(actualSlot, count);
            if (!result.isEmpty()) {
                this.setChanged();
            }
            return result;
        }

        public boolean mayPlace(ItemStack stack) {
            if (stack.getItem() instanceof ShellItem) {
                return false;
            }
            Player p = VirtualShellMenu.this.playerInventory.player;
            int vIdx = this.virtualSlotIndex;
            ItemStack tpl = WidgetDataHelper.getMemorizedItemAt(p, VirtualShellMenu.this.getActualSlotIndex(vIdx));
            if (!tpl.isEmpty()) {
                return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)tpl);
            }
            return true;
        }

        public int getMaxStackSize() {
            return 64;
        }

        public boolean hasItem() {
            return !this.getItem().isEmpty();
        }

        public void setChanged() {
            super.setChanged();
            if (!VirtualShellMenu.this.playerInventory.player.level().isClientSide) {
                ItemStack shellToSave = VirtualShellMenu.this.shellStack;
                if (shellToSave.isEmpty()) {
                    for (int i = 0; i < VirtualShellMenu.this.playerInventory.player.getInventory().getContainerSize(); ++i) {
                        ItemStack stack = VirtualShellMenu.this.playerInventory.player.getInventory().getItem(i);
                        if (stack.isEmpty() || !(stack.getItem() instanceof ShellItem)) continue;
                        shellToSave = stack;
                        break;
                    }
                }
                if (!shellToSave.isEmpty() && shellToSave.getItem() instanceof ShellItem) {
                    ShellItem.setVirtualInventory(shellToSave, VirtualShellMenu.this.virtualInventory);
                }
            }
        }

        public int getVirtualSlotIndex() {
            return this.virtualSlotIndex;
        }
    }
}

