/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.AutoCraftRecipe;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record AddAutoCrafterRecipePacket(AutoCraftRecipe recipe) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AddAutoCrafterRecipePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"add_auto_crafter_recipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AddAutoCrafterRecipePacket> STREAM_CODEC = StreamCodec.composite(AutoCraftRecipe.STREAM_CODEC, AddAutoCrafterRecipePacket::recipe, AddAutoCrafterRecipePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(AddAutoCrafterRecipePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                AddAutoCrafterRecipePacket.handleServer(player, packet.recipe);
            }
        });
    }

    private static void handleServer(ServerPlayer player, AutoCraftRecipe recipe) {
        if (recipe == null || !recipe.isValid()) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack)) {
            return;
        }
        if (!WidgetDataHelper.isAutoCrafterUnlocked((Player)player)) {
            return;
        }
        List<AutoCraftRecipe> existing = WidgetDataHelper.getAutoCrafterRecipes((Player)player);
        for (AutoCraftRecipe e : existing) {
            if (!e.recipeId().equals((Object)recipe.recipeId())) continue;
            return;
        }
        WidgetDataHelper.addAutoCrafterRecipe((Player)player, recipe);
    }
}

