/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record AnvilSyncPacket(ItemStack inputItem, ItemStack materialItem, ItemStack resultItem, int repairCost, String renameText) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AnvilSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"anvil_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnvilSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, AnvilSyncPacket>(){

        public AnvilSyncPacket decode(RegistryFriendlyByteBuf buffer) {
            boolean hasInput = buffer.readBoolean();
            ItemStack inputItem = hasInput ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            boolean hasMaterial = buffer.readBoolean();
            ItemStack materialItem = hasMaterial ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            boolean hasResult = buffer.readBoolean();
            ItemStack resultItem = hasResult ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            int repairCost = buffer.readVarInt();
            String renameText = buffer.readUtf();
            return new AnvilSyncPacket(inputItem, materialItem, resultItem, repairCost, renameText);
        }

        public void encode(RegistryFriendlyByteBuf buffer, AnvilSyncPacket packet) {
            boolean hasInput = !packet.inputItem().isEmpty();
            buffer.writeBoolean(hasInput);
            if (hasInput) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.inputItem());
            }
            boolean hasMaterial = !packet.materialItem().isEmpty();
            buffer.writeBoolean(hasMaterial);
            if (hasMaterial) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.materialItem());
            }
            boolean hasResult = !packet.resultItem().isEmpty();
            buffer.writeBoolean(hasResult);
            if (hasResult) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.resultItem());
            }
            buffer.writeVarInt(packet.repairCost());
            buffer.writeUtf(packet.renameText());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(AnvilSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> AnvilClientData.updateData(packet.inputItem(), packet.materialItem(), packet.resultItem(), packet.repairCost(), packet.renameText()));
    }

    public static class AnvilClientData {
        private static ItemStack inputItem = ItemStack.EMPTY;
        private static ItemStack materialItem = ItemStack.EMPTY;
        private static ItemStack resultItem = ItemStack.EMPTY;
        private static int repairCost = 0;
        private static String renameText = "";

        public static void updateData(ItemStack input, ItemStack material, ItemStack result, int cost, String text) {
            inputItem = input;
            materialItem = material;
            resultItem = result;
            repairCost = cost;
            renameText = text;
        }

        public static ItemStack getInputItem() {
            return inputItem;
        }

        public static ItemStack getMaterialItem() {
            return materialItem;
        }

        public static ItemStack getResultItem() {
            return resultItem;
        }

        public static int getRepairCost() {
            return repairCost;
        }

        public static String getRenameText() {
            return renameText;
        }
    }
}

