/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.item.ShellTier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ConfigUpdatePacket(Map<ShellTier, ConfigData> tierConfigs) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"config_update"));
    public static final StreamCodec<FriendlyByteBuf, ConfigUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.idMapper(i -> ShellTier.values()[i], Enum::ordinal), ConfigData.STREAM_CODEC), ConfigUpdatePacket::tierConfigs, ConfigUpdatePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ConfigUpdatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (serverPlayer = (ServerPlayer)patt0$temp).hasPermissions(2)) {
                for (Map.Entry<ShellTier, ConfigData> entry : packet.tierConfigs.entrySet()) {
                    ShellTier tier = entry.getKey();
                    ConfigData data = entry.getValue();
                    ShellConfig.SERVER.setDimensions(tier, data.width(), data.height());
                }
                ShellConfig.SERVER_SPEC.save();
            }
        });
    }

    public record ConfigData(int width, int height) {
        public static final StreamCodec<FriendlyByteBuf, ConfigData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ConfigData::width, (StreamCodec)ByteBufCodecs.INT, ConfigData::height, ConfigData::new);
    }
}

