/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.AutoCraftRecipe;
import com.etka.nomadsshell.util.ItemStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CraftingTableSlotInteractionPacket(SlotType slotType, ActionType actionType, int slotIndex, ItemStack itemStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CraftingTableSlotInteractionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"crafting_table_slot_interaction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingTableSlotInteractionPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CraftingTableSlotInteractionPacket>(){

        public CraftingTableSlotInteractionPacket decode(RegistryFriendlyByteBuf buffer) {
            SlotType slotType = (SlotType)buffer.readEnum(SlotType.class);
            ActionType actionType = (ActionType)buffer.readEnum(ActionType.class);
            int slotIndex = buffer.readVarInt();
            boolean hasItem = buffer.readBoolean();
            ItemStack itemStack = hasItem ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            return new CraftingTableSlotInteractionPacket(slotType, actionType, slotIndex, itemStack);
        }

        public void encode(RegistryFriendlyByteBuf buffer, CraftingTableSlotInteractionPacket packet) {
            buffer.writeEnum((Enum)packet.slotType);
            buffer.writeEnum((Enum)packet.actionType);
            buffer.writeVarInt(packet.slotIndex);
            if (packet.itemStack != null && !packet.itemStack.isEmpty()) {
                buffer.writeBoolean(true);
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.itemStack);
            } else {
                buffer.writeBoolean(false);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CraftingTableSlotInteractionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                CraftingTableSlotInteractionPacket.handleSlotInteraction(serverPlayer, packet);
            }
        });
    }

    private static void handleSlotInteraction(ServerPlayer player, CraftingTableSlotInteractionPacket packet) {
        switch (packet.slotType.ordinal()) {
            case 0: {
                CraftingTableSlotInteractionPacket.handleGridSlot(player, packet.slotIndex, packet.actionType, packet.itemStack);
                break;
            }
            case 1: {
                CraftingTableSlotInteractionPacket.handleResultSlot(player, packet.actionType, packet.itemStack);
            }
        }
    }

    private static void handleGridSlot(ServerPlayer player, int slotIndex, ActionType actionType, ItemStack packetItem) {
        if (slotIndex < 0 || slotIndex >= 9) {
            return;
        }
        List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
        ItemStack slotItem = slotIndex < grid.size() ? grid.get(slotIndex) : ItemStack.EMPTY;
        ItemStack carried = player.containerMenu.getCarried();
        switch (actionType.ordinal()) {
            case 0: {
                if (carried.isEmpty()) break;
                if (slotItem.isEmpty()) {
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, carried.copy());
                    player.containerMenu.setCarried(ItemStack.EMPTY);
                    break;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)slotItem)) {
                    int max = Math.min(slotItem.getMaxStackSize(), carried.getMaxStackSize());
                    int canAdd = Math.min(max - slotItem.getCount(), carried.getCount());
                    if (canAdd <= 0) break;
                    ItemStack newSlot = slotItem.copy();
                    newSlot.grow(canAdd);
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, newSlot);
                    carried.shrink(canAdd);
                    if (!carried.isEmpty()) break;
                    player.containerMenu.setCarried(ItemStack.EMPTY);
                    break;
                }
                ItemStack newCarried = slotItem.copy();
                WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, carried.copy());
                player.containerMenu.setCarried(newCarried);
                break;
            }
            case 1: {
                if (carried.isEmpty()) break;
                if (slotItem.isEmpty()) {
                    ItemStack oneItem = carried.copy();
                    oneItem.setCount(1);
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, oneItem);
                    carried.shrink(1);
                    if (!carried.isEmpty()) break;
                    player.containerMenu.setCarried(ItemStack.EMPTY);
                    break;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)slotItem) || slotItem.getCount() >= slotItem.getMaxStackSize()) break;
                slotItem.grow(1);
                WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, slotItem);
                carried.shrink(1);
                if (!carried.isEmpty()) break;
                player.containerMenu.setCarried(ItemStack.EMPTY);
                break;
            }
            case 2: {
                int toAdd;
                if (slotItem.isEmpty()) break;
                if (carried.isEmpty()) {
                    player.containerMenu.setCarried(slotItem.copy());
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, ItemStack.EMPTY);
                    break;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)slotItem) || (toAdd = Math.min(slotItem.getCount(), carried.getMaxStackSize() - carried.getCount())) <= 0) break;
                carried.grow(toAdd);
                slotItem.shrink(toAdd);
                if (slotItem.isEmpty()) {
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, slotItem);
                break;
            }
            case 3: {
                if (slotItem.isEmpty()) break;
                int halfCount = (slotItem.getCount() + 1) / 2;
                if (!carried.isEmpty()) break;
                ItemStack halfStack = slotItem.copy();
                halfStack.setCount(halfCount);
                player.containerMenu.setCarried(halfStack);
                slotItem.shrink(halfCount);
                if (slotItem.isEmpty()) {
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, slotItem);
                break;
            }
            case 4: {
                if (slotItem.isEmpty() || !carried.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)slotItem) || carried.getCount() >= carried.getMaxStackSize())) break;
                if (carried.isEmpty()) {
                    ItemStack oneItem = slotItem.copy();
                    oneItem.setCount(1);
                    player.containerMenu.setCarried(oneItem);
                } else {
                    carried.grow(1);
                }
                slotItem.shrink(1);
                if (slotItem.isEmpty()) {
                    WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, slotItem);
            }
        }
        CraftingTableSlotInteractionPacket.updateCraftingResult(player);
    }

    private static void handleResultSlot(ServerPlayer player, ActionType actionType, ItemStack packetItem) {
        ItemStack result = WidgetDataHelper.getCraftingTableResult((Player)player);
        ItemStack carried = player.containerMenu.getCarried();
        switch (actionType.ordinal()) {
            case 2: {
                int toAdd;
                if (result.isEmpty()) break;
                if (carried.isEmpty()) {
                    player.containerMenu.setCarried(result.copy());
                    CraftingTableSlotInteractionPacket.consumeCraftingIngredients(player);
                    WidgetDataHelper.setCraftingTableResult((Player)player, ItemStack.EMPTY);
                    CraftingTableSlotInteractionPacket.updateCraftingResult(player);
                    CraftingTableSlotInteractionPacket.recordAutoCrafterTemplate(player, result.copy());
                    break;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)result) || (toAdd = Math.min(result.getCount(), carried.getMaxStackSize() - carried.getCount())) <= 0) break;
                carried.grow(toAdd);
                if (toAdd != result.getCount()) break;
                CraftingTableSlotInteractionPacket.consumeCraftingIngredients(player);
                WidgetDataHelper.setCraftingTableResult((Player)player, ItemStack.EMPTY);
                CraftingTableSlotInteractionPacket.updateCraftingResult(player);
                CraftingTableSlotInteractionPacket.recordAutoCrafterTemplate(player, result.copy());
            }
        }
    }

    private static void consumeCraftingIngredients(ServerPlayer player) {
        List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
        ArrayList<ItemStack> newGrid = new ArrayList<ItemStack>();
        for (ItemStack stack : grid) {
            if (!stack.isEmpty()) {
                ItemStack newStack = stack.copy();
                newStack.shrink(1);
                newGrid.add(newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                continue;
            }
            newGrid.add(ItemStack.EMPTY);
        }
        WidgetDataHelper.setCraftingTableGrid((Player)player, newGrid);
    }

    private static void updateCraftingResult(ServerPlayer player) {
        CraftingInput recipeInput;
        List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player player) {
                return true;
            }
        }, 3, 3);
        for (int i2 = 0; i2 < 9 && i2 < grid.size(); ++i2) {
            craftingContainer.setItem(i2, grid.get(i2));
        }
        RecipeManager recipeManager = player.server.getRecipeManager();
        RecipeHolder recipe = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)(recipeInput = CraftingInput.of((int)3, (int)3, IntStream.range(0, 9).mapToObj(i -> i < grid.size() ? (ItemStack)grid.get(i) : ItemStack.EMPTY).toList())), player.level()).orElse(null);
        ItemStack result = recipe != null ? ((CraftingRecipe)recipe.value()).assemble((RecipeInput)recipeInput, (HolderLookup.Provider)player.level().registryAccess()) : ItemStack.EMPTY;
        WidgetDataHelper.setCraftingTableResult((Player)player, result);
    }

    private static void recordAutoCrafterTemplate(ServerPlayer player, ItemStack craftedResult) {
        CraftingInput recipeInput;
        if (!WidgetDataHelper.isAutoCrafterUnlocked((Player)player)) {
            return;
        }
        List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
        List<ItemStackData> templateData = grid.stream().map(stack -> stack.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(stack)).collect(Collectors.toList());
        RecipeManager recipeManager = player.server.getRecipeManager();
        Optional opt = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)(recipeInput = CraftingInput.of((int)3, (int)3, IntStream.range(0, 9).mapToObj(i -> i < grid.size() ? (ItemStack)grid.get(i) : ItemStack.EMPTY).toList())), player.level());
        if (opt.isPresent()) {
            RecipeHolder holder = (RecipeHolder)opt.get();
            String displayName = craftedResult.getHoverName().getString();
            AutoCraftRecipe autoRecipe = new AutoCraftRecipe(templateData, ItemStackData.of(craftedResult), holder.id(), displayName);
            List<AutoCraftRecipe> existing = WidgetDataHelper.getAutoCrafterRecipes((Player)player);
            for (AutoCraftRecipe e : existing) {
                if (!e.recipeId().equals((Object)autoRecipe.recipeId())) continue;
                return;
            }
            WidgetDataHelper.addAutoCrafterRecipe((Player)player, autoRecipe);
        }
    }

    public static enum SlotType {
        GRID,
        RESULT;

    }

    public static enum ActionType {
        PUT_ITEM,
        PUT_ONE,
        TAKE_ITEM,
        TAKE_HALF,
        TAKE_ONE,
        MERGE_ITEM;

    }
}

