/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.init.ModFluids;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.ShellFluidTank;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FluidTankInteractionPacket(int tankIndex, Action action) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FluidTankInteractionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"fluid_tank_interact"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidTankInteractionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, FluidTankInteractionPacket::tankIndex, (StreamCodec)StreamCodec.of((buf, a) -> buf.writeEnum((Enum)a), b -> (Action)b.readEnum(Action.class)), FluidTankInteractionPacket::action, FluidTankInteractionPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(FluidTankInteractionPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            ItemStack carried = sp.containerMenu.getCarried();
            if (carried.isEmpty()) {
                return;
            }
            ShellFluidTank tank = new ShellFluidTank((Player)sp, packet.tankIndex);
            if (packet.action == Action.FILL_FROM_CONTAINER) {
                if (FluidTankInteractionPacket.isWaterRelatedItem(carried)) {
                    FluidTankInteractionPacket.handleWaterRelatedFluid(sp, tank, carried, packet.tankIndex);
                } else if (carried.getItem() == Items.MILK_BUCKET) {
                    FluidTankInteractionPacket.handlePlaceholderFluid(sp, tank, carried, ModFluids.MILK.get());
                } else if (carried.getItem() == Items.POWDER_SNOW_BUCKET) {
                    FluidTankInteractionPacket.handlePlaceholderFluid(sp, tank, carried, ModFluids.POWDER_SNOW.get());
                } else if (carried.getItem() == Items.HONEY_BOTTLE) {
                    FluidTankInteractionPacket.handlePlaceholderFluid(sp, tank, carried, ModFluids.HONEY.get());
                } else if (carried.getItem() == Items.POTION) {
                    FluidTankInteractionPacket.handlePotionFill(sp, tank, carried, packet.tankIndex);
                } else if (carried.getCount() > 1) {
                    FluidActionResult result;
                    FluidActionResult testResult;
                    int containersToEmpty = 0;
                    ItemStack single = carried.copy();
                    single.setCount(1);
                    for (int i = 0; i < carried.getCount() && (testResult = FluidUtil.tryEmptyContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)false)).isSuccess(); ++i) {
                        ++containersToEmpty;
                    }
                    if (containersToEmpty > 0 && (result = FluidUtil.tryEmptyContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)true)).isSuccess()) {
                        for (int i = 1; i < containersToEmpty; ++i) {
                            FluidUtil.tryEmptyContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)true);
                        }
                        carried.shrink(containersToEmpty);
                        ItemStack emptyStack = result.getResult().copy();
                        emptyStack.setCount(containersToEmpty);
                        if (carried.isEmpty()) {
                            sp.containerMenu.setCarried(emptyStack);
                        } else {
                            ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, emptyStack);
                            if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                                sp.drop(leftover, false);
                            }
                            sp.containerMenu.setCarried(carried);
                        }
                        sp.containerMenu.broadcastChanges();
                    }
                } else {
                    FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)carried, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)true);
                    if (result.isSuccess()) {
                        sp.containerMenu.setCarried(result.getResult());
                        sp.containerMenu.broadcastChanges();
                    }
                }
            } else if (packet.action == Action.DRAIN_TO_CONTAINER) {
                FluidStackData data;
                if (carried.getItem() == Items.BUCKET) {
                    data = WidgetDataHelper.getTankFluid((Player)sp, packet.tankIndex);
                    if (data != null && !data.isEmpty()) {
                        if (data.fluid() == ModFluids.MILK.get()) {
                            FluidTankInteractionPacket.handlePlaceholderFluidDrain(sp, tank, carried, Items.MILK_BUCKET, packet.tankIndex);
                            return;
                        }
                        if (data.fluid() == ModFluids.POWDER_SNOW.get()) {
                            FluidTankInteractionPacket.handlePlaceholderFluidDrain(sp, tank, carried, Items.POWDER_SNOW_BUCKET, packet.tankIndex);
                            return;
                        }
                    }
                } else if (carried.getItem() == Items.GLASS_BOTTLE && (data = WidgetDataHelper.getTankFluid((Player)sp, packet.tankIndex)) != null && !data.isEmpty()) {
                    if (data.fluid() == ModFluids.HONEY.get()) {
                        FluidTankInteractionPacket.handlePlaceholderFluidDrain(sp, tank, carried, Items.HONEY_BOTTLE, packet.tankIndex);
                        return;
                    }
                    if (data.fluid() == ModFluids.POTION.get()) {
                        FluidTankInteractionPacket.handlePlaceholderFluidDrain(sp, tank, carried, Items.POTION, packet.tankIndex);
                        return;
                    }
                    if (FluidTankInteractionPacket.isWaterRelatedFluid(new FluidStack(data.fluid(), 1))) {
                        FluidTankInteractionPacket.handleWaterBottleDrain(sp, tank, carried, packet.tankIndex);
                        return;
                    }
                }
                if (carried.getCount() > 1) {
                    FluidActionResult result;
                    FluidStack tankFluid;
                    ItemStack filledContainer;
                    int containersToFill = 0;
                    ItemStack single = carried.copy();
                    single.setCount(1);
                    FluidActionResult testResult = FluidUtil.tryFillContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)false);
                    if (testResult.isSuccess() && !(filledContainer = testResult.getResult()).isEmpty() && !(tankFluid = tank.getFluidInTank(0)).isEmpty()) {
                        FluidActionResult verifyResult;
                        int availableFluid = tankFluid.getAmount();
                        int fluidPerContainer = filledContainer.getItem() == Items.HONEY_BOTTLE || filledContainer.getItem() == Items.POTION ? 250 : 1000;
                        int maxPossibleByFluid = availableFluid / fluidPerContainer;
                        containersToFill = Math.min(carried.getCount(), maxPossibleByFluid);
                        if (containersToFill > 0 && !(verifyResult = FluidUtil.tryFillContainer((ItemStack)single, (IFluidHandler)tank, (int)(containersToFill * fluidPerContainer), (Player)sp, (boolean)false)).isSuccess()) {
                            FluidActionResult singleTest;
                            containersToFill = 0;
                            for (int i = 0; i < Math.min(carried.getCount(), maxPossibleByFluid) && (singleTest = FluidUtil.tryFillContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)false)).isSuccess(); ++i) {
                                ++containersToFill;
                            }
                        }
                    }
                    if (containersToFill > 0 && (result = FluidUtil.tryFillContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)true)).isSuccess()) {
                        for (int i = 1; i < containersToFill; ++i) {
                            FluidUtil.tryFillContainer((ItemStack)single, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)true);
                        }
                        carried.shrink(containersToFill);
                        ItemStack filledStack = result.getResult().copy();
                        filledStack.setCount(containersToFill);
                        if (carried.isEmpty()) {
                            sp.containerMenu.setCarried(filledStack);
                        } else {
                            ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, filledStack);
                            if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                                sp.drop(leftover, false);
                            }
                            sp.containerMenu.setCarried(carried);
                        }
                        sp.containerMenu.broadcastChanges();
                    }
                } else {
                    FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)carried, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)sp, (boolean)true);
                    if (result.isSuccess()) {
                        sp.containerMenu.setCarried(result.getResult());
                        sp.containerMenu.broadcastChanges();
                    }
                }
            }
        });
    }

    private static void handlePlaceholderFluid(ServerPlayer sp, IFluidHandler tank, ItemStack carried, Fluid placeholderFluid) {
        int amount = placeholderFluid == ModFluids.HONEY.get() || placeholderFluid == ModFluids.POTION.get() ? 250 : 1000;
        FluidStack placeholderFs = new FluidStack(placeholderFluid, amount);
        int filled = tank.fill(placeholderFs, IFluidHandler.FluidAction.EXECUTE);
        if (filled > 0) {
            if (carried.getCount() > 1) {
                carried.shrink(1);
                sp.containerMenu.setCarried(carried);
                Item emptyContainer = placeholderFluid == ModFluids.HONEY.get() || placeholderFluid == ModFluids.POTION.get() ? Items.GLASS_BOTTLE : Items.BUCKET;
                ItemStack emptyStack = new ItemStack((ItemLike)emptyContainer);
                ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, emptyStack);
                leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover);
                if (!leftover.isEmpty()) {
                    sp.drop(leftover, false);
                }
            } else {
                Item emptyContainer = placeholderFluid == ModFluids.HONEY.get() || placeholderFluid == ModFluids.POTION.get() ? Items.GLASS_BOTTLE : Items.BUCKET;
                sp.containerMenu.setCarried(new ItemStack((ItemLike)emptyContainer));
            }
            sp.containerMenu.broadcastChanges();
        }
    }

    private static void handlePlaceholderFluidDrain(ServerPlayer sp, IFluidHandler tank, ItemStack carried, Item filledContainer, int tankIndex) {
        FluidStackData data = WidgetDataHelper.getTankFluid((Player)sp, tankIndex);
        if (data != null && !data.isEmpty()) {
            FluidStack drainAmount;
            FluidStack drained;
            int amount = data.fluid() == ModFluids.HONEY.get() || data.fluid() == ModFluids.POTION.get() ? 250 : 1000;
            int availableFluid = data.amount();
            int containersToFill = Math.min(carried.getCount(), availableFluid / amount);
            if (containersToFill > 0 && !(drained = tank.drain(drainAmount = new FluidStack(data.fluid(), containersToFill * amount), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drained.getAmount() == containersToFill * amount) {
                ItemStack filledStack;
                carried.shrink(containersToFill);
                if (filledContainer == Items.POTION && data.fluid() == ModFluids.POTION.get()) {
                    PotionContents contents = WidgetDataHelper.getTankPotionContents((Player)sp, tankIndex);
                    filledStack = new ItemStack((ItemLike)Items.POTION, containersToFill);
                    if (contents != null && contents != PotionContents.EMPTY) {
                        filledStack.set(DataComponents.POTION_CONTENTS, (Object)contents);
                    }
                } else {
                    filledStack = new ItemStack((ItemLike)filledContainer, containersToFill);
                }
                if (carried.isEmpty()) {
                    sp.containerMenu.setCarried(filledStack);
                } else {
                    ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, filledStack);
                    if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                        sp.drop(leftover, false);
                    }
                    sp.containerMenu.setCarried(carried);
                }
                FluidStack remaining = tank.getFluidInTank(0);
                if (remaining.isEmpty() && data.fluid() == ModFluids.POTION.get()) {
                    WidgetDataHelper.setTankPotionItem((Player)sp, tankIndex, ItemStack.EMPTY);
                    WidgetDataHelper.setTankPotionContents((Player)sp, tankIndex, PotionContents.EMPTY);
                }
                sp.containerMenu.broadcastChanges();
            }
        }
    }

    private static void handleWaterBottleDrain(ServerPlayer sp, IFluidHandler tank, ItemStack carried, int tankIndex) {
        FluidStackData data = WidgetDataHelper.getTankFluid((Player)sp, tankIndex);
        if (data != null && !data.isEmpty()) {
            FluidStack drainAmount;
            FluidStack drained;
            int amount = 250;
            int availableFluid = data.amount();
            int containersToFill = Math.min(carried.getCount(), availableFluid / amount);
            if (containersToFill > 0 && !(drained = tank.drain(drainAmount = new FluidStack(data.fluid(), containersToFill * amount), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drained.getAmount() == containersToFill * amount) {
                carried.shrink(containersToFill);
                ItemStack filledStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE, containersToFill);
                if (data.fluid().builtInRegistryHolder().key().location().getPath().contains("water")) {
                    filledStack = new ItemStack((ItemLike)Items.POTION, containersToFill);
                    filledStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Water Bottle"));
                }
                if (carried.isEmpty()) {
                    sp.containerMenu.setCarried(filledStack);
                } else {
                    ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, filledStack);
                    if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                        sp.drop(leftover, false);
                    }
                    sp.containerMenu.setCarried(carried);
                }
                sp.containerMenu.broadcastChanges();
            }
        }
    }

    private static void handlePotionFill(ServerPlayer sp, IFluidHandler tank, ItemStack carried, int tankIndex) {
        int space;
        if (carried.isEmpty() || carried.getItem() != Items.POTION) {
            return;
        }
        int capacity = tank.getTankCapacity(0);
        if (capacity <= 0) {
            return;
        }
        FluidStack current = tank.getFluidInTank(0);
        if (!current.isEmpty() && current.getFluid() != ModFluids.POTION.get()) {
            return;
        }
        PotionContents carriedContents = (PotionContents)carried.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (!current.isEmpty()) {
            PotionContents storedContents = WidgetDataHelper.getTankPotionContents((Player)sp, tankIndex);
            if (storedContents == null) {
                storedContents = PotionContents.EMPTY;
            }
            if (!storedContents.equals((Object)carriedContents)) {
                return;
            }
        }
        if ((space = capacity - current.getAmount()) <= 0) {
            return;
        }
        int amountPerBottle = 250;
        int maxBySpace = space / amountPerBottle;
        if (maxBySpace <= 0) {
            return;
        }
        int toEmpty = Math.min(carried.getCount(), maxBySpace);
        if (toEmpty <= 0) {
            return;
        }
        int filled = tank.fill(new FluidStack(ModFluids.POTION.get(), toEmpty * amountPerBottle), IFluidHandler.FluidAction.EXECUTE);
        int bottlesFilled = filled / amountPerBottle;
        if (bottlesFilled <= 0) {
            return;
        }
        if (current.isEmpty()) {
            ItemStack template = carried.copy();
            template.setCount(1);
            WidgetDataHelper.setTankPotionItem((Player)sp, tankIndex, template);
            PotionContents contents = (PotionContents)template.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            WidgetDataHelper.setTankPotionContents((Player)sp, tankIndex, contents);
        }
        carried.shrink(bottlesFilled);
        ItemStack empties = new ItemStack((ItemLike)Items.GLASS_BOTTLE, bottlesFilled);
        if (carried.isEmpty()) {
            sp.containerMenu.setCarried(empties);
        } else {
            ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, empties);
            if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                sp.drop(leftover, false);
            }
            sp.containerMenu.setCarried(carried);
        }
        sp.containerMenu.broadcastChanges();
    }

    private static boolean isWaterRelatedItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item == Items.WATER_BUCKET) {
            return true;
        }
        if (item == Items.POTION) {
            PotionContents contents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            return contents.equals((Object)PotionContents.EMPTY) || contents.potion().isPresent() && contents.potion().get() == Potions.WATER;
        }
        return false;
    }

    private static boolean isWaterRelatedFluid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        String fluidPath = fluid.builtInRegistryHolder().key().location().getPath();
        return fluidPath.contains("water") || fluidPath.contains("flowing_water");
    }

    private static void handleWaterRelatedFluid(ServerPlayer sp, IFluidHandler tank, ItemStack carried, int tankIndex) {
        FluidStackData currentTankFluid = WidgetDataHelper.getTankFluid((Player)sp, tankIndex);
        if (!currentTankFluid.isEmpty() && !FluidTankInteractionPacket.isWaterRelatedFluid(new FluidStack(currentTankFluid.fluid(), 1))) {
            return;
        }
        FlowingFluid waterFluid = Fluids.WATER;
        if (carried.getItem() == Items.WATER_BUCKET) {
            FluidTankInteractionPacket.handlePlaceholderFluid(sp, tank, carried, (Fluid)waterFluid);
        } else if (carried.getItem() == Items.POTION) {
            FluidTankInteractionPacket.handleWaterBottleToTank(sp, tank, carried, tankIndex, (Fluid)waterFluid);
        }
    }

    private static void handleWaterBottleToTank(ServerPlayer sp, IFluidHandler tank, ItemStack carried, int tankIndex, Fluid waterFluid) {
        PotionContents contents = (PotionContents)carried.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (!(contents.equals((Object)PotionContents.EMPTY) || contents.potion().isPresent() && contents.potion().get() == Potions.WATER)) {
            return;
        }
        int amount = 250;
        FluidStack waterStack = new FluidStack(waterFluid, amount);
        int filled = tank.fill(waterStack, IFluidHandler.FluidAction.EXECUTE);
        if (filled > 0) {
            if (carried.getCount() > 1) {
                carried.shrink(1);
                sp.containerMenu.setCarried(carried);
                ItemStack emptyBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, emptyBottle);
                leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover);
                if (!leftover.isEmpty()) {
                    sp.drop(leftover, false);
                }
            } else {
                sp.containerMenu.setCarried(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            sp.containerMenu.broadcastChanges();
        }
    }

    public static enum Action {
        FILL_FROM_CONTAINER,
        DRAIN_TO_CONTAINER;

    }
}

