/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FurnaceSlotInteractionPacket(SlotType slotType, ActionType actionType, ItemStack itemStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FurnaceSlotInteractionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"furnace_slot_interaction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FurnaceSlotInteractionPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FurnaceSlotInteractionPacket>(){

        public FurnaceSlotInteractionPacket decode(RegistryFriendlyByteBuf buffer) {
            SlotType slotType = (SlotType)buffer.readEnum(SlotType.class);
            ActionType actionType = (ActionType)buffer.readEnum(ActionType.class);
            boolean hasItemStack = buffer.readBoolean();
            ItemStack itemStack = hasItemStack ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            return new FurnaceSlotInteractionPacket(slotType, actionType, itemStack);
        }

        public void encode(RegistryFriendlyByteBuf buffer, FurnaceSlotInteractionPacket packet) {
            buffer.writeEnum((Enum)packet.slotType);
            buffer.writeEnum((Enum)packet.actionType);
            boolean hasItemStack = !packet.itemStack.isEmpty();
            buffer.writeBoolean(hasItemStack);
            if (hasItemStack) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.itemStack);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(FurnaceSlotInteractionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack carried = serverPlayer.containerMenu.getCarried();
                switch (packet.slotType.ordinal()) {
                    case 0: {
                        FurnaceSlotInteractionPacket.handleInputSlot(serverPlayer, carried, packet.actionType, packet.itemStack);
                        break;
                    }
                    case 1: {
                        FurnaceSlotInteractionPacket.handleFuelSlot(serverPlayer, carried, packet.actionType, packet.itemStack);
                        break;
                    }
                    case 2: {
                        FurnaceSlotInteractionPacket.handleOutputSlot(serverPlayer, carried, packet.actionType, packet.itemStack);
                    }
                }
            }
        });
    }

    private static void handleInputSlot(ServerPlayer player, ItemStack carried, ActionType actionType, ItemStack packetItem) {
        ItemStack currentInput = WidgetDataHelper.getFurnaceInputItem((Player)player);
        switch (actionType.ordinal()) {
            case 0: {
                if (carried.isEmpty()) break;
                if (!currentInput.isEmpty()) {
                    player.containerMenu.setCarried(currentInput.copy());
                    WidgetDataHelper.setFurnaceInputItem((Player)player, carried.copy());
                    break;
                }
                WidgetDataHelper.setFurnaceInputItem((Player)player, carried.copy());
                player.containerMenu.setCarried(ItemStack.EMPTY);
                break;
            }
            case 1: {
                if (currentInput.isEmpty() || !carried.isEmpty()) break;
                player.containerMenu.setCarried(currentInput.copy());
                WidgetDataHelper.setFurnaceInputItem((Player)player, ItemStack.EMPTY);
                break;
            }
            case 3: {
                if (currentInput.isEmpty() || !carried.isEmpty()) break;
                int halfCount = Math.max(1, currentInput.getCount() / 2);
                ItemStack toTake = currentInput.copy();
                toTake.setCount(halfCount);
                player.containerMenu.setCarried(toTake);
                ItemStack remaining = currentInput.copy();
                remaining.shrink(halfCount);
                if (remaining.isEmpty()) {
                    WidgetDataHelper.setFurnaceInputItem((Player)player, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setFurnaceInputItem((Player)player, remaining);
                break;
            }
            case 4: {
                if (carried.isEmpty() || !currentInput.isEmpty()) break;
                ItemStack newInput = carried.copy();
                newInput.setCount(1);
                WidgetDataHelper.setFurnaceInputItem((Player)player, newInput);
                carried.shrink(1);
                if (!carried.isEmpty()) break;
                player.containerMenu.setCarried(ItemStack.EMPTY);
                break;
            }
            case 2: {
                int space;
                int toAdd;
                if (carried.isEmpty() || currentInput.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)currentInput) || (toAdd = Math.min(space = currentInput.getMaxStackSize() - currentInput.getCount(), carried.getCount())) <= 0) break;
                ItemStack newInput = currentInput.copy();
                newInput.grow(toAdd);
                WidgetDataHelper.setFurnaceInputItem((Player)player, newInput);
                carried.shrink(toAdd);
                if (!carried.isEmpty()) break;
                player.containerMenu.setCarried(ItemStack.EMPTY);
            }
        }
    }

    private static void handleFuelSlot(ServerPlayer player, ItemStack carried, ActionType actionType, ItemStack packetItem) {
        ItemStack currentFuel = WidgetDataHelper.getFurnaceFuelItem((Player)player);
        switch (actionType.ordinal()) {
            case 0: {
                if (carried.isEmpty() || carried.getBurnTime(RecipeType.SMELTING) <= 0) break;
                if (!currentFuel.isEmpty()) {
                    player.containerMenu.setCarried(currentFuel.copy());
                    WidgetDataHelper.setFurnaceFuelItem((Player)player, carried.copy());
                    break;
                }
                WidgetDataHelper.setFurnaceFuelItem((Player)player, carried.copy());
                player.containerMenu.setCarried(ItemStack.EMPTY);
                break;
            }
            case 1: {
                if (currentFuel.isEmpty()) break;
                if (carried.isEmpty()) {
                    player.containerMenu.setCarried(currentFuel.copy());
                    WidgetDataHelper.setFurnaceFuelItem((Player)player, ItemStack.EMPTY);
                    break;
                }
                return;
            }
            case 3: {
                if (currentFuel.isEmpty() || !carried.isEmpty()) break;
                int halfCount = Math.max(1, currentFuel.getCount() / 2);
                ItemStack toTake = currentFuel.copy();
                toTake.setCount(halfCount);
                player.containerMenu.setCarried(toTake);
                ItemStack remaining = currentFuel.copy();
                remaining.shrink(halfCount);
                if (remaining.isEmpty()) {
                    WidgetDataHelper.setFurnaceFuelItem((Player)player, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setFurnaceFuelItem((Player)player, remaining);
                break;
            }
            case 4: {
                if (carried.isEmpty() || !currentFuel.isEmpty() || carried.getBurnTime(RecipeType.SMELTING) <= 0) break;
                ItemStack newFuel = carried.copy();
                newFuel.setCount(1);
                WidgetDataHelper.setFurnaceFuelItem((Player)player, newFuel);
                carried.shrink(1);
                if (!carried.isEmpty()) break;
                player.containerMenu.setCarried(ItemStack.EMPTY);
                break;
            }
            case 2: {
                int space;
                int toAdd;
                if (carried.isEmpty() || currentFuel.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)currentFuel) || carried.getBurnTime(RecipeType.SMELTING) <= 0 || (toAdd = Math.min(space = currentFuel.getMaxStackSize() - currentFuel.getCount(), carried.getCount())) <= 0) break;
                ItemStack newFuel = currentFuel.copy();
                newFuel.grow(toAdd);
                WidgetDataHelper.setFurnaceFuelItem((Player)player, newFuel);
                carried.shrink(toAdd);
                if (!carried.isEmpty()) break;
                player.containerMenu.setCarried(ItemStack.EMPTY);
            }
        }
    }

    private static void handleOutputSlot(ServerPlayer player, ItemStack carried, ActionType actionType, ItemStack packetItem) {
        ItemStack currentOutput = WidgetDataHelper.getFurnaceOutputItem((Player)player);
        switch (actionType.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                if (currentOutput.isEmpty() || !carried.isEmpty()) break;
                player.containerMenu.setCarried(currentOutput.copy());
                WidgetDataHelper.setFurnaceOutputItem((Player)player, ItemStack.EMPTY);
                break;
            }
            case 3: {
                if (currentOutput.isEmpty() || !carried.isEmpty()) break;
                int halfCount = Math.max(1, currentOutput.getCount() / 2);
                ItemStack toTake = currentOutput.copy();
                toTake.setCount(halfCount);
                player.containerMenu.setCarried(toTake);
                ItemStack remaining = currentOutput.copy();
                remaining.shrink(halfCount);
                if (remaining.isEmpty()) {
                    WidgetDataHelper.setFurnaceOutputItem((Player)player, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setFurnaceOutputItem((Player)player, remaining);
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                int space;
                int toTake;
                if (carried.isEmpty() || currentOutput.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)currentOutput) || (toTake = Math.min(space = carried.getMaxStackSize() - carried.getCount(), currentOutput.getCount())) <= 0) break;
                carried.grow(toTake);
                ItemStack newOutput = currentOutput.copy();
                newOutput.shrink(toTake);
                if (newOutput.isEmpty()) {
                    WidgetDataHelper.setFurnaceOutputItem((Player)player, ItemStack.EMPTY);
                    break;
                }
                WidgetDataHelper.setFurnaceOutputItem((Player)player, newOutput);
            }
        }
    }

    public static enum SlotType {
        INPUT,
        FUEL,
        OUTPUT;

    }

    public static enum ActionType {
        PUT_ITEM,
        TAKE_ITEM,
        MERGE_ITEM,
        TAKE_HALF,
        PUT_ONE;

    }
}

