/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FurnaceTemplateSlotPacket(SlotType slotType, int slotIndex, ItemStack templateItem) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FurnaceTemplateSlotPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"furnace_template_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FurnaceTemplateSlotPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FurnaceTemplateSlotPacket>(){

        public FurnaceTemplateSlotPacket decode(RegistryFriendlyByteBuf buffer) {
            SlotType slotType = (SlotType)buffer.readEnum(SlotType.class);
            int slotIndex = buffer.readVarInt();
            boolean hasTemplateItem = buffer.readBoolean();
            ItemStack templateItem = hasTemplateItem ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            return new FurnaceTemplateSlotPacket(slotType, slotIndex, templateItem);
        }

        public void encode(RegistryFriendlyByteBuf buffer, FurnaceTemplateSlotPacket packet) {
            buffer.writeEnum((Enum)packet.slotType);
            buffer.writeVarInt(packet.slotIndex);
            boolean hasTemplateItem = !packet.templateItem.isEmpty();
            buffer.writeBoolean(hasTemplateItem);
            if (hasTemplateItem) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.templateItem);
            }
        }
    };

    public CustomPacketPayload.Type<FurnaceTemplateSlotPacket> type() {
        return TYPE;
    }

    public static void handle(FurnaceTemplateSlotPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                int allowed = 3;
                try {
                    allowed = Math.max(0, Math.min(8, WidgetDataHelper.getAllowedTemplateSlots((Player)serverPlayer)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (packet.slotIndex < 0 || packet.slotIndex >= allowed) {
                    return;
                }
                switch (packet.slotType.ordinal()) {
                    case 0: {
                        WidgetDataHelper.setFurnaceInputTemplate((Player)serverPlayer, packet.slotIndex, packet.templateItem);
                        break;
                    }
                    case 1: {
                        WidgetDataHelper.setFurnaceFuelTemplate((Player)serverPlayer, packet.slotIndex, packet.templateItem);
                    }
                }
            }
        });
    }

    public static enum SlotType {
        INPUT,
        FUEL;

        public static final StreamCodec<RegistryFriendlyByteBuf, SlotType> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.of((buf, slotType) -> buf.writeEnum((Enum)slotType), buf -> (SlotType)buf.readEnum(SlotType.class));
        }
    }
}

