/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemoveAutoCrafterRecipePacket(int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveAutoCrafterRecipePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"remove_auto_crafter_recipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveAutoCrafterRecipePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RemoveAutoCrafterRecipePacket::index, RemoveAutoCrafterRecipePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RemoveAutoCrafterRecipePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                RemoveAutoCrafterRecipePacket.handleServer(player, packet.index);
            }
        });
    }

    private static void handleServer(ServerPlayer player, int index) {
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack)) {
            return;
        }
        if (!WidgetDataHelper.isAutoCrafterUnlocked((Player)player)) {
            return;
        }
        WidgetDataHelper.removeAutoCrafterRecipe((Player)player, index);
    }
}

