/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.network.TeleportServerActions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TeleportRequestPacket(Action action) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportRequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"teleport_request"));
    public static final StreamCodec<FriendlyByteBuf, TeleportRequestPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, TeleportRequestPacket>(){

        public void encode(FriendlyByteBuf buf, TeleportRequestPacket value) {
            buf.writeEnum((Enum)value.action);
        }

        public TeleportRequestPacket decode(FriendlyByteBuf buf) {
            Action a = (Action)buf.readEnum(Action.class);
            return new TeleportRequestPacket(a);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TeleportRequestPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            switch (packet.action.ordinal()) {
                case 0: {
                    TeleportServerActions.teleportToBedOrSpawn(player);
                    break;
                }
                case 1: {
                    TeleportServerActions.teleportToggleNetherOverworld(player);
                    break;
                }
                case 2: {
                    TeleportServerActions.teleportToEndSpawn(player);
                    break;
                }
                case 3: {
                    TeleportServerActions.teleportToPocket(player);
                    break;
                }
                case 4: {
                    TeleportServerActions.teleportRandomLocal(player);
                }
            }
        });
    }

    public static enum Action {
        BED_OR_SPAWN,
        TOGGLE_NETHER_OVERWORLD,
        END_SPAWN,
        POCKET_DIMENSION,
        RANDOM_LOCAL;

    }
}

