/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleAutoCrafterPacket(boolean enable) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleAutoCrafterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"toggle_auto_crafter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleAutoCrafterPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ToggleAutoCrafterPacket::enable, ToggleAutoCrafterPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ToggleAutoCrafterPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ToggleAutoCrafterPacket.handleToggle(packet.enable, player);
            }
        });
    }

    private static void handleToggle(boolean enable, ServerPlayer player) {
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack)) {
            return;
        }
        if (!WidgetDataHelper.isAutoCrafterUnlocked((Player)player)) {
            return;
        }
        WidgetDataHelper.setAutoCrafterEnabled((Player)player, enable);
    }
}

