/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.ItemStackData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TravelersGardenActionPacket(Action action, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TravelersGardenActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"travelers_garden_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TravelersGardenActionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, a) -> buf.writeEnum((Enum)a), b -> (Action)b.readEnum(Action.class)), TravelersGardenActionPacket::action, (StreamCodec)ByteBufCodecs.VAR_INT, TravelersGardenActionPacket::index, TravelersGardenActionPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TravelersGardenActionPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            ItemStack shell = ShellItem.findWornshell((Player)sp);
            if (shell.isEmpty()) {
                return;
            }
            if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN, shell)) {
                return;
            }
            switch (packet.action.ordinal()) {
                case 0: {
                    int slot = Math.max(0, Math.min(19, packet.index));
                    int maxSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
                    if (slot >= maxSlots) {
                        return;
                    }
                    ItemStack carried = sp.containerMenu.getCarried();
                    if (carried.isEmpty()) {
                        return;
                    }
                    String seedId = TravelersGardenActionPacket.getItemId(carried.getItem());
                    String cropId = null;
                    if (!seedId.startsWith("travelersgarden:") || !seedId.endsWith("_farm")) {
                        return;
                    }
                    cropId = seedId;
                    ArrayList<CompoundTag> plants = new ArrayList<CompoundTag>((Collection)shell.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList()));
                    while (plants.size() <= slot) {
                        plants.add(new CompoundTag());
                    }
                    CompoundTag tag = (CompoundTag)plants.get(slot);
                    if (tag.contains("cropId")) {
                        return;
                    }
                    CompoundTag newTag = new CompoundTag();
                    newTag.putString("seedId", seedId);
                    newTag.putString("cropId", cropId);
                    newTag.putInt("progress", 0);
                    plants.set(slot, newTag);
                    shell.set(ModDataComponents.TG_PLANTS.get(), plants);
                    carried.shrink(1);
                    sp.containerMenu.setCarried(carried);
                    sp.containerMenu.broadcastChanges();
                    break;
                }
                case 1: {
                    ItemStack cropStack;
                    ItemStack remaining;
                    Item item;
                    String cropId;
                    ResourceLocation rl;
                    int slot = Math.max(0, Math.min(19, packet.index));
                    int maxSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
                    if (slot >= maxSlots) {
                        return;
                    }
                    ArrayList<CompoundTag> plants = new ArrayList<CompoundTag>((Collection)shell.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList()));
                    if (slot >= plants.size()) break;
                    CompoundTag plantTag = (CompoundTag)plants.get(slot);
                    if (plantTag.contains("cropId") && (rl = ResourceLocation.tryParse((String)(cropId = plantTag.getString("cropId")))) != null && (item = (Item)BuiltInRegistries.ITEM.get(rl)) != null && item != Items.AIR && !(remaining = InventoryUtils.addItemToShell((Player)sp, cropStack = new ItemStack((ItemLike)item, 1))).isEmpty()) {
                        sp.drop(remaining, false);
                    }
                    plants.set(slot, new CompoundTag());
                    shell.set(ModDataComponents.TG_PLANTS.get(), plants);
                    sp.containerMenu.broadcastChanges();
                    break;
                }
                case 2: {
                    int idx = Math.max(0, packet.index);
                    ArrayList buffer = new ArrayList((Collection)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList()));
                    if (idx >= buffer.size()) break;
                    ItemStack stack = ((ItemStackData)buffer.get(idx)).toItemStack();
                    if (sp.containerMenu.getCarried().isEmpty() && !stack.isEmpty()) {
                        sp.containerMenu.setCarried(stack);
                    } else {
                        ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, stack);
                        if (!(leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                            sp.drop(leftover, false);
                        }
                    }
                    buffer.remove(idx);
                    shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), buffer);
                    sp.containerMenu.broadcastChanges();
                    break;
                }
                case 3: {
                    ArrayList buffer = new ArrayList((Collection)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList()));
                    if (buffer.isEmpty()) break;
                    for (ItemStackData data : buffer) {
                        ItemStack stack = data.toItemStack();
                        if (stack.isEmpty()) continue;
                        ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, stack);
                        if ((leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) continue;
                        sp.drop(leftover, false);
                    }
                    shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList());
                    sp.containerMenu.broadcastChanges();
                    break;
                }
                case 4: {
                    boolean currentAutoPush = (Boolean)shell.getOrDefault(ModDataComponents.TG_AUTO_PUSH_ENABLED.get(), (Object)false);
                    boolean newAutoPush = !currentAutoPush;
                    shell.set(ModDataComponents.TG_AUTO_PUSH_ENABLED.get(), (Object)newAutoPush);
                    sp.containerMenu.broadcastChanges();
                    break;
                }
                case 5: {
                    ItemStackData itemData;
                    ItemStack itemStack;
                    int slot = Math.max(0, Math.min(19, packet.index));
                    int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                    if (slot >= harvestSlots) {
                        return;
                    }
                    ArrayList buffer = new ArrayList((Collection)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList()));
                    if (slot >= buffer.size() || (itemStack = (itemData = (ItemStackData)buffer.get(slot)).toItemStack()).isEmpty()) break;
                    ItemStack leftover = InventoryUtils.addItemToShell((Player)sp, itemStack);
                    if (leftover.isEmpty()) {
                        buffer.remove(slot);
                        shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), buffer);
                    } else if ((leftover = InventoryUtils.addItemToPlayerInventory((Player)sp, leftover)).isEmpty()) {
                        buffer.remove(slot);
                        shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), buffer);
                    } else {
                        sp.drop(leftover, false);
                        buffer.remove(slot);
                        shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), buffer);
                    }
                    sp.containerMenu.broadcastChanges();
                }
            }
        });
    }

    private static String getItemId(Item item) {
        ResourceLocation rl = item.builtInRegistryHolder().key().location();
        return rl.toString();
    }

    private static String mapSeedToCrop(String seedId) {
        try {
            Class<?> modItems = Class.forName("com.etka.travelersgarden.registry.ModItems");
            Field f = modItems.getDeclaredField("SEED_TO_CROP_MAP");
            Map map = (Map)f.get(null);
            if (map == null) {
                return null;
            }
            return (String)map.get(seedId);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static enum Action {
        PLANT_SLOT,
        REMOVE_PLANT,
        TAKE_BUFFER_SLOT,
        TAKE_ALL_BUFFER,
        TOGGLE_AUTO_PUSH,
        MOVE_BUFFER_TO_BACKPACK;

    }
}

