/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateCollectorSlotPacket(int slotIndex, ItemStack ghost) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateCollectorSlotPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_collector_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateCollectorSlotPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        ByteBufCodecs.VAR_INT.encode(buf, (Object)packet.slotIndex);
        boolean hasItem = packet.ghost != null && !packet.ghost.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            ItemStack.STREAM_CODEC.encode(buf, (Object)packet.ghost);
        }
    }, buf -> {
        int idx = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        boolean hasItem = buf.readBoolean();
        ItemStack item = hasItem ? (ItemStack)ItemStack.STREAM_CODEC.decode(buf) : ItemStack.EMPTY;
        return new UpdateCollectorSlotPacket(idx, item);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateCollectorSlotPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                int index = Math.max(0, Math.min(4, packet.slotIndex));
                ItemStack ghost = packet.ghost == null ? ItemStack.EMPTY : packet.ghost;
                WidgetDataHelper.setCollectorItem((Player)player, index, ghost);
            }
        });
    }
}

