/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateCollectorTagFilterPacket(List<ResourceLocation> tags, boolean whitelist) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateCollectorTagFilterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_collector_tag_filter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateCollectorTagFilterPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateCollectorTagFilterPacket>(){

        public UpdateCollectorTagFilterPacket decode(RegistryFriendlyByteBuf buf) {
            int n = buf.readVarInt();
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(n);
            for (int i = 0; i < n; ++i) {
                list.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf));
            }
            boolean whitelist = buf.readBoolean();
            return new UpdateCollectorTagFilterPacket(list, whitelist);
        }

        public void encode(RegistryFriendlyByteBuf buf, UpdateCollectorTagFilterPacket pkt) {
            buf.writeVarInt(pkt.tags.size());
            for (ResourceLocation rl : pkt.tags) {
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)rl);
            }
            buf.writeBoolean(pkt.whitelist);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateCollectorTagFilterPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                WidgetDataHelper.setCollectorTags((Player)player, packet.tags);
                WidgetDataHelper.setCollectorTagWhitelist((Player)player, packet.whitelist);
            }
        });
    }
}

