/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateFurnaceTagFilterPacket(Slot slot, List<ResourceLocation> tags, boolean whitelist) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateFurnaceTagFilterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_furnace_tag_filter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateFurnaceTagFilterPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateFurnaceTagFilterPacket>(){

        public UpdateFurnaceTagFilterPacket decode(RegistryFriendlyByteBuf buf) {
            Slot slot = (Slot)buf.readEnum(Slot.class);
            int n = buf.readVarInt();
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(n);
            for (int i = 0; i < n; ++i) {
                list.add((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf));
            }
            boolean whitelist = buf.readBoolean();
            return new UpdateFurnaceTagFilterPacket(slot, list, whitelist);
        }

        public void encode(RegistryFriendlyByteBuf buf, UpdateFurnaceTagFilterPacket pkt) {
            buf.writeEnum((Enum)pkt.slot);
            buf.writeVarInt(pkt.tags.size());
            for (ResourceLocation rl : pkt.tags) {
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)rl);
            }
            buf.writeBoolean(pkt.whitelist);
        }
    };

    public CustomPacketPayload.Type<UpdateFurnaceTagFilterPacket> type() {
        return TYPE;
    }

    public static void handle(UpdateFurnaceTagFilterPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                if (packet.slot == Slot.INPUT) {
                    WidgetDataHelper.setFurnaceInputTags((Player)sp, packet.tags);
                    WidgetDataHelper.setFurnaceInputTagWhitelist((Player)sp, packet.whitelist);
                } else {
                    WidgetDataHelper.setFurnaceFuelTags((Player)sp, packet.tags);
                    WidgetDataHelper.setFurnaceFuelTagWhitelist((Player)sp, packet.whitelist);
                }
            }
        });
    }

    public static enum Slot {
        INPUT,
        FUEL;

    }
}

