/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdatePlantProgressPacket(List<CompoundTag> plants) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdatePlantProgressPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_plant_progress"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdatePlantProgressPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, plants) -> {
        buf.writeInt(plants.size());
        for (CompoundTag plant : plants) {
            buf.writeNbt((Tag)plant);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<CompoundTag> plants = new ArrayList<CompoundTag>();
        for (int i = 0; i < size; ++i) {
            CompoundTag plant = buf.readNbt();
            if (plant == null) continue;
            plants.add(plant);
        }
        return plants;
    }), UpdatePlantProgressPacket::plants, UpdatePlantProgressPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdatePlantProgressPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack shellStack = ShellItem.findWornshell((Player)mc.player);
            if (!shellStack.isEmpty()) {
                shellStack.set(ModDataComponents.TG_PLANTS.get(), packet.plants);
            }
        });
    }
}

