/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.config.ShellConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdatePocketSettingsPacket(int width, int length, int height, int background) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdatePocketSettingsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_pocket_settings"));
    public static final StreamCodec<ByteBuf, UpdatePocketSettingsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UpdatePocketSettingsPacket::width, (StreamCodec)ByteBufCodecs.VAR_INT, UpdatePocketSettingsPacket::length, (StreamCodec)ByteBufCodecs.VAR_INT, UpdatePocketSettingsPacket::height, (StreamCodec)ByteBufCodecs.VAR_INT, UpdatePocketSettingsPacket::background, UpdatePocketSettingsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdatePocketSettingsPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            boolean isOwner = player.getServer() != null && player.getServer().isSingleplayerOwner(player.getGameProfile());
            boolean isOp = player.hasPermissions(4);
            if (!isOwner && !isOp) {
                return;
            }
            int w = Math.max(1, msg.width());
            int l = Math.max(1, msg.length());
            int h = Math.max(3, msg.height());
            int bg = Math.max(0, Math.min(1, msg.background()));
            ShellConfig.SERVER.teleporterPocketWidth.set((Object)w);
            ShellConfig.SERVER.teleporterPocketLength.set((Object)l);
            ShellConfig.SERVER.teleporterPocketHeight.set((Object)h);
            ShellConfig.SERVER.teleporterPocketBackground.set((Object)bg);
            try {
                ShellConfig.SERVER_SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

