/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.network.WidgetUpgradedPacket;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpgradeWidgetPacket(WidgetUnlockSystem.WidgetType widgetType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpgradeWidgetPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"upgrade_widget"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeWidgetPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, widgetType) -> buf.writeEnum((Enum)widgetType), buf -> (WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class)), UpgradeWidgetPacket::widgetType, UpgradeWidgetPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpgradeWidgetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                UpgradeWidgetPacket.handleUpgrade(packet.widgetType, serverPlayer);
            }
        });
    }

    private static void handleUpgrade(WidgetUnlockSystem.WidgetType widgetType, ServerPlayer player) {
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(widgetType, shellStack)) {
            return;
        }
        if (!WidgetUnlockSystem.canUpgrade(widgetType, shellStack)) {
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shellStack);
            return;
        }
        boolean hasUpgradeItems = WidgetUnlockSystem.hasUpgradeItems(widgetType, shellStack, (Player)player);
        if (!hasUpgradeItems) {
            return;
        }
        if (UpgradeWidgetPacket.consumeUpgradeItems(widgetType, shellStack, player)) {
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shellStack);
            WidgetUnlockSystem.WidgetTier nextTier = switch (currentTier) {
                case WidgetUnlockSystem.WidgetTier.TIER_I -> WidgetUnlockSystem.WidgetTier.TIER_II;
                case WidgetUnlockSystem.WidgetTier.TIER_II -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_III;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_III;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_III;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TELEPORTER) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_III;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_III;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.COLLECTOR) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_III;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_III -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IV;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IV;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IV;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TELEPORTER) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IV;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IV;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_IV -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_V;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_V;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TELEPORTER) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_V;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_V;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_V -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VI;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VI;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VI;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_VI -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VII;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VII;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_VII -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VIII;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_VIII;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_VIII -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IX;
                    }
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_IX;
                    }
                    yield currentTier;
                }
                case WidgetUnlockSystem.WidgetTier.TIER_IX -> {
                    if (widgetType == WidgetUnlockSystem.WidgetType.GUARDIAN) {
                        yield WidgetUnlockSystem.WidgetTier.TIER_X;
                    }
                    yield currentTier;
                }
                default -> currentTier;
            };
            WidgetUnlockSystem.setWidgetTier(widgetType, nextTier, shellStack);
            if (widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK) {
                UpgradeWidgetPacket.handleFluidTankUpgrade(shellStack, currentTier, nextTier);
            }
            if (widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN) {
                switch (nextTier) {
                    case TIER_II: {
                        shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)10);
                        shellStack.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                        break;
                    }
                    case TIER_III: {
                        shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)25);
                        break;
                    }
                    case TIER_IV: {
                        shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)15);
                        shellStack.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                        break;
                    }
                    case TIER_V: {
                        shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)50);
                        break;
                    }
                    case TIER_VI: {
                        shellStack.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)20);
                        shellStack.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
                        shellStack.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)60);
                        break;
                    }
                }
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WidgetUpgradedPacket(widgetType, nextTier), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static boolean consumeUpgradeItems(WidgetUnlockSystem.WidgetType widgetType, ItemStack shellStack, ServerPlayer player) {
        List<WidgetUnlockSystem.ItemRequirement> requirements = WidgetUnlockSystem.getUpgradeRequirements(widgetType, shellStack);
        Map<Item, Integer> availableItems = InventoryUtils.getAllItemCountsAcrossInventoryAndshell((Player)player);
        for (WidgetUnlockSystem.ItemRequirement requirement : requirements) {
            int available = availableItems.getOrDefault(requirement.getItem(), 0);
            if (available >= requirement.getCount()) continue;
            return false;
        }
        for (WidgetUnlockSystem.ItemRequirement requirement : requirements) {
            int i;
            AbstractContainerMenu stack;
            int remaining = requirement.getCount();
            for (int i2 = 0; i2 < player.getInventory().getContainerSize() && remaining > 0; ++i2) {
                stack = player.getInventory().getItem(i2);
                if (stack.isEmpty() || stack.getItem() != requirement.getItem()) continue;
                int toConsume = Math.min(remaining, stack.getCount());
                stack.shrink(toConsume);
                if (stack.isEmpty()) {
                    player.getInventory().setItem(i2, ItemStack.EMPTY);
                }
                remaining -= toConsume;
            }
            if (remaining <= 0) continue;
            stack = player.containerMenu;
            if (stack instanceof ShellMenu) {
                ShellMenu ShellMenu2 = (ShellMenu)stack;
                for (int i3 = 0; i3 < ShellMenu2.getshellSlotCount() && remaining > 0; ++i3) {
                    ItemStack stack2 = ShellMenu2.getshellContainer().getItem(i3);
                    if (stack2.isEmpty() || stack2.getItem() != requirement.getItem()) continue;
                    int toConsume = Math.min(remaining, stack2.getCount());
                    stack2.shrink(toConsume);
                    if (stack2.isEmpty()) {
                        ShellMenu2.getshellContainer().setItem(i3, ItemStack.EMPTY);
                    }
                    remaining -= toConsume;
                }
                continue;
            }
            ItemStack shell = ShellItem.findWornshell((Player)player);
            if (shell.isEmpty()) continue;
            ItemContainerContents originalshellContents = ShellItem.getshellContents(shell);
            ArrayList<ItemStack> ShellItems = new ArrayList<ItemStack>();
            for (i = 0; i < originalshellContents.getSlots(); ++i) {
                ShellItems.add(originalshellContents.getStackInSlot(i).copy());
            }
            for (i = 0; i < ShellItems.size() && remaining > 0; ++i) {
                ItemStack stack3 = (ItemStack)ShellItems.get(i);
                if (stack3.isEmpty() || stack3.getItem() != requirement.getItem()) continue;
                int toConsume = Math.min(remaining, stack3.getCount());
                stack3.shrink(toConsume);
                if (stack3.isEmpty()) {
                    ShellItems.set(i, ItemStack.EMPTY);
                }
                remaining -= toConsume;
            }
            ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(ShellItems);
            ShellItem.setshellContents(shell, newContents);
        }
        return true;
    }

    private static void handleFluidTankUpgrade(ItemStack shellStack, WidgetUnlockSystem.WidgetTier currentTier, WidgetUnlockSystem.WidgetTier nextTier) {
        int newCapacity = WidgetDataHelper.getDefaultTankCapacity(WidgetUnlockSystem.WidgetType.FLUID_TANK, nextTier, 1);
        shellStack.set(ModDataComponents.TANK1_CAPACITY.get(), (Object)newCapacity);
        if (((Boolean)shellStack.getOrDefault(ModDataComponents.TANK2_UNLOCKED.get(), (Object)false)).booleanValue()) {
            shellStack.set(ModDataComponents.TANK2_CAPACITY.get(), (Object)newCapacity);
        }
        if (((Boolean)shellStack.getOrDefault(ModDataComponents.TANK3_UNLOCKED.get(), (Object)false)).booleanValue()) {
            shellStack.set(ModDataComponents.TANK3_CAPACITY.get(), (Object)newCapacity);
        }
        if (((Boolean)shellStack.getOrDefault(ModDataComponents.TANK4_UNLOCKED.get(), (Object)false)).booleanValue()) {
            shellStack.set(ModDataComponents.TANK4_CAPACITY.get(), (Object)newCapacity);
        }
        if (((Boolean)shellStack.getOrDefault(ModDataComponents.TANK5_UNLOCKED.get(), (Object)false)).booleanValue()) {
            shellStack.set(ModDataComponents.TANK5_CAPACITY.get(), (Object)newCapacity);
        }
        switch (nextTier) {
            case TIER_II: {
                shellStack.set(ModDataComponents.TANK2_UNLOCKED.get(), (Object)true);
                shellStack.set(ModDataComponents.TANK2_CAPACITY.get(), (Object)newCapacity);
                shellStack.set(ModDataComponents.TANK2_FLUID.get(), (Object)FluidStackData.EMPTY);
                break;
            }
            case TIER_IV: {
                shellStack.set(ModDataComponents.TANK3_UNLOCKED.get(), (Object)true);
                shellStack.set(ModDataComponents.TANK3_CAPACITY.get(), (Object)newCapacity);
                shellStack.set(ModDataComponents.TANK3_FLUID.get(), (Object)FluidStackData.EMPTY);
                break;
            }
            case TIER_VI: {
                shellStack.set(ModDataComponents.TANK4_UNLOCKED.get(), (Object)true);
                shellStack.set(ModDataComponents.TANK4_CAPACITY.get(), (Object)newCapacity);
                shellStack.set(ModDataComponents.TANK4_FLUID.get(), (Object)FluidStackData.EMPTY);
                break;
            }
            case TIER_VIII: {
                shellStack.set(ModDataComponents.TANK5_UNLOCKED.get(), (Object)true);
                shellStack.set(ModDataComponents.TANK5_CAPACITY.get(), (Object)newCapacity);
                shellStack.set(ModDataComponents.TANK5_FLUID.get(), (Object)FluidStackData.EMPTY);
            }
        }
    }
}

