/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record ItemStackData(Item item, int count) {
    public static final ItemStackData EMPTY = new ItemStackData(Items.AIR, 0);
    public static final Codec<ItemStackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(ItemStackData::item), (App)Codec.INT.fieldOf("count").forGetter(ItemStackData::count)).apply((Applicative)instance, ItemStackData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)BuiltInRegistries.ITEM.key()), ItemStackData::item, (StreamCodec)ByteBufCodecs.VAR_INT, ItemStackData::count, ItemStackData::new);

    public static ItemStackData of(ItemStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return new ItemStackData(stack.getItem(), stack.getCount());
    }

    public ItemStack toItemStack() {
        if (this.item == Items.AIR || this.count <= 0) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.item, this.count);
    }

    public static ItemStackData ofWithEnchantments(ItemStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        if (stack.getItem() instanceof EnchantedBookItem) {
            return new ItemStackData(stack.getItem(), stack.getCount());
        }
        return new ItemStackData(stack.getItem(), stack.getCount());
    }

    public ItemStack toItemStackWithEnchantments() {
        if (this.item == Items.AIR || this.count <= 0) {
            return ItemStack.EMPTY;
        }
        if (this.item instanceof EnchantedBookItem) {
            return new ItemStack((ItemLike)this.item, this.count);
        }
        return new ItemStack((ItemLike)this.item, this.count);
    }

    public boolean isEmpty() {
        return this.item == Items.AIR || this.count <= 0;
    }
}

